---
title: 12 steps to cloud security
osem_url: https://osem.seagl.org/conferences/seagl2015/program/proposals/13
beginning: '2015-10-23T11:00:00.000-07:00'
end: '2015-10-23T11:50:00.000-07:00'
presenters:
- name: Vishnu Vettrivel
  affiliation: DataBrigade
  osem_url: https://osem.seagl.org/users/35
  gravatar_id: d38698f14c9bf9be6cc202804bc8034c
  biography: Vishnu Vettrivel is a developer and architect with over 15 years of experience
    with open source, Big Data and linux based environments in Banking, e-commerce
    and Healthcare industries. He currently builds, secures and operates multiple
    data driven applications in the cloud for an analytics platform company in Bellevue.
    He is a champion of open source and secure development, agile architectures and
    Continuous delivery. Vishnu has a graduate degree in Software Management from
    the Carnegie Mellon and lives in the Seattle Metro Area.
---

Whether you are running on a public or a private cloud provider, this talk aims to help you secure your cloud based deployment, by using a simple step-by-step guide that involves using open source tools. You will be able to understand and implement a security framework for your own cloud deployment.

This talk outlines a 12-step guide consisting of the following steps:

1. Knowing your shared responsibility
2. Protecting your network
3. Protecting your cloud machine images
4. Protecting your data at rest
5. Protecting your data in transit
6. Protecting and patching your instances
7. Protecting access to your instances
8. Protecting your applications
9. Auditing and monitoring your cloud
10. Validating your protection
11. Automating everything
12. Updating your security policy

Open Source tools and technologies covered:

- PfSense, Openswan, OpenVPN
- SELinux, App Armor, Dm-crypt
- Nginx, ModSecurity
- Samba/Winbind, OpenLDAP
- Logstash, Nagios, Ganglia
- Metasploit, Nessus
- Ansible, Docker, Jenkins

We will be going over each step in detail, so attendees can understand the importance of underlying security domains and learn how to go about implementing them using open source solutions alone. I will also be sharing my personal experiences and best practices when it comes to implementing a security framework for the cloud using open source tools and technologies.
