$("#contactForm").validator().on("submit", function (event) {
    if (event.isDefaultPrevented()) {
        // handle the invalid form...
        formError();
        submitMSG(false, "Did you fill in the form properly?");
    } else {
        // everything looks good!
        event.preventDefault();
        $('#form-submit').attr("disabled", true);
        submitMSG(true,"Form Submitted");
        $('#contactForm')[0].reset();
    }
});


function submitForm(){
    emailjs.init("user_ZT7rBieC356W4uDwh5hOx");

emailjs.sendForm('service_7zxkfqv', 'template_7b4srz6', '#contactForm')
    .then(function(response) {
        formSuccess();
    //    console.log('SUCCESS!', response.status, response.text);
    //    alert("Form Submitted Successfully");
      }, function(error) {
        // console.log('FAILED...', error);
        formError();
        submitMSG(false,error);
    });

}

function formSuccess(){
    $("#contactForm")[0].reset();
    submitMSG(true, "Form Submitted!")
}

function formError(){
    $("#contactForm").removeClass().addClass('shake animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(){
        $(this).removeClass();
    });
}

function submitMSG(valid, msg){
    if(valid){
        var msgClasses = "h3 text-left animated bounce text-dark";
    } else {
        var msgClasses = "h3 text-left text-dark";
    }
    $("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
}
