/**
 * @file locales.js
 * @author Sanjay Sunil
 * @license GPL-3.0
 */

const locales = {
  en: {
    'langCode': 'en',
    'language': 'English',
    // ========================= PANEL =========================
    'status': {
      loading: 'Loading ...',
    },
    'headings': {
      profile: 'Discord Bot',
      guildName: 'Chats',
      settings: 'Settings',
    },
    'sub-headings': {
      about: 'About',
      tools: 'Tools',
      info: 'Info',
    },
    'navbar': {
      profileNav: 'Profile',
      chatNav: 'Chat',
      lastMessagesNav: 'Last Messages',
      infoNav: 'Chat / Server Info',
      settingsNav: 'Settings',
      lightDark: 'Light / Dark Mode',
      logoutTitle: 'Logout',
    },
    'text': {
      channelNameLabel: 'Chat',
      fileSent: 'sent some file(s)',
      attachmentTxt: 'Attachments',
      privateMessages: 'DM',
      profileSection: {
        name: 'Name',
        discrim: 'Discrim',
        id: 'ID',
        guilds: 'Guilds',
        createdAt: 'Created At',
      },
      settingsSection: {
        createBotInvite: 'Create Bot Invite',
        eval: 'EVAL',
        languages: 'Languages',
      },
    },
    'buttons': {
      clearLastMessages: 'Clear Last Messages',
      editToken: 'Logout',
      refreshChat: 'Refresh chat',
      send: 'Send',
      leave: 'Leave server',
      invite: 'Invite',
    },
    // ========================= DISCORD =========================
    'infos': {
      owner: 'Owner',
      members: 'Members',
      vChannels: 'Channels (voice)',
      tChannels: 'Channels (text)',
      roles: 'Roles',
      channels: 'Channels',
      emojis: 'Emojis',
    },
    'errors': {
      error: 'ERROR',
      dm: 'ERROR : DM',
      emptyMsg: 'Empty Message!',
      missingPermissions: 'Missing Permissions!',
    },
    'token': {
      confirmation: 'Are you sure you want to logout?',
      invalid: 'Token is Invalid. Please try again.',
    },
    'messageType': {
      serverJoin: 'joined the server.',
      pin: 'pinned a message.',
      channelNews: 'added a remote channel news.',
      boost: 'boosted the server.',
    },
    'fileType': {
      unknown: 'unknown',
      img: 'image',
      doc: 'document',
      pdf: 'pdf',
      video: 'video',
      audio: 'audio',
    },
  },

  id: {
    'langCode': 'id',
    'language': 'Indonesia',
    // ========================= PANEL =========================
    'status': {
      loading: 'Memuat ...',
    },
    'headings': {
      profile: 'Bot Discord',
      guildName: 'Obrolan',
      settings: 'Pengaturan',
    },
    'sub-headings': {
      about: 'Tentang',
      tools: 'Peralatan',
      info: 'Info',
    },
    'navbar': {
      profileNav: 'Profil',
      chatNav: 'Pesan',
      lastMessagesNav: 'Pesan Terakhir',
      infoNav: 'Pesan / Info Server',
      settingsNav: 'Pengaturan',
      lightDark: 'Mode Terang / Gelap',
      logoutTitle: 'Keluar',
    },
    'text': {
      channelNameLabel: 'Pesan',
      fileSent: 'Mengirim kan sebuah file',
      attachmentTxt: 'Lampiran',
      privateMessages: 'Pesan langsung',
      profileSection: {
        name: 'Nama',
        discrim: 'Diskriminasi',
        id: 'ID',
        guilds: 'Persekutuan',
        createdAt: 'Dibuat saat',
      },
      settingsSection: {
        createBotInvite: 'Buat undangan bot',
        eval: 'EVAL',
        languages: 'Bahasa',
      },
    },
    'buttons': {
      clearLastMessages: 'Bersihkan pesan terakhir',
      editToken: 'Keluar',
      refreshChat: 'Menyegarkan pesan',
      send: 'Kirim',
      leave: 'Keluar Server',
      invite: 'Undangan',
    },
    // ========================= DISCORD =========================
    'infos': {
      owner: 'Pemilik',
      members: 'Anggota',
      vChannels: 'Saluran (suara)',
      tChannels: 'Saluran (teks)',
      roles: 'Peran',
      channels: 'Saluran',
      emojis: 'Emoji',
    },
    'errors': {
      error: 'Kesalahan',
      dm: 'Kesalahan : Pesan Langsung',
      emptyMsg: 'Pesan Kosong.',
      missingPermissions: 'Tidak Mempunyai Izin!',
    },
    'token': {
      confirmation: 'Apakah kamu yakin ingin keluar?',
      invalid: 'Token tidak Valid. Silakan coba lagi.',
    },
    'messageType': {
      serverJoin: 'Bergabung dengan server ini.',
      pin: 'Pesan yang disematkan',
      channelNews: 'Menambahkan berita saluran jarak jauh.',
      boost: 'Meningkatkan server ini.',
    },
    'fileType': {
      unknown: 'Tidak dikenal',
      img: 'Foto',
      doc: 'Dokumen',
      pdf: 'pdf',
      video: 'video',
      audio: 'audio',
    },
  },
};
