import 'dart:convert';

import 'package:flutter_test/flutter_test.dart';
import 'package:mobile_polimi_project/app/activity/data/models/segment_model.dart';
import 'package:mobile_polimi_project/app/activity/domain/entities/segment.dart';

import '../../../../fixtures/fixture_reader.dart';
import 'shared.dart';

void main() {
  final jsonMap =
      json.decode(fixture("segment_model.json")) as Map<String, dynamic>;

  test('should be of type Segment', () async {
    expect(Shared.segmentModel, isA<Segment>());
  });

  test('should be equals based on its unique_id only', () async {
    expect(Shared.segmentModel, Shared.segmentModelCopy);
  });

  group('fromJson', () {
    test('should convert correctly to json', () async {
      expect(SegmentModel.fromJson(jsonMap), Shared.segmentModel);
    });
  });
}
