(function () {
'use strict';


	/* eslint-disable */
	var define = false;
	var global={};
	var process = {env: {}};
	var isServer = false;
	

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};





function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

// Unique ID creation requires a high quality random # generator.  In the
// browser this is a little complicated due to unknown quality of Math.random()
// and inconsistent support for the `crypto` API.  We do the best we can via
// feature-detection
var rng;

var crypto = commonjsGlobal.crypto || commonjsGlobal.msCrypto; // for IE 11
if (crypto && crypto.getRandomValues) {
  // WHATWG crypto RNG - http://wiki.whatwg.org/wiki/Crypto
  var rnds8 = new Uint8Array(16); // eslint-disable-line no-undef
  rng = function whatwgRNG() {
    crypto.getRandomValues(rnds8);
    return rnds8;
  };
}

if (!rng) {
  // Math.random()-based (RNG)
  //
  // If all else fails, use Math.random().  It's fast, but is of unspecified
  // quality.
  var rnds = new Array(16);
  rng = function() {
    for (var i = 0, r; i < 16; i++) {
      if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
      rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
    }

    return rnds;
  };
}

var rngBrowser = rng;

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
var byteToHex = [];
for (var i = 0; i < 256; ++i) {
  byteToHex[i] = (i + 0x100).toString(16).substr(1);
}

function bytesToUuid(buf, offset) {
  var i = offset || 0;
  var bth = byteToHex;
  return bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]];
}

var bytesToUuid_1 = bytesToUuid;

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

// random #'s we need to init node and clockseq
var _seedBytes = rngBrowser();

// Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
var _nodeId = [
  _seedBytes[0] | 0x01,
  _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5]
];

// Per 4.2.2, randomize (14 bit) clockseq
var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 0x3fff;

// Previous uuid creation time
var _lastMSecs = 0;
var _lastNSecs = 0;

// See https://github.com/broofa/node-uuid for API details
function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || [];

  options = options || {};

  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq;

  // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
  var msecs = options.msecs !== undefined ? options.msecs : new Date().getTime();

  // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock
  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;

  // Time since last uuid creation (in msecs)
  var dt = (msecs - _lastMSecs) + (nsecs - _lastNSecs)/10000;

  // Per 4.2.1.2, Bump clockseq on clock regression
  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  }

  // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  }

  // Per 4.2.1.2 Throw error if too many uuids are requested
  if (nsecs >= 10000) {
    throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;

  // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
  msecs += 12219292800000;

  // `time_low`
  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff;

  // `time_mid`
  var tmh = (msecs / 0x100000000 * 10000) & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff;

  // `time_high_and_version`
  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
  b[i++] = tmh >>> 16 & 0xff;

  // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
  b[i++] = clockseq >>> 8 | 0x80;

  // `clock_seq_low`
  b[i++] = clockseq & 0xff;

  // `node`
  var node = options.node || _nodeId;
  for (var n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf ? buf : bytesToUuid_1(b);
}

var v1_1 = v1;

function v4(options, buf, offset) {
  var i = buf && offset || 0;

  if (typeof(options) == 'string') {
    buf = options == 'binary' ? new Array(16) : null;
    options = null;
  }
  options = options || {};

  var rnds = options.random || (options.rng || rngBrowser)();

  // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
  rnds[6] = (rnds[6] & 0x0f) | 0x40;
  rnds[8] = (rnds[8] & 0x3f) | 0x80;

  // Copy bytes to buffer, if provided
  if (buf) {
    for (var ii = 0; ii < 16; ++ii) {
      buf[i + ii] = rnds[ii];
    }
  }

  return buf || bytesToUuid_1(rnds);
}

var v4_1 = v4;

var uuid$1 = v4_1;
uuid$1.v1 = v1_1;
uuid$1.v4 = v4_1;

var index$1 = uuid$1;

var Mutation = commonjsGlobal.MutationObserver || commonjsGlobal.WebKitMutationObserver;

var scheduleDrain;

{
  if (Mutation) {
    var called = 0;
    var observer = new Mutation(nextTick);
    var element = commonjsGlobal.document.createTextNode('');
    observer.observe(element, {
      characterData: true
    });
    scheduleDrain = function () {
      element.data = (called = ++called % 2);
    };
  } else if (!commonjsGlobal.setImmediate && typeof commonjsGlobal.MessageChannel !== 'undefined') {
    var channel = new commonjsGlobal.MessageChannel();
    channel.port1.onmessage = nextTick;
    scheduleDrain = function () {
      channel.port2.postMessage(0);
    };
  } else if ('document' in commonjsGlobal && 'onreadystatechange' in commonjsGlobal.document.createElement('script')) {
    scheduleDrain = function () {

      // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
      // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
      var scriptEl = commonjsGlobal.document.createElement('script');
      scriptEl.onreadystatechange = function () {
        nextTick();

        scriptEl.onreadystatechange = null;
        scriptEl.parentNode.removeChild(scriptEl);
        scriptEl = null;
      };
      commonjsGlobal.document.documentElement.appendChild(scriptEl);
    };
  } else {
    scheduleDrain = function () {
      setTimeout(nextTick, 0);
    };
  }
}

var draining;
var queue$1 = [];
//named nextTick for less confusing stack traces
function nextTick() {
  draining = true;
  var i, oldQueue;
  var len = queue$1.length;
  while (len) {
    oldQueue = queue$1;
    queue$1 = [];
    i = -1;
    while (++i < len) {
      oldQueue[i]();
    }
    len = queue$1.length;
  }
  draining = false;
}

var browser$2 = immediate;
function immediate(task) {
  if (queue$1.push(task) === 1 && !draining) {
    scheduleDrain();
  }
}

/* istanbul ignore next */
function INTERNAL() {}

var handlers = {};

var REJECTED = ['REJECTED'];
var FULFILLED = ['FULFILLED'];
var PENDING = ['PENDING'];

var browser$1 = Promise$1;

function Promise$1(resolver) {
  if (typeof resolver !== 'function') {
    throw new TypeError('resolver must be a function');
  }
  this.state = PENDING;
  this.queue = [];
  this.outcome = void 0;
  if (resolver !== INTERNAL) {
    safelyResolveThenable(this, resolver);
  }
}

Promise$1.prototype["catch"] = function (onRejected) {
  return this.then(null, onRejected);
};
Promise$1.prototype.then = function (onFulfilled, onRejected) {
  if (typeof onFulfilled !== 'function' && this.state === FULFILLED ||
    typeof onRejected !== 'function' && this.state === REJECTED) {
    return this;
  }
  var promise = new this.constructor(INTERNAL);
  if (this.state !== PENDING) {
    var resolver = this.state === FULFILLED ? onFulfilled : onRejected;
    unwrap(promise, resolver, this.outcome);
  } else {
    this.queue.push(new QueueItem(promise, onFulfilled, onRejected));
  }

  return promise;
};
function QueueItem(promise, onFulfilled, onRejected) {
  this.promise = promise;
  if (typeof onFulfilled === 'function') {
    this.onFulfilled = onFulfilled;
    this.callFulfilled = this.otherCallFulfilled;
  }
  if (typeof onRejected === 'function') {
    this.onRejected = onRejected;
    this.callRejected = this.otherCallRejected;
  }
}
QueueItem.prototype.callFulfilled = function (value) {
  handlers.resolve(this.promise, value);
};
QueueItem.prototype.otherCallFulfilled = function (value) {
  unwrap(this.promise, this.onFulfilled, value);
};
QueueItem.prototype.callRejected = function (value) {
  handlers.reject(this.promise, value);
};
QueueItem.prototype.otherCallRejected = function (value) {
  unwrap(this.promise, this.onRejected, value);
};

function unwrap(promise, func, value) {
  browser$2(function () {
    var returnValue;
    try {
      returnValue = func(value);
    } catch (e) {
      return handlers.reject(promise, e);
    }
    if (returnValue === promise) {
      handlers.reject(promise, new TypeError('Cannot resolve promise with itself'));
    } else {
      handlers.resolve(promise, returnValue);
    }
  });
}

handlers.resolve = function (self, value) {
  var result = tryCatch(getThen, value);
  if (result.status === 'error') {
    return handlers.reject(self, result.value);
  }
  var thenable = result.value;

  if (thenable) {
    safelyResolveThenable(self, thenable);
  } else {
    self.state = FULFILLED;
    self.outcome = value;
    var i = -1;
    var len = self.queue.length;
    while (++i < len) {
      self.queue[i].callFulfilled(value);
    }
  }
  return self;
};
handlers.reject = function (self, error) {
  self.state = REJECTED;
  self.outcome = error;
  var i = -1;
  var len = self.queue.length;
  while (++i < len) {
    self.queue[i].callRejected(error);
  }
  return self;
};

function getThen(obj) {
  // Make sure we only access the accessor once as required by the spec
  var then = obj && obj.then;
  if (obj && (typeof obj === 'object' || typeof obj === 'function') && typeof then === 'function') {
    return function appyThen() {
      then.apply(obj, arguments);
    };
  }
}

function safelyResolveThenable(self, thenable) {
  // Either fulfill, reject or reject with error
  var called = false;
  function onError(value) {
    if (called) {
      return;
    }
    called = true;
    handlers.reject(self, value);
  }

  function onSuccess(value) {
    if (called) {
      return;
    }
    called = true;
    handlers.resolve(self, value);
  }

  function tryToUnwrap() {
    thenable(onSuccess, onError);
  }

  var result = tryCatch(tryToUnwrap);
  if (result.status === 'error') {
    onError(result.value);
  }
}

function tryCatch(func, value) {
  var out = {};
  try {
    out.value = func(value);
    out.status = 'success';
  } catch (e) {
    out.status = 'error';
    out.value = e;
  }
  return out;
}

Promise$1.resolve = resolve;
function resolve(value) {
  if (value instanceof this) {
    return value;
  }
  return handlers.resolve(new this(INTERNAL), value);
}

Promise$1.reject = reject;
function reject(reason) {
  var promise = new this(INTERNAL);
  return handlers.reject(promise, reason);
}

Promise$1.all = all;
function all(iterable) {
  var self = this;
  if (Object.prototype.toString.call(iterable) !== '[object Array]') {
    return this.reject(new TypeError('must be an array'));
  }

  var len = iterable.length;
  var called = false;
  if (!len) {
    return this.resolve([]);
  }

  var values = new Array(len);
  var resolved = 0;
  var i = -1;
  var promise = new this(INTERNAL);

  while (++i < len) {
    allResolver(iterable[i], i);
  }
  return promise;
  function allResolver(value, i) {
    self.resolve(value).then(resolveFromAll, function (error) {
      if (!called) {
        called = true;
        handlers.reject(promise, error);
      }
    });
    function resolveFromAll(outValue) {
      values[i] = outValue;
      if (++resolved === len && !called) {
        called = true;
        handlers.resolve(promise, values);
      }
    }
  }
}

Promise$1.race = race;
function race(iterable) {
  var self = this;
  if (Object.prototype.toString.call(iterable) !== '[object Array]') {
    return this.reject(new TypeError('must be an array'));
  }

  var len = iterable.length;
  var called = false;
  if (!len) {
    return this.resolve([]);
  }

  var i = -1;
  var promise = new this(INTERNAL);

  while (++i < len) {
    resolver(iterable[i]);
  }
  return promise;
  function resolver(value) {
    self.resolve(value).then(function (response) {
      if (!called) {
        called = true;
        handlers.resolve(promise, response);
      }
    }, function (error) {
      if (!called) {
        called = true;
        handlers.reject(promise, error);
      }
    });
  }
}

var index$2 = argsArray;

function argsArray(fun) {
  return function () {
    var len = arguments.length;
    if (len) {
      var args = [];
      var i = -1;
      while (++i < len) {
        args[i] = arguments[i];
      }
      return fun.call(this, args);
    } else {
      return fun.call(this, []);
    }
  };
}

var domain;

// This constructor is used to store event handlers. Instantiating this is
// faster than explicitly calling `Object.create(null)` to get a "clean" empty
// object (tested with v8 v4.9).
function EventHandlers() {}
EventHandlers.prototype = Object.create(null);

function EventEmitter() {
  EventEmitter.init.call(this);
}
// nodejs oddity
// require('events') === require('events').EventEmitter
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.usingDomains = false;

EventEmitter.prototype.domain = undefined;
EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

EventEmitter.init = function() {
  this.domain = null;
  if (EventEmitter.usingDomains) {
    // if there is an active domain, then attach to it.
    if (domain.active && !(this instanceof domain.Domain)) {
      this.domain = domain.active;
    }
  }

  if (!this._events || this._events === Object.getPrototypeOf(this)._events) {
    this._events = new EventHandlers();
    this._eventsCount = 0;
  }

  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || isNaN(n))
    throw new TypeError('"n" argument must be a positive number');
  this._maxListeners = n;
  return this;
};

function $getMaxListeners(that) {
  if (that._maxListeners === undefined)
    return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}

EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return $getMaxListeners(this);
};

// These standalone emit* functions are used to optimize calling of event
// handlers for fast cases because emit() itself often has a variable number of
// arguments and can be deoptimized because of that. These functions always have
// the same number of arguments and thus do not get deoptimized, so the code
// inside them can execute faster.
function emitNone(handler, isFn, self) {
  if (isFn)
    handler.call(self);
  else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      listeners[i].call(self);
  }
}
function emitOne(handler, isFn, self, arg1) {
  if (isFn)
    handler.call(self, arg1);
  else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      listeners[i].call(self, arg1);
  }
}
function emitTwo(handler, isFn, self, arg1, arg2) {
  if (isFn)
    handler.call(self, arg1, arg2);
  else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      listeners[i].call(self, arg1, arg2);
  }
}
function emitThree(handler, isFn, self, arg1, arg2, arg3) {
  if (isFn)
    handler.call(self, arg1, arg2, arg3);
  else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      listeners[i].call(self, arg1, arg2, arg3);
  }
}

function emitMany(handler, isFn, self, args) {
  if (isFn)
    handler.apply(self, args);
  else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      listeners[i].apply(self, args);
  }
}

EventEmitter.prototype.emit = function emit(type) {
  var er, handler, len, args, i, events, domain;
  var needDomainExit = false;
  var doError = (type === 'error');

  events = this._events;
  if (events)
    doError = (doError && events.error == null);
  else if (!doError)
    return false;

  domain = this.domain;

  // If there is no 'error' event listener then throw.
  if (doError) {
    er = arguments[1];
    if (domain) {
      if (!er)
        er = new Error('Uncaught, unspecified "error" event');
      er.domainEmitter = this;
      er.domain = domain;
      er.domainThrown = false;
      domain.emit('error', er);
    } else if (er instanceof Error) {
      throw er; // Unhandled 'error' event
    } else {
      // At least give some kind of context to the user
      var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
      err.context = er;
      throw err;
    }
    return false;
  }

  handler = events[type];

  if (!handler)
    return false;

  var isFn = typeof handler === 'function';
  len = arguments.length;
  switch (len) {
    // fast cases
    case 1:
      emitNone(handler, isFn, this);
      break;
    case 2:
      emitOne(handler, isFn, this, arguments[1]);
      break;
    case 3:
      emitTwo(handler, isFn, this, arguments[1], arguments[2]);
      break;
    case 4:
      emitThree(handler, isFn, this, arguments[1], arguments[2], arguments[3]);
      break;
    // slower
    default:
      args = new Array(len - 1);
      for (i = 1; i < len; i++)
        args[i - 1] = arguments[i];
      emitMany(handler, isFn, this, args);
  }

  if (needDomainExit)
    domain.exit();

  return true;
};

function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;

  if (typeof listener !== 'function')
    throw new TypeError('"listener" argument must be a function');

  events = target._events;
  if (!events) {
    events = target._events = new EventHandlers();
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener) {
      target.emit('newListener', type,
                  listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }

  if (!existing) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] = prepend ? [listener, existing] :
                                          [existing, listener];
    } else {
      // If we've already got an array, just append.
      if (prepend) {
        existing.unshift(listener);
      } else {
        existing.push(listener);
      }
    }

    // Check for listener leak
    if (!existing.warned) {
      m = $getMaxListeners(target);
      if (m && m > 0 && existing.length > m) {
        existing.warned = true;
        var w = new Error('Possible EventEmitter memory leak detected. ' +
                            existing.length + ' ' + type + ' listeners added. ' +
                            'Use emitter.setMaxListeners() to increase limit');
        w.name = 'MaxListenersExceededWarning';
        w.emitter = target;
        w.type = type;
        w.count = existing.length;
        emitWarning(w);
      }
    }
  }

  return target;
}
function emitWarning(e) {
  typeof console.warn === 'function' ? console.warn(e) : console.log(e);
}
EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.prependListener =
    function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };

function _onceWrap(target, type, listener) {
  var fired = false;
  function g() {
    target.removeListener(type, g);
    if (!fired) {
      fired = true;
      listener.apply(target, arguments);
    }
  }
  g.listener = listener;
  return g;
}

EventEmitter.prototype.once = function once(type, listener) {
  if (typeof listener !== 'function')
    throw new TypeError('"listener" argument must be a function');
  this.on(type, _onceWrap(this, type, listener));
  return this;
};

EventEmitter.prototype.prependOnceListener =
    function prependOnceListener(type, listener) {
      if (typeof listener !== 'function')
        throw new TypeError('"listener" argument must be a function');
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener =
    function removeListener(type, listener) {
      var list, events, position, i, originalListener;

      if (typeof listener !== 'function')
        throw new TypeError('"listener" argument must be a function');

      events = this._events;
      if (!events)
        return this;

      list = events[type];
      if (!list)
        return this;

      if (list === listener || (list.listener && list.listener === listener)) {
        if (--this._eventsCount === 0)
          this._events = new EventHandlers();
        else {
          delete events[type];
          if (events.removeListener)
            this.emit('removeListener', type, list.listener || listener);
        }
      } else if (typeof list !== 'function') {
        position = -1;

        for (i = list.length; i-- > 0;) {
          if (list[i] === listener ||
              (list[i].listener && list[i].listener === listener)) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }

        if (position < 0)
          return this;

        if (list.length === 1) {
          list[0] = undefined;
          if (--this._eventsCount === 0) {
            this._events = new EventHandlers();
            return this;
          } else {
            delete events[type];
          }
        } else {
          spliceOne(list, position);
        }

        if (events.removeListener)
          this.emit('removeListener', type, originalListener || listener);
      }

      return this;
    };

EventEmitter.prototype.removeAllListeners =
    function removeAllListeners(type) {
      var listeners, events;

      events = this._events;
      if (!events)
        return this;

      // not listening for removeListener, no need to emit
      if (!events.removeListener) {
        if (arguments.length === 0) {
          this._events = new EventHandlers();
          this._eventsCount = 0;
        } else if (events[type]) {
          if (--this._eventsCount === 0)
            this._events = new EventHandlers();
          else
            delete events[type];
        }
        return this;
      }

      // emit removeListener for all listeners on all events
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        for (var i = 0, key; i < keys.length; ++i) {
          key = keys[i];
          if (key === 'removeListener') continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners('removeListener');
        this._events = new EventHandlers();
        this._eventsCount = 0;
        return this;
      }

      listeners = events[type];

      if (typeof listeners === 'function') {
        this.removeListener(type, listeners);
      } else if (listeners) {
        // LIFO order
        do {
          this.removeListener(type, listeners[listeners.length - 1]);
        } while (listeners[0]);
      }

      return this;
    };

EventEmitter.prototype.listeners = function listeners(type) {
  var evlistener;
  var ret;
  var events = this._events;

  if (!events)
    ret = [];
  else {
    evlistener = events[type];
    if (!evlistener)
      ret = [];
    else if (typeof evlistener === 'function')
      ret = [evlistener.listener || evlistener];
    else
      ret = unwrapListeners(evlistener);
  }

  return ret;
};

EventEmitter.listenerCount = function(emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount$1.call(emitter, type);
  }
};

EventEmitter.prototype.listenerCount = listenerCount$1;
function listenerCount$1(type) {
  var events = this._events;

  if (events) {
    var evlistener = events[type];

    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener) {
      return evlistener.length;
    }
  }

  return 0;
}

EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? Reflect.ownKeys(this._events) : [];
};

// About 1.5x faster than the two-arg version of Array#splice().
function spliceOne(list, index) {
  for (var i = index, k = i + 1, n = list.length; k < n; i += 1, k += 1)
    list[i] = list[k];
  list.pop();
}

function arrayClone(arr, i) {
  var copy = new Array(i);
  while (i--)
    copy[i] = arr[i];
  return copy;
}

function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}

var inherits_browser$1 = createCommonjsModule(function (module) {
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function () {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  };
}
});

/**
 * Helpers.
 */

var s = 1000;
var m = s * 60;
var h = m * 60;
var d = h * 24;
var y = d * 365.25;

/**
 * Parse or format the given `val`.
 *
 * Options:
 *
 *  - `long` verbose formatting [false]
 *
 * @param {String|Number} val
 * @param {Object} [options]
 * @throws {Error} throw an error if val is not a non-empty string or a number
 * @return {String|Number}
 * @api public
 */

var index$3 = function (val, options) {
  options = options || {};
  var type = typeof val;
  if (type === 'string' && val.length > 0) {
    return parse(val)
  } else if (type === 'number' && isNaN(val) === false) {
    return options.long ?
			fmtLong(val) :
			fmtShort(val)
  }
  throw new Error('val is not a non-empty string or a valid number. val=' + JSON.stringify(val))
};

/**
 * Parse the given `str` and return milliseconds.
 *
 * @param {String} str
 * @return {Number}
 * @api private
 */

function parse(str) {
  str = String(str);
  if (str.length > 10000) {
    return
  }
  var match = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(str);
  if (!match) {
    return
  }
  var n = parseFloat(match[1]);
  var type = (match[2] || 'ms').toLowerCase();
  switch (type) {
    case 'years':
    case 'year':
    case 'yrs':
    case 'yr':
    case 'y':
      return n * y
    case 'days':
    case 'day':
    case 'd':
      return n * d
    case 'hours':
    case 'hour':
    case 'hrs':
    case 'hr':
    case 'h':
      return n * h
    case 'minutes':
    case 'minute':
    case 'mins':
    case 'min':
    case 'm':
      return n * m
    case 'seconds':
    case 'second':
    case 'secs':
    case 'sec':
    case 's':
      return n * s
    case 'milliseconds':
    case 'millisecond':
    case 'msecs':
    case 'msec':
    case 'ms':
      return n
    default:
      return undefined
  }
}

/**
 * Short format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtShort(ms) {
  if (ms >= d) {
    return Math.round(ms / d) + 'd'
  }
  if (ms >= h) {
    return Math.round(ms / h) + 'h'
  }
  if (ms >= m) {
    return Math.round(ms / m) + 'm'
  }
  if (ms >= s) {
    return Math.round(ms / s) + 's'
  }
  return ms + 'ms'
}

/**
 * Long format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtLong(ms) {
  return plural(ms, d, 'day') ||
    plural(ms, h, 'hour') ||
    plural(ms, m, 'minute') ||
    plural(ms, s, 'second') ||
    ms + ' ms'
}

/**
 * Pluralization helper.
 */

function plural(ms, n, name) {
  if (ms < n) {
    return
  }
  if (ms < n * 1.5) {
    return Math.floor(ms / n) + ' ' + name
  }
  return Math.ceil(ms / n) + ' ' + name + 's'
}

var debug$1 = createCommonjsModule(function (module, exports) {
/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = createDebug.debug = createDebug['default'] = createDebug;
exports.coerce = coerce;
exports.disable = disable;
exports.enable = enable;
exports.enabled = enabled;
exports.humanize = index$3;

/**
 * The currently active debug mode names, and names to skip.
 */

exports.names = [];
exports.skips = [];

/**
 * Map of special "%n" handling functions, for the debug "format" argument.
 *
 * Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
 */

exports.formatters = {};

/**
 * Previous log timestamp.
 */

var prevTime;

/**
 * Select a color.
 * @param {String} namespace
 * @return {Number}
 * @api private
 */

function selectColor(namespace) {
  var hash = 0, i;

  for (i in namespace) {
    hash  = ((hash << 5) - hash) + namespace.charCodeAt(i);
    hash |= 0; // Convert to 32bit integer
  }

  return exports.colors[Math.abs(hash) % exports.colors.length];
}

/**
 * Create a debugger with the given `namespace`.
 *
 * @param {String} namespace
 * @return {Function}
 * @api public
 */

function createDebug(namespace) {

  function debug() {
    // disabled?
    if (!debug.enabled) return;

    var self = debug;

    // set `diff` timestamp
    var curr = +new Date();
    var ms = curr - (prevTime || curr);
    self.diff = ms;
    self.prev = prevTime;
    self.curr = curr;
    prevTime = curr;

    // turn the `arguments` into a proper Array
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }

    args[0] = exports.coerce(args[0]);

    if ('string' !== typeof args[0]) {
      // anything else let's inspect with %O
      args.unshift('%O');
    }

    // apply any `formatters` transformations
    var index = 0;
    args[0] = args[0].replace(/%([a-zA-Z%])/g, function(match, format) {
      // if we encounter an escaped % then don't increase the array index
      if (match === '%%') return match;
      index++;
      var formatter = exports.formatters[format];
      if ('function' === typeof formatter) {
        var val = args[index];
        match = formatter.call(self, val);

        // now we need to remove `args[index]` since it's inlined in the `format`
        args.splice(index, 1);
        index--;
      }
      return match;
    });

    // apply env-specific formatting (colors, etc.)
    exports.formatArgs.call(self, args);

    var logFn = debug.log || exports.log || console.log.bind(console);
    logFn.apply(self, args);
  }

  debug.namespace = namespace;
  debug.enabled = exports.enabled(namespace);
  debug.useColors = exports.useColors();
  debug.color = selectColor(namespace);

  // env-specific initialization logic for debug instances
  if ('function' === typeof exports.init) {
    exports.init(debug);
  }

  return debug;
}

/**
 * Enables a debug mode by namespaces. This can include modes
 * separated by a colon and wildcards.
 *
 * @param {String} namespaces
 * @api public
 */

function enable(namespaces) {
  exports.save(namespaces);

  exports.names = [];
  exports.skips = [];

  var split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
  var len = split.length;

  for (var i = 0; i < len; i++) {
    if (!split[i]) continue; // ignore empty strings
    namespaces = split[i].replace(/\*/g, '.*?');
    if (namespaces[0] === '-') {
      exports.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
    } else {
      exports.names.push(new RegExp('^' + namespaces + '$'));
    }
  }
}

/**
 * Disable debug output.
 *
 * @api public
 */

function disable() {
  exports.enable('');
}

/**
 * Returns true if the given mode name is enabled, false otherwise.
 *
 * @param {String} name
 * @return {Boolean}
 * @api public
 */

function enabled(name) {
  var i, len;
  for (i = 0, len = exports.skips.length; i < len; i++) {
    if (exports.skips[i].test(name)) {
      return false;
    }
  }
  for (i = 0, len = exports.names.length; i < len; i++) {
    if (exports.names[i].test(name)) {
      return true;
    }
  }
  return false;
}

/**
 * Coerce `val`.
 *
 * @param {Mixed} val
 * @return {Mixed}
 * @api private
 */

function coerce(val) {
  if (val instanceof Error) return val.stack || val.message;
  return val;
}
});

var browser$3 = createCommonjsModule(function (module, exports) {
/**
 * This is the web browser implementation of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = debug$1;
exports.log = log;
exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = 'undefined' != typeof chrome
               && 'undefined' != typeof chrome.storage
                  ? chrome.storage.local
                  : localstorage();

/**
 * Colors.
 */

exports.colors = [
  'lightseagreen',
  'forestgreen',
  'goldenrod',
  'dodgerblue',
  'darkorchid',
  'crimson'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

function useColors() {
  // NB: In an Electron preload script, document will be defined but not fully
  // initialized. Since we know we're in Chrome, we'll just detect this case
  // explicitly
  if (typeof window !== 'undefined' && window && typeof window.process !== 'undefined' && window.process.type === 'renderer') {
    return true;
  }

  // is webkit? http://stackoverflow.com/a/16459606/376773
  // document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
  return (typeof document !== 'undefined' && document && 'WebkitAppearance' in document.documentElement.style) ||
    // is firebug? http://stackoverflow.com/a/398120/376773
    (typeof window !== 'undefined' && window && window.console && (console.firebug || (console.exception && console.table))) ||
    // is firefox >= v31?
    // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
    (typeof navigator !== 'undefined' && navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
    // double check webkit in userAgent just in case we are in a worker
    (typeof navigator !== 'undefined' && navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

exports.formatters.j = function(v) {
  try {
    return JSON.stringify(v);
  } catch (err) {
    return '[UnexpectedJSONParseError]: ' + err.message;
  }
};


/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
  var useColors = this.useColors;

  args[0] = (useColors ? '%c' : '')
    + this.namespace
    + (useColors ? ' %c' : ' ')
    + args[0]
    + (useColors ? '%c ' : ' ')
    + '+' + exports.humanize(this.diff);

  if (!useColors) return;

  var c = 'color: ' + this.color;
  args.splice(1, 0, c, 'color: inherit');

  // the final "%c" is somewhat tricky, because there could be other
  // arguments passed either before or after the %c, so we need to
  // figure out the correct index to insert the CSS into
  var index = 0;
  var lastC = 0;
  args[0].replace(/%[a-zA-Z%]/g, function(match) {
    if ('%%' === match) return;
    index++;
    if ('%c' === match) {
      // we only are interested in the *last* %c
      // (the user may have provided their own)
      lastC = index;
    }
  });

  args.splice(lastC, 0, c);
}

/**
 * Invokes `console.log()` when available.
 * No-op when `console.log` is not a "function".
 *
 * @api public
 */

function log() {
  // this hackery is required for IE8/9, where
  // the `console.log` function doesn't have 'apply'
  return 'object' === typeof console
    && console.log
    && Function.prototype.apply.call(console.log, console, arguments);
}

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */

function save(namespaces) {
  try {
    if (null == namespaces) {
      exports.storage.removeItem('debug');
    } else {
      exports.storage.debug = namespaces;
    }
  } catch(e) {}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */

function load() {
  var r;
  try {
    r = exports.storage.debug;
  } catch(e) {}

  // If debug isn't set in LS, and we're in Electron, try to load $DEBUG
  if (!r && typeof process !== 'undefined' && 'env' in process) {
    r = process.env.DEBUG;
  }

  return r;
}

/**
 * Enable namespaces listed in `localStorage.debug` initially.
 */

exports.enable(load());

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
  try {
    return window.localStorage;
  } catch (e) {}
}
});

var sparkMd5 = createCommonjsModule(function (module, exports) {
(function (factory) {
    {
        // Node/CommonJS
        module.exports = factory();
    }
}(function (undefined) {

    'use strict';

    /*
     * Fastest md5 implementation around (JKM md5).
     * Credits: Joseph Myers
     *
     * @see http://www.myersdaily.org/joseph/javascript/md5-text.html
     * @see http://jsperf.com/md5-shootout/7
     */

    /* this function is much faster,
      so if possible we use it. Some IEs
      are the only ones I know of that
      need the idiotic second function,
      generated by an if clause.  */
    var add32 = function (a, b) {
        return (a + b) & 0xFFFFFFFF;
    },
        hex_chr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'];


    function md5cycle(x, k) {
        var a = x[0],
            b = x[1],
            c = x[2],
            d = x[3];

        a += (b & c | ~b & d) + k[0] - 680876936 | 0;
        a  = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[1] - 389564586 | 0;
        d  = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[2] + 606105819 | 0;
        c  = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[3] - 1044525330 | 0;
        b  = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[4] - 176418897 | 0;
        a  = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[5] + 1200080426 | 0;
        d  = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[6] - 1473231341 | 0;
        c  = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[7] - 45705983 | 0;
        b  = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[8] + 1770035416 | 0;
        a  = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[9] - 1958414417 | 0;
        d  = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[10] - 42063 | 0;
        c  = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[11] - 1990404162 | 0;
        b  = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[12] + 1804603682 | 0;
        a  = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[13] - 40341101 | 0;
        d  = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[14] - 1502002290 | 0;
        c  = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[15] + 1236535329 | 0;
        b  = (b << 22 | b >>> 10) + c | 0;

        a += (b & d | c & ~d) + k[1] - 165796510 | 0;
        a  = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[6] - 1069501632 | 0;
        d  = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[11] + 643717713 | 0;
        c  = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[0] - 373897302 | 0;
        b  = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[5] - 701558691 | 0;
        a  = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[10] + 38016083 | 0;
        d  = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[15] - 660478335 | 0;
        c  = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[4] - 405537848 | 0;
        b  = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[9] + 568446438 | 0;
        a  = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[14] - 1019803690 | 0;
        d  = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[3] - 187363961 | 0;
        c  = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[8] + 1163531501 | 0;
        b  = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[13] - 1444681467 | 0;
        a  = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[2] - 51403784 | 0;
        d  = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[7] + 1735328473 | 0;
        c  = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[12] - 1926607734 | 0;
        b  = (b << 20 | b >>> 12) + c | 0;

        a += (b ^ c ^ d) + k[5] - 378558 | 0;
        a  = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[8] - 2022574463 | 0;
        d  = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[11] + 1839030562 | 0;
        c  = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[14] - 35309556 | 0;
        b  = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[1] - 1530992060 | 0;
        a  = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[4] + 1272893353 | 0;
        d  = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[7] - 155497632 | 0;
        c  = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[10] - 1094730640 | 0;
        b  = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[13] + 681279174 | 0;
        a  = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[0] - 358537222 | 0;
        d  = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[3] - 722521979 | 0;
        c  = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[6] + 76029189 | 0;
        b  = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[9] - 640364487 | 0;
        a  = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[12] - 421815835 | 0;
        d  = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[15] + 530742520 | 0;
        c  = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[2] - 995338651 | 0;
        b  = (b << 23 | b >>> 9) + c | 0;

        a += (c ^ (b | ~d)) + k[0] - 198630844 | 0;
        a  = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[7] + 1126891415 | 0;
        d  = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[14] - 1416354905 | 0;
        c  = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[5] - 57434055 | 0;
        b  = (b << 21 |b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[12] + 1700485571 | 0;
        a  = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[3] - 1894986606 | 0;
        d  = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[10] - 1051523 | 0;
        c  = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[1] - 2054922799 | 0;
        b  = (b << 21 |b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[8] + 1873313359 | 0;
        a  = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[15] - 30611744 | 0;
        d  = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[6] - 1560198380 | 0;
        c  = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[13] + 1309151649 | 0;
        b  = (b << 21 |b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[4] - 145523070 | 0;
        a  = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[11] - 1120210379 | 0;
        d  = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[2] + 718787259 | 0;
        c  = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[9] - 343485551 | 0;
        b  = (b << 21 | b >>> 11) + c | 0;

        x[0] = a + x[0] | 0;
        x[1] = b + x[1] | 0;
        x[2] = c + x[2] | 0;
        x[3] = d + x[3] | 0;
    }

    function md5blk(s) {
        var md5blks = [],
            i; /* Andy King said do it this way. */

        for (i = 0; i < 64; i += 4) {
            md5blks[i >> 2] = s.charCodeAt(i) + (s.charCodeAt(i + 1) << 8) + (s.charCodeAt(i + 2) << 16) + (s.charCodeAt(i + 3) << 24);
        }
        return md5blks;
    }

    function md5blk_array(a) {
        var md5blks = [],
            i; /* Andy King said do it this way. */

        for (i = 0; i < 64; i += 4) {
            md5blks[i >> 2] = a[i] + (a[i + 1] << 8) + (a[i + 2] << 16) + (a[i + 3] << 24);
        }
        return md5blks;
    }

    function md51(s) {
        var n = s.length,
            state = [1732584193, -271733879, -1732584194, 271733878],
            i,
            length,
            tail,
            tmp,
            lo,
            hi;

        for (i = 64; i <= n; i += 64) {
            md5cycle(state, md5blk(s.substring(i - 64, i)));
        }
        s = s.substring(i - 64);
        length = s.length;
        tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= s.charCodeAt(i) << ((i % 4) << 3);
        }
        tail[i >> 2] |= 0x80 << ((i % 4) << 3);
        if (i > 55) {
            md5cycle(state, tail);
            for (i = 0; i < 16; i += 1) {
                tail[i] = 0;
            }
        }

        // Beware that the final length might not fit in 32 bits so we take care of that
        tmp = n * 8;
        tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
        lo = parseInt(tmp[2], 16);
        hi = parseInt(tmp[1], 16) || 0;

        tail[14] = lo;
        tail[15] = hi;

        md5cycle(state, tail);
        return state;
    }

    function md51_array(a) {
        var n = a.length,
            state = [1732584193, -271733879, -1732584194, 271733878],
            i,
            length,
            tail,
            tmp,
            lo,
            hi;

        for (i = 64; i <= n; i += 64) {
            md5cycle(state, md5blk_array(a.subarray(i - 64, i)));
        }

        // Not sure if it is a bug, however IE10 will always produce a sub array of length 1
        // containing the last element of the parent array if the sub array specified starts
        // beyond the length of the parent array - weird.
        // https://connect.microsoft.com/IE/feedback/details/771452/typed-array-subarray-issue
        a = (i - 64) < n ? a.subarray(i - 64) : new Uint8Array(0);

        length = a.length;
        tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= a[i] << ((i % 4) << 3);
        }

        tail[i >> 2] |= 0x80 << ((i % 4) << 3);
        if (i > 55) {
            md5cycle(state, tail);
            for (i = 0; i < 16; i += 1) {
                tail[i] = 0;
            }
        }

        // Beware that the final length might not fit in 32 bits so we take care of that
        tmp = n * 8;
        tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
        lo = parseInt(tmp[2], 16);
        hi = parseInt(tmp[1], 16) || 0;

        tail[14] = lo;
        tail[15] = hi;

        md5cycle(state, tail);

        return state;
    }

    function rhex(n) {
        var s = '',
            j;
        for (j = 0; j < 4; j += 1) {
            s += hex_chr[(n >> (j * 8 + 4)) & 0x0F] + hex_chr[(n >> (j * 8)) & 0x0F];
        }
        return s;
    }

    function hex(x) {
        var i;
        for (i = 0; i < x.length; i += 1) {
            x[i] = rhex(x[i]);
        }
        return x.join('');
    }

    // In some cases the fast add32 function cannot be used..
    if (hex(md51('hello')) !== '5d41402abc4b2a76b9719d911017c592') {
        add32 = function (x, y) {
            var lsw = (x & 0xFFFF) + (y & 0xFFFF),
                msw = (x >> 16) + (y >> 16) + (lsw >> 16);
            return (msw << 16) | (lsw & 0xFFFF);
        };
    }

    // ---------------------------------------------------

    /**
     * ArrayBuffer slice polyfill.
     *
     * @see https://github.com/ttaubert/node-arraybuffer-slice
     */

    if (typeof ArrayBuffer !== 'undefined' && !ArrayBuffer.prototype.slice) {
        (function () {
            function clamp(val, length) {
                val = (val | 0) || 0;

                if (val < 0) {
                    return Math.max(val + length, 0);
                }

                return Math.min(val, length);
            }

            ArrayBuffer.prototype.slice = function (from, to) {
                var length = this.byteLength,
                    begin = clamp(from, length),
                    end = length,
                    num,
                    target,
                    targetArray,
                    sourceArray;

                if (to !== undefined) {
                    end = clamp(to, length);
                }

                if (begin > end) {
                    return new ArrayBuffer(0);
                }

                num = end - begin;
                target = new ArrayBuffer(num);
                targetArray = new Uint8Array(target);

                sourceArray = new Uint8Array(this, begin, num);
                targetArray.set(sourceArray);

                return target;
            };
        })();
    }

    // ---------------------------------------------------

    /**
     * Helpers.
     */

    function toUtf8(str) {
        if (/[\u0080-\uFFFF]/.test(str)) {
            str = unescape(encodeURIComponent(str));
        }

        return str;
    }

    function utf8Str2ArrayBuffer(str, returnUInt8Array) {
        var length = str.length,
           buff = new ArrayBuffer(length),
           arr = new Uint8Array(buff),
           i;

        for (i = 0; i < length; i += 1) {
            arr[i] = str.charCodeAt(i);
        }

        return returnUInt8Array ? arr : buff;
    }

    function arrayBuffer2Utf8Str(buff) {
        return String.fromCharCode.apply(null, new Uint8Array(buff));
    }

    function concatenateArrayBuffers(first, second, returnUInt8Array) {
        var result = new Uint8Array(first.byteLength + second.byteLength);

        result.set(new Uint8Array(first));
        result.set(new Uint8Array(second), first.byteLength);

        return returnUInt8Array ? result : result.buffer;
    }

    function hexToBinaryString(hex) {
        var bytes = [],
            length = hex.length,
            x;

        for (x = 0; x < length - 1; x += 2) {
            bytes.push(parseInt(hex.substr(x, 2), 16));
        }

        return String.fromCharCode.apply(String, bytes);
    }

    // ---------------------------------------------------

    /**
     * SparkMD5 OOP implementation.
     *
     * Use this class to perform an incremental md5, otherwise use the
     * static methods instead.
     */

    function SparkMD5() {
        // call reset to init the instance
        this.reset();
    }

    /**
     * Appends a string.
     * A conversion will be applied if an utf8 string is detected.
     *
     * @param {String} str The string to be appended
     *
     * @return {SparkMD5} The instance itself
     */
    SparkMD5.prototype.append = function (str) {
        // Converts the string to utf8 bytes if necessary
        // Then append as binary
        this.appendBinary(toUtf8(str));

        return this;
    };

    /**
     * Appends a binary string.
     *
     * @param {String} contents The binary string to be appended
     *
     * @return {SparkMD5} The instance itself
     */
    SparkMD5.prototype.appendBinary = function (contents) {
        this._buff += contents;
        this._length += contents.length;

        var length = this._buff.length,
            i;

        for (i = 64; i <= length; i += 64) {
            md5cycle(this._hash, md5blk(this._buff.substring(i - 64, i)));
        }

        this._buff = this._buff.substring(i - 64);

        return this;
    };

    /**
     * Finishes the incremental computation, reseting the internal state and
     * returning the result.
     *
     * @param {Boolean} raw True to get the raw string, false to get the hex string
     *
     * @return {String} The result
     */
    SparkMD5.prototype.end = function (raw) {
        var buff = this._buff,
            length = buff.length,
            i,
            tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            ret;

        for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= buff.charCodeAt(i) << ((i % 4) << 3);
        }

        this._finish(tail, length);
        ret = hex(this._hash);

        if (raw) {
            ret = hexToBinaryString(ret);
        }

        this.reset();

        return ret;
    };

    /**
     * Resets the internal state of the computation.
     *
     * @return {SparkMD5} The instance itself
     */
    SparkMD5.prototype.reset = function () {
        this._buff = '';
        this._length = 0;
        this._hash = [1732584193, -271733879, -1732584194, 271733878];

        return this;
    };

    /**
     * Gets the internal state of the computation.
     *
     * @return {Object} The state
     */
    SparkMD5.prototype.getState = function () {
        return {
            buff: this._buff,
            length: this._length,
            hash: this._hash
        };
    };

    /**
     * Gets the internal state of the computation.
     *
     * @param {Object} state The state
     *
     * @return {SparkMD5} The instance itself
     */
    SparkMD5.prototype.setState = function (state) {
        this._buff = state.buff;
        this._length = state.length;
        this._hash = state.hash;

        return this;
    };

    /**
     * Releases memory used by the incremental buffer and other additional
     * resources. If you plan to use the instance again, use reset instead.
     */
    SparkMD5.prototype.destroy = function () {
        delete this._hash;
        delete this._buff;
        delete this._length;
    };

    /**
     * Finish the final calculation based on the tail.
     *
     * @param {Array}  tail   The tail (will be modified)
     * @param {Number} length The length of the remaining buffer
     */
    SparkMD5.prototype._finish = function (tail, length) {
        var i = length,
            tmp,
            lo,
            hi;

        tail[i >> 2] |= 0x80 << ((i % 4) << 3);
        if (i > 55) {
            md5cycle(this._hash, tail);
            for (i = 0; i < 16; i += 1) {
                tail[i] = 0;
            }
        }

        // Do the final computation based on the tail and length
        // Beware that the final length may not fit in 32 bits so we take care of that
        tmp = this._length * 8;
        tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
        lo = parseInt(tmp[2], 16);
        hi = parseInt(tmp[1], 16) || 0;

        tail[14] = lo;
        tail[15] = hi;
        md5cycle(this._hash, tail);
    };

    /**
     * Performs the md5 hash on a string.
     * A conversion will be applied if utf8 string is detected.
     *
     * @param {String}  str The string
     * @param {Boolean} raw True to get the raw string, false to get the hex string
     *
     * @return {String} The result
     */
    SparkMD5.hash = function (str, raw) {
        // Converts the string to utf8 bytes if necessary
        // Then compute it using the binary function
        return SparkMD5.hashBinary(toUtf8(str), raw);
    };

    /**
     * Performs the md5 hash on a binary string.
     *
     * @param {String}  content The binary string
     * @param {Boolean} raw     True to get the raw string, false to get the hex string
     *
     * @return {String} The result
     */
    SparkMD5.hashBinary = function (content, raw) {
        var hash = md51(content),
            ret = hex(hash);

        return raw ? hexToBinaryString(ret) : ret;
    };

    // ---------------------------------------------------

    /**
     * SparkMD5 OOP implementation for array buffers.
     *
     * Use this class to perform an incremental md5 ONLY for array buffers.
     */
    SparkMD5.ArrayBuffer = function () {
        // call reset to init the instance
        this.reset();
    };

    /**
     * Appends an array buffer.
     *
     * @param {ArrayBuffer} arr The array to be appended
     *
     * @return {SparkMD5.ArrayBuffer} The instance itself
     */
    SparkMD5.ArrayBuffer.prototype.append = function (arr) {
        var buff = concatenateArrayBuffers(this._buff.buffer, arr, true),
            length = buff.length,
            i;

        this._length += arr.byteLength;

        for (i = 64; i <= length; i += 64) {
            md5cycle(this._hash, md5blk_array(buff.subarray(i - 64, i)));
        }

        this._buff = (i - 64) < length ? new Uint8Array(buff.buffer.slice(i - 64)) : new Uint8Array(0);

        return this;
    };

    /**
     * Finishes the incremental computation, reseting the internal state and
     * returning the result.
     *
     * @param {Boolean} raw True to get the raw string, false to get the hex string
     *
     * @return {String} The result
     */
    SparkMD5.ArrayBuffer.prototype.end = function (raw) {
        var buff = this._buff,
            length = buff.length,
            tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            i,
            ret;

        for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= buff[i] << ((i % 4) << 3);
        }

        this._finish(tail, length);
        ret = hex(this._hash);

        if (raw) {
            ret = hexToBinaryString(ret);
        }

        this.reset();

        return ret;
    };

    /**
     * Resets the internal state of the computation.
     *
     * @return {SparkMD5.ArrayBuffer} The instance itself
     */
    SparkMD5.ArrayBuffer.prototype.reset = function () {
        this._buff = new Uint8Array(0);
        this._length = 0;
        this._hash = [1732584193, -271733879, -1732584194, 271733878];

        return this;
    };

    /**
     * Gets the internal state of the computation.
     *
     * @return {Object} The state
     */
    SparkMD5.ArrayBuffer.prototype.getState = function () {
        var state = SparkMD5.prototype.getState.call(this);

        // Convert buffer to a string
        state.buff = arrayBuffer2Utf8Str(state.buff);

        return state;
    };

    /**
     * Gets the internal state of the computation.
     *
     * @param {Object} state The state
     *
     * @return {SparkMD5.ArrayBuffer} The instance itself
     */
    SparkMD5.ArrayBuffer.prototype.setState = function (state) {
        // Convert string to buffer
        state.buff = utf8Str2ArrayBuffer(state.buff, true);

        return SparkMD5.prototype.setState.call(this, state);
    };

    SparkMD5.ArrayBuffer.prototype.destroy = SparkMD5.prototype.destroy;

    SparkMD5.ArrayBuffer.prototype._finish = SparkMD5.prototype._finish;

    /**
     * Performs the md5 hash on an array buffer.
     *
     * @param {ArrayBuffer} arr The array buffer
     * @param {Boolean}     raw True to get the raw string, false to get the hex one
     *
     * @return {String} The result
     */
    SparkMD5.ArrayBuffer.hash = function (arr, raw) {
        var hash = md51_array(new Uint8Array(arr)),
            ret = hex(hash);

        return raw ? hexToBinaryString(ret) : ret;
    };

    return SparkMD5;
}));
});

/**
 * Stringify/parse functions that don't operate
 * recursively, so they avoid call stack exceeded
 * errors.
 */
var stringify$1 = function stringify(input) {
  var queue = [];
  queue.push({obj: input});

  var res = '';
  var next, obj, prefix, val, i, arrayPrefix, keys, k, key, value, objPrefix;
  while ((next = queue.pop())) {
    obj = next.obj;
    prefix = next.prefix || '';
    val = next.val || '';
    res += prefix;
    if (val) {
      res += val;
    } else if (typeof obj !== 'object') {
      res += typeof obj === 'undefined' ? null : JSON.stringify(obj);
    } else if (obj === null) {
      res += 'null';
    } else if (Array.isArray(obj)) {
      queue.push({val: ']'});
      for (i = obj.length - 1; i >= 0; i--) {
        arrayPrefix = i === 0 ? '' : ',';
        queue.push({obj: obj[i], prefix: arrayPrefix});
      }
      queue.push({val: '['});
    } else { // object
      keys = [];
      for (k in obj) {
        if (obj.hasOwnProperty(k)) {
          keys.push(k);
        }
      }
      queue.push({val: '}'});
      for (i = keys.length - 1; i >= 0; i--) {
        key = keys[i];
        value = obj[key];
        objPrefix = (i > 0 ? ',' : '');
        objPrefix += JSON.stringify(key) + ':';
        queue.push({obj: value, prefix: objPrefix});
      }
      queue.push({val: '{'});
    }
  }
  return res;
};

// Convenience function for the parse function.
// This pop function is basically copied from
// pouchCollate.parseIndexableString
function pop$1(obj, stack, metaStack) {
  var lastMetaElement = metaStack[metaStack.length - 1];
  if (obj === lastMetaElement.element) {
    // popping a meta-element, e.g. an object whose value is another object
    metaStack.pop();
    lastMetaElement = metaStack[metaStack.length - 1];
  }
  var element = lastMetaElement.element;
  var lastElementIndex = lastMetaElement.index;
  if (Array.isArray(element)) {
    element.push(obj);
  } else if (lastElementIndex === stack.length - 2) { // obj with key+value
    var key = stack.pop();
    element[key] = obj;
  } else {
    stack.push(obj); // obj with key only
  }
}

var parse$1 = function (str) {
  var stack = [];
  var metaStack = []; // stack for arrays and objects
  var i = 0;
  var collationIndex,parsedNum,numChar;
  var parsedString,lastCh,numConsecutiveSlashes,ch;
  var arrayElement, objElement;
  while (true) {
    collationIndex = str[i++];
    if (collationIndex === '}' ||
        collationIndex === ']' ||
        typeof collationIndex === 'undefined') {
      if (stack.length === 1) {
        return stack.pop();
      } else {
        pop$1(stack.pop(), stack, metaStack);
        continue;
      }
    }
    switch (collationIndex) {
      case ' ':
      case '\t':
      case '\n':
      case ':':
      case ',':
        break;
      case 'n':
        i += 3; // 'ull'
        pop$1(null, stack, metaStack);
        break;
      case 't':
        i += 3; // 'rue'
        pop$1(true, stack, metaStack);
        break;
      case 'f':
        i += 4; // 'alse'
        pop$1(false, stack, metaStack);
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case '-':
        parsedNum = '';
        i--;
        while (true) {
          numChar = str[i++];
          if (/[\d\.\-e\+]/.test(numChar)) {
            parsedNum += numChar;
          } else {
            i--;
            break;
          }
        }
        pop$1(parseFloat(parsedNum), stack, metaStack);
        break;
      case '"':
        parsedString = '';
        lastCh = void 0;
        numConsecutiveSlashes = 0;
        while (true) {
          ch = str[i++];
          if (ch !== '"' || (lastCh === '\\' &&
              numConsecutiveSlashes % 2 === 1)) {
            parsedString += ch;
            lastCh = ch;
            if (lastCh === '\\') {
              numConsecutiveSlashes++;
            } else {
              numConsecutiveSlashes = 0;
            }
          } else {
            break;
          }
        }
        pop$1(JSON.parse('"' + parsedString + '"'), stack, metaStack);
        break;
      case '[':
        arrayElement = { element: [], index: stack.length };
        stack.push(arrayElement.element);
        metaStack.push(arrayElement);
        break;
      case '{':
        objElement = { element: {}, index: stack.length };
        stack.push(objElement.element);
        metaStack.push(objElement);
        break;
      default:
        throw new Error(
          'unexpectedly reached end of input: ' + collationIndex);
    }
  }
};

var index$5 = {
	stringify: stringify$1,
	parse: parse$1
};

/* istanbul ignore next */
var PouchPromise$1 = typeof Promise === 'function' ? Promise : browser$1;

function isBinaryObject(object) {
  return (typeof ArrayBuffer !== 'undefined' && object instanceof ArrayBuffer) ||
    (typeof Blob !== 'undefined' && object instanceof Blob);
}

function cloneArrayBuffer(buff) {
  if (typeof buff.slice === 'function') {
    return buff.slice(0);
  }
  // IE10-11 slice() polyfill
  var target = new ArrayBuffer(buff.byteLength);
  var targetArray = new Uint8Array(target);
  var sourceArray = new Uint8Array(buff);
  targetArray.set(sourceArray);
  return target;
}

function cloneBinaryObject(object) {
  if (object instanceof ArrayBuffer) {
    return cloneArrayBuffer(object);
  }
  var size = object.size;
  var type = object.type;
  // Blob
  if (typeof object.slice === 'function') {
    return object.slice(0, size, type);
  }
  // PhantomJS slice() replacement
  return object.webkitSlice(0, size, type);
}

// most of this is borrowed from lodash.isPlainObject:
// https://github.com/fis-components/lodash.isplainobject/
// blob/29c358140a74f252aeb08c9eb28bef86f2217d4a/index.js

var funcToString = Function.prototype.toString;
var objectCtorString = funcToString.call(Object);

function isPlainObject(value) {
  var proto = Object.getPrototypeOf(value);
  /* istanbul ignore if */
  if (proto === null) { // not sure when this happens, but I guess it can
    return true;
  }
  var Ctor = proto.constructor;
  return (typeof Ctor == 'function' &&
    Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString);
}

function clone(object) {
  var newObject;
  var i;
  var len;

  if (!object || typeof object !== 'object') {
    return object;
  }

  if (Array.isArray(object)) {
    newObject = [];
    for (i = 0, len = object.length; i < len; i++) {
      newObject[i] = clone(object[i]);
    }
    return newObject;
  }

  // special case: to avoid inconsistencies between IndexedDB
  // and other backends, we automatically stringify Dates
  if (object instanceof Date) {
    return object.toISOString();
  }

  if (isBinaryObject(object)) {
    return cloneBinaryObject(object);
  }

  if (!isPlainObject(object)) {
    return object; // don't clone objects like Workers
  }

  newObject = {};
  for (i in object) {
    /* istanbul ignore else */
    if (Object.prototype.hasOwnProperty.call(object, i)) {
      var value = clone(object[i]);
      if (typeof value !== 'undefined') {
        newObject[i] = value;
      }
    }
  }
  return newObject;
}

function once(fun) {
  var called = false;
  return index$2(function (args) {
    /* istanbul ignore if */
    if (called) {
      // this is a smoke test and should never actually happen
      throw new Error('once called more than once');
    } else {
      called = true;
      fun.apply(this, args);
    }
  });
}

function toPromise(func) {
  //create the function we will be returning
  return index$2(function (args) {
    // Clone arguments
    args = clone(args);
    var self = this;
    // if the last argument is a function, assume its a callback
    var usedCB = (typeof args[args.length - 1] === 'function') ? args.pop() : false;
    var promise = new PouchPromise$1(function (fulfill, reject) {
      var resp;
      try {
        var callback = once(function (err, mesg) {
          if (err) {
            reject(err);
          } else {
            fulfill(mesg);
          }
        });
        // create a callback for this invocation
        // apply the function in the orig context
        args.push(callback);
        resp = func.apply(self, args);
        if (resp && typeof resp.then === 'function') {
          fulfill(resp);
        }
      } catch (e) {
        reject(e);
      }
    });
    // if there is a callback, call it back
    if (usedCB) {
      promise.then(function (result) {
        usedCB(null, result);
      }, usedCB);
    }
    return promise;
  });
}

function logApiCall(self, name, args) {
  /* istanbul ignore if */
  if (self.constructor.listeners('debug').length) {
    var logArgs = ['api', self.name, name];
    for (var i = 0; i < args.length - 1; i++) {
      logArgs.push(args[i]);
    }
    self.constructor.emit('debug', logArgs);

    // override the callback itself to log the response
    var origCallback = args[args.length - 1];
    args[args.length - 1] = function (err, res) {
      var responseArgs = ['api', self.name, name];
      responseArgs = responseArgs.concat(
        err ? ['error', err] : ['success', res]
      );
      self.constructor.emit('debug', responseArgs);
      origCallback(err, res);
    };
  }
}

function adapterFun(name, callback) {
  return toPromise(index$2(function (args) {
    if (this._closed) {
      return PouchPromise$1.reject(new Error('database is closed'));
    }
    if (this._destroyed) {
      return PouchPromise$1.reject(new Error('database is destroyed'));
    }
    var self = this;
    logApiCall(self, name, args);
    if (!this.taskqueue.isReady) {
      return new PouchPromise$1(function (fulfill, reject) {
        self.taskqueue.addTask(function (failed) {
          if (failed) {
            reject(failed);
          } else {
            fulfill(self[name].apply(self, args));
          }
        });
      });
    }
    return callback.apply(this, args);
  }));
}

function mangle(key) {
  return '$' + key;
}
function unmangle(key) {
  return key.substring(1);
}
function Map$1() {
  this._store = {};
}
Map$1.prototype.get = function (key) {
  var mangled = mangle(key);
  return this._store[mangled];
};
Map$1.prototype.set = function (key, value) {
  var mangled = mangle(key);
  this._store[mangled] = value;
  return true;
};
Map$1.prototype.has = function (key) {
  var mangled = mangle(key);
  return mangled in this._store;
};
Map$1.prototype.delete = function (key) {
  var mangled = mangle(key);
  var res = mangled in this._store;
  delete this._store[mangled];
  return res;
};
Map$1.prototype.forEach = function (cb) {
  var keys = Object.keys(this._store);
  for (var i = 0, len = keys.length; i < len; i++) {
    var key = keys[i];
    var value = this._store[key];
    key = unmangle(key);
    cb(value, key);
  }
};
Object.defineProperty(Map$1.prototype, 'size', {
  get: function () {
    return Object.keys(this._store).length;
  }
});

function Set$1(array) {
  this._store = new Map$1();

  // init with an array
  if (array && Array.isArray(array)) {
    for (var i = 0, len = array.length; i < len; i++) {
      this.add(array[i]);
    }
  }
}
Set$1.prototype.add = function (key) {
  return this._store.set(key, true);
};
Set$1.prototype.has = function (key) {
  return this._store.has(key);
};
Set$1.prototype.forEach = function (cb) {
  this._store.forEach(function (value, key) {
    cb(key);
  });
};
Object.defineProperty(Set$1.prototype, 'size', {
  get: function () {
    return this._store.size;
  }
});

/* global Map,Set,Symbol */
// Based on https://kangax.github.io/compat-table/es6/ we can sniff out
// incomplete Map/Set implementations which would otherwise cause our tests to fail.
// Notably they fail in IE11 and iOS 8.4, which this prevents.
function supportsMapAndSet() {
  if (typeof Symbol === 'undefined' || typeof Map === 'undefined' || typeof Set === 'undefined') {
    return false;
  }
  var prop = Object.getOwnPropertyDescriptor(Map, Symbol.species);
  return prop && 'get' in prop && Map[Symbol.species] === Map;
}

// based on https://github.com/montagejs/collections
/* global Map,Set */

var ExportedSet;
var ExportedMap;

{
  if (supportsMapAndSet()) { // prefer built-in Map/Set
    ExportedSet = Set;
    ExportedMap = Map;
  } else { // fall back to our polyfill
    ExportedSet = Set$1;
    ExportedMap = Map$1;
  }
}

// like underscore/lodash _.pick()
function pick(obj, arr) {
  var res = {};
  for (var i = 0, len = arr.length; i < len; i++) {
    var prop = arr[i];
    if (prop in obj) {
      res[prop] = obj[prop];
    }
  }
  return res;
}

// Most browsers throttle concurrent requests at 6, so it's silly
// to shim _bulk_get by trying to launch potentially hundreds of requests
// and then letting the majority time out. We can handle this ourselves.
var MAX_NUM_CONCURRENT_REQUESTS = 6;

function identityFunction(x) {
  return x;
}

function formatResultForOpenRevsGet(result) {
  return [{
    ok: result
  }];
}

// shim for P/CouchDB adapters that don't directly implement _bulk_get
function bulkGet(db, opts, callback) {
  var requests = opts.docs;

  // consolidate into one request per doc if possible
  var requestsById = new ExportedMap();
  requests.forEach(function (request) {
    if (requestsById.has(request.id)) {
      requestsById.get(request.id).push(request);
    } else {
      requestsById.set(request.id, [request]);
    }
  });

  var numDocs = requestsById.size;
  var numDone = 0;
  var perDocResults = new Array(numDocs);

  function collapseResultsAndFinish() {
    var results = [];
    perDocResults.forEach(function (res) {
      res.docs.forEach(function (info) {
        results.push({
          id: res.id,
          docs: [info]
        });
      });
    });
    callback(null, {results: results});
  }

  function checkDone() {
    if (++numDone === numDocs) {
      collapseResultsAndFinish();
    }
  }

  function gotResult(docIndex, id, docs) {
    perDocResults[docIndex] = {id: id, docs: docs};
    checkDone();
  }

  var allRequests = [];
  requestsById.forEach(function (value, key) {
    allRequests.push(key);
  });

  var i = 0;

  function nextBatch() {

    if (i >= allRequests.length) {
      return;
    }

    var upTo = Math.min(i + MAX_NUM_CONCURRENT_REQUESTS, allRequests.length);
    var batch = allRequests.slice(i, upTo);
    processBatch(batch, i);
    i += batch.length;
  }

  function processBatch(batch, offset) {
    batch.forEach(function (docId, j) {
      var docIdx = offset + j;
      var docRequests = requestsById.get(docId);

      // just use the first request as the "template"
      // TODO: The _bulk_get API allows for more subtle use cases than this,
      // but for now it is unlikely that there will be a mix of different
      // "atts_since" or "attachments" in the same request, since it's just
      // replicate.js that is using this for the moment.
      // Also, atts_since is aspirational, since we don't support it yet.
      var docOpts = pick(docRequests[0], ['atts_since', 'attachments']);
      docOpts.open_revs = docRequests.map(function (request) {
        // rev is optional, open_revs disallowed
        return request.rev;
      });

      // remove falsey / undefined revisions
      docOpts.open_revs = docOpts.open_revs.filter(identityFunction);

      var formatResult = identityFunction;

      if (docOpts.open_revs.length === 0) {
        delete docOpts.open_revs;

        // when fetching only the "winning" leaf,
        // transform the result so it looks like an open_revs
        // request
        formatResult = formatResultForOpenRevsGet;
      }

      // globally-supplied options
      ['revs', 'attachments', 'binary', 'ajax', 'latest'].forEach(function (param) {
        if (param in opts) {
          docOpts[param] = opts[param];
        }
      });
      db.get(docId, docOpts, function (err, res) {
        var result;
        /* istanbul ignore if */
        if (err) {
          result = [{error: err}];
        } else {
          result = formatResult(res);
        }
        gotResult(docIdx, docId, result);
        nextBatch();
      });
    });
  }

  nextBatch();

}

function isChromeApp() {
  return (typeof chrome !== "undefined" &&
    typeof chrome.storage !== "undefined" &&
    typeof chrome.storage.local !== "undefined");
}

var hasLocal;

if (isChromeApp()) {
  hasLocal = false;
} else {
  try {
    localStorage.setItem('_pouch_check_localstorage', 1);
    hasLocal = !!localStorage.getItem('_pouch_check_localstorage');
  } catch (e) {
    hasLocal = false;
  }
}

function hasLocalStorage() {
  return hasLocal;
}

// Custom nextTick() shim for browsers. In node, this will just be process.nextTick(). We
// avoid using process.nextTick() directly because the polyfill is very large and we don't
// need all of it (see: https://github.com/defunctzombie/node-process).
// "immediate" 3.0.8 is used by lie, and it's a smaller version of the latest "immediate"
// package, so it's the one we use.
// When we use nextTick() in our codebase, we only care about not releasing Zalgo
// (see: http://blog.izs.me/post/59142742143/designing-apis-for-asynchrony).
// Microtask vs macrotask doesn't matter to us. So we're free to use the fastest
// (least latency) option, which is "immediate" due to use of microtasks.
// All of our nextTicks are isolated to this one function so we can easily swap out one
// implementation for another.

inherits_browser$1(Changes, EventEmitter);

/* istanbul ignore next */
function attachBrowserEvents(self) {
  if (isChromeApp()) {
    chrome.storage.onChanged.addListener(function (e) {
      // make sure it's event addressed to us
      if (e.db_name != null) {
        //object only has oldValue, newValue members
        self.emit(e.dbName.newValue);
      }
    });
  } else if (hasLocalStorage()) {
    if (typeof addEventListener !== 'undefined') {
      addEventListener("storage", function (e) {
        self.emit(e.key);
      });
    } else { // old IE
      window.attachEvent("storage", function (e) {
        self.emit(e.key);
      });
    }
  }
}

function Changes() {
  EventEmitter.call(this);
  this._listeners = {};

  attachBrowserEvents(this);
}
Changes.prototype.addListener = function (dbName, id, db, opts) {
  /* istanbul ignore if */
  if (this._listeners[id]) {
    return;
  }
  var self = this;
  var inprogress = false;
  function eventFunction() {
    /* istanbul ignore if */
    if (!self._listeners[id]) {
      return;
    }
    if (inprogress) {
      inprogress = 'waiting';
      return;
    }
    inprogress = true;
    var changesOpts = pick(opts, [
      'style', 'include_docs', 'attachments', 'conflicts', 'filter',
      'doc_ids', 'view', 'since', 'query_params', 'binary'
    ]);

    /* istanbul ignore next */
    function onError() {
      inprogress = false;
    }

    db.changes(changesOpts).on('change', function (c) {
      if (c.seq > opts.since && !opts.cancelled) {
        opts.since = c.seq;
        opts.onChange(c);
      }
    }).on('complete', function () {
      if (inprogress === 'waiting') {
        browser$2(eventFunction);
      }
      inprogress = false;
    }).on('error', onError);
  }
  this._listeners[id] = eventFunction;
  this.on(dbName, eventFunction);
};

Changes.prototype.removeListener = function (dbName, id) {
  /* istanbul ignore if */
  if (!(id in this._listeners)) {
    return;
  }
  EventEmitter.prototype.removeListener.call(this, dbName,
    this._listeners[id]);
  delete this._listeners[id];
};


/* istanbul ignore next */
Changes.prototype.notifyLocalWindows = function (dbName) {
  //do a useless change on a storage thing
  //in order to get other windows's listeners to activate
  if (isChromeApp()) {
    chrome.storage.local.set({dbName: dbName});
  } else if (hasLocalStorage()) {
    localStorage[dbName] = (localStorage[dbName] === "a") ? "b" : "a";
  }
};

Changes.prototype.notify = function (dbName) {
  this.emit(dbName);
  this.notifyLocalWindows(dbName);
};

function guardedConsole(method) {
  /* istanbul ignore else */
  if (console !== 'undefined' && method in console) {
    var args = Array.prototype.slice.call(arguments, 1);
    console[method].apply(console, args);
  }
}

function randomNumber(min, max) {
  var maxTimeout = 600000; // Hard-coded default of 10 minutes
  min = parseInt(min, 10) || 0;
  max = parseInt(max, 10);
  if (max !== max || max <= min) {
    max = (min || 1) << 1; //doubling
  } else {
    max = max + 1;
  }
  // In order to not exceed maxTimeout, pick a random value between half of maxTimeout and maxTimeout
  if (max > maxTimeout) {
    min = maxTimeout >> 1; // divide by two
    max = maxTimeout;
  }
  var ratio = Math.random();
  var range = max - min;

  return ~~(range * ratio + min); // ~~ coerces to an int, but fast.
}

function defaultBackOff(min) {
  var max = 0;
  if (!min) {
    max = 2000;
  }
  return randomNumber(min, max);
}

// designed to give info to browser users, who are disturbed
// when they see http errors in the console
function explainError(status, str) {
  guardedConsole('info', 'The above ' + status + ' is totally normal. ' + str);
}

var assign;
{
  if (typeof Object.assign === 'function') {
    assign = Object.assign;
  } else {
    // lite Object.assign polyfill based on
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
    assign = function (target) {
      var to = Object(target);

      for (var index = 1; index < arguments.length; index++) {
        var nextSource = arguments[index];

        if (nextSource != null) { // Skip over if undefined or null
          for (var nextKey in nextSource) {
            // Avoid bugs when hasOwnProperty is shadowed
            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
              to[nextKey] = nextSource[nextKey];
            }
          }
        }
      }
      return to;
    };
  }
}

var $inject_Object_assign = assign;

inherits_browser$1(PouchError, Error);

function PouchError(status, error, reason) {
  Error.call(this, reason);
  this.status = status;
  this.name = error;
  this.message = reason;
  this.error = true;
}

PouchError.prototype.toString = function () {
  return JSON.stringify({
    status: this.status,
    name: this.name,
    message: this.message,
    reason: this.reason
  });
};

var UNAUTHORIZED = new PouchError(401, 'unauthorized', "Name or password is incorrect.");
var MISSING_BULK_DOCS = new PouchError(400, 'bad_request', "Missing JSON list of 'docs'");
var MISSING_DOC = new PouchError(404, 'not_found', 'missing');
var REV_CONFLICT = new PouchError(409, 'conflict', 'Document update conflict');
var INVALID_ID = new PouchError(400, 'bad_request', '_id field must contain a string');
var MISSING_ID = new PouchError(412, 'missing_id', '_id is required for puts');
var RESERVED_ID = new PouchError(400, 'bad_request', 'Only reserved document ids may start with underscore.');
var NOT_OPEN = new PouchError(412, 'precondition_failed', 'Database not open');
var UNKNOWN_ERROR = new PouchError(500, 'unknown_error', 'Database encountered an unknown error');
var BAD_ARG = new PouchError(500, 'badarg', 'Some query argument is invalid');
var INVALID_REQUEST = new PouchError(400, 'invalid_request', 'Request was invalid');
var QUERY_PARSE_ERROR = new PouchError(400, 'query_parse_error', 'Some query parameter is invalid');
var DOC_VALIDATION = new PouchError(500, 'doc_validation', 'Bad special document member');
var BAD_REQUEST = new PouchError(400, 'bad_request', 'Something wrong with the request');
var NOT_AN_OBJECT = new PouchError(400, 'bad_request', 'Document must be a JSON object');
var DB_MISSING = new PouchError(404, 'not_found', 'Database not found');
var IDB_ERROR = new PouchError(500, 'indexed_db_went_bad', 'unknown');
var WSQ_ERROR = new PouchError(500, 'web_sql_went_bad', 'unknown');
var LDB_ERROR = new PouchError(500, 'levelDB_went_went_bad', 'unknown');
var FORBIDDEN = new PouchError(403, 'forbidden', 'Forbidden by design doc validate_doc_update function');
var INVALID_REV = new PouchError(400, 'bad_request', 'Invalid rev format');
var FILE_EXISTS = new PouchError(412, 'file_exists', 'The database could not be created, the file already exists.');
var MISSING_STUB = new PouchError(412, 'missing_stub', 'A pre-existing attachment stub wasn\'t found');
var INVALID_URL = new PouchError(413, 'invalid_url', 'Provided URL is invalid');

function createError(error, reason) {
  function CustomPouchError(reason) {
    // inherit error properties from our parent error manually
    // so as to allow proper JSON parsing.
    /* jshint ignore:start */
    for (var p in error) {
      if (typeof error[p] !== 'function') {
        this[p] = error[p];
      }
    }
    /* jshint ignore:end */
    if (reason !== undefined) {
      this.reason = reason;
    }
  }
  CustomPouchError.prototype = PouchError.prototype;
  return new CustomPouchError(reason);
}

function generateErrorFromResponse(err) {

  if (typeof err !== 'object') {
    var data = err;
    err = UNKNOWN_ERROR;
    err.data = data;
  }

  if ('error' in err && err.error === 'conflict') {
    err.name = 'conflict';
    err.status = 409;
  }

  if (!('name' in err)) {
    err.name = err.error || 'unknown';
  }

  if (!('status' in err)) {
    err.status = 500;
  }

  if (!('message' in err)) {
    err.message = err.message || err.reason;
  }

  return err;
}

function tryFilter(filter, doc, req) {
  try {
    return !filter(doc, req);
  } catch (err) {
    var msg = 'Filter function threw: ' + err.toString();
    return createError(BAD_REQUEST, msg);
  }
}

function filterChange(opts) {
  var req = {};
  var hasFilter = opts.filter && typeof opts.filter === 'function';
  req.query = opts.query_params;

  return function filter(change) {
    if (!change.doc) {
      // CSG sends events on the changes feed that don't have documents,
      // this hack makes a whole lot of existing code robust.
      change.doc = {};
    }

    var filterReturn = hasFilter && tryFilter(opts.filter, change.doc, req);

    if (typeof filterReturn === 'object') {
      return filterReturn;
    }

    if (filterReturn) {
      return false;
    }

    if (!opts.include_docs) {
      delete change.doc;
    } else if (!opts.attachments) {
      for (var att in change.doc._attachments) {
        /* istanbul ignore else */
        if (change.doc._attachments.hasOwnProperty(att)) {
          change.doc._attachments[att].stub = true;
        }
      }
    }
    return true;
  };
}

function flatten(arrs) {
  var res = [];
  for (var i = 0, len = arrs.length; i < len; i++) {
    res = res.concat(arrs[i]);
  }
  return res;
}

// shim for Function.prototype.name,
// for browsers that don't support it like IE

/* istanbul ignore next */
function f() {}

var hasName = f.name;
var res;

// We dont run coverage in IE
/* istanbul ignore else */
if (hasName) {
  res = function (fun) {
    return fun.name;
  };
} else {
  res = function (fun) {
    return fun.toString().match(/^\s*function\s*(\S*)\s*\(/)[1];
  };
}

// Determine id an ID is valid
//   - invalid IDs begin with an underescore that does not begin '_design' or
//     '_local'
//   - any other string value is a valid id
// Returns the specific error object for each case
function invalidIdError(id) {
  var err;
  if (!id) {
    err = createError(MISSING_ID);
  } else if (typeof id !== 'string') {
    err = createError(INVALID_ID);
  } else if (/^_/.test(id) && !(/^_(design|local)/).test(id)) {
    err = createError(RESERVED_ID);
  }
  if (err) {
    throw err;
  }
}

// Checks if a PouchDB object is "remote" or not. This is
// designed to opt-in to certain optimizations, such as
// avoiding checks for "dependentDbs" and other things that
// we know only apply to local databases. In general, "remote"
// should be true for the http adapter, and for third-party
// adapters with similar expensive boundaries to cross for
// every API call, such as socket-pouch and worker-pouch.
// Previously, this was handled via db.type() === 'http'
// which is now deprecated.

function isRemote(db) {
  if (typeof db._remote === 'boolean') {
    return db._remote;
  }
  /* istanbul ignore next */
  if (typeof db.type === 'function') {
    guardedConsole('warn',
      'db.type() is deprecated and will be removed in ' +
      'a future version of PouchDB');
    return db.type() === 'http';
  }
  /* istanbul ignore next */
  return false;
}

function listenerCount(ee, type) {
  return 'listenerCount' in ee ? ee.listenerCount(type) :
                                 EventEmitter.listenerCount(ee, type);
}

function parseDesignDocFunctionName(s) {
  if (!s) {
    return null;
  }
  var parts = s.split('/');
  if (parts.length === 2) {
    return parts;
  }
  if (parts.length === 1) {
    return [s, s];
  }
  return null;
}

function normalizeDesignDocFunctionName(s) {
  var normalized = parseDesignDocFunctionName(s);
  return normalized ? normalized.join('/') : null;
}

// originally parseUri 1.2.2, now patched by us
// (c) Steven Levithan <stevenlevithan.com>
// MIT License
var keys = ["source", "protocol", "authority", "userInfo", "user", "password",
    "host", "port", "relative", "path", "directory", "file", "query", "anchor"];
var qName ="queryKey";
var qParser = /(?:^|&)([^&=]*)=?([^&]*)/g;

// use the "loose" parser
/* eslint maxlen: 0, no-useless-escape: 0 */
var parser = /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/;

function parseUri(str) {
  var m = parser.exec(str);
  var uri = {};
  var i = 14;

  while (i--) {
    var key = keys[i];
    var value = m[i] || "";
    var encoded = ['user', 'password'].indexOf(key) !== -1;
    uri[key] = encoded ? decodeURIComponent(value) : value;
  }

  uri[qName] = {};
  uri[keys[12]].replace(qParser, function ($0, $1, $2) {
    if ($1) {
      uri[qName][$1] = $2;
    }
  });

  return uri;
}

// Based on https://github.com/alexdavid/scope-eval v0.0.3
// (source: https://unpkg.com/scope-eval@0.0.3/scope_eval.js)
// This is basically just a wrapper around new Function()

function scopeEval(source, scope) {
  var keys = [];
  var values = [];
  for (var key in scope) {
    if (scope.hasOwnProperty(key)) {
      keys.push(key);
      values.push(scope[key]);
    }
  }
  keys.push(source);
  return Function.apply(null, keys).apply(null, values);
}

// this is essentially the "update sugar" function from daleharvey/pouchdb#1388
// the diffFun tells us what delta to apply to the doc.  it either returns
// the doc, or false if it doesn't need to do an update after all
function upsert(db, docId, diffFun) {
  return new PouchPromise$1(function (fulfill, reject) {
    db.get(docId, function (err, doc) {
      if (err) {
        /* istanbul ignore next */
        if (err.status !== 404) {
          return reject(err);
        }
        doc = {};
      }

      // the user might change the _rev, so save it for posterity
      var docRev = doc._rev;
      var newDoc = diffFun(doc);

      if (!newDoc) {
        // if the diffFun returns falsy, we short-circuit as
        // an optimization
        return fulfill({updated: false, rev: docRev});
      }

      // users aren't allowed to modify these values,
      // so reset them here
      newDoc._id = docId;
      newDoc._rev = docRev;
      fulfill(tryAndPut(db, newDoc, diffFun));
    });
  });
}

function tryAndPut(db, doc, diffFun) {
  return db.put(doc).then(function (res) {
    return {
      updated: true,
      rev: res.rev
    };
  }, function (err) {
    /* istanbul ignore next */
    if (err.status !== 409) {
      throw err;
    }
    return upsert(db, doc._id, diffFun);
  });
}

function rev() {
  return index$1.v4().replace(/-/g, '').toLowerCase();
}

var uuid = index$1.v4;

// We fetch all leafs of the revision tree, and sort them based on tree length
// and whether they were deleted, undeleted documents with the longest revision
// tree (most edits) win
// The final sort algorithm is slightly documented in a sidebar here:
// http://guide.couchdb.org/draft/conflicts.html
function winningRev(metadata) {
  var winningId;
  var winningPos;
  var winningDeleted;
  var toVisit = metadata.rev_tree.slice();
  var node;
  while ((node = toVisit.pop())) {
    var tree = node.ids;
    var branches = tree[2];
    var pos = node.pos;
    if (branches.length) { // non-leaf
      for (var i = 0, len = branches.length; i < len; i++) {
        toVisit.push({pos: pos + 1, ids: branches[i]});
      }
      continue;
    }
    var deleted = !!tree[1].deleted;
    var id = tree[0];
    // sort by deleted, then pos, then id
    if (!winningId || (winningDeleted !== deleted ? winningDeleted :
        winningPos !== pos ? winningPos < pos : winningId < id)) {
      winningId = id;
      winningPos = pos;
      winningDeleted = deleted;
    }
  }

  return winningPos + '-' + winningId;
}

// Pretty much all below can be combined into a higher order function to
// traverse revisions
// The return value from the callback will be passed as context to all
// children of that node
function traverseRevTree(revs, callback) {
  var toVisit = revs.slice();

  var node;
  while ((node = toVisit.pop())) {
    var pos = node.pos;
    var tree = node.ids;
    var branches = tree[2];
    var newCtx =
      callback(branches.length === 0, pos, tree[0], node.ctx, tree[1]);
    for (var i = 0, len = branches.length; i < len; i++) {
      toVisit.push({pos: pos + 1, ids: branches[i], ctx: newCtx});
    }
  }
}

function sortByPos(a, b) {
  return a.pos - b.pos;
}

function collectLeaves(revs) {
  var leaves = [];
  traverseRevTree(revs, function (isLeaf, pos, id, acc, opts) {
    if (isLeaf) {
      leaves.push({rev: pos + "-" + id, pos: pos, opts: opts});
    }
  });
  leaves.sort(sortByPos).reverse();
  for (var i = 0, len = leaves.length; i < len; i++) {
    delete leaves[i].pos;
  }
  return leaves;
}

// returns revs of all conflicts that is leaves such that
// 1. are not deleted and
// 2. are different than winning revision
function collectConflicts(metadata) {
  var win = winningRev(metadata);
  var leaves = collectLeaves(metadata.rev_tree);
  var conflicts = [];
  for (var i = 0, len = leaves.length; i < len; i++) {
    var leaf = leaves[i];
    if (leaf.rev !== win && !leaf.opts.deleted) {
      conflicts.push(leaf.rev);
    }
  }
  return conflicts;
}

// compact a tree by marking its non-leafs as missing,
// and return a list of revs to delete
function compactTree(metadata) {
  var revs = [];
  traverseRevTree(metadata.rev_tree, function (isLeaf, pos,
                                               revHash, ctx, opts) {
    if (opts.status === 'available' && !isLeaf) {
      revs.push(pos + '-' + revHash);
      opts.status = 'missing';
    }
  });
  return revs;
}

// build up a list of all the paths to the leafs in this revision tree
function rootToLeaf(revs) {
  var paths = [];
  var toVisit = revs.slice();
  var node;
  while ((node = toVisit.pop())) {
    var pos = node.pos;
    var tree = node.ids;
    var id = tree[0];
    var opts = tree[1];
    var branches = tree[2];
    var isLeaf = branches.length === 0;

    var history = node.history ? node.history.slice() : [];
    history.push({id: id, opts: opts});
    if (isLeaf) {
      paths.push({pos: (pos + 1 - history.length), ids: history});
    }
    for (var i = 0, len = branches.length; i < len; i++) {
      toVisit.push({pos: pos + 1, ids: branches[i], history: history});
    }
  }
  return paths.reverse();
}

// for a better overview of what this is doing, read:
// https://github.com/apache/couchdb-couch/blob/master/src/couch_key_tree.erl
//
// But for a quick intro, CouchDB uses a revision tree to store a documents
// history, A -> B -> C, when a document has conflicts, that is a branch in the
// tree, A -> (B1 | B2 -> C), We store these as a nested array in the format
//
// KeyTree = [Path ... ]
// Path = {pos: position_from_root, ids: Tree}
// Tree = [Key, Opts, [Tree, ...]], in particular single node: [Key, []]

function sortByPos$1(a, b) {
  return a.pos - b.pos;
}

// classic binary search
function binarySearch(arr, item, comparator) {
  var low = 0;
  var high = arr.length;
  var mid;
  while (low < high) {
    mid = (low + high) >>> 1;
    if (comparator(arr[mid], item) < 0) {
      low = mid + 1;
    } else {
      high = mid;
    }
  }
  return low;
}

// assuming the arr is sorted, insert the item in the proper place
function insertSorted(arr, item, comparator) {
  var idx = binarySearch(arr, item, comparator);
  arr.splice(idx, 0, item);
}

// Turn a path as a flat array into a tree with a single branch.
// If any should be stemmed from the beginning of the array, that's passed
// in as the second argument
function pathToTree(path, numStemmed) {
  var root;
  var leaf;
  for (var i = numStemmed, len = path.length; i < len; i++) {
    var node = path[i];
    var currentLeaf = [node.id, node.opts, []];
    if (leaf) {
      leaf[2].push(currentLeaf);
      leaf = currentLeaf;
    } else {
      root = leaf = currentLeaf;
    }
  }
  return root;
}

// compare the IDs of two trees
function compareTree(a, b) {
  return a[0] < b[0] ? -1 : 1;
}

// Merge two trees together
// The roots of tree1 and tree2 must be the same revision
function mergeTree(in_tree1, in_tree2) {
  var queue = [{tree1: in_tree1, tree2: in_tree2}];
  var conflicts = false;
  while (queue.length > 0) {
    var item = queue.pop();
    var tree1 = item.tree1;
    var tree2 = item.tree2;

    if (tree1[1].status || tree2[1].status) {
      tree1[1].status =
        (tree1[1].status ===  'available' ||
        tree2[1].status === 'available') ? 'available' : 'missing';
    }

    for (var i = 0; i < tree2[2].length; i++) {
      if (!tree1[2][0]) {
        conflicts = 'new_leaf';
        tree1[2][0] = tree2[2][i];
        continue;
      }

      var merged = false;
      for (var j = 0; j < tree1[2].length; j++) {
        if (tree1[2][j][0] === tree2[2][i][0]) {
          queue.push({tree1: tree1[2][j], tree2: tree2[2][i]});
          merged = true;
        }
      }
      if (!merged) {
        conflicts = 'new_branch';
        insertSorted(tree1[2], tree2[2][i], compareTree);
      }
    }
  }
  return {conflicts: conflicts, tree: in_tree1};
}

function doMerge(tree, path, dontExpand) {
  var restree = [];
  var conflicts = false;
  var merged = false;
  var res;

  if (!tree.length) {
    return {tree: [path], conflicts: 'new_leaf'};
  }

  for (var i = 0, len = tree.length; i < len; i++) {
    var branch = tree[i];
    if (branch.pos === path.pos && branch.ids[0] === path.ids[0]) {
      // Paths start at the same position and have the same root, so they need
      // merged
      res = mergeTree(branch.ids, path.ids);
      restree.push({pos: branch.pos, ids: res.tree});
      conflicts = conflicts || res.conflicts;
      merged = true;
    } else if (dontExpand !== true) {
      // The paths start at a different position, take the earliest path and
      // traverse up until it as at the same point from root as the path we
      // want to merge.  If the keys match we return the longer path with the
      // other merged After stemming we dont want to expand the trees

      var t1 = branch.pos < path.pos ? branch : path;
      var t2 = branch.pos < path.pos ? path : branch;
      var diff = t2.pos - t1.pos;

      var candidateParents = [];

      var trees = [];
      trees.push({ids: t1.ids, diff: diff, parent: null, parentIdx: null});
      while (trees.length > 0) {
        var item = trees.pop();
        if (item.diff === 0) {
          if (item.ids[0] === t2.ids[0]) {
            candidateParents.push(item);
          }
          continue;
        }
        var elements = item.ids[2];
        for (var j = 0, elementsLen = elements.length; j < elementsLen; j++) {
          trees.push({
            ids: elements[j],
            diff: item.diff - 1,
            parent: item.ids,
            parentIdx: j
          });
        }
      }

      var el = candidateParents[0];

      if (!el) {
        restree.push(branch);
      } else {
        res = mergeTree(el.ids, t2.ids);
        el.parent[2][el.parentIdx] = res.tree;
        restree.push({pos: t1.pos, ids: t1.ids});
        conflicts = conflicts || res.conflicts;
        merged = true;
      }
    } else {
      restree.push(branch);
    }
  }

  // We didnt find
  if (!merged) {
    restree.push(path);
  }

  restree.sort(sortByPos$1);

  return {
    tree: restree,
    conflicts: conflicts || 'internal_node'
  };
}

// To ensure we dont grow the revision tree infinitely, we stem old revisions
function stem(tree, depth) {
  // First we break out the tree into a complete list of root to leaf paths
  var paths = rootToLeaf(tree);
  var stemmedRevs;

  var result;
  for (var i = 0, len = paths.length; i < len; i++) {
    // Then for each path, we cut off the start of the path based on the
    // `depth` to stem to, and generate a new set of flat trees
    var path = paths[i];
    var stemmed = path.ids;
    var node;
    if (stemmed.length > depth) {
      // only do the stemming work if we actually need to stem
      if (!stemmedRevs) {
        stemmedRevs = {}; // avoid allocating this object unnecessarily
      }
      var numStemmed = stemmed.length - depth;
      node = {
        pos: path.pos + numStemmed,
        ids: pathToTree(stemmed, numStemmed)
      };

      for (var s = 0; s < numStemmed; s++) {
        var rev = (path.pos + s) + '-' + stemmed[s].id;
        stemmedRevs[rev] = true;
      }
    } else { // no need to actually stem
      node = {
        pos: path.pos,
        ids: pathToTree(stemmed, 0)
      };
    }

    // Then we remerge all those flat trees together, ensuring that we dont
    // connect trees that would go beyond the depth limit
    if (result) {
      result = doMerge(result, node, true).tree;
    } else {
      result = [node];
    }
  }

  // this is memory-heavy per Chrome profiler, avoid unless we actually stemmed
  if (stemmedRevs) {
    traverseRevTree(result, function (isLeaf, pos, revHash) {
      // some revisions may have been removed in a branch but not in another
      delete stemmedRevs[pos + '-' + revHash];
    });
  }

  return {
    tree: result,
    revs: stemmedRevs ? Object.keys(stemmedRevs) : []
  };
}

function merge(tree, path, depth) {
  var newTree = doMerge(tree, path);
  var stemmed = stem(newTree.tree, depth);
  return {
    tree: stemmed.tree,
    stemmedRevs: stemmed.revs,
    conflicts: newTree.conflicts
  };
}

// return true if a rev exists in the rev tree, false otherwise
function revExists(revs, rev) {
  var toVisit = revs.slice();
  var splitRev = rev.split('-');
  var targetPos = parseInt(splitRev[0], 10);
  var targetId = splitRev[1];

  var node;
  while ((node = toVisit.pop())) {
    if (node.pos === targetPos && node.ids[0] === targetId) {
      return true;
    }
    var branches = node.ids[2];
    for (var i = 0, len = branches.length; i < len; i++) {
      toVisit.push({pos: node.pos + 1, ids: branches[i]});
    }
  }
  return false;
}

function getTrees(node) {
  return node.ids;
}

// check if a specific revision of a doc has been deleted
//  - metadata: the metadata object from the doc store
//  - rev: (optional) the revision to check. defaults to winning revision
function isDeleted(metadata, rev) {
  if (!rev) {
    rev = winningRev(metadata);
  }
  var id = rev.substring(rev.indexOf('-') + 1);
  var toVisit = metadata.rev_tree.map(getTrees);

  var tree;
  while ((tree = toVisit.pop())) {
    if (tree[0] === id) {
      return !!tree[1].deleted;
    }
    toVisit = toVisit.concat(tree[2]);
  }
}

function isLocalId(id) {
  return (/^_local/).test(id);
}

// returns the current leaf node for a given revision
function latest(rev, metadata) {
  var toVisit = metadata.rev_tree.slice();
  var node;
  while ((node = toVisit.pop())) {
    var pos = node.pos;
    var tree = node.ids;
    var id = tree[0];
    var opts = tree[1];
    var branches = tree[2];
    var isLeaf = branches.length === 0;

    var history = node.history ? node.history.slice() : [];
    history.push({id: id, pos: pos, opts: opts});

    if (isLeaf) {
      for (var i = 0, len = history.length; i < len; i++) {
        var historyNode = history[i];
        var historyRev = historyNode.pos + '-' + historyNode.id;

        if (historyRev === rev) {
          // return the rev of this leaf
          return pos + '-' + id;
        }
      }
    }

    for (var j = 0, l = branches.length; j < l; j++) {
      toVisit.push({pos: pos + 1, ids: branches[j], history: history});
    }
  }

  /* istanbul ignore next */
  throw new Error('Unable to resolve latest revision for id ' + metadata.id + ', rev ' + rev);
}

inherits_browser$1(Changes$2, EventEmitter);

function tryCatchInChangeListener(self, change) {
  // isolate try/catches to avoid V8 deoptimizations
  try {
    self.emit('change', change);
  } catch (e) {
    guardedConsole('error', 'Error in .on("change", function):', e);
  }
}

function Changes$2(db, opts, callback) {
  EventEmitter.call(this);
  var self = this;
  this.db = db;
  opts = opts ? clone(opts) : {};
  var complete = opts.complete = once(function (err, resp) {
    if (err) {
      if (listenerCount(self, 'error') > 0) {
        self.emit('error', err);
      }
    } else {
      self.emit('complete', resp);
    }
    self.removeAllListeners();
    db.removeListener('destroyed', onDestroy);
  });
  if (callback) {
    self.on('complete', function (resp) {
      callback(null, resp);
    });
    self.on('error', callback);
  }
  function onDestroy() {
    self.cancel();
  }
  db.once('destroyed', onDestroy);

  opts.onChange = function (change) {
    /* istanbul ignore if */
    if (self.isCancelled) {
      return;
    }
    tryCatchInChangeListener(self, change);
  };

  var promise = new PouchPromise$1(function (fulfill, reject) {
    opts.complete = function (err, res) {
      if (err) {
        reject(err);
      } else {
        fulfill(res);
      }
    };
  });
  self.once('cancel', function () {
    db.removeListener('destroyed', onDestroy);
    opts.complete(null, {status: 'cancelled'});
  });
  this.then = promise.then.bind(promise);
  this['catch'] = promise['catch'].bind(promise);
  this.then(function (result) {
    complete(null, result);
  }, complete);



  if (!db.taskqueue.isReady) {
    db.taskqueue.addTask(function (failed) {
      if (failed) {
        opts.complete(failed);
      } else if (self.isCancelled) {
        self.emit('cancel');
      } else {
        self.validateChanges(opts);
      }
    });
  } else {
    self.validateChanges(opts);
  }
}
Changes$2.prototype.cancel = function () {
  this.isCancelled = true;
  if (this.db.taskqueue.isReady) {
    this.emit('cancel');
  }
};
function processChange(doc, metadata, opts) {
  var changeList = [{rev: doc._rev}];
  if (opts.style === 'all_docs') {
    changeList = collectLeaves(metadata.rev_tree)
    .map(function (x) { return {rev: x.rev}; });
  }
  var change = {
    id: metadata.id,
    changes: changeList,
    doc: doc
  };

  if (isDeleted(metadata, doc._rev)) {
    change.deleted = true;
  }
  if (opts.conflicts) {
    change.doc._conflicts = collectConflicts(metadata);
    if (!change.doc._conflicts.length) {
      delete change.doc._conflicts;
    }
  }
  return change;
}

Changes$2.prototype.validateChanges = function (opts) {
  var callback = opts.complete;
  var self = this;

  /* istanbul ignore else */
  if (PouchDB$3$1._changesFilterPlugin) {
    PouchDB$3$1._changesFilterPlugin.validate(opts, function (err) {
      if (err) {
        return callback(err);
      }
      self.doChanges(opts);
    });
  } else {
    self.doChanges(opts);
  }
};

Changes$2.prototype.doChanges = function (opts) {
  var self = this;
  var callback = opts.complete;

  opts = clone(opts);
  if ('live' in opts && !('continuous' in opts)) {
    opts.continuous = opts.live;
  }
  opts.processChange = processChange;

  if (opts.since === 'latest') {
    opts.since = 'now';
  }
  if (!opts.since) {
    opts.since = 0;
  }
  if (opts.since === 'now') {
    this.db.info().then(function (info) {
      /* istanbul ignore if */
      if (self.isCancelled) {
        callback(null, {status: 'cancelled'});
        return;
      }
      opts.since = info.update_seq;
      self.doChanges(opts);
    }, callback);
    return;
  }

  /* istanbul ignore else */
  if (PouchDB$3$1._changesFilterPlugin) {
    PouchDB$3$1._changesFilterPlugin.normalize(opts);
    if (PouchDB$3$1._changesFilterPlugin.shouldFilter(this, opts)) {
      return PouchDB$3$1._changesFilterPlugin.filter(this, opts);
    }
  } else {
    ['doc_ids', 'filter', 'selector', 'view'].forEach(function (key) {
      if (key in opts) {
        guardedConsole('warn',
          'The "' + key + '" option was passed in to changes/replicate, ' +
          'but pouchdb-changes-filter plugin is not installed, so it ' +
          'was ignored. Please install the plugin to enable filtering.'
        );
      }
    });
  }

  if (!('descending' in opts)) {
    opts.descending = false;
  }

  // 0 and 1 should return 1 document
  opts.limit = opts.limit === 0 ? 1 : opts.limit;
  opts.complete = callback;
  var newPromise = this.db._changes(opts);
  /* istanbul ignore else */
  if (newPromise && typeof newPromise.cancel === 'function') {
    var cancel = self.cancel;
    self.cancel = index$2(function (args) {
      newPromise.cancel();
      cancel.apply(this, args);
    });
  }
};

/*
 * A generic pouch adapter
 */

function compare(left, right) {
  return left < right ? -1 : left > right ? 1 : 0;
}

// Wrapper for functions that call the bulkdocs api with a single doc,
// if the first result is an error, return an error
function yankError(callback, docId) {
  return function (err, results) {
    if (err || (results[0] && results[0].error)) {
      err = err || results[0];
      err.docId = docId;
      callback(err);
    } else {
      callback(null, results.length ? results[0]  : results);
    }
  };
}

// clean docs given to us by the user
function cleanDocs(docs) {
  for (var i = 0; i < docs.length; i++) {
    var doc = docs[i];
    if (doc._deleted) {
      delete doc._attachments; // ignore atts for deleted docs
    } else if (doc._attachments) {
      // filter out extraneous keys from _attachments
      var atts = Object.keys(doc._attachments);
      for (var j = 0; j < atts.length; j++) {
        var att = atts[j];
        doc._attachments[att] = pick(doc._attachments[att],
          ['data', 'digest', 'content_type', 'length', 'revpos', 'stub']);
      }
    }
  }
}

// compare two docs, first by _id then by _rev
function compareByIdThenRev(a, b) {
  var idCompare = compare(a._id, b._id);
  if (idCompare !== 0) {
    return idCompare;
  }
  var aStart = a._revisions ? a._revisions.start : 0;
  var bStart = b._revisions ? b._revisions.start : 0;
  return compare(aStart, bStart);
}

// for every node in a revision tree computes its distance from the closest
// leaf
function computeHeight(revs) {
  var height = {};
  var edges = [];
  traverseRevTree(revs, function (isLeaf, pos, id, prnt) {
    var rev$$1 = pos + "-" + id;
    if (isLeaf) {
      height[rev$$1] = 0;
    }
    if (prnt !== undefined) {
      edges.push({from: prnt, to: rev$$1});
    }
    return rev$$1;
  });

  edges.reverse();
  edges.forEach(function (edge) {
    if (height[edge.from] === undefined) {
      height[edge.from] = 1 + height[edge.to];
    } else {
      height[edge.from] = Math.min(height[edge.from], 1 + height[edge.to]);
    }
  });
  return height;
}

function allDocsKeysQuery(api, opts, callback) {
  var keys =  ('limit' in opts) ?
      opts.keys.slice(opts.skip, opts.limit + opts.skip) :
      (opts.skip > 0) ? opts.keys.slice(opts.skip) : opts.keys;
  if (opts.descending) {
    keys.reverse();
  }
  if (!keys.length) {
    return api._allDocs({limit: 0}, callback);
  }
  var finalResults = {
    offset: opts.skip
  };
  return PouchPromise$1.all(keys.map(function (key) {
    var subOpts = $inject_Object_assign({key: key, deleted: 'ok'}, opts);
    ['limit', 'skip', 'keys'].forEach(function (optKey) {
      delete subOpts[optKey];
    });
    return new PouchPromise$1(function (resolve, reject) {
      api._allDocs(subOpts, function (err, res) {
        /* istanbul ignore if */
        if (err) {
          return reject(err);
        }
        finalResults.total_rows = res.total_rows;
        resolve(res.rows[0] || {key: key, error: 'not_found'});
      });
    });
  })).then(function (results) {
    finalResults.rows = results;
    return finalResults;
  });
}

// all compaction is done in a queue, to avoid attaching
// too many listeners at once
function doNextCompaction(self) {
  var task = self._compactionQueue[0];
  var opts = task.opts;
  var callback = task.callback;
  self.get('_local/compaction').catch(function () {
    return false;
  }).then(function (doc) {
    if (doc && doc.last_seq) {
      opts.last_seq = doc.last_seq;
    }
    self._compact(opts, function (err, res) {
      /* istanbul ignore if */
      if (err) {
        callback(err);
      } else {
        callback(null, res);
      }
      browser$2(function () {
        self._compactionQueue.shift();
        if (self._compactionQueue.length) {
          doNextCompaction(self);
        }
      });
    });
  });
}

function attachmentNameError(name) {
  if (name.charAt(0) === '_') {
    return name + ' is not a valid attachment name, attachment ' +
      'names cannot start with \'_\'';
  }
  return false;
}

inherits_browser$1(AbstractPouchDB, EventEmitter);

function AbstractPouchDB() {
  EventEmitter.call(this);
}

AbstractPouchDB.prototype.post =
  adapterFun('post', function (doc, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  if (typeof doc !== 'object' || Array.isArray(doc)) {
    return callback(createError(NOT_AN_OBJECT));
  }
  this.bulkDocs({docs: [doc]}, opts, yankError(callback, doc._id));
});

AbstractPouchDB.prototype.put = adapterFun('put', function (doc, opts, cb) {
  if (typeof opts === 'function') {
    cb = opts;
    opts = {};
  }
  if (typeof doc !== 'object' || Array.isArray(doc)) {
    return cb(createError(NOT_AN_OBJECT));
  }
  invalidIdError(doc._id);
  if (isLocalId(doc._id) && typeof this._putLocal === 'function') {
    if (doc._deleted) {
      return this._removeLocal(doc, cb);
    } else {
      return this._putLocal(doc, cb);
    }
  }
  var self = this;
  if (opts.force && doc._rev) {
    transformForceOptionToNewEditsOption();
    putDoc(function (err) {
      var result = err ? null : {ok: true, id: doc._id, rev: doc._rev};
      cb(err, result);
    });
  } else {
    putDoc(cb);
  }

  function transformForceOptionToNewEditsOption() {
    var parts = doc._rev.split('-');
    var oldRevId = parts[1];
    var oldRevNum = parseInt(parts[0], 10);

    var newRevNum = oldRevNum + 1;
    var newRevId = rev();

    doc._revisions = {
      start: newRevNum,
      ids: [newRevId, oldRevId]
    };
    doc._rev = newRevNum + '-' + newRevId;
    opts.new_edits = false;
  }
  function putDoc(next) {
    if (typeof self._put === 'function' && opts.new_edits !== false) {
      self._put(doc, opts, next);
    } else {
      self.bulkDocs({docs: [doc]}, opts, yankError(next, doc._id));
    }
  }
});

AbstractPouchDB.prototype.putAttachment =
  adapterFun('putAttachment', function (docId, attachmentId, rev$$1,
                                              blob, type) {
  var api = this;
  if (typeof type === 'function') {
    type = blob;
    blob = rev$$1;
    rev$$1 = null;
  }
  // Lets fix in https://github.com/pouchdb/pouchdb/issues/3267
  /* istanbul ignore if */
  if (typeof type === 'undefined') {
    type = blob;
    blob = rev$$1;
    rev$$1 = null;
  }
  if (!type) {
    guardedConsole('warn', 'Attachment', attachmentId, 'on document', docId, 'is missing content_type');
  }

  function createAttachment(doc) {
    var prevrevpos = '_rev' in doc ? parseInt(doc._rev, 10) : 0;
    doc._attachments = doc._attachments || {};
    doc._attachments[attachmentId] = {
      content_type: type,
      data: blob,
      revpos: ++prevrevpos
    };
    return api.put(doc);
  }

  return api.get(docId).then(function (doc) {
    if (doc._rev !== rev$$1) {
      throw createError(REV_CONFLICT);
    }

    return createAttachment(doc);
  }, function (err) {
     // create new doc
    /* istanbul ignore else */
    if (err.reason === MISSING_DOC.message) {
      return createAttachment({_id: docId});
    } else {
      throw err;
    }
  });
});

AbstractPouchDB.prototype.removeAttachment =
  adapterFun('removeAttachment', function (docId, attachmentId, rev$$1,
                                                 callback) {
  var self = this;
  self.get(docId, function (err, obj) {
    /* istanbul ignore if */
    if (err) {
      callback(err);
      return;
    }
    if (obj._rev !== rev$$1) {
      callback(createError(REV_CONFLICT));
      return;
    }
    /* istanbul ignore if */
    if (!obj._attachments) {
      return callback();
    }
    delete obj._attachments[attachmentId];
    if (Object.keys(obj._attachments).length === 0) {
      delete obj._attachments;
    }
    self.put(obj, callback);
  });
});

AbstractPouchDB.prototype.remove =
  adapterFun('remove', function (docOrId, optsOrRev, opts, callback) {
  var doc;
  if (typeof optsOrRev === 'string') {
    // id, rev, opts, callback style
    doc = {
      _id: docOrId,
      _rev: optsOrRev
    };
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
  } else {
    // doc, opts, callback style
    doc = docOrId;
    if (typeof optsOrRev === 'function') {
      callback = optsOrRev;
      opts = {};
    } else {
      callback = opts;
      opts = optsOrRev;
    }
  }
  opts = opts || {};
  opts.was_delete = true;
  var newDoc = {_id: doc._id, _rev: (doc._rev || opts.rev)};
  newDoc._deleted = true;
  if (isLocalId(newDoc._id) && typeof this._removeLocal === 'function') {
    return this._removeLocal(doc, callback);
  }
  this.bulkDocs({docs: [newDoc]}, opts, yankError(callback, newDoc._id));
});

AbstractPouchDB.prototype.revsDiff =
  adapterFun('revsDiff', function (req, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  var ids = Object.keys(req);

  if (!ids.length) {
    return callback(null, {});
  }

  var count = 0;
  var missing = new ExportedMap();

  function addToMissing(id, revId) {
    if (!missing.has(id)) {
      missing.set(id, {missing: []});
    }
    missing.get(id).missing.push(revId);
  }

  function processDoc(id, rev_tree) {
    // Is this fast enough? Maybe we should switch to a set simulated by a map
    var missingForId = req[id].slice(0);
    traverseRevTree(rev_tree, function (isLeaf, pos, revHash, ctx,
      opts) {
        var rev$$1 = pos + '-' + revHash;
        var idx = missingForId.indexOf(rev$$1);
        if (idx === -1) {
          return;
        }

        missingForId.splice(idx, 1);
        /* istanbul ignore if */
        if (opts.status !== 'available') {
          addToMissing(id, rev$$1);
        }
      });

    // Traversing the tree is synchronous, so now `missingForId` contains
    // revisions that were not found in the tree
    missingForId.forEach(function (rev$$1) {
      addToMissing(id, rev$$1);
    });
  }

  ids.map(function (id) {
    this._getRevisionTree(id, function (err, rev_tree) {
      if (err && err.status === 404 && err.message === 'missing') {
        missing.set(id, {missing: req[id]});
      } else if (err) {
        /* istanbul ignore next */
        return callback(err);
      } else {
        processDoc(id, rev_tree);
      }

      if (++count === ids.length) {
        // convert LazyMap to object
        var missingObj = {};
        missing.forEach(function (value, key) {
          missingObj[key] = value;
        });
        return callback(null, missingObj);
      }
    });
  }, this);
});

// _bulk_get API for faster replication, as described in
// https://github.com/apache/couchdb-chttpd/pull/33
// At the "abstract" level, it will just run multiple get()s in
// parallel, because this isn't much of a performance cost
// for local databases (except the cost of multiple transactions, which is
// small). The http adapter overrides this in order
// to do a more efficient single HTTP request.
AbstractPouchDB.prototype.bulkGet =
  adapterFun('bulkGet', function (opts, callback) {
  bulkGet(this, opts, callback);
});

// compact one document and fire callback
// by compacting we mean removing all revisions which
// are further from the leaf in revision tree than max_height
AbstractPouchDB.prototype.compactDocument =
  adapterFun('compactDocument', function (docId, maxHeight, callback) {
  var self = this;
  this._getRevisionTree(docId, function (err, revTree) {
    /* istanbul ignore if */
    if (err) {
      return callback(err);
    }
    var height = computeHeight(revTree);
    var candidates = [];
    var revs = [];
    Object.keys(height).forEach(function (rev$$1) {
      if (height[rev$$1] > maxHeight) {
        candidates.push(rev$$1);
      }
    });

    traverseRevTree(revTree, function (isLeaf, pos, revHash, ctx, opts) {
      var rev$$1 = pos + '-' + revHash;
      if (opts.status === 'available' && candidates.indexOf(rev$$1) !== -1) {
        revs.push(rev$$1);
      }
    });
    self._doCompaction(docId, revs, callback);
  });
});

// compact the whole database using single document
// compaction
AbstractPouchDB.prototype.compact =
  adapterFun('compact', function (opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }

  var self = this;
  opts = opts || {};

  self._compactionQueue = self._compactionQueue || [];
  self._compactionQueue.push({opts: opts, callback: callback});
  if (self._compactionQueue.length === 1) {
    doNextCompaction(self);
  }
});
AbstractPouchDB.prototype._compact = function (opts, callback) {
  var self = this;
  var changesOpts = {
    return_docs: false,
    last_seq: opts.last_seq || 0
  };
  var promises = [];

  function onChange(row) {
    promises.push(self.compactDocument(row.id, 0));
  }
  function onComplete(resp) {
    var lastSeq = resp.last_seq;
    PouchPromise$1.all(promises).then(function () {
      return upsert(self, '_local/compaction', function deltaFunc(doc) {
        if (!doc.last_seq || doc.last_seq < lastSeq) {
          doc.last_seq = lastSeq;
          return doc;
        }
        return false; // somebody else got here first, don't update
      });
    }).then(function () {
      callback(null, {ok: true});
    }).catch(callback);
  }
  self.changes(changesOpts)
    .on('change', onChange)
    .on('complete', onComplete)
    .on('error', callback);
};

/* Begin api wrappers. Specific functionality to storage belongs in the
   _[method] */
AbstractPouchDB.prototype.get = adapterFun('get', function (id, opts, cb) {
  if (typeof opts === 'function') {
    cb = opts;
    opts = {};
  }
  if (typeof id !== 'string') {
    return cb(createError(INVALID_ID));
  }
  if (isLocalId(id) && typeof this._getLocal === 'function') {
    return this._getLocal(id, cb);
  }
  var leaves = [], self = this;

  function finishOpenRevs() {
    var result = [];
    var count = leaves.length;
    /* istanbul ignore if */
    if (!count) {
      return cb(null, result);
    }

    // order with open_revs is unspecified
    leaves.forEach(function (leaf) {
      self.get(id, {
        rev: leaf,
        revs: opts.revs,
        latest: opts.latest,
        attachments: opts.attachments
      }, function (err, doc) {
        if (!err) {
          // using latest=true can produce duplicates
          var existing;
          for (var i = 0, l = result.length; i < l; i++) {
            if (result[i].ok && result[i].ok._rev === doc._rev) {
              existing = true;
              break;
            }
          }
          if (!existing) {
            result.push({ok: doc});
          }
        } else {
          result.push({missing: leaf});
        }
        count--;
        if (!count) {
          cb(null, result);
        }
      });
    });
  }

  if (opts.open_revs) {
    if (opts.open_revs === "all") {
      this._getRevisionTree(id, function (err, rev_tree) {
        if (err) {
          return cb(err);
        }
        leaves = collectLeaves(rev_tree).map(function (leaf) {
          return leaf.rev;
        });
        finishOpenRevs();
      });
    } else {
      if (Array.isArray(opts.open_revs)) {
        leaves = opts.open_revs;
        for (var i = 0; i < leaves.length; i++) {
          var l = leaves[i];
          // looks like it's the only thing couchdb checks
          if (!(typeof (l) === "string" && /^\d+-/.test(l))) {
            return cb(createError(INVALID_REV));
          }
        }
        finishOpenRevs();
      } else {
        return cb(createError(UNKNOWN_ERROR, 'function_clause'));
      }
    }
    return; // open_revs does not like other options
  }

  return this._get(id, opts, function (err, result) {
    if (err) {
      err.docId = id;
      return cb(err);
    }

    var doc = result.doc;
    var metadata = result.metadata;
    var ctx = result.ctx;

    if (opts.conflicts) {
      var conflicts = collectConflicts(metadata);
      if (conflicts.length) {
        doc._conflicts = conflicts;
      }
    }

    if (isDeleted(metadata, doc._rev)) {
      doc._deleted = true;
    }

    if (opts.revs || opts.revs_info) {
      var splittedRev = doc._rev.split('-');
      var revNo       = parseInt(splittedRev[0], 10);
      var revHash     = splittedRev[1];

      var paths = rootToLeaf(metadata.rev_tree);
      var path = null;

      for (var i = 0; i < paths.length; i++) {
        var currentPath = paths[i];
        var hashIndex = currentPath.ids.map(function (x) { return x.id; })
          .indexOf(revHash);
        var hashFoundAtRevPos = hashIndex === (revNo - 1);

        if (hashFoundAtRevPos || (!path && hashIndex !== -1)) {
          path = currentPath;
        }
      }

      var indexOfRev = path.ids.map(function (x) { return x.id; })
        .indexOf(doc._rev.split('-')[1]) + 1;
      var howMany = path.ids.length - indexOfRev;
      path.ids.splice(indexOfRev, howMany);
      path.ids.reverse();

      if (opts.revs) {
        doc._revisions = {
          start: (path.pos + path.ids.length) - 1,
          ids: path.ids.map(function (rev$$1) {
            return rev$$1.id;
          })
        };
      }
      if (opts.revs_info) {
        var pos =  path.pos + path.ids.length;
        doc._revs_info = path.ids.map(function (rev$$1) {
          pos--;
          return {
            rev: pos + '-' + rev$$1.id,
            status: rev$$1.opts.status
          };
        });
      }
    }

    if (opts.attachments && doc._attachments) {
      var attachments = doc._attachments;
      var count = Object.keys(attachments).length;
      if (count === 0) {
        return cb(null, doc);
      }
      Object.keys(attachments).forEach(function (key) {
        this._getAttachment(doc._id, key, attachments[key], {
          // Previously the revision handling was done in adapter.js
          // getAttachment, however since idb-next doesnt we need to
          // pass the rev through
          rev: doc._rev,
          binary: opts.binary,
          ctx: ctx
        }, function (err, data) {
          var att = doc._attachments[key];
          att.data = data;
          delete att.stub;
          delete att.length;
          if (!--count) {
            cb(null, doc);
          }
        });
      }, self);
    } else {
      if (doc._attachments) {
        for (var key in doc._attachments) {
          /* istanbul ignore else */
          if (doc._attachments.hasOwnProperty(key)) {
            doc._attachments[key].stub = true;
          }
        }
      }
      cb(null, doc);
    }
  });
});

// TODO: I dont like this, it forces an extra read for every
// attachment read and enforces a confusing api between
// adapter.js and the adapter implementation
AbstractPouchDB.prototype.getAttachment =
  adapterFun('getAttachment', function (docId, attachmentId, opts, callback) {
  var self = this;
  if (opts instanceof Function) {
    callback = opts;
    opts = {};
  }
  this._get(docId, opts, function (err, res) {
    if (err) {
      return callback(err);
    }
    if (res.doc._attachments && res.doc._attachments[attachmentId]) {
      opts.ctx = res.ctx;
      opts.binary = true;
      self._getAttachment(docId, attachmentId,
                          res.doc._attachments[attachmentId], opts, callback);
    } else {
      return callback(createError(MISSING_DOC));
    }
  });
});

AbstractPouchDB.prototype.allDocs =
  adapterFun('allDocs', function (opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  opts.skip = typeof opts.skip !== 'undefined' ? opts.skip : 0;
  if (opts.start_key) {
    opts.startkey = opts.start_key;
  }
  if (opts.end_key) {
    opts.endkey = opts.end_key;
  }
  if ('keys' in opts) {
    if (!Array.isArray(opts.keys)) {
      return callback(new TypeError('options.keys must be an array'));
    }
    var incompatibleOpt =
      ['startkey', 'endkey', 'key'].filter(function (incompatibleOpt) {
      return incompatibleOpt in opts;
    })[0];
    if (incompatibleOpt) {
      callback(createError(QUERY_PARSE_ERROR,
        'Query parameter `' + incompatibleOpt +
        '` is not compatible with multi-get'
      ));
      return;
    }
    if (!isRemote(this)) {
      return allDocsKeysQuery(this, opts, callback);
    }
  }

  return this._allDocs(opts, callback);
});

AbstractPouchDB.prototype.changes = function (opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return new Changes$2(this, opts, callback);
};

AbstractPouchDB.prototype.close = adapterFun('close', function (callback) {
  this._closed = true;
  this.emit('closed');
  return this._close(callback);
});

AbstractPouchDB.prototype.info = adapterFun('info', function (callback) {
  var self = this;
  this._info(function (err, info) {
    if (err) {
      return callback(err);
    }
    // assume we know better than the adapter, unless it informs us
    info.db_name = info.db_name || self.name;
    info.auto_compaction = !!(self.auto_compaction && !isRemote(self));
    info.adapter = self.adapter;
    callback(null, info);
  });
});

AbstractPouchDB.prototype.id = adapterFun('id', function (callback) {
  return this._id(callback);
});

/* istanbul ignore next */
AbstractPouchDB.prototype.type = function () {
  return (typeof this._type === 'function') ? this._type() : this.adapter;
};

AbstractPouchDB.prototype.bulkDocs =
  adapterFun('bulkDocs', function (req, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }

  opts = opts || {};

  if (Array.isArray(req)) {
    req = {
      docs: req
    };
  }

  if (!req || !req.docs || !Array.isArray(req.docs)) {
    return callback(createError(MISSING_BULK_DOCS));
  }

  for (var i = 0; i < req.docs.length; ++i) {
    if (typeof req.docs[i] !== 'object' || Array.isArray(req.docs[i])) {
      return callback(createError(NOT_AN_OBJECT));
    }
  }

  var attachmentError;
  req.docs.forEach(function (doc) {
    if (doc._attachments) {
      Object.keys(doc._attachments).forEach(function (name) {
        attachmentError = attachmentError || attachmentNameError(name);
        if (!doc._attachments[name].content_type) {
          guardedConsole('warn', 'Attachment', name, 'on document', doc._id, 'is missing content_type');
        }
      });
    }
  });

  if (attachmentError) {
    return callback(createError(BAD_REQUEST, attachmentError));
  }

  if (!('new_edits' in opts)) {
    if ('new_edits' in req) {
      opts.new_edits = req.new_edits;
    } else {
      opts.new_edits = true;
    }
  }

  var adapter = this;
  if (!opts.new_edits && !isRemote(adapter)) {
    // ensure revisions of the same doc are sorted, so that
    // the local adapter processes them correctly (#2935)
    req.docs.sort(compareByIdThenRev);
  }

  cleanDocs(req.docs);

  // in the case of conflicts, we want to return the _ids to the user
  // however, the underlying adapter may destroy the docs array, so
  // create a copy here
  var ids = req.docs.map(function (doc) {
    return doc._id;
  });

  return this._bulkDocs(req, opts, function (err, res) {
    if (err) {
      return callback(err);
    }
    if (!opts.new_edits) {
      // this is what couch does when new_edits is false
      res = res.filter(function (x) {
        return x.error;
      });
    }
    // add ids for error/conflict responses (not required for CouchDB)
    if (!isRemote(adapter)) {
      for (var i = 0, l = res.length; i < l; i++) {
        res[i].id = res[i].id || ids[i];
      }
    }

    callback(null, res);
  });
});

AbstractPouchDB.prototype.registerDependentDatabase =
  adapterFun('registerDependentDatabase', function (dependentDb,
                                                          callback) {
  var depDB = new this.constructor(dependentDb, this.__opts);

  function diffFun(doc) {
    doc.dependentDbs = doc.dependentDbs || {};
    if (doc.dependentDbs[dependentDb]) {
      return false; // no update required
    }
    doc.dependentDbs[dependentDb] = true;
    return doc;
  }
  upsert(this, '_local/_pouch_dependentDbs', diffFun)
    .then(function () {
      callback(null, {db: depDB});
    }).catch(callback);
});

AbstractPouchDB.prototype.destroy =
  adapterFun('destroy', function (opts, callback) {

  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }

  var self = this;
  var usePrefix = 'use_prefix' in self ? self.use_prefix : true;

  function destroyDb() {
    // call destroy method of the particular adaptor
    self._destroy(opts, function (err, resp) {
      if (err) {
        return callback(err);
      }
      self._destroyed = true;
      self.emit('destroyed');
      callback(null, resp || { 'ok': true });
    });
  }

  if (isRemote(self)) {
    // no need to check for dependent DBs if it's a remote DB
    return destroyDb();
  }

  self.get('_local/_pouch_dependentDbs', function (err, localDoc) {
    if (err) {
      /* istanbul ignore if */
      if (err.status !== 404) {
        return callback(err);
      } else { // no dependencies
        return destroyDb();
      }
    }
    var dependentDbs = localDoc.dependentDbs;
    var PouchDB = self.constructor;
    var deletedMap = Object.keys(dependentDbs).map(function (name) {
      // use_prefix is only false in the browser
      /* istanbul ignore next */
      var trueName = usePrefix ?
        name.replace(new RegExp('^' + PouchDB.prefix), '') : name;
      return new PouchDB(trueName, self.__opts).destroy();
    });
    PouchPromise$1.all(deletedMap).then(destroyDb, callback);
  });
});

function TaskQueue$1() {
  this.isReady = false;
  this.failed = false;
  this.queue = [];
}

TaskQueue$1.prototype.execute = function () {
  var fun;
  if (this.failed) {
    while ((fun = this.queue.shift())) {
      fun(this.failed);
    }
  } else {
    while ((fun = this.queue.shift())) {
      fun();
    }
  }
};

TaskQueue$1.prototype.fail = function (err) {
  this.failed = err;
  this.execute();
};

TaskQueue$1.prototype.ready = function (db) {
  this.isReady = true;
  this.db = db;
  this.execute();
};

TaskQueue$1.prototype.addTask = function (fun) {
  this.queue.push(fun);
  if (this.failed) {
    this.execute();
  }
};

function parseAdapter(name, opts) {
  var match = name.match(/([a-z-]*):\/\/(.*)/);
  if (match) {
    // the http adapter expects the fully qualified name
    return {
      name: /https?/.test(match[1]) ? match[1] + '://' + match[2] : match[2],
      adapter: match[1]
    };
  }

  var adapters = PouchDB$3$1.adapters;
  var preferredAdapters = PouchDB$3$1.preferredAdapters;
  var prefix = PouchDB$3$1.prefix;
  var adapterName = opts.adapter;

  if (!adapterName) { // automatically determine adapter
    for (var i = 0; i < preferredAdapters.length; ++i) {
      adapterName = preferredAdapters[i];
      // check for browsers that have been upgraded from websql-only to websql+idb
      /* istanbul ignore if */
      if (adapterName === 'idb' && 'websql' in adapters &&
          hasLocalStorage() && localStorage['_pouch__websqldb_' + prefix + name]) {
        // log it, because this can be confusing during development
        guardedConsole('log', 'PouchDB is downgrading "' + name + '" to WebSQL to' +
          ' avoid data loss, because it was already opened with WebSQL.');
        continue; // keep using websql to avoid user data loss
      }
      break;
    }
  }

  var adapter = adapters[adapterName];

  // if adapter is invalid, then an error will be thrown later
  var usePrefix = (adapter && 'use_prefix' in adapter) ?
    adapter.use_prefix : true;

  return {
    name: usePrefix ? (prefix + name) : name,
    adapter: adapterName
  };
}

// OK, so here's the deal. Consider this code:
//     var db1 = new PouchDB('foo');
//     var db2 = new PouchDB('foo');
//     db1.destroy();
// ^ these two both need to emit 'destroyed' events,
// as well as the PouchDB constructor itself.
// So we have one db object (whichever one got destroy() called on it)
// responsible for emitting the initial event, which then gets emitted
// by the constructor, which then broadcasts it to any other dbs
// that may have been created with the same name.
function prepareForDestruction(self) {

  function onDestroyed(from_constructor) {
    self.removeListener('closed', onClosed);
    if (!from_constructor) {
      self.constructor.emit('destroyed', self.name);
    }
  }

  function onClosed() {
    self.removeListener('destroyed', onDestroyed);
    self.constructor.emit('unref', self);
  }

  self.once('destroyed', onDestroyed);
  self.once('closed', onClosed);
  self.constructor.emit('ref', self);
}

inherits_browser$1(PouchDB$3$1, AbstractPouchDB);
function PouchDB$3$1(name, opts) {
  // In Node our test suite only tests this for PouchAlt unfortunately
  /* istanbul ignore if */
  if (!(this instanceof PouchDB$3$1)) {
    return new PouchDB$3$1(name, opts);
  }

  var self = this;
  opts = opts || {};

  if (name && typeof name === 'object') {
    opts = name;
    name = opts.name;
    delete opts.name;
  }

  this.__opts = opts = clone(opts);

  self.auto_compaction = opts.auto_compaction;
  self.prefix = PouchDB$3$1.prefix;

  if (typeof name !== 'string') {
    throw new Error('Missing/invalid DB name');
  }

  var prefixedName = (opts.prefix || '') + name;
  var backend = parseAdapter(prefixedName, opts);

  opts.name = backend.name;
  opts.adapter = opts.adapter || backend.adapter;

  self.name = name;
  self._adapter = opts.adapter;
  PouchDB$3$1.emit('debug', ['adapter', 'Picked adapter: ', opts.adapter]);

  if (!PouchDB$3$1.adapters[opts.adapter] ||
      !PouchDB$3$1.adapters[opts.adapter].valid()) {
    throw new Error('Invalid Adapter: ' + opts.adapter);
  }

  AbstractPouchDB.call(self);
  self.taskqueue = new TaskQueue$1();

  self.adapter = opts.adapter;

  PouchDB$3$1.adapters[opts.adapter].call(self, opts, function (err) {
    if (err) {
      return self.taskqueue.fail(err);
    }
    prepareForDestruction(self);

    self.emit('created', self);
    PouchDB$3$1.emit('created', self.name);
    self.taskqueue.ready(self);
  });

}

PouchDB$3$1.adapters = {};
PouchDB$3$1.preferredAdapters = [];

PouchDB$3$1.prefix = '_pouch_';

var eventEmitter = new EventEmitter();

function setUpEventEmitter(Pouch) {
  Object.keys(EventEmitter.prototype).forEach(function (key) {
    if (typeof EventEmitter.prototype[key] === 'function') {
      Pouch[key] = eventEmitter[key].bind(eventEmitter);
    }
  });

  // these are created in constructor.js, and allow us to notify each DB with
  // the same name that it was destroyed, via the constructor object
  var destructListeners = Pouch._destructionListeners = new ExportedMap();

  Pouch.on('ref', function onConstructorRef(db) {
    if (!destructListeners.has(db.name)) {
      destructListeners.set(db.name, []);
    }
    destructListeners.get(db.name).push(db);
  });

  Pouch.on('unref', function onConstructorUnref(db) {
    if (!destructListeners.has(db.name)) {
      return;
    }
    var dbList = destructListeners.get(db.name);
    var pos = dbList.indexOf(db);
    if (pos < 0) {
      /* istanbul ignore next */
      return;
    }
    dbList.splice(pos, 1);
    if (dbList.length > 1) {
      /* istanbul ignore next */
      destructListeners.set(db.name, dbList);
    } else {
      destructListeners.delete(db.name);
    }
  });

  Pouch.on('destroyed', function onConstructorDestroyed(name) {
    if (!destructListeners.has(name)) {
      return;
    }
    var dbList = destructListeners.get(name);
    destructListeners.delete(name);
    dbList.forEach(function (db) {
      db.emit('destroyed',true);
    });
  });
}

setUpEventEmitter(PouchDB$3$1);

PouchDB$3$1.adapter = function (id, obj, addToPreferredAdapters) {
  /* istanbul ignore else */
  if (obj.valid()) {
    PouchDB$3$1.adapters[id] = obj;
    if (addToPreferredAdapters) {
      PouchDB$3$1.preferredAdapters.push(id);
    }
  }
};

PouchDB$3$1.plugin = function (obj) {
  if (typeof obj === 'function') { // function style for plugins
    obj(PouchDB$3$1);
  } else if (typeof obj !== 'object' || Object.keys(obj).length === 0) {
    throw new Error('Invalid plugin: got "' + obj + '", expected an object or a function');
  } else {
    Object.keys(obj).forEach(function (id) { // object style for plugins
      PouchDB$3$1.prototype[id] = obj[id];
    });
  }
  if (this.__defaults) {
    PouchDB$3$1.__defaults = $inject_Object_assign({}, this.__defaults);
  }
  return PouchDB$3$1;
};

PouchDB$3$1.defaults = function (defaultOpts) {
  function PouchAlt(name, opts) {
    if (!(this instanceof PouchAlt)) {
      return new PouchAlt(name, opts);
    }

    opts = opts || {};

    if (name && typeof name === 'object') {
      opts = name;
      name = opts.name;
      delete opts.name;
    }

    opts = $inject_Object_assign({}, PouchAlt.__defaults, opts);
    PouchDB$3$1.call(this, name, opts);
  }

  inherits_browser$1(PouchAlt, PouchDB$3$1);

  PouchAlt.preferredAdapters = PouchDB$3$1.preferredAdapters.slice();
  Object.keys(PouchDB$3$1).forEach(function (key) {
    if (!(key in PouchAlt)) {
      PouchAlt[key] = PouchDB$3$1[key];
    }
  });

  // make default options transitive
  // https://github.com/pouchdb/pouchdb/issues/5922
  PouchAlt.__defaults = $inject_Object_assign({}, this.__defaults, defaultOpts);

  return PouchAlt;
};

// managed automatically by set-version.js
var version = "6.3.4";

function debugPouch(PouchDB) {
  PouchDB.debug = browser$3;
  var logs = {};
  /* istanbul ignore next */
  PouchDB.on('debug', function (args) {
    // first argument is log identifier
    var logId = args[0];
    // rest should be passed verbatim to debug module
    var logArgs = args.slice(1);
    if (!logs[logId]) {
      logs[logId] = browser$3('pouchdb:' + logId);
    }
    logs[logId].apply(null, logArgs);
  });
}

// this would just be "return doc[field]", but fields
// can be "deep" due to dot notation
function getFieldFromDoc(doc, parsedField) {
  var value = doc;
  for (var i = 0, len = parsedField.length; i < len; i++) {
    var key = parsedField[i];
    value = value[key];
    if (!value) {
      break;
    }
  }
  return value;
}

function compare$1(left, right) {
  return left < right ? -1 : left > right ? 1 : 0;
}

// Converts a string in dot notation to an array of its components, with backslash escaping
function parseField(fieldName) {
  // fields may be deep (e.g. "foo.bar.baz"), so parse
  var fields = [];
  var current = '';
  for (var i = 0, len = fieldName.length; i < len; i++) {
    var ch = fieldName[i];
    if (ch === '.') {
      if (i > 0 && fieldName[i - 1] === '\\') { // escaped delimiter
        current = current.substring(0, current.length - 1) + '.';
      } else { // not escaped, so delimiter
        fields.push(current);
        current = '';
      }
    } else { // normal character
      current += ch;
    }
  }
  fields.push(current);
  return fields;
}

var combinationFields = ['$or', '$nor', '$not'];
function isCombinationalField(field) {
  return combinationFields.indexOf(field) > -1;
}

function getKey(obj) {
  return Object.keys(obj)[0];
}

function getValue(obj) {
  return obj[getKey(obj)];
}


// flatten an array of selectors joined by an $and operator
function mergeAndedSelectors(selectors) {

  // sort to ensure that e.g. if the user specified
  // $and: [{$gt: 'a'}, {$gt: 'b'}], then it's collapsed into
  // just {$gt: 'b'}
  var res = {};

  selectors.forEach(function (selector) {
    Object.keys(selector).forEach(function (field) {
      var matcher = selector[field];
      if (typeof matcher !== 'object') {
        matcher = {$eq: matcher};
      }

      if (isCombinationalField(field)) {
        if (matcher instanceof Array) {
          res[field] = matcher.map(function (m) {
            return mergeAndedSelectors([m]);
          });
        } else {
          res[field] = mergeAndedSelectors([matcher]);
        }
      } else {
        var fieldMatchers = res[field] = res[field] || {};
        Object.keys(matcher).forEach(function (operator) {
          var value = matcher[operator];

          if (operator === '$gt' || operator === '$gte') {
            return mergeGtGte(operator, value, fieldMatchers);
          } else if (operator === '$lt' || operator === '$lte') {
            return mergeLtLte(operator, value, fieldMatchers);
          } else if (operator === '$ne') {
            return mergeNe(value, fieldMatchers);
          } else if (operator === '$eq') {
            return mergeEq(value, fieldMatchers);
          }
          fieldMatchers[operator] = value;
        });
      }
    });
  });

  return res;
}



// collapse logically equivalent gt/gte values
function mergeGtGte(operator, value, fieldMatchers) {
  if (typeof fieldMatchers.$eq !== 'undefined') {
    return; // do nothing
  }
  if (typeof fieldMatchers.$gte !== 'undefined') {
    if (operator === '$gte') {
      if (value > fieldMatchers.$gte) { // more specificity
        fieldMatchers.$gte = value;
      }
    } else { // operator === '$gt'
      if (value >= fieldMatchers.$gte) { // more specificity
        delete fieldMatchers.$gte;
        fieldMatchers.$gt = value;
      }
    }
  } else if (typeof fieldMatchers.$gt !== 'undefined') {
    if (operator === '$gte') {
      if (value > fieldMatchers.$gt) { // more specificity
        delete fieldMatchers.$gt;
        fieldMatchers.$gte = value;
      }
    } else { // operator === '$gt'
      if (value > fieldMatchers.$gt) { // more specificity
        fieldMatchers.$gt = value;
      }
    }
  } else {
    fieldMatchers[operator] = value;
  }
}

// collapse logically equivalent lt/lte values
function mergeLtLte(operator, value, fieldMatchers) {
  if (typeof fieldMatchers.$eq !== 'undefined') {
    return; // do nothing
  }
  if (typeof fieldMatchers.$lte !== 'undefined') {
    if (operator === '$lte') {
      if (value < fieldMatchers.$lte) { // more specificity
        fieldMatchers.$lte = value;
      }
    } else { // operator === '$gt'
      if (value <= fieldMatchers.$lte) { // more specificity
        delete fieldMatchers.$lte;
        fieldMatchers.$lt = value;
      }
    }
  } else if (typeof fieldMatchers.$lt !== 'undefined') {
    if (operator === '$lte') {
      if (value < fieldMatchers.$lt) { // more specificity
        delete fieldMatchers.$lt;
        fieldMatchers.$lte = value;
      }
    } else { // operator === '$gt'
      if (value < fieldMatchers.$lt) { // more specificity
        fieldMatchers.$lt = value;
      }
    }
  } else {
    fieldMatchers[operator] = value;
  }
}

// combine $ne values into one array
function mergeNe(value, fieldMatchers) {
  if ('$ne' in fieldMatchers) {
    // there are many things this could "not" be
    fieldMatchers.$ne.push(value);
  } else { // doesn't exist yet
    fieldMatchers.$ne = [value];
  }
}

// add $eq into the mix
function mergeEq(value, fieldMatchers) {
  // these all have less specificity than the $eq
  // TODO: check for user errors here
  delete fieldMatchers.$gt;
  delete fieldMatchers.$gte;
  delete fieldMatchers.$lt;
  delete fieldMatchers.$lte;
  delete fieldMatchers.$ne;
  fieldMatchers.$eq = value;
}


//
// normalize the selector
//
function massageSelector(input) {
  var result = clone(input);
  var wasAnded = false;
  if ('$and' in result) {
    result = mergeAndedSelectors(result['$and']);
    wasAnded = true;
  }

  ['$or', '$nor'].forEach(function (orOrNor) {
    if (orOrNor in result) {
      // message each individual selector
      // e.g. {foo: 'bar'} becomes {foo: {$eq: 'bar'}}
      result[orOrNor].forEach(function (subSelector) {
        var fields = Object.keys(subSelector);
        for (var i = 0; i < fields.length; i++) {
          var field = fields[i];
          var matcher = subSelector[field];
          if (typeof matcher !== 'object' || matcher === null) {
            subSelector[field] = {$eq: matcher};
          }
        }
      });
    }
  });

  if ('$not' in result) {
    //This feels a little like forcing, but it will work for now,
    //I would like to come back to this and make the merging of selectors a little more generic
    result['$not'] = mergeAndedSelectors([result['$not']]);
  }

  var fields = Object.keys(result);

  for (var i = 0; i < fields.length; i++) {
    var field = fields[i];
    var matcher = result[field];

    if (typeof matcher !== 'object' || matcher === null) {
      matcher = {$eq: matcher};
    } else if ('$ne' in matcher && !wasAnded) {
      // I put these in an array, since there may be more than one
      // but in the "mergeAnded" operation, I already take care of that
      matcher.$ne = [matcher.$ne];
    }
    result[field] = matcher;
  }

  return result;
}

function pad(str, padWith, upToLength) {
  var padding = '';
  var targetLength = upToLength - str.length;
  /* istanbul ignore next */
  while (padding.length < targetLength) {
    padding += padWith;
  }
  return padding;
}

function padLeft(str, padWith, upToLength) {
  var padding = pad(str, padWith, upToLength);
  return padding + str;
}

var MIN_MAGNITUDE = -324; // verified by -Number.MIN_VALUE
var MAGNITUDE_DIGITS = 3; // ditto
var SEP = ''; // set to '_' for easier debugging 

function collate(a, b) {

  if (a === b) {
    return 0;
  }

  a = normalizeKey(a);
  b = normalizeKey(b);

  var ai = collationIndex(a);
  var bi = collationIndex(b);
  if ((ai - bi) !== 0) {
    return ai - bi;
  }
  switch (typeof a) {
    case 'number':
      return a - b;
    case 'boolean':
      return a < b ? -1 : 1;
    case 'string':
      return stringCollate(a, b);
  }
  return Array.isArray(a) ? arrayCollate(a, b) : objectCollate(a, b);
}

// couch considers null/NaN/Infinity/-Infinity === undefined,
// for the purposes of mapreduce indexes. also, dates get stringified.
function normalizeKey(key) {
  switch (typeof key) {
    case 'undefined':
      return null;
    case 'number':
      if (key === Infinity || key === -Infinity || isNaN(key)) {
        return null;
      }
      return key;
    case 'object':
      var origKey = key;
      if (Array.isArray(key)) {
        var len = key.length;
        key = new Array(len);
        for (var i = 0; i < len; i++) {
          key[i] = normalizeKey(origKey[i]);
        }
      /* istanbul ignore next */
      } else if (key instanceof Date) {
        return key.toJSON();
      } else if (key !== null) { // generic object
        key = {};
        for (var k in origKey) {
          if (origKey.hasOwnProperty(k)) {
            var val = origKey[k];
            if (typeof val !== 'undefined') {
              key[k] = normalizeKey(val);
            }
          }
        }
      }
  }
  return key;
}

function indexify(key) {
  if (key !== null) {
    switch (typeof key) {
      case 'boolean':
        return key ? 1 : 0;
      case 'number':
        return numToIndexableString(key);
      case 'string':
        // We've to be sure that key does not contain \u0000
        // Do order-preserving replacements:
        // 0 -> 1, 1
        // 1 -> 1, 2
        // 2 -> 2, 2
        return key
          .replace(/\u0002/g, '\u0002\u0002')
          .replace(/\u0001/g, '\u0001\u0002')
          .replace(/\u0000/g, '\u0001\u0001');
      case 'object':
        var isArray = Array.isArray(key);
        var arr = isArray ? key : Object.keys(key);
        var i = -1;
        var len = arr.length;
        var result = '';
        if (isArray) {
          while (++i < len) {
            result += toIndexableString(arr[i]);
          }
        } else {
          while (++i < len) {
            var objKey = arr[i];
            result += toIndexableString(objKey) +
                toIndexableString(key[objKey]);
          }
        }
        return result;
    }
  }
  return '';
}

// convert the given key to a string that would be appropriate
// for lexical sorting, e.g. within a database, where the
// sorting is the same given by the collate() function.
function toIndexableString(key) {
  var zero = '\u0000';
  key = normalizeKey(key);
  return collationIndex(key) + SEP + indexify(key) + zero;
}

function parseNumber(str, i) {
  var originalIdx = i;
  var num;
  var zero = str[i] === '1';
  if (zero) {
    num = 0;
    i++;
  } else {
    var neg = str[i] === '0';
    i++;
    var numAsString = '';
    var magAsString = str.substring(i, i + MAGNITUDE_DIGITS);
    var magnitude = parseInt(magAsString, 10) + MIN_MAGNITUDE;
    /* istanbul ignore next */
    if (neg) {
      magnitude = -magnitude;
    }
    i += MAGNITUDE_DIGITS;
    while (true) {
      var ch = str[i];
      if (ch === '\u0000') {
        break;
      } else {
        numAsString += ch;
      }
      i++;
    }
    numAsString = numAsString.split('.');
    if (numAsString.length === 1) {
      num = parseInt(numAsString, 10);
    } else {
      /* istanbul ignore next */
      num = parseFloat(numAsString[0] + '.' + numAsString[1]);
    }
    /* istanbul ignore next */
    if (neg) {
      num = num - 10;
    }
    /* istanbul ignore next */
    if (magnitude !== 0) {
      // parseFloat is more reliable than pow due to rounding errors
      // e.g. Number.MAX_VALUE would return Infinity if we did
      // num * Math.pow(10, magnitude);
      num = parseFloat(num + 'e' + magnitude);
    }
  }
  return {num: num, length : i - originalIdx};
}

// move up the stack while parsing
// this function moved outside of parseIndexableString for performance
function pop(stack, metaStack) {
  var obj = stack.pop();

  if (metaStack.length) {
    var lastMetaElement = metaStack[metaStack.length - 1];
    if (obj === lastMetaElement.element) {
      // popping a meta-element, e.g. an object whose value is another object
      metaStack.pop();
      lastMetaElement = metaStack[metaStack.length - 1];
    }
    var element = lastMetaElement.element;
    var lastElementIndex = lastMetaElement.index;
    if (Array.isArray(element)) {
      element.push(obj);
    } else if (lastElementIndex === stack.length - 2) { // obj with key+value
      var key = stack.pop();
      element[key] = obj;
    } else {
      stack.push(obj); // obj with key only
    }
  }
}

function parseIndexableString(str) {
  var stack = [];
  var metaStack = []; // stack for arrays and objects
  var i = 0;

  /*eslint no-constant-condition: ["error", { "checkLoops": false }]*/
  while (true) {
    var collationIndex = str[i++];
    if (collationIndex === '\u0000') {
      if (stack.length === 1) {
        return stack.pop();
      } else {
        pop(stack, metaStack);
        continue;
      }
    }
    switch (collationIndex) {
      case '1':
        stack.push(null);
        break;
      case '2':
        stack.push(str[i] === '1');
        i++;
        break;
      case '3':
        var parsedNum = parseNumber(str, i);
        stack.push(parsedNum.num);
        i += parsedNum.length;
        break;
      case '4':
        var parsedStr = '';
        /*eslint no-constant-condition: ["error", { "checkLoops": false }]*/
        while (true) {
          var ch = str[i];
          if (ch === '\u0000') {
            break;
          }
          parsedStr += ch;
          i++;
        }
        // perform the reverse of the order-preserving replacement
        // algorithm (see above)
        parsedStr = parsedStr.replace(/\u0001\u0001/g, '\u0000')
          .replace(/\u0001\u0002/g, '\u0001')
          .replace(/\u0002\u0002/g, '\u0002');
        stack.push(parsedStr);
        break;
      case '5':
        var arrayElement = { element: [], index: stack.length };
        stack.push(arrayElement.element);
        metaStack.push(arrayElement);
        break;
      case '6':
        var objElement = { element: {}, index: stack.length };
        stack.push(objElement.element);
        metaStack.push(objElement);
        break;
      /* istanbul ignore next */
      default:
        throw new Error(
          'bad collationIndex or unexpectedly reached end of input: ' +
            collationIndex);
    }
  }
}

function arrayCollate(a, b) {
  var len = Math.min(a.length, b.length);
  for (var i = 0; i < len; i++) {
    var sort = collate(a[i], b[i]);
    if (sort !== 0) {
      return sort;
    }
  }
  return (a.length === b.length) ? 0 :
    (a.length > b.length) ? 1 : -1;
}
function stringCollate(a, b) {
  // See: https://github.com/daleharvey/pouchdb/issues/40
  // This is incompatible with the CouchDB implementation, but its the
  // best we can do for now
  return (a === b) ? 0 : ((a > b) ? 1 : -1);
}
function objectCollate(a, b) {
  var ak = Object.keys(a), bk = Object.keys(b);
  var len = Math.min(ak.length, bk.length);
  for (var i = 0; i < len; i++) {
    // First sort the keys
    var sort = collate(ak[i], bk[i]);
    if (sort !== 0) {
      return sort;
    }
    // if the keys are equal sort the values
    sort = collate(a[ak[i]], b[bk[i]]);
    if (sort !== 0) {
      return sort;
    }

  }
  return (ak.length === bk.length) ? 0 :
    (ak.length > bk.length) ? 1 : -1;
}
// The collation is defined by erlangs ordered terms
// the atoms null, true, false come first, then numbers, strings,
// arrays, then objects
// null/undefined/NaN/Infinity/-Infinity are all considered null
function collationIndex(x) {
  var id = ['boolean', 'number', 'string', 'object'];
  var idx = id.indexOf(typeof x);
  //false if -1 otherwise true, but fast!!!!1
  if (~idx) {
    if (x === null) {
      return 1;
    }
    if (Array.isArray(x)) {
      return 5;
    }
    return idx < 3 ? (idx + 2) : (idx + 3);
  }
  /* istanbul ignore next */
  if (Array.isArray(x)) {
    return 5;
  }
}

// conversion:
// x yyy zz...zz
// x = 0 for negative, 1 for 0, 2 for positive
// y = exponent (for negative numbers negated) moved so that it's >= 0
// z = mantisse
function numToIndexableString(num) {

  if (num === 0) {
    return '1';
  }

  // convert number to exponential format for easier and
  // more succinct string sorting
  var expFormat = num.toExponential().split(/e\+?/);
  var magnitude = parseInt(expFormat[1], 10);

  var neg = num < 0;

  var result = neg ? '0' : '2';

  // first sort by magnitude
  // it's easier if all magnitudes are positive
  var magForComparison = ((neg ? -magnitude : magnitude) - MIN_MAGNITUDE);
  var magString = padLeft((magForComparison).toString(), '0', MAGNITUDE_DIGITS);

  result += SEP + magString;

  // then sort by the factor
  var factor = Math.abs(parseFloat(expFormat[0])); // [1..10)
  /* istanbul ignore next */
  if (neg) { // for negative reverse ordering
    factor = 10 - factor;
  }

  var factorStr = factor.toFixed(20);

  // strip zeros from the end
  factorStr = factorStr.replace(/\.?0+$/, '');

  result += SEP + factorStr;

  return result;
}

// create a comparator based on the sort object
function createFieldSorter(sort) {

  function getFieldValuesAsArray(doc) {
    return sort.map(function (sorting) {
      var fieldName = getKey(sorting);
      var parsedField = parseField(fieldName);
      var docFieldValue = getFieldFromDoc(doc, parsedField);
      return docFieldValue;
    });
  }

  return function (aRow, bRow) {
    var aFieldValues = getFieldValuesAsArray(aRow.doc);
    var bFieldValues = getFieldValuesAsArray(bRow.doc);
    var collation = collate(aFieldValues, bFieldValues);
    if (collation !== 0) {
      return collation;
    }
    // this is what mango seems to do
    return compare$1(aRow.doc._id, bRow.doc._id);
  };
}

function filterInMemoryFields(rows, requestDef, inMemoryFields) {
  rows = rows.filter(function (row) {
    return rowFilter(row.doc, requestDef.selector, inMemoryFields);
  });

  if (requestDef.sort) {
    // in-memory sort
    var fieldSorter = createFieldSorter(requestDef.sort);
    rows = rows.sort(fieldSorter);
    if (typeof requestDef.sort[0] !== 'string' &&
        getValue(requestDef.sort[0]) === 'desc') {
      rows = rows.reverse();
    }
  }

  if ('limit' in requestDef || 'skip' in requestDef) {
    // have to do the limit in-memory
    var skip = requestDef.skip || 0;
    var limit = ('limit' in requestDef ? requestDef.limit : rows.length) + skip;
    rows = rows.slice(skip, limit);
  }
  return rows;
}

function rowFilter(doc, selector, inMemoryFields) {
  return inMemoryFields.every(function (field) {
    var matcher = selector[field];
    var parsedField = parseField(field);
    var docFieldValue = getFieldFromDoc(doc, parsedField);
    if (isCombinationalField(field)) {
      return matchCominationalSelector(field, matcher, doc);
    }

    return matchSelector(matcher, doc, parsedField, docFieldValue);
  });
}

function matchSelector(matcher, doc, parsedField, docFieldValue) {
  if (!matcher) {
    // no filtering necessary; this field is just needed for sorting
    return true;
  }

  return Object.keys(matcher).every(function (userOperator) {
    var userValue = matcher[userOperator];
    return match(userOperator, doc, userValue, parsedField, docFieldValue);
  });
}

function matchCominationalSelector(field, matcher, doc) {

  if (field === '$or') {
    return matcher.some(function (orMatchers) {
      return rowFilter(doc, orMatchers, Object.keys(orMatchers));
    });
  }

  if (field === '$not') {
    return !rowFilter(doc, matcher, Object.keys(matcher));
  }

  //`$nor`
  return !matcher.find(function (orMatchers) {
    return rowFilter(doc, orMatchers, Object.keys(orMatchers));
  });

}

function match(userOperator, doc, userValue, parsedField, docFieldValue) {
  if (!matchers[userOperator]) {
    throw new Error('unknown operator "' + userOperator +
      '" - should be one of $eq, $lte, $lt, $gt, $gte, $exists, $ne, $in, ' +
      '$nin, $size, $mod, $regex, $elemMatch, $type, $allMatch or $all');
  }
  return matchers[userOperator](doc, userValue, parsedField, docFieldValue);
}

function fieldExists(docFieldValue) {
  return typeof docFieldValue !== 'undefined' && docFieldValue !== null;
}

function fieldIsNotUndefined(docFieldValue) {
  return typeof docFieldValue !== 'undefined';
}

function modField(docFieldValue, userValue) {
  var divisor = userValue[0];
  var mod = userValue[1];
  if (divisor === 0) {
    throw new Error('Bad divisor, cannot divide by zero');
  }

  if (parseInt(divisor, 10) !== divisor ) {
    throw new Error('Divisor is not an integer');
  }

  if (parseInt(mod, 10) !== mod ) {
    throw new Error('Modulus is not an integer');
  }

  if (parseInt(docFieldValue, 10) !== docFieldValue) {
    return false;
  }

  return docFieldValue % divisor === mod;
}

function arrayContainsValue(docFieldValue, userValue) {
  return userValue.some(function (val) {
    if (docFieldValue instanceof Array) {
      return docFieldValue.indexOf(val) > -1;
    }

    return docFieldValue === val;
  });
}

function arrayContainsAllValues(docFieldValue, userValue) {
  return userValue.every(function (val) {
    return docFieldValue.indexOf(val) > -1;
  });
}

function arraySize(docFieldValue, userValue) {
  return docFieldValue.length === userValue;
}

function regexMatch(docFieldValue, userValue) {
  var re = new RegExp(userValue);

  return re.test(docFieldValue);
}

function typeMatch(docFieldValue, userValue) {

  switch (userValue) {
    case 'null':
      return docFieldValue === null;
    case 'boolean':
      return typeof (docFieldValue) === 'boolean';
    case 'number':
      return typeof (docFieldValue) === 'number';
    case 'string':
      return typeof (docFieldValue) === 'string';
    case 'array':
      return docFieldValue instanceof Array;
    case 'object':
      return ({}).toString.call(docFieldValue) === '[object Object]';
  }

  throw new Error(userValue + ' not supported as a type.' +
                  'Please use one of object, string, array, number, boolean or null.');

}

var matchers = {

  '$elemMatch': function (doc, userValue, parsedField, docFieldValue) {
    if (!Array.isArray(docFieldValue)) {
      return false;
    }

    if (docFieldValue.length === 0) {
      return false;
    }

    if (typeof docFieldValue[0] === 'object') {
      return docFieldValue.some(function (val) {
        return rowFilter(val, userValue, Object.keys(userValue));
      });
    }

    return docFieldValue.some(function (val) {
      return matchSelector(userValue, doc, parsedField, val);
    });
  },

  '$allMatch': function (doc, userValue, parsedField, docFieldValue) {
    if (!Array.isArray(docFieldValue)) {
      return false;
    }

    /* istanbul ignore next */
    if (docFieldValue.length === 0) {
      return false;
    }

    if (typeof docFieldValue[0] === 'object') {
      return docFieldValue.every(function (val) {
        return rowFilter(val, userValue, Object.keys(userValue));
      });
    }

    return docFieldValue.every(function (val) {
      return matchSelector(userValue, doc, parsedField, val);
    });
  },

  '$eq': function (doc, userValue, parsedField, docFieldValue) {
    return fieldIsNotUndefined(docFieldValue) && collate(docFieldValue, userValue) === 0;
  },

  '$gte': function (doc, userValue, parsedField, docFieldValue) {
    return fieldIsNotUndefined(docFieldValue) && collate(docFieldValue, userValue) >= 0;
  },

  '$gt': function (doc, userValue, parsedField, docFieldValue) {
    return fieldIsNotUndefined(docFieldValue) && collate(docFieldValue, userValue) > 0;
  },

  '$lte': function (doc, userValue, parsedField, docFieldValue) {
    return fieldIsNotUndefined(docFieldValue) && collate(docFieldValue, userValue) <= 0;
  },

  '$lt': function (doc, userValue, parsedField, docFieldValue) {
    return fieldIsNotUndefined(docFieldValue) && collate(docFieldValue, userValue) < 0;
  },

  '$exists': function (doc, userValue, parsedField, docFieldValue) {
    //a field that is null is still considered to exist
    if (userValue) {
      return fieldIsNotUndefined(docFieldValue);
    }

    return !fieldIsNotUndefined(docFieldValue);
  },

  '$mod': function (doc, userValue, parsedField, docFieldValue) {
    return fieldExists(docFieldValue) && modField(docFieldValue, userValue);
  },

  '$ne': function (doc, userValue, parsedField, docFieldValue) {
    return userValue.every(function (neValue) {
      return collate(docFieldValue, neValue) !== 0;
    });
  },
  '$in': function (doc, userValue, parsedField, docFieldValue) {
    return fieldExists(docFieldValue) && arrayContainsValue(docFieldValue, userValue);
  },

  '$nin': function (doc, userValue, parsedField, docFieldValue) {
    return fieldExists(docFieldValue) && !arrayContainsValue(docFieldValue, userValue);
  },

  '$size': function (doc, userValue, parsedField, docFieldValue) {
    return fieldExists(docFieldValue) && arraySize(docFieldValue, userValue);
  },

  '$all': function (doc, userValue, parsedField, docFieldValue) {
    return Array.isArray(docFieldValue) && arrayContainsAllValues(docFieldValue, userValue);
  },

  '$regex': function (doc, userValue, parsedField, docFieldValue) {
    return fieldExists(docFieldValue) && regexMatch(docFieldValue, userValue);
  },

  '$type': function (doc, userValue, parsedField, docFieldValue) {
    return typeMatch(docFieldValue, userValue);
  }
};

// return true if the given doc matches the supplied selector
function matchesSelector(doc, selector) {
  /* istanbul ignore if */
  if (typeof selector !== 'object') {
    // match the CouchDB error message
    throw new Error('Selector error: expected a JSON object');
  }

  selector = massageSelector(selector);
  var row = {
    'doc': doc
  };

  var rowsMatched = filterInMemoryFields([row], { 'selector': selector }, Object.keys(selector));
  return rowsMatched && rowsMatched.length === 1;
}

function evalFilter(input) {
  return scopeEval('"use strict";\nreturn ' + input + ';', {});
}

function evalView(input) {
  var code = [
    'return function(doc) {',
    '  "use strict";',
    '  var emitted = false;',
    '  var emit = function (a, b) {',
    '    emitted = true;',
    '  };',
    '  var view = ' + input + ';',
    '  view(doc);',
    '  if (emitted) {',
    '    return true;',
    '  }',
    '};'
  ].join('\n');

  return scopeEval(code, {});
}

function validate(opts, callback) {
  if (opts.selector) {
    if (opts.filter && opts.filter !== '_selector') {
      var filterName = typeof opts.filter === 'string' ?
        opts.filter : 'function';
      return callback(new Error('selector invalid for filter "' + filterName + '"'));
    }
  }
  callback();
}

function normalize(opts) {
  if (opts.view && !opts.filter) {
    opts.filter = '_view';
  }

  if (opts.selector && !opts.filter) {
    opts.filter = '_selector';
  }

  if (opts.filter && typeof opts.filter === 'string') {
    if (opts.filter === '_view') {
      opts.view = normalizeDesignDocFunctionName(opts.view);
    } else {
      opts.filter = normalizeDesignDocFunctionName(opts.filter);
    }
  }
}

function shouldFilter(changesHandler, opts) {
  return opts.filter && typeof opts.filter === 'string' &&
    !opts.doc_ids && !isRemote(changesHandler.db);
}

function filter(changesHandler, opts) {
  var callback = opts.complete;
  if (opts.filter === '_view') {
    if (!opts.view || typeof opts.view !== 'string') {
      var err = createError(BAD_REQUEST,
        '`view` filter parameter not found or invalid.');
      return callback(err);
    }
    // fetch a view from a design doc, make it behave like a filter
    var viewName = parseDesignDocFunctionName(opts.view);
    changesHandler.db.get('_design/' + viewName[0], function (err, ddoc) {
      /* istanbul ignore if */
      if (changesHandler.isCancelled) {
        return callback(null, {status: 'cancelled'});
      }
      /* istanbul ignore next */
      if (err) {
        return callback(generateErrorFromResponse(err));
      }
      var mapFun = ddoc && ddoc.views && ddoc.views[viewName[1]] &&
        ddoc.views[viewName[1]].map;
      if (!mapFun) {
        return callback(createError(MISSING_DOC,
          (ddoc.views ? 'missing json key: ' + viewName[1] :
            'missing json key: views')));
      }
      opts.filter = evalView(mapFun);
      changesHandler.doChanges(opts);
    });
  } else if (opts.selector) {
    opts.filter = function (doc) {
      return matchesSelector(doc, opts.selector);
    };
    changesHandler.doChanges(opts);
  } else {
    // fetch a filter from a design doc
    var filterName = parseDesignDocFunctionName(opts.filter);
    changesHandler.db.get('_design/' + filterName[0], function (err, ddoc) {
      /* istanbul ignore if */
      if (changesHandler.isCancelled) {
        return callback(null, {status: 'cancelled'});
      }
      /* istanbul ignore next */
      if (err) {
        return callback(generateErrorFromResponse(err));
      }
      var filterFun = ddoc && ddoc.filters && ddoc.filters[filterName[1]];
      if (!filterFun) {
        return callback(createError(MISSING_DOC,
          ((ddoc && ddoc.filters) ? 'missing json key: ' + filterName[1]
            : 'missing json key: filters')));
      }
      opts.filter = evalFilter(filterFun);
      changesHandler.doChanges(opts);
    });
  }
}

function applyChangesFilterPlugin(PouchDB) {
  PouchDB._changesFilterPlugin = {
    validate: validate,
    normalize: normalize,
    shouldFilter: shouldFilter,
    filter: filter
  };
}

// TODO: remove from pouchdb-core (breaking)
PouchDB$3$1.plugin(debugPouch);

// TODO: remove from pouchdb-core (breaking)
PouchDB$3$1.plugin(applyChangesFilterPlugin);

PouchDB$3$1.version = version;

function toObject(array) {
  return array.reduce(function (obj, item) {
    obj[item] = true;
    return obj;
  }, {});
}
// List of top level reserved words for doc
var reservedWords = toObject([
  '_id',
  '_rev',
  '_attachments',
  '_deleted',
  '_revisions',
  '_revs_info',
  '_conflicts',
  '_deleted_conflicts',
  '_local_seq',
  '_rev_tree',
  //replication documents
  '_replication_id',
  '_replication_state',
  '_replication_state_time',
  '_replication_state_reason',
  '_replication_stats',
  // Specific to Couchbase Sync Gateway
  '_removed'
]);

// List of reserved words that should end up the document
var dataWords = toObject([
  '_attachments',
  //replication documents
  '_replication_id',
  '_replication_state',
  '_replication_state_time',
  '_replication_state_reason',
  '_replication_stats'
]);

function parseRevisionInfo(rev$$1) {
  if (!/^\d+-./.test(rev$$1)) {
    return createError(INVALID_REV);
  }
  var idx = rev$$1.indexOf('-');
  var left = rev$$1.substring(0, idx);
  var right = rev$$1.substring(idx + 1);
  return {
    prefix: parseInt(left, 10),
    id: right
  };
}

function makeRevTreeFromRevisions(revisions, opts) {
  var pos = revisions.start - revisions.ids.length + 1;

  var revisionIds = revisions.ids;
  var ids = [revisionIds[0], opts, []];

  for (var i = 1, len = revisionIds.length; i < len; i++) {
    ids = [revisionIds[i], {status: 'missing'}, [ids]];
  }

  return [{
    pos: pos,
    ids: ids
  }];
}

// Preprocess documents, parse their revisions, assign an id and a
// revision for new writes that are missing them, etc
function parseDoc(doc, newEdits) {

  var nRevNum;
  var newRevId;
  var revInfo;
  var opts = {status: 'available'};
  if (doc._deleted) {
    opts.deleted = true;
  }

  if (newEdits) {
    if (!doc._id) {
      doc._id = uuid();
    }
    newRevId = rev();
    if (doc._rev) {
      revInfo = parseRevisionInfo(doc._rev);
      if (revInfo.error) {
        return revInfo;
      }
      doc._rev_tree = [{
        pos: revInfo.prefix,
        ids: [revInfo.id, {status: 'missing'}, [[newRevId, opts, []]]]
      }];
      nRevNum = revInfo.prefix + 1;
    } else {
      doc._rev_tree = [{
        pos: 1,
        ids : [newRevId, opts, []]
      }];
      nRevNum = 1;
    }
  } else {
    if (doc._revisions) {
      doc._rev_tree = makeRevTreeFromRevisions(doc._revisions, opts);
      nRevNum = doc._revisions.start;
      newRevId = doc._revisions.ids[0];
    }
    if (!doc._rev_tree) {
      revInfo = parseRevisionInfo(doc._rev);
      if (revInfo.error) {
        return revInfo;
      }
      nRevNum = revInfo.prefix;
      newRevId = revInfo.id;
      doc._rev_tree = [{
        pos: nRevNum,
        ids: [newRevId, opts, []]
      }];
    }
  }

  invalidIdError(doc._id);

  doc._rev = nRevNum + '-' + newRevId;

  var result = {metadata : {}, data : {}};
  for (var key in doc) {
    /* istanbul ignore else */
    if (Object.prototype.hasOwnProperty.call(doc, key)) {
      var specialKey = key[0] === '_';
      if (specialKey && !reservedWords[key]) {
        var error = createError(DOC_VALIDATION, key);
        error.message = DOC_VALIDATION.message + ': ' + key;
        throw error;
      } else if (specialKey && !dataWords[key]) {
        result.metadata[key.slice(1)] = doc[key];
      } else {
        result.data[key] = doc[key];
      }
    }
  }
  return result;
}

var thisAtob = function (str) {
  return atob(str);
};

var thisBtoa = function (str) {
  return btoa(str);
};

// Abstracts constructing a Blob object, so it also works in older
// browsers that don't support the native Blob constructor (e.g.
// old QtWebKit versions, Android < 4.4).
function createBlob(parts, properties) {
  /* global BlobBuilder,MSBlobBuilder,MozBlobBuilder,WebKitBlobBuilder */
  parts = parts || [];
  properties = properties || {};
  try {
    return new Blob(parts, properties);
  } catch (e) {
    if (e.name !== "TypeError") {
      throw e;
    }
    var Builder = typeof BlobBuilder !== 'undefined' ? BlobBuilder :
                  typeof MSBlobBuilder !== 'undefined' ? MSBlobBuilder :
                  typeof MozBlobBuilder !== 'undefined' ? MozBlobBuilder :
                  WebKitBlobBuilder;
    var builder = new Builder();
    for (var i = 0; i < parts.length; i += 1) {
      builder.append(parts[i]);
    }
    return builder.getBlob(properties.type);
  }
}

// From http://stackoverflow.com/questions/14967647/ (continues on next line)
// encode-decode-image-with-base64-breaks-image (2013-04-21)
function binaryStringToArrayBuffer(bin) {
  var length = bin.length;
  var buf = new ArrayBuffer(length);
  var arr = new Uint8Array(buf);
  for (var i = 0; i < length; i++) {
    arr[i] = bin.charCodeAt(i);
  }
  return buf;
}

function binStringToBluffer(binString, type) {
  return createBlob([binaryStringToArrayBuffer(binString)], {type: type});
}

function b64ToBluffer(b64, type) {
  return binStringToBluffer(thisAtob(b64), type);
}

//Can't find original post, but this is close
//http://stackoverflow.com/questions/6965107/ (continues on next line)
//converting-between-strings-and-arraybuffers
function arrayBufferToBinaryString(buffer) {
  var binary = '';
  var bytes = new Uint8Array(buffer);
  var length = bytes.byteLength;
  for (var i = 0; i < length; i++) {
    binary += String.fromCharCode(bytes[i]);
  }
  return binary;
}

// shim for browsers that don't support it
function readAsBinaryString(blob, callback) {
  if (typeof FileReader === 'undefined') {
    // fix for Firefox in a web worker
    // https://bugzilla.mozilla.org/show_bug.cgi?id=901097
    return callback(arrayBufferToBinaryString(
      new FileReaderSync().readAsArrayBuffer(blob)));
  }

  var reader = new FileReader();
  var hasBinaryString = typeof reader.readAsBinaryString === 'function';
  reader.onloadend = function (e) {
    var result = e.target.result || '';
    if (hasBinaryString) {
      return callback(result);
    }
    callback(arrayBufferToBinaryString(result));
  };
  if (hasBinaryString) {
    reader.readAsBinaryString(blob);
  } else {
    reader.readAsArrayBuffer(blob);
  }
}

function blobToBinaryString(blobOrBuffer, callback) {
  readAsBinaryString(blobOrBuffer, function (bin) {
    callback(bin);
  });
}

function blobToBase64(blobOrBuffer, callback) {
  blobToBinaryString(blobOrBuffer, function (base64) {
    callback(thisBtoa(base64));
  });
}

// simplified API. universal browser support is assumed
function readAsArrayBuffer(blob, callback) {
  if (typeof FileReader === 'undefined') {
    // fix for Firefox in a web worker:
    // https://bugzilla.mozilla.org/show_bug.cgi?id=901097
    return callback(new FileReaderSync().readAsArrayBuffer(blob));
  }

  var reader = new FileReader();
  reader.onloadend = function (e) {
    var result = e.target.result || new ArrayBuffer(0);
    callback(result);
  };
  reader.readAsArrayBuffer(blob);
}

// this is not used in the browser

var setImmediateShim = global.setImmediate || global.setTimeout;
var MD5_CHUNK_SIZE = 32768;

function rawToBase64(raw) {
  return thisBtoa(raw);
}

function sliceBlob(blob, start, end) {
  if (blob.webkitSlice) {
    return blob.webkitSlice(start, end);
  }
  return blob.slice(start, end);
}

function appendBlob(buffer, blob, start, end, callback) {
  if (start > 0 || end < blob.size) {
    // only slice blob if we really need to
    blob = sliceBlob(blob, start, end);
  }
  readAsArrayBuffer(blob, function (arrayBuffer) {
    buffer.append(arrayBuffer);
    callback();
  });
}

function appendString(buffer, string, start, end, callback) {
  if (start > 0 || end < string.length) {
    // only create a substring if we really need to
    string = string.substring(start, end);
  }
  buffer.appendBinary(string);
  callback();
}

function binaryMd5(data, callback) {
  var inputIsString = typeof data === 'string';
  var len = inputIsString ? data.length : data.size;
  var chunkSize = Math.min(MD5_CHUNK_SIZE, len);
  var chunks = Math.ceil(len / chunkSize);
  var currentChunk = 0;
  var buffer = inputIsString ? new sparkMd5() : new sparkMd5.ArrayBuffer();

  var append = inputIsString ? appendString : appendBlob;

  function next() {
    setImmediateShim(loadNextChunk);
  }

  function done() {
    var raw = buffer.end(true);
    var base64 = rawToBase64(raw);
    callback(base64);
    buffer.destroy();
  }

  function loadNextChunk() {
    var start = currentChunk * chunkSize;
    var end = start + chunkSize;
    currentChunk++;
    if (currentChunk < chunks) {
      append(buffer, data, start, end, next);
    } else {
      append(buffer, data, start, end, done);
    }
  }
  loadNextChunk();
}

function stringMd5(string) {
  return sparkMd5.hash(string);
}

function parseBase64(data) {
  try {
    return thisAtob(data);
  } catch (e) {
    var err = createError(BAD_ARG,
      'Attachment is not a valid base64 string');
    return {error: err};
  }
}

function preprocessString(att, blobType, callback) {
  var asBinary = parseBase64(att.data);
  if (asBinary.error) {
    return callback(asBinary.error);
  }

  att.length = asBinary.length;
  if (blobType === 'blob') {
    att.data = binStringToBluffer(asBinary, att.content_type);
  } else if (blobType === 'base64') {
    att.data = thisBtoa(asBinary);
  } else { // binary
    att.data = asBinary;
  }
  binaryMd5(asBinary, function (result) {
    att.digest = 'md5-' + result;
    callback();
  });
}

function preprocessBlob(att, blobType, callback) {
  binaryMd5(att.data, function (md5) {
    att.digest = 'md5-' + md5;
    // size is for blobs (browser), length is for buffers (node)
    att.length = att.data.size || att.data.length || 0;
    if (blobType === 'binary') {
      blobToBinaryString(att.data, function (binString) {
        att.data = binString;
        callback();
      });
    } else if (blobType === 'base64') {
      blobToBase64(att.data, function (b64) {
        att.data = b64;
        callback();
      });
    } else {
      callback();
    }
  });
}

function preprocessAttachment(att, blobType, callback) {
  if (att.stub) {
    return callback();
  }
  if (typeof att.data === 'string') { // input is a base64 string
    preprocessString(att, blobType, callback);
  } else { // input is a blob
    preprocessBlob(att, blobType, callback);
  }
}

function preprocessAttachments(docInfos, blobType, callback) {

  if (!docInfos.length) {
    return callback();
  }

  var docv = 0;
  var overallErr;

  docInfos.forEach(function (docInfo) {
    var attachments = docInfo.data && docInfo.data._attachments ?
      Object.keys(docInfo.data._attachments) : [];
    var recv = 0;

    if (!attachments.length) {
      return done();
    }

    function processedAttachment(err) {
      overallErr = err;
      recv++;
      if (recv === attachments.length) {
        done();
      }
    }

    for (var key in docInfo.data._attachments) {
      if (docInfo.data._attachments.hasOwnProperty(key)) {
        preprocessAttachment(docInfo.data._attachments[key],
          blobType, processedAttachment);
      }
    }
  });

  function done() {
    docv++;
    if (docInfos.length === docv) {
      if (overallErr) {
        callback(overallErr);
      } else {
        callback();
      }
    }
  }
}

function updateDoc(revLimit, prev, docInfo, results,
                   i, cb, writeDoc, newEdits) {

  if (revExists(prev.rev_tree, docInfo.metadata.rev)) {
    results[i] = docInfo;
    return cb();
  }

  // sometimes this is pre-calculated. historically not always
  var previousWinningRev = prev.winningRev || winningRev(prev);
  var previouslyDeleted = 'deleted' in prev ? prev.deleted :
    isDeleted(prev, previousWinningRev);
  var deleted = 'deleted' in docInfo.metadata ? docInfo.metadata.deleted :
    isDeleted(docInfo.metadata);
  var isRoot = /^1-/.test(docInfo.metadata.rev);

  if (previouslyDeleted && !deleted && newEdits && isRoot) {
    var newDoc = docInfo.data;
    newDoc._rev = previousWinningRev;
    newDoc._id = docInfo.metadata.id;
    docInfo = parseDoc(newDoc, newEdits);
  }

  var merged = merge(prev.rev_tree, docInfo.metadata.rev_tree[0], revLimit);

  var inConflict = newEdits && ((
    (previouslyDeleted && deleted && merged.conflicts !== 'new_leaf') ||
    (!previouslyDeleted && merged.conflicts !== 'new_leaf') ||
    (previouslyDeleted && !deleted && merged.conflicts === 'new_branch')));

  if (inConflict) {
    var err = createError(REV_CONFLICT);
    results[i] = err;
    return cb();
  }

  var newRev = docInfo.metadata.rev;
  docInfo.metadata.rev_tree = merged.tree;
  docInfo.stemmedRevs = merged.stemmedRevs || [];
  /* istanbul ignore else */
  if (prev.rev_map) {
    docInfo.metadata.rev_map = prev.rev_map; // used only by leveldb
  }

  // recalculate
  var winningRev$$1 = winningRev(docInfo.metadata);
  var winningRevIsDeleted = isDeleted(docInfo.metadata, winningRev$$1);

  // calculate the total number of documents that were added/removed,
  // from the perspective of total_rows/doc_count
  var delta = (previouslyDeleted === winningRevIsDeleted) ? 0 :
    previouslyDeleted < winningRevIsDeleted ? -1 : 1;

  var newRevIsDeleted;
  if (newRev === winningRev$$1) {
    // if the new rev is the same as the winning rev, we can reuse that value
    newRevIsDeleted = winningRevIsDeleted;
  } else {
    // if they're not the same, then we need to recalculate
    newRevIsDeleted = isDeleted(docInfo.metadata, newRev);
  }

  writeDoc(docInfo, winningRev$$1, winningRevIsDeleted, newRevIsDeleted,
    true, delta, i, cb);
}

function rootIsMissing(docInfo) {
  return docInfo.metadata.rev_tree[0].ids[1].status === 'missing';
}

function processDocs(revLimit, docInfos, api, fetchedDocs, tx, results,
                     writeDoc, opts, overallCallback) {

  // Default to 1000 locally
  revLimit = revLimit || 1000;

  function insertDoc(docInfo, resultsIdx, callback) {
    // Cant insert new deleted documents
    var winningRev$$1 = winningRev(docInfo.metadata);
    var deleted = isDeleted(docInfo.metadata, winningRev$$1);
    if ('was_delete' in opts && deleted) {
      results[resultsIdx] = createError(MISSING_DOC, 'deleted');
      return callback();
    }

    // 4712 - detect whether a new document was inserted with a _rev
    var inConflict = newEdits && rootIsMissing(docInfo);

    if (inConflict) {
      var err = createError(REV_CONFLICT);
      results[resultsIdx] = err;
      return callback();
    }

    var delta = deleted ? 0 : 1;

    writeDoc(docInfo, winningRev$$1, deleted, deleted, false,
      delta, resultsIdx, callback);
  }

  var newEdits = opts.new_edits;
  var idsToDocs = new ExportedMap();

  var docsDone = 0;
  var docsToDo = docInfos.length;

  function checkAllDocsDone() {
    if (++docsDone === docsToDo && overallCallback) {
      overallCallback();
    }
  }

  docInfos.forEach(function (currentDoc, resultsIdx) {

    if (currentDoc._id && isLocalId(currentDoc._id)) {
      var fun = currentDoc._deleted ? '_removeLocal' : '_putLocal';
      api[fun](currentDoc, {ctx: tx}, function (err, res) {
        results[resultsIdx] = err || res;
        checkAllDocsDone();
      });
      return;
    }

    var id = currentDoc.metadata.id;
    if (idsToDocs.has(id)) {
      docsToDo--; // duplicate
      idsToDocs.get(id).push([currentDoc, resultsIdx]);
    } else {
      idsToDocs.set(id, [[currentDoc, resultsIdx]]);
    }
  });

  // in the case of new_edits, the user can provide multiple docs
  // with the same id. these need to be processed sequentially
  idsToDocs.forEach(function (docs, id) {
    var numDone = 0;

    function docWritten() {
      if (++numDone < docs.length) {
        nextDoc();
      } else {
        checkAllDocsDone();
      }
    }
    function nextDoc() {
      var value = docs[numDone];
      var currentDoc = value[0];
      var resultsIdx = value[1];

      if (fetchedDocs.has(id)) {
        updateDoc(revLimit, fetchedDocs.get(id), currentDoc, results,
          resultsIdx, docWritten, writeDoc, newEdits);
      } else {
        // Ensure stemming applies to new writes as well
        var merged = merge([], currentDoc.metadata.rev_tree[0], revLimit);
        currentDoc.metadata.rev_tree = merged.tree;
        currentDoc.stemmedRevs = merged.stemmedRevs || [];
        insertDoc(currentDoc, resultsIdx, docWritten);
      }
    }
    nextDoc();
  });
}

// IndexedDB requires a versioned database structure, so we use the
// version here to manage migrations.
var ADAPTER_VERSION = 5;

// The object stores created for each database
// DOC_STORE stores the document meta data, its revision history and state
// Keyed by document id
var DOC_STORE = 'document-store';
// BY_SEQ_STORE stores a particular version of a document, keyed by its
// sequence id
var BY_SEQ_STORE = 'by-sequence';
// Where we store attachments
var ATTACH_STORE = 'attach-store';
// Where we store many-to-many relations
// between attachment digests and seqs
var ATTACH_AND_SEQ_STORE = 'attach-seq-store';

// Where we store database-wide meta data in a single record
// keyed by id: META_STORE
var META_STORE = 'meta-store';
// Where we store local documents
var LOCAL_STORE = 'local-store';
// Where we detect blob support
var DETECT_BLOB_SUPPORT_STORE = 'detect-blob-support';

function safeJsonParse(str) {
  // This try/catch guards against stack overflow errors.
  // JSON.parse() is faster than vuvuzela.parse() but vuvuzela
  // cannot overflow.
  try {
    return JSON.parse(str);
  } catch (e) {
    /* istanbul ignore next */
    return index$5.parse(str);
  }
}

function safeJsonStringify(json) {
  try {
    return JSON.stringify(json);
  } catch (e) {
    /* istanbul ignore next */
    return index$5.stringify(json);
  }
}

function idbError(callback) {
  return function (evt) {
    var message = 'unknown_error';
    if (evt.target && evt.target.error) {
      message = evt.target.error.name || evt.target.error.message;
    }
    callback(createError(IDB_ERROR, message, evt.type));
  };
}

// Unfortunately, the metadata has to be stringified
// when it is put into the database, because otherwise
// IndexedDB can throw errors for deeply-nested objects.
// Originally we just used JSON.parse/JSON.stringify; now
// we use this custom vuvuzela library that avoids recursion.
// If we could do it all over again, we'd probably use a
// format for the revision trees other than JSON.
function encodeMetadata(metadata, winningRev, deleted) {
  return {
    data: safeJsonStringify(metadata),
    winningRev: winningRev,
    deletedOrLocal: deleted ? '1' : '0',
    seq: metadata.seq, // highest seq for this doc
    id: metadata.id
  };
}

function decodeMetadata(storedObject) {
  if (!storedObject) {
    return null;
  }
  var metadata = safeJsonParse(storedObject.data);
  metadata.winningRev = storedObject.winningRev;
  metadata.deleted = storedObject.deletedOrLocal === '1';
  metadata.seq = storedObject.seq;
  return metadata;
}

// read the doc back out from the database. we don't store the
// _id or _rev because we already have _doc_id_rev.
function decodeDoc(doc) {
  if (!doc) {
    return doc;
  }
  var idx = doc._doc_id_rev.lastIndexOf(':');
  doc._id = doc._doc_id_rev.substring(0, idx - 1);
  doc._rev = doc._doc_id_rev.substring(idx + 1);
  delete doc._doc_id_rev;
  return doc;
}

// Read a blob from the database, encoding as necessary
// and translating from base64 if the IDB doesn't support
// native Blobs
function readBlobData(body, type, asBlob, callback) {
  if (asBlob) {
    if (!body) {
      callback(createBlob([''], {type: type}));
    } else if (typeof body !== 'string') { // we have blob support
      callback(body);
    } else { // no blob support
      callback(b64ToBluffer(body, type));
    }
  } else { // as base64 string
    if (!body) {
      callback('');
    } else if (typeof body !== 'string') { // we have blob support
      readAsBinaryString(body, function (binary) {
        callback(thisBtoa(binary));
      });
    } else { // no blob support
      callback(body);
    }
  }
}

function fetchAttachmentsIfNecessary(doc, opts, txn, cb) {
  var attachments = Object.keys(doc._attachments || {});
  if (!attachments.length) {
    return cb && cb();
  }
  var numDone = 0;

  function checkDone() {
    if (++numDone === attachments.length && cb) {
      cb();
    }
  }

  function fetchAttachment(doc, att) {
    var attObj = doc._attachments[att];
    var digest = attObj.digest;
    var req = txn.objectStore(ATTACH_STORE).get(digest);
    req.onsuccess = function (e) {
      attObj.body = e.target.result.body;
      checkDone();
    };
  }

  attachments.forEach(function (att) {
    if (opts.attachments && opts.include_docs) {
      fetchAttachment(doc, att);
    } else {
      doc._attachments[att].stub = true;
      checkDone();
    }
  });
}

// IDB-specific postprocessing necessary because
// we don't know whether we stored a true Blob or
// a base64-encoded string, and if it's a Blob it
// needs to be read outside of the transaction context
function postProcessAttachments(results, asBlob) {
  return PouchPromise$1.all(results.map(function (row) {
    if (row.doc && row.doc._attachments) {
      var attNames = Object.keys(row.doc._attachments);
      return PouchPromise$1.all(attNames.map(function (att) {
        var attObj = row.doc._attachments[att];
        if (!('body' in attObj)) { // already processed
          return;
        }
        var body = attObj.body;
        var type = attObj.content_type;
        return new PouchPromise$1(function (resolve) {
          readBlobData(body, type, asBlob, function (data) {
            row.doc._attachments[att] = $inject_Object_assign(
              pick(attObj, ['digest', 'content_type']),
              {data: data}
            );
            resolve();
          });
        });
      }));
    }
  }));
}

function compactRevs(revs, docId, txn) {

  var possiblyOrphanedDigests = [];
  var seqStore = txn.objectStore(BY_SEQ_STORE);
  var attStore = txn.objectStore(ATTACH_STORE);
  var attAndSeqStore = txn.objectStore(ATTACH_AND_SEQ_STORE);
  var count = revs.length;

  function checkDone() {
    count--;
    if (!count) { // done processing all revs
      deleteOrphanedAttachments();
    }
  }

  function deleteOrphanedAttachments() {
    if (!possiblyOrphanedDigests.length) {
      return;
    }
    possiblyOrphanedDigests.forEach(function (digest) {
      var countReq = attAndSeqStore.index('digestSeq').count(
        IDBKeyRange.bound(
          digest + '::', digest + '::\uffff', false, false));
      countReq.onsuccess = function (e) {
        var count = e.target.result;
        if (!count) {
          // orphaned
          attStore.delete(digest);
        }
      };
    });
  }

  revs.forEach(function (rev$$1) {
    var index = seqStore.index('_doc_id_rev');
    var key = docId + "::" + rev$$1;
    index.getKey(key).onsuccess = function (e) {
      var seq = e.target.result;
      if (typeof seq !== 'number') {
        return checkDone();
      }
      seqStore.delete(seq);

      var cursor = attAndSeqStore.index('seq')
        .openCursor(IDBKeyRange.only(seq));

      cursor.onsuccess = function (event) {
        var cursor = event.target.result;
        if (cursor) {
          var digest = cursor.value.digestSeq.split('::')[0];
          possiblyOrphanedDigests.push(digest);
          attAndSeqStore.delete(cursor.primaryKey);
          cursor.continue();
        } else { // done
          checkDone();
        }
      };
    };
  });
}

function openTransactionSafely(idb, stores, mode) {
  try {
    return {
      txn: idb.transaction(stores, mode)
    };
  } catch (err) {
    return {
      error: err
    };
  }
}

var changesHandler = new Changes();

function idbBulkDocs(dbOpts, req, opts, api, idb, callback) {
  var docInfos = req.docs;
  var txn;
  var docStore;
  var bySeqStore;
  var attachStore;
  var attachAndSeqStore;
  var metaStore;
  var docInfoError;
  var metaDoc;

  for (var i = 0, len = docInfos.length; i < len; i++) {
    var doc = docInfos[i];
    if (doc._id && isLocalId(doc._id)) {
      continue;
    }
    doc = docInfos[i] = parseDoc(doc, opts.new_edits);
    if (doc.error && !docInfoError) {
      docInfoError = doc;
    }
  }

  if (docInfoError) {
    return callback(docInfoError);
  }

  var allDocsProcessed = false;
  var docCountDelta = 0;
  var results = new Array(docInfos.length);
  var fetchedDocs = new ExportedMap();
  var preconditionErrored = false;
  var blobType = api._meta.blobSupport ? 'blob' : 'base64';

  preprocessAttachments(docInfos, blobType, function (err) {
    if (err) {
      return callback(err);
    }
    startTransaction();
  });

  function startTransaction() {

    var stores = [
      DOC_STORE, BY_SEQ_STORE,
      ATTACH_STORE,
      LOCAL_STORE, ATTACH_AND_SEQ_STORE,
      META_STORE
    ];
    var txnResult = openTransactionSafely(idb, stores, 'readwrite');
    if (txnResult.error) {
      return callback(txnResult.error);
    }
    txn = txnResult.txn;
    txn.onabort = idbError(callback);
    txn.ontimeout = idbError(callback);
    txn.oncomplete = complete;
    docStore = txn.objectStore(DOC_STORE);
    bySeqStore = txn.objectStore(BY_SEQ_STORE);
    attachStore = txn.objectStore(ATTACH_STORE);
    attachAndSeqStore = txn.objectStore(ATTACH_AND_SEQ_STORE);
    metaStore = txn.objectStore(META_STORE);

    metaStore.get(META_STORE).onsuccess = function (e) {
      metaDoc = e.target.result;
      updateDocCountIfReady();
    };

    verifyAttachments(function (err) {
      if (err) {
        preconditionErrored = true;
        return callback(err);
      }
      fetchExistingDocs();
    });
  }

  function onAllDocsProcessed() {
    allDocsProcessed = true;
    updateDocCountIfReady();
  }

  function idbProcessDocs() {
    processDocs(dbOpts.revs_limit, docInfos, api, fetchedDocs,
                txn, results, writeDoc, opts, onAllDocsProcessed);
  }

  function updateDocCountIfReady() {
    if (!metaDoc || !allDocsProcessed) {
      return;
    }
    // caching the docCount saves a lot of time in allDocs() and
    // info(), which is why we go to all the trouble of doing this
    metaDoc.docCount += docCountDelta;
    metaStore.put(metaDoc);
  }

  function fetchExistingDocs() {

    if (!docInfos.length) {
      return;
    }

    var numFetched = 0;

    function checkDone() {
      if (++numFetched === docInfos.length) {
        idbProcessDocs();
      }
    }

    function readMetadata(event) {
      var metadata = decodeMetadata(event.target.result);

      if (metadata) {
        fetchedDocs.set(metadata.id, metadata);
      }
      checkDone();
    }

    for (var i = 0, len = docInfos.length; i < len; i++) {
      var docInfo = docInfos[i];
      if (docInfo._id && isLocalId(docInfo._id)) {
        checkDone(); // skip local docs
        continue;
      }
      var req = docStore.get(docInfo.metadata.id);
      req.onsuccess = readMetadata;
    }
  }

  function complete() {
    if (preconditionErrored) {
      return;
    }

    changesHandler.notify(api._meta.name);
    callback(null, results);
  }

  function verifyAttachment(digest, callback) {

    var req = attachStore.get(digest);
    req.onsuccess = function (e) {
      if (!e.target.result) {
        var err = createError(MISSING_STUB,
          'unknown stub attachment with digest ' +
          digest);
        err.status = 412;
        callback(err);
      } else {
        callback();
      }
    };
  }

  function verifyAttachments(finish) {


    var digests = [];
    docInfos.forEach(function (docInfo) {
      if (docInfo.data && docInfo.data._attachments) {
        Object.keys(docInfo.data._attachments).forEach(function (filename) {
          var att = docInfo.data._attachments[filename];
          if (att.stub) {
            digests.push(att.digest);
          }
        });
      }
    });
    if (!digests.length) {
      return finish();
    }
    var numDone = 0;
    var err;

    function checkDone() {
      if (++numDone === digests.length) {
        finish(err);
      }
    }
    digests.forEach(function (digest) {
      verifyAttachment(digest, function (attErr) {
        if (attErr && !err) {
          err = attErr;
        }
        checkDone();
      });
    });
  }

  function writeDoc(docInfo, winningRev$$1, winningRevIsDeleted, newRevIsDeleted,
                    isUpdate, delta, resultsIdx, callback) {

    docInfo.metadata.winningRev = winningRev$$1;
    docInfo.metadata.deleted = winningRevIsDeleted;

    var doc = docInfo.data;
    doc._id = docInfo.metadata.id;
    doc._rev = docInfo.metadata.rev;

    if (newRevIsDeleted) {
      doc._deleted = true;
    }

    var hasAttachments = doc._attachments &&
      Object.keys(doc._attachments).length;
    if (hasAttachments) {
      return writeAttachments(docInfo, winningRev$$1, winningRevIsDeleted,
        isUpdate, resultsIdx, callback);
    }

    docCountDelta += delta;
    updateDocCountIfReady();

    finishDoc(docInfo, winningRev$$1, winningRevIsDeleted,
      isUpdate, resultsIdx, callback);
  }

  function finishDoc(docInfo, winningRev$$1, winningRevIsDeleted,
                     isUpdate, resultsIdx, callback) {

    var doc = docInfo.data;
    var metadata = docInfo.metadata;

    doc._doc_id_rev = metadata.id + '::' + metadata.rev;
    delete doc._id;
    delete doc._rev;

    function afterPutDoc(e) {
      var revsToDelete = docInfo.stemmedRevs || [];

      if (isUpdate && api.auto_compaction) {
        revsToDelete = revsToDelete.concat(compactTree(docInfo.metadata));
      }

      if (revsToDelete && revsToDelete.length) {
        compactRevs(revsToDelete, docInfo.metadata.id, txn);
      }

      metadata.seq = e.target.result;
      // Current _rev is calculated from _rev_tree on read
      // delete metadata.rev;
      var metadataToStore = encodeMetadata(metadata, winningRev$$1,
        winningRevIsDeleted);
      var metaDataReq = docStore.put(metadataToStore);
      metaDataReq.onsuccess = afterPutMetadata;
    }

    function afterPutDocError(e) {
      // ConstraintError, need to update, not put (see #1638 for details)
      e.preventDefault(); // avoid transaction abort
      e.stopPropagation(); // avoid transaction onerror
      var index = bySeqStore.index('_doc_id_rev');
      var getKeyReq = index.getKey(doc._doc_id_rev);
      getKeyReq.onsuccess = function (e) {
        var putReq = bySeqStore.put(doc, e.target.result);
        putReq.onsuccess = afterPutDoc;
      };
    }

    function afterPutMetadata() {
      results[resultsIdx] = {
        ok: true,
        id: metadata.id,
        rev: metadata.rev
      };
      fetchedDocs.set(docInfo.metadata.id, docInfo.metadata);
      insertAttachmentMappings(docInfo, metadata.seq, callback);
    }

    var putReq = bySeqStore.put(doc);

    putReq.onsuccess = afterPutDoc;
    putReq.onerror = afterPutDocError;
  }

  function writeAttachments(docInfo, winningRev$$1, winningRevIsDeleted,
                            isUpdate, resultsIdx, callback) {


    var doc = docInfo.data;

    var numDone = 0;
    var attachments = Object.keys(doc._attachments);

    function collectResults() {
      if (numDone === attachments.length) {
        finishDoc(docInfo, winningRev$$1, winningRevIsDeleted,
          isUpdate, resultsIdx, callback);
      }
    }

    function attachmentSaved() {
      numDone++;
      collectResults();
    }

    attachments.forEach(function (key) {
      var att = docInfo.data._attachments[key];
      if (!att.stub) {
        var data = att.data;
        delete att.data;
        att.revpos = parseInt(winningRev$$1, 10);
        var digest = att.digest;
        saveAttachment(digest, data, attachmentSaved);
      } else {
        numDone++;
        collectResults();
      }
    });
  }

  // map seqs to attachment digests, which
  // we will need later during compaction
  function insertAttachmentMappings(docInfo, seq, callback) {

    var attsAdded = 0;
    var attsToAdd = Object.keys(docInfo.data._attachments || {});

    if (!attsToAdd.length) {
      return callback();
    }

    function checkDone() {
      if (++attsAdded === attsToAdd.length) {
        callback();
      }
    }

    function add(att) {
      var digest = docInfo.data._attachments[att].digest;
      var req = attachAndSeqStore.put({
        seq: seq,
        digestSeq: digest + '::' + seq
      });

      req.onsuccess = checkDone;
      req.onerror = function (e) {
        // this callback is for a constaint error, which we ignore
        // because this docid/rev has already been associated with
        // the digest (e.g. when new_edits == false)
        e.preventDefault(); // avoid transaction abort
        e.stopPropagation(); // avoid transaction onerror
        checkDone();
      };
    }
    for (var i = 0; i < attsToAdd.length; i++) {
      add(attsToAdd[i]); // do in parallel
    }
  }

  function saveAttachment(digest, data, callback) {


    var getKeyReq = attachStore.count(digest);
    getKeyReq.onsuccess = function (e) {
      var count = e.target.result;
      if (count) {
        return callback(); // already exists
      }
      var newAtt = {
        digest: digest,
        body: data
      };
      var putReq = attachStore.put(newAtt);
      putReq.onsuccess = callback;
    };
  }
}

// Abstraction over IDBCursor and getAll()/getAllKeys() that allows us to batch our operations
// while falling back to a normal IDBCursor operation on browsers that don't support getAll() or
// getAllKeys(). This allows for a much faster implementation than just straight-up cursors, because
// we're not processing each document one-at-a-time.
function runBatchedCursor(objectStore, keyRange, descending, batchSize, onBatch) {

  // Bail out of getAll()/getAllKeys() in the following cases:
  // 1) either method is unsupported - we need both
  // 2) batchSize is 1 (might as well use IDBCursor), or batchSize is -1 (i.e. batchSize unlimited,
  //    not really clear the user wants a batched approach where the entire DB is read into memory,
  //    perhaps they are filtering on a per-doc basis)
  // 3) descending – no real way to do this via getAll()/getAllKeys()

  var useGetAll = typeof objectStore.getAll === 'function' &&
    typeof objectStore.getAllKeys === 'function' &&
    batchSize > 1 && !descending;

  var keysBatch;
  var valuesBatch;
  var pseudoCursor;

  function onGetAll(e) {
    valuesBatch = e.target.result;
    if (keysBatch) {
      onBatch(keysBatch, valuesBatch, pseudoCursor);
    }
  }

  function onGetAllKeys(e) {
    keysBatch = e.target.result;
    if (valuesBatch) {
      onBatch(keysBatch, valuesBatch, pseudoCursor);
    }
  }

  function continuePseudoCursor() {
    if (!keysBatch.length) { // no more results
      return onBatch();
    }
    // fetch next batch, exclusive start
    var lastKey = keysBatch[keysBatch.length - 1];
    var newKeyRange;
    if (keyRange && keyRange.upper) {
      try {
        newKeyRange = IDBKeyRange.bound(lastKey, keyRange.upper,
          true, keyRange.upperOpen);
      } catch (e) {
        if (e.name === "DataError" && e.code === 0) {
          return onBatch(); // we're done, startkey and endkey are equal
        }
      }
    } else {
      newKeyRange = IDBKeyRange.lowerBound(lastKey, true);
    }
    keyRange = newKeyRange;
    keysBatch = null;
    valuesBatch = null;
    objectStore.getAll(keyRange, batchSize).onsuccess = onGetAll;
    objectStore.getAllKeys(keyRange, batchSize).onsuccess = onGetAllKeys;
  }

  function onCursor(e) {
    var cursor = e.target.result;
    if (!cursor) { // done
      return onBatch();
    }
    // regular IDBCursor acts like a batch where batch size is always 1
    onBatch([cursor.key], [cursor.value], cursor);
  }

  if (useGetAll) {
    pseudoCursor = {"continue": continuePseudoCursor};
    objectStore.getAll(keyRange, batchSize).onsuccess = onGetAll;
    objectStore.getAllKeys(keyRange, batchSize).onsuccess = onGetAllKeys;
  } else if (descending) {
    objectStore.openCursor(keyRange, 'prev').onsuccess = onCursor;
  } else {
    objectStore.openCursor(keyRange).onsuccess = onCursor;
  }
}

// simple shim for objectStore.getAll(), falling back to IDBCursor
function getAll(objectStore, keyRange, onSuccess) {
  if (typeof objectStore.getAll === 'function') {
    // use native getAll
    objectStore.getAll(keyRange).onsuccess = onSuccess;
    return;
  }
  // fall back to cursors
  var values = [];

  function onCursor(e) {
    var cursor = e.target.result;
    if (cursor) {
      values.push(cursor.value);
      cursor.continue();
    } else {
      onSuccess({
        target: {
          result: values
        }
      });
    }
  }

  objectStore.openCursor(keyRange).onsuccess = onCursor;
}

function createKeyRange(start, end, inclusiveEnd, key, descending) {
  try {
    if (start && end) {
      if (descending) {
        return IDBKeyRange.bound(end, start, !inclusiveEnd, false);
      } else {
        return IDBKeyRange.bound(start, end, false, !inclusiveEnd);
      }
    } else if (start) {
      if (descending) {
        return IDBKeyRange.upperBound(start);
      } else {
        return IDBKeyRange.lowerBound(start);
      }
    } else if (end) {
      if (descending) {
        return IDBKeyRange.lowerBound(end, !inclusiveEnd);
      } else {
        return IDBKeyRange.upperBound(end, !inclusiveEnd);
      }
    } else if (key) {
      return IDBKeyRange.only(key);
    }
  } catch (e) {
    return {error: e};
  }
  return null;
}

function idbAllDocs(opts, idb, callback) {
  var start = 'startkey' in opts ? opts.startkey : false;
  var end = 'endkey' in opts ? opts.endkey : false;
  var key = 'key' in opts ? opts.key : false;
  var skip = opts.skip || 0;
  var limit = typeof opts.limit === 'number' ? opts.limit : -1;
  var inclusiveEnd = opts.inclusive_end !== false;

  var keyRange = createKeyRange(start, end, inclusiveEnd, key, opts.descending);
  var keyRangeError = keyRange && keyRange.error;
  if (keyRangeError && !(keyRangeError.name === "DataError" &&
      keyRangeError.code === 0)) {
    // DataError with error code 0 indicates start is less than end, so
    // can just do an empty query. Else need to throw
    return callback(createError(IDB_ERROR,
      keyRangeError.name, keyRangeError.message));
  }

  var stores = [DOC_STORE, BY_SEQ_STORE, META_STORE];

  if (opts.attachments) {
    stores.push(ATTACH_STORE);
  }
  var txnResult = openTransactionSafely(idb, stores, 'readonly');
  if (txnResult.error) {
    return callback(txnResult.error);
  }
  var txn = txnResult.txn;
  txn.oncomplete = onTxnComplete;
  txn.onabort = idbError(callback);
  var docStore = txn.objectStore(DOC_STORE);
  var seqStore = txn.objectStore(BY_SEQ_STORE);
  var metaStore = txn.objectStore(META_STORE);
  var docIdRevIndex = seqStore.index('_doc_id_rev');
  var results = [];
  var docCount;

  metaStore.get(META_STORE).onsuccess = function (e) {
    docCount = e.target.result.docCount;
  };

  // if the user specifies include_docs=true, then we don't
  // want to block the main cursor while we're fetching the doc
  function fetchDocAsynchronously(metadata, row, winningRev$$1) {
    var key = metadata.id + "::" + winningRev$$1;
    docIdRevIndex.get(key).onsuccess =  function onGetDoc(e) {
      row.doc = decodeDoc(e.target.result);
      if (opts.conflicts) {
        var conflicts = collectConflicts(metadata);
        if (conflicts.length) {
          row.doc._conflicts = conflicts;
        }
      }
      fetchAttachmentsIfNecessary(row.doc, opts, txn);
    };
  }

  function allDocsInner(winningRev$$1, metadata) {
    var row = {
      id: metadata.id,
      key: metadata.id,
      value: {
        rev: winningRev$$1
      }
    };
    var deleted = metadata.deleted;
    if (opts.deleted === 'ok') {
      results.push(row);
      // deleted docs are okay with "keys" requests
      if (deleted) {
        row.value.deleted = true;
        row.doc = null;
      } else if (opts.include_docs) {
        fetchDocAsynchronously(metadata, row, winningRev$$1);
      }
    } else if (!deleted && skip-- <= 0) {
      results.push(row);
      if (opts.include_docs) {
        fetchDocAsynchronously(metadata, row, winningRev$$1);
      }
    }
  }

  function processBatch(batchValues) {
    for (var i = 0, len = batchValues.length; i < len; i++) {
      if (results.length === limit) {
        break;
      }
      var batchValue = batchValues[i];
      var metadata = decodeMetadata(batchValue);
      var winningRev$$1 = metadata.winningRev;
      allDocsInner(winningRev$$1, metadata);
    }
  }

  function onBatch(batchKeys, batchValues, cursor) {
    if (!cursor) {
      return;
    }
    processBatch(batchValues);
    if (results.length < limit) {
      cursor.continue();
    }
  }

  function onGetAll(e) {
    var values = e.target.result;
    if (opts.descending) {
      values = values.reverse();
    }
    processBatch(values);
  }

  function onResultsReady() {
    callback(null, {
      total_rows: docCount,
      offset: opts.skip,
      rows: results
    });
  }

  function onTxnComplete() {
    if (opts.attachments) {
      postProcessAttachments(results, opts.binary).then(onResultsReady);
    } else {
      onResultsReady();
    }
  }

  // don't bother doing any requests if start > end or limit === 0
  if (keyRangeError || limit === 0) {
    return;
  }
  if (limit === -1) { // just fetch everything
    return getAll(docStore, keyRange, onGetAll);
  }
  // else do a cursor
  // choose a batch size based on the skip, since we'll need to skip that many
  runBatchedCursor(docStore, keyRange, opts.descending, limit + skip, onBatch);
}

//
// Blobs are not supported in all versions of IndexedDB, notably
// Chrome <37 and Android <5. In those versions, storing a blob will throw.
//
// Various other blob bugs exist in Chrome v37-42 (inclusive).
// Detecting them is expensive and confusing to users, and Chrome 37-42
// is at very low usage worldwide, so we do a hacky userAgent check instead.
//
// content-type bug: https://code.google.com/p/chromium/issues/detail?id=408120
// 404 bug: https://code.google.com/p/chromium/issues/detail?id=447916
// FileReader bug: https://code.google.com/p/chromium/issues/detail?id=447836
//
function checkBlobSupport(txn) {
  return new PouchPromise$1(function (resolve) {
    var blob = createBlob(['']);
    var req = txn.objectStore(DETECT_BLOB_SUPPORT_STORE).put(blob, 'key');

    req.onsuccess = function () {
      var matchedChrome = navigator.userAgent.match(/Chrome\/(\d+)/);
      var matchedEdge = navigator.userAgent.match(/Edge\//);
      // MS Edge pretends to be Chrome 42:
      // https://msdn.microsoft.com/en-us/library/hh869301%28v=vs.85%29.aspx
      resolve(matchedEdge || !matchedChrome ||
        parseInt(matchedChrome[1], 10) >= 43);
    };

    txn.onabort = function (e) {
      // If the transaction aborts now its due to not being able to
      // write to the database, likely due to the disk being full
      e.preventDefault();
      e.stopPropagation();
      resolve(false);
    };
  }).catch(function () {
    return false; // error, so assume unsupported
  });
}

function countDocs(txn, cb) {
  var index = txn.objectStore(DOC_STORE).index('deletedOrLocal');
  index.count(IDBKeyRange.only('0')).onsuccess = function (e) {
    cb(e.target.result);
  };
}

// This task queue ensures that IDB open calls are done in their own tick
// and sequentially - i.e. we wait for the async IDB open to *fully* complete
// before calling the next one. This works around IE/Edge race conditions in IDB.

var running = false;
var queue = [];

function tryCode(fun, err, res, PouchDB) {
  try {
    fun(err, res);
  } catch (err) {
    // Shouldn't happen, but in some odd cases
    // IndexedDB implementations might throw a sync
    // error, in which case this will at least log it.
    PouchDB.emit('error', err);
  }
}

function applyNext() {
  if (running || !queue.length) {
    return;
  }
  running = true;
  queue.shift()();
}

function enqueueTask(action, callback, PouchDB) {
  queue.push(function runAction() {
    action(function runCallback(err, res) {
      tryCode(callback, err, res, PouchDB);
      running = false;
      browser$2(function runNext() {
        applyNext(PouchDB);
      });
    });
  });
  applyNext();
}

function changes(opts, api, dbName, idb) {
  opts = clone(opts);

  if (opts.continuous) {
    var id = dbName + ':' + uuid();
    changesHandler.addListener(dbName, id, api, opts);
    changesHandler.notify(dbName);
    return {
      cancel: function () {
        changesHandler.removeListener(dbName, id);
      }
    };
  }

  var docIds = opts.doc_ids && new ExportedSet(opts.doc_ids);

  opts.since = opts.since || 0;
  var lastSeq = opts.since;

  var limit = 'limit' in opts ? opts.limit : -1;
  if (limit === 0) {
    limit = 1; // per CouchDB _changes spec
  }
  var returnDocs;
  if ('return_docs' in opts) {
    returnDocs = opts.return_docs;
  } else if ('returnDocs' in opts) {
    // TODO: Remove 'returnDocs' in favor of 'return_docs' in a future release
    returnDocs = opts.returnDocs;
  } else {
    returnDocs = true;
  }

  var results = [];
  var numResults = 0;
  var filter = filterChange(opts);
  var docIdsToMetadata = new ExportedMap();

  var txn;
  var bySeqStore;
  var docStore;
  var docIdRevIndex;

  function onBatch(batchKeys, batchValues, cursor) {
    if (!cursor || !batchKeys.length) { // done
      return;
    }

    var winningDocs = new Array(batchKeys.length);
    var metadatas = new Array(batchKeys.length);

    function processMetadataAndWinningDoc(metadata, winningDoc) {
      var change = opts.processChange(winningDoc, metadata, opts);
      lastSeq = change.seq = metadata.seq;

      var filtered = filter(change);
      if (typeof filtered === 'object') { // anything but true/false indicates error
        return opts.complete(filtered);
      }

      if (filtered) {
        numResults++;
        if (returnDocs) {
          results.push(change);
        }
        // process the attachment immediately
        // for the benefit of live listeners
        if (opts.attachments && opts.include_docs) {
          fetchAttachmentsIfNecessary(winningDoc, opts, txn, function () {
            postProcessAttachments([change], opts.binary).then(function () {
              opts.onChange(change);
            });
          });
        } else {
          opts.onChange(change);
        }
      }
    }

    function onBatchDone() {
      for (var i = 0, len = winningDocs.length; i < len; i++) {
        if (numResults === limit) {
          break;
        }
        var winningDoc = winningDocs[i];
        if (!winningDoc) {
          continue;
        }
        var metadata = metadatas[i];
        processMetadataAndWinningDoc(metadata, winningDoc);
      }

      if (numResults !== limit) {
        cursor.continue();
      }
    }

    // Fetch all metadatas/winningdocs from this batch in parallel, then process
    // them all only once all data has been collected. This is done in parallel
    // because it's faster than doing it one-at-a-time.
    var numDone = 0;
    batchValues.forEach(function (value, i) {
      var doc = decodeDoc(value);
      var seq = batchKeys[i];
      fetchWinningDocAndMetadata(doc, seq, function (metadata, winningDoc) {
        metadatas[i] = metadata;
        winningDocs[i] = winningDoc;
        if (++numDone === batchKeys.length) {
          onBatchDone();
        }
      });
    });
  }

  function onGetMetadata(doc, seq, metadata, cb) {
    if (metadata.seq !== seq) {
      // some other seq is later
      return cb();
    }

    if (metadata.winningRev === doc._rev) {
      // this is the winning doc
      return cb(metadata, doc);
    }

    // fetch winning doc in separate request
    var docIdRev = doc._id + '::' + metadata.winningRev;
    var req = docIdRevIndex.get(docIdRev);
    req.onsuccess = function (e) {
      cb(metadata, decodeDoc(e.target.result));
    };
  }

  function fetchWinningDocAndMetadata(doc, seq, cb) {
    if (docIds && !docIds.has(doc._id)) {
      return cb();
    }

    var metadata = docIdsToMetadata.get(doc._id);
    if (metadata) { // cached
      return onGetMetadata(doc, seq, metadata, cb);
    }
    // metadata not cached, have to go fetch it
    docStore.get(doc._id).onsuccess = function (e) {
      metadata = decodeMetadata(e.target.result);
      docIdsToMetadata.set(doc._id, metadata);
      onGetMetadata(doc, seq, metadata, cb);
    };
  }

  function finish() {
    opts.complete(null, {
      results: results,
      last_seq: lastSeq
    });
  }

  function onTxnComplete() {
    if (!opts.continuous && opts.attachments) {
      // cannot guarantee that postProcessing was already done,
      // so do it again
      postProcessAttachments(results).then(finish);
    } else {
      finish();
    }
  }

  var objectStores = [DOC_STORE, BY_SEQ_STORE];
  if (opts.attachments) {
    objectStores.push(ATTACH_STORE);
  }
  var txnResult = openTransactionSafely(idb, objectStores, 'readonly');
  if (txnResult.error) {
    return opts.complete(txnResult.error);
  }
  txn = txnResult.txn;
  txn.onabort = idbError(opts.complete);
  txn.oncomplete = onTxnComplete;

  bySeqStore = txn.objectStore(BY_SEQ_STORE);
  docStore = txn.objectStore(DOC_STORE);
  docIdRevIndex = bySeqStore.index('_doc_id_rev');

  var keyRange = (opts.since && !opts.descending) ?
    IDBKeyRange.lowerBound(opts.since, true) : null;

  runBatchedCursor(bySeqStore, keyRange, opts.descending, limit, onBatch);
}

var cachedDBs = new ExportedMap();
var blobSupportPromise;
var openReqList = new ExportedMap();

function IdbPouch(opts, callback) {
  var api = this;

  enqueueTask(function (thisCallback) {
    init(api, opts, thisCallback);
  }, callback, api.constructor);
}

function init(api, opts, callback) {

  var dbName = opts.name;

  var idb = null;
  api._meta = null;

  // called when creating a fresh new database
  function createSchema(db) {
    var docStore = db.createObjectStore(DOC_STORE, {keyPath : 'id'});
    db.createObjectStore(BY_SEQ_STORE, {autoIncrement: true})
      .createIndex('_doc_id_rev', '_doc_id_rev', {unique: true});
    db.createObjectStore(ATTACH_STORE, {keyPath: 'digest'});
    db.createObjectStore(META_STORE, {keyPath: 'id', autoIncrement: false});
    db.createObjectStore(DETECT_BLOB_SUPPORT_STORE);

    // added in v2
    docStore.createIndex('deletedOrLocal', 'deletedOrLocal', {unique : false});

    // added in v3
    db.createObjectStore(LOCAL_STORE, {keyPath: '_id'});

    // added in v4
    var attAndSeqStore = db.createObjectStore(ATTACH_AND_SEQ_STORE,
      {autoIncrement: true});
    attAndSeqStore.createIndex('seq', 'seq');
    attAndSeqStore.createIndex('digestSeq', 'digestSeq', {unique: true});
  }

  // migration to version 2
  // unfortunately "deletedOrLocal" is a misnomer now that we no longer
  // store local docs in the main doc-store, but whaddyagonnado
  function addDeletedOrLocalIndex(txn, callback) {
    var docStore = txn.objectStore(DOC_STORE);
    docStore.createIndex('deletedOrLocal', 'deletedOrLocal', {unique : false});

    docStore.openCursor().onsuccess = function (event) {
      var cursor = event.target.result;
      if (cursor) {
        var metadata = cursor.value;
        var deleted = isDeleted(metadata);
        metadata.deletedOrLocal = deleted ? "1" : "0";
        docStore.put(metadata);
        cursor.continue();
      } else {
        callback();
      }
    };
  }

  // migration to version 3 (part 1)
  function createLocalStoreSchema(db) {
    db.createObjectStore(LOCAL_STORE, {keyPath: '_id'})
      .createIndex('_doc_id_rev', '_doc_id_rev', {unique: true});
  }

  // migration to version 3 (part 2)
  function migrateLocalStore(txn, cb) {
    var localStore = txn.objectStore(LOCAL_STORE);
    var docStore = txn.objectStore(DOC_STORE);
    var seqStore = txn.objectStore(BY_SEQ_STORE);

    var cursor = docStore.openCursor();
    cursor.onsuccess = function (event) {
      var cursor = event.target.result;
      if (cursor) {
        var metadata = cursor.value;
        var docId = metadata.id;
        var local = isLocalId(docId);
        var rev$$1 = winningRev(metadata);
        if (local) {
          var docIdRev = docId + "::" + rev$$1;
          // remove all seq entries
          // associated with this docId
          var start = docId + "::";
          var end = docId + "::~";
          var index = seqStore.index('_doc_id_rev');
          var range = IDBKeyRange.bound(start, end, false, false);
          var seqCursor = index.openCursor(range);
          seqCursor.onsuccess = function (e) {
            seqCursor = e.target.result;
            if (!seqCursor) {
              // done
              docStore.delete(cursor.primaryKey);
              cursor.continue();
            } else {
              var data = seqCursor.value;
              if (data._doc_id_rev === docIdRev) {
                localStore.put(data);
              }
              seqStore.delete(seqCursor.primaryKey);
              seqCursor.continue();
            }
          };
        } else {
          cursor.continue();
        }
      } else if (cb) {
        cb();
      }
    };
  }

  // migration to version 4 (part 1)
  function addAttachAndSeqStore(db) {
    var attAndSeqStore = db.createObjectStore(ATTACH_AND_SEQ_STORE,
      {autoIncrement: true});
    attAndSeqStore.createIndex('seq', 'seq');
    attAndSeqStore.createIndex('digestSeq', 'digestSeq', {unique: true});
  }

  // migration to version 4 (part 2)
  function migrateAttsAndSeqs(txn, callback) {
    var seqStore = txn.objectStore(BY_SEQ_STORE);
    var attStore = txn.objectStore(ATTACH_STORE);
    var attAndSeqStore = txn.objectStore(ATTACH_AND_SEQ_STORE);

    // need to actually populate the table. this is the expensive part,
    // so as an optimization, check first that this database even
    // contains attachments
    var req = attStore.count();
    req.onsuccess = function (e) {
      var count = e.target.result;
      if (!count) {
        return callback(); // done
      }

      seqStore.openCursor().onsuccess = function (e) {
        var cursor = e.target.result;
        if (!cursor) {
          return callback(); // done
        }
        var doc = cursor.value;
        var seq = cursor.primaryKey;
        var atts = Object.keys(doc._attachments || {});
        var digestMap = {};
        for (var j = 0; j < atts.length; j++) {
          var att = doc._attachments[atts[j]];
          digestMap[att.digest] = true; // uniq digests, just in case
        }
        var digests = Object.keys(digestMap);
        for (j = 0; j < digests.length; j++) {
          var digest = digests[j];
          attAndSeqStore.put({
            seq: seq,
            digestSeq: digest + '::' + seq
          });
        }
        cursor.continue();
      };
    };
  }

  // migration to version 5
  // Instead of relying on on-the-fly migration of metadata,
  // this brings the doc-store to its modern form:
  // - metadata.winningrev
  // - metadata.seq
  // - stringify the metadata when storing it
  function migrateMetadata(txn) {

    function decodeMetadataCompat(storedObject) {
      if (!storedObject.data) {
        // old format, when we didn't store it stringified
        storedObject.deleted = storedObject.deletedOrLocal === '1';
        return storedObject;
      }
      return decodeMetadata(storedObject);
    }

    // ensure that every metadata has a winningRev and seq,
    // which was previously created on-the-fly but better to migrate
    var bySeqStore = txn.objectStore(BY_SEQ_STORE);
    var docStore = txn.objectStore(DOC_STORE);
    var cursor = docStore.openCursor();
    cursor.onsuccess = function (e) {
      var cursor = e.target.result;
      if (!cursor) {
        return; // done
      }
      var metadata = decodeMetadataCompat(cursor.value);

      metadata.winningRev = metadata.winningRev ||
        winningRev(metadata);

      function fetchMetadataSeq() {
        // metadata.seq was added post-3.2.0, so if it's missing,
        // we need to fetch it manually
        var start = metadata.id + '::';
        var end = metadata.id + '::\uffff';
        var req = bySeqStore.index('_doc_id_rev').openCursor(
          IDBKeyRange.bound(start, end));

        var metadataSeq = 0;
        req.onsuccess = function (e) {
          var cursor = e.target.result;
          if (!cursor) {
            metadata.seq = metadataSeq;
            return onGetMetadataSeq();
          }
          var seq = cursor.primaryKey;
          if (seq > metadataSeq) {
            metadataSeq = seq;
          }
          cursor.continue();
        };
      }

      function onGetMetadataSeq() {
        var metadataToStore = encodeMetadata(metadata,
          metadata.winningRev, metadata.deleted);

        var req = docStore.put(metadataToStore);
        req.onsuccess = function () {
          cursor.continue();
        };
      }

      if (metadata.seq) {
        return onGetMetadataSeq();
      }

      fetchMetadataSeq();
    };

  }

  api._remote = false;
  api.type = function () {
    return 'idb';
  };

  api._id = toPromise(function (callback) {
    callback(null, api._meta.instanceId);
  });

  api._bulkDocs = function idb_bulkDocs(req, reqOpts, callback) {
    idbBulkDocs(opts, req, reqOpts, api, idb, callback);
  };

  // First we look up the metadata in the ids database, then we fetch the
  // current revision(s) from the by sequence store
  api._get = function idb_get(id, opts, callback) {
    var doc;
    var metadata;
    var err;
    var txn = opts.ctx;
    if (!txn) {
      var txnResult = openTransactionSafely(idb,
        [DOC_STORE, BY_SEQ_STORE, ATTACH_STORE], 'readonly');
      if (txnResult.error) {
        return callback(txnResult.error);
      }
      txn = txnResult.txn;
    }

    function finish() {
      callback(err, {doc: doc, metadata: metadata, ctx: txn});
    }

    txn.objectStore(DOC_STORE).get(id).onsuccess = function (e) {
      metadata = decodeMetadata(e.target.result);
      // we can determine the result here if:
      // 1. there is no such document
      // 2. the document is deleted and we don't ask about specific rev
      // When we ask with opts.rev we expect the answer to be either
      // doc (possibly with _deleted=true) or missing error
      if (!metadata) {
        err = createError(MISSING_DOC, 'missing');
        return finish();
      }

      var rev$$1;
      if (!opts.rev) {
        rev$$1 = metadata.winningRev;
        var deleted = isDeleted(metadata);
        if (deleted) {
          err = createError(MISSING_DOC, "deleted");
          return finish();
        }
      } else {
        rev$$1 = opts.latest ? latest(opts.rev, metadata) : opts.rev;
      }

      var objectStore = txn.objectStore(BY_SEQ_STORE);
      var key = metadata.id + '::' + rev$$1;

      objectStore.index('_doc_id_rev').get(key).onsuccess = function (e) {
        doc = e.target.result;
        if (doc) {
          doc = decodeDoc(doc);
        }
        if (!doc) {
          err = createError(MISSING_DOC, 'missing');
          return finish();
        }
        finish();
      };
    };
  };

  api._getAttachment = function (docId, attachId, attachment, opts, callback) {
    var txn;
    if (opts.ctx) {
      txn = opts.ctx;
    } else {
      var txnResult = openTransactionSafely(idb,
        [DOC_STORE, BY_SEQ_STORE, ATTACH_STORE], 'readonly');
      if (txnResult.error) {
        return callback(txnResult.error);
      }
      txn = txnResult.txn;
    }
    var digest = attachment.digest;
    var type = attachment.content_type;

    txn.objectStore(ATTACH_STORE).get(digest).onsuccess = function (e) {
      var body = e.target.result.body;
      readBlobData(body, type, opts.binary, function (blobData) {
        callback(null, blobData);
      });
    };
  };

  api._info = function idb_info(callback) {
    var updateSeq;
    var docCount;

    var txnResult = openTransactionSafely(idb, [META_STORE, BY_SEQ_STORE], 'readonly');
    if (txnResult.error) {
      return callback(txnResult.error);
    }
    var txn = txnResult.txn;
    txn.objectStore(META_STORE).get(META_STORE).onsuccess = function (e) {
      docCount = e.target.result.docCount;
    };
    txn.objectStore(BY_SEQ_STORE).openCursor(null, 'prev').onsuccess = function (e) {
      var cursor = e.target.result;
      updateSeq = cursor ? cursor.key : 0;
    };

    txn.oncomplete = function () {
      callback(null, {
        doc_count: docCount,
        update_seq: updateSeq,
        // for debugging
        idb_attachment_format: (api._meta.blobSupport ? 'binary' : 'base64')
      });
    };
  };

  api._allDocs = function idb_allDocs(opts, callback) {
    idbAllDocs(opts, idb, callback);
  };

  api._changes = function idbChanges(opts) {
    return changes(opts, api, dbName, idb);
  };

  api._close = function (callback) {
    // https://developer.mozilla.org/en-US/docs/IndexedDB/IDBDatabase#close
    // "Returns immediately and closes the connection in a separate thread..."
    idb.close();
    cachedDBs.delete(dbName);
    callback();
  };

  api._getRevisionTree = function (docId, callback) {
    var txnResult = openTransactionSafely(idb, [DOC_STORE], 'readonly');
    if (txnResult.error) {
      return callback(txnResult.error);
    }
    var txn = txnResult.txn;
    var req = txn.objectStore(DOC_STORE).get(docId);
    req.onsuccess = function (event) {
      var doc = decodeMetadata(event.target.result);
      if (!doc) {
        callback(createError(MISSING_DOC));
      } else {
        callback(null, doc.rev_tree);
      }
    };
  };

  // This function removes revisions of document docId
  // which are listed in revs and sets this document
  // revision to to rev_tree
  api._doCompaction = function (docId, revs, callback) {
    var stores = [
      DOC_STORE,
      BY_SEQ_STORE,
      ATTACH_STORE,
      ATTACH_AND_SEQ_STORE
    ];
    var txnResult = openTransactionSafely(idb, stores, 'readwrite');
    if (txnResult.error) {
      return callback(txnResult.error);
    }
    var txn = txnResult.txn;

    var docStore = txn.objectStore(DOC_STORE);

    docStore.get(docId).onsuccess = function (event) {
      var metadata = decodeMetadata(event.target.result);
      traverseRevTree(metadata.rev_tree, function (isLeaf, pos,
                                                         revHash, ctx, opts) {
        var rev$$1 = pos + '-' + revHash;
        if (revs.indexOf(rev$$1) !== -1) {
          opts.status = 'missing';
        }
      });
      compactRevs(revs, docId, txn);
      var winningRev$$1 = metadata.winningRev;
      var deleted = metadata.deleted;
      txn.objectStore(DOC_STORE).put(
        encodeMetadata(metadata, winningRev$$1, deleted));
    };
    txn.onabort = idbError(callback);
    txn.oncomplete = function () {
      callback();
    };
  };


  api._getLocal = function (id, callback) {
    var txnResult = openTransactionSafely(idb, [LOCAL_STORE], 'readonly');
    if (txnResult.error) {
      return callback(txnResult.error);
    }
    var tx = txnResult.txn;
    var req = tx.objectStore(LOCAL_STORE).get(id);

    req.onerror = idbError(callback);
    req.onsuccess = function (e) {
      var doc = e.target.result;
      if (!doc) {
        callback(createError(MISSING_DOC));
      } else {
        delete doc['_doc_id_rev']; // for backwards compat
        callback(null, doc);
      }
    };
  };

  api._putLocal = function (doc, opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    delete doc._revisions; // ignore this, trust the rev
    var oldRev = doc._rev;
    var id = doc._id;
    if (!oldRev) {
      doc._rev = '0-1';
    } else {
      doc._rev = '0-' + (parseInt(oldRev.split('-')[1], 10) + 1);
    }

    var tx = opts.ctx;
    var ret;
    if (!tx) {
      var txnResult = openTransactionSafely(idb, [LOCAL_STORE], 'readwrite');
      if (txnResult.error) {
        return callback(txnResult.error);
      }
      tx = txnResult.txn;
      tx.onerror = idbError(callback);
      tx.oncomplete = function () {
        if (ret) {
          callback(null, ret);
        }
      };
    }

    var oStore = tx.objectStore(LOCAL_STORE);
    var req;
    if (oldRev) {
      req = oStore.get(id);
      req.onsuccess = function (e) {
        var oldDoc = e.target.result;
        if (!oldDoc || oldDoc._rev !== oldRev) {
          callback(createError(REV_CONFLICT));
        } else { // update
          var req = oStore.put(doc);
          req.onsuccess = function () {
            ret = {ok: true, id: doc._id, rev: doc._rev};
            if (opts.ctx) { // return immediately
              callback(null, ret);
            }
          };
        }
      };
    } else { // new doc
      req = oStore.add(doc);
      req.onerror = function (e) {
        // constraint error, already exists
        callback(createError(REV_CONFLICT));
        e.preventDefault(); // avoid transaction abort
        e.stopPropagation(); // avoid transaction onerror
      };
      req.onsuccess = function () {
        ret = {ok: true, id: doc._id, rev: doc._rev};
        if (opts.ctx) { // return immediately
          callback(null, ret);
        }
      };
    }
  };

  api._removeLocal = function (doc, opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    var tx = opts.ctx;
    if (!tx) {
      var txnResult = openTransactionSafely(idb, [LOCAL_STORE], 'readwrite');
      if (txnResult.error) {
        return callback(txnResult.error);
      }
      tx = txnResult.txn;
      tx.oncomplete = function () {
        if (ret) {
          callback(null, ret);
        }
      };
    }
    var ret;
    var id = doc._id;
    var oStore = tx.objectStore(LOCAL_STORE);
    var req = oStore.get(id);

    req.onerror = idbError(callback);
    req.onsuccess = function (e) {
      var oldDoc = e.target.result;
      if (!oldDoc || oldDoc._rev !== doc._rev) {
        callback(createError(MISSING_DOC));
      } else {
        oStore.delete(id);
        ret = {ok: true, id: id, rev: '0-0'};
        if (opts.ctx) { // return immediately
          callback(null, ret);
        }
      }
    };
  };

  api._destroy = function (opts, callback) {
    changesHandler.removeAllListeners(dbName);

    //Close open request for "dbName" database to fix ie delay.
    var openReq = openReqList.get(dbName);
    if (openReq && openReq.result) {
      openReq.result.close();
      cachedDBs.delete(dbName);
    }
    var req = indexedDB.deleteDatabase(dbName);

    req.onsuccess = function () {
      //Remove open request from the list.
      openReqList.delete(dbName);
      if (hasLocalStorage() && (dbName in localStorage)) {
        delete localStorage[dbName];
      }
      callback(null, { 'ok': true });
    };

    req.onerror = idbError(callback);
  };

  var cached = cachedDBs.get(dbName);

  if (cached) {
    idb = cached.idb;
    api._meta = cached.global;
    return browser$2(function () {
      callback(null, api);
    });
  }

  var req;
  if (opts.storage) {
    req = tryStorageOption(dbName, opts.storage);
  } else {
    req = indexedDB.open(dbName, ADAPTER_VERSION);
  }

  openReqList.set(dbName, req);

  req.onupgradeneeded = function (e) {
    var db = e.target.result;
    if (e.oldVersion < 1) {
      return createSchema(db); // new db, initial schema
    }
    // do migrations

    var txn = e.currentTarget.transaction;
    // these migrations have to be done in this function, before
    // control is returned to the event loop, because IndexedDB

    if (e.oldVersion < 3) {
      createLocalStoreSchema(db); // v2 -> v3
    }
    if (e.oldVersion < 4) {
      addAttachAndSeqStore(db); // v3 -> v4
    }

    var migrations = [
      addDeletedOrLocalIndex, // v1 -> v2
      migrateLocalStore,      // v2 -> v3
      migrateAttsAndSeqs,     // v3 -> v4
      migrateMetadata         // v4 -> v5
    ];

    var i = e.oldVersion;

    function next() {
      var migration = migrations[i - 1];
      i++;
      if (migration) {
        migration(txn, next);
      }
    }

    next();
  };

  req.onsuccess = function (e) {

    idb = e.target.result;

    idb.onversionchange = function () {
      idb.close();
      cachedDBs.delete(dbName);
    };

    idb.onabort = function (e) {
      guardedConsole('error', 'Database has a global failure', e.target.error);
      idb.close();
      cachedDBs.delete(dbName);
    };

    // Do a few setup operations (in parallel as much as possible):
    // 1. Fetch meta doc
    // 2. Check blob support
    // 3. Calculate docCount
    // 4. Generate an instanceId if necessary
    // 5. Store docCount and instanceId on meta doc

    var txn = idb.transaction([
      META_STORE,
      DETECT_BLOB_SUPPORT_STORE,
      DOC_STORE
    ], 'readwrite');

    var storedMetaDoc = false;
    var metaDoc;
    var docCount;
    var blobSupport;
    var instanceId;

    function completeSetup() {
      if (typeof blobSupport === 'undefined' || !storedMetaDoc) {
        return;
      }
      api._meta = {
        name: dbName,
        instanceId: instanceId,
        blobSupport: blobSupport
      };

      cachedDBs.set(dbName, {
        idb: idb,
        global: api._meta
      });
      callback(null, api);
    }

    function storeMetaDocIfReady() {
      if (typeof docCount === 'undefined' || typeof metaDoc === 'undefined') {
        return;
      }
      var instanceKey = dbName + '_id';
      if (instanceKey in metaDoc) {
        instanceId = metaDoc[instanceKey];
      } else {
        metaDoc[instanceKey] = instanceId = uuid();
      }
      metaDoc.docCount = docCount;
      txn.objectStore(META_STORE).put(metaDoc);
    }

    //
    // fetch or generate the instanceId
    //
    txn.objectStore(META_STORE).get(META_STORE).onsuccess = function (e) {
      metaDoc = e.target.result || { id: META_STORE };
      storeMetaDocIfReady();
    };

    //
    // countDocs
    //
    countDocs(txn, function (count) {
      docCount = count;
      storeMetaDocIfReady();
    });

    //
    // check blob support
    //
    if (!blobSupportPromise) {
      // make sure blob support is only checked once
      blobSupportPromise = checkBlobSupport(txn);
    }

    blobSupportPromise.then(function (val) {
      blobSupport = val;
      completeSetup();
    });

    // only when the metadata put transaction has completed,
    // consider the setup done
    txn.oncomplete = function () {
      storedMetaDoc = true;
      completeSetup();
    };
  };

  req.onerror = function () {
    var msg = 'Failed to open indexedDB, are you in private browsing mode?';
    guardedConsole('error', msg);
    callback(createError(IDB_ERROR, msg));
  };
}

IdbPouch.valid = function () {
  // Issue #2533, we finally gave up on doing bug
  // detection instead of browser sniffing. Safari brought us
  // to our knees.
  var isSafari = typeof openDatabase !== 'undefined' &&
    /(Safari|iPhone|iPad|iPod)/.test(navigator.userAgent) &&
    !/Chrome/.test(navigator.userAgent) &&
    !/BlackBerry/.test(navigator.platform);

  // some outdated implementations of IDB that appear on Samsung
  // and HTC Android devices <4.4 are missing IDBKeyRange
  return !isSafari && typeof indexedDB !== 'undefined' &&
    typeof IDBKeyRange !== 'undefined';
};

function tryStorageOption(dbName, storage) {
  try { // option only available in Firefox 26+
    return indexedDB.open(dbName, {
      version: ADAPTER_VERSION,
      storage: storage
    });
  } catch (err) {
      return indexedDB.open(dbName, ADAPTER_VERSION);
  }
}

var IDBPouch = function (PouchDB) {
  PouchDB.adapter('idb', IdbPouch, true);
};

//
// Parsing hex strings. Yeah.
//
// So basically we need this because of a bug in WebSQL:
// https://code.google.com/p/chromium/issues/detail?id=422690
// https://bugs.webkit.org/show_bug.cgi?id=137637
//
// UTF-8 and UTF-16 are provided as separate functions
// for meager performance improvements
//

function decodeUtf8(str) {
  return decodeURIComponent(escape(str));
}

function hexToInt(charCode) {
  // '0'-'9' is 48-57
  // 'A'-'F' is 65-70
  // SQLite will only give us uppercase hex
  return charCode < 65 ? (charCode - 48) : (charCode - 55);
}


// Example:
// pragma encoding=utf8;
// select hex('A');
// returns '41'
function parseHexUtf8(str, start, end) {
  var result = '';
  while (start < end) {
    result += String.fromCharCode(
      (hexToInt(str.charCodeAt(start++)) << 4) |
        hexToInt(str.charCodeAt(start++)));
  }
  return result;
}

// Example:
// pragma encoding=utf16;
// select hex('A');
// returns '4100'
// notice that the 00 comes after the 41 (i.e. it's swizzled)
function parseHexUtf16(str, start, end) {
  var result = '';
  while (start < end) {
    // UTF-16, so swizzle the bytes
    result += String.fromCharCode(
      (hexToInt(str.charCodeAt(start + 2)) << 12) |
        (hexToInt(str.charCodeAt(start + 3)) << 8) |
        (hexToInt(str.charCodeAt(start)) << 4) |
        hexToInt(str.charCodeAt(start + 1)));
    start += 4;
  }
  return result;
}

function parseHexString(str, encoding) {
  if (encoding === 'UTF-8') {
    return decodeUtf8(parseHexUtf8(str, 0, str.length));
  } else {
    return parseHexUtf16(str, 0, str.length);
  }
}

function quote(str) {
  return "'" + str + "'";
}

var ADAPTER_VERSION$1 = 7; // used to manage migrations

// The object stores created for each database
// DOC_STORE stores the document meta data, its revision history and state
var DOC_STORE$1 = quote('document-store');
// BY_SEQ_STORE stores a particular version of a document, keyed by its
// sequence id
var BY_SEQ_STORE$1 = quote('by-sequence');
// Where we store attachments
var ATTACH_STORE$1 = quote('attach-store');
var LOCAL_STORE$1 = quote('local-store');
var META_STORE$1 = quote('metadata-store');
// where we store many-to-many relations between attachment
// digests and seqs
var ATTACH_AND_SEQ_STORE$1 = quote('attach-seq-store');

// escapeBlob and unescapeBlob are workarounds for a websql bug:
// https://code.google.com/p/chromium/issues/detail?id=422690
// https://bugs.webkit.org/show_bug.cgi?id=137637
// The goal is to never actually insert the \u0000 character
// in the database.
function escapeBlob(str) {
  return str
    .replace(/\u0002/g, '\u0002\u0002')
    .replace(/\u0001/g, '\u0001\u0002')
    .replace(/\u0000/g, '\u0001\u0001');
}

function unescapeBlob(str) {
  return str
    .replace(/\u0001\u0001/g, '\u0000')
    .replace(/\u0001\u0002/g, '\u0001')
    .replace(/\u0002\u0002/g, '\u0002');
}

function stringifyDoc(doc) {
  // don't bother storing the id/rev. it uses lots of space,
  // in persistent map/reduce especially
  delete doc._id;
  delete doc._rev;
  return JSON.stringify(doc);
}

function unstringifyDoc(doc, id, rev$$1) {
  doc = JSON.parse(doc);
  doc._id = id;
  doc._rev = rev$$1;
  return doc;
}

// question mark groups IN queries, e.g. 3 -> '(?,?,?)'
function qMarks(num) {
  var s = '(';
  while (num--) {
    s += '?';
    if (num) {
      s += ',';
    }
  }
  return s + ')';
}

function select(selector, table, joiner, where, orderBy) {
  return 'SELECT ' + selector + ' FROM ' +
    (typeof table === 'string' ? table : table.join(' JOIN ')) +
    (joiner ? (' ON ' + joiner) : '') +
    (where ? (' WHERE ' +
    (typeof where === 'string' ? where : where.join(' AND '))) : '') +
    (orderBy ? (' ORDER BY ' + orderBy) : '');
}

function compactRevs$1(revs, docId, tx) {

  if (!revs.length) {
    return;
  }

  var numDone = 0;
  var seqs = [];

  function checkDone() {
    if (++numDone === revs.length) { // done
      deleteOrphans();
    }
  }

  function deleteOrphans() {
    // find orphaned attachment digests

    if (!seqs.length) {
      return;
    }

    var sql = 'SELECT DISTINCT digest AS digest FROM ' +
      ATTACH_AND_SEQ_STORE$1 + ' WHERE seq IN ' + qMarks(seqs.length);

    tx.executeSql(sql, seqs, function (tx, res) {

      var digestsToCheck = [];
      for (var i = 0; i < res.rows.length; i++) {
        digestsToCheck.push(res.rows.item(i).digest);
      }
      if (!digestsToCheck.length) {
        return;
      }

      var sql = 'DELETE FROM ' + ATTACH_AND_SEQ_STORE$1 +
        ' WHERE seq IN (' +
        seqs.map(function () { return '?'; }).join(',') +
        ')';
      tx.executeSql(sql, seqs, function (tx) {

        var sql = 'SELECT digest FROM ' + ATTACH_AND_SEQ_STORE$1 +
          ' WHERE digest IN (' +
          digestsToCheck.map(function () { return '?'; }).join(',') +
          ')';
        tx.executeSql(sql, digestsToCheck, function (tx, res) {
          var nonOrphanedDigests = new ExportedSet();
          for (var i = 0; i < res.rows.length; i++) {
            nonOrphanedDigests.add(res.rows.item(i).digest);
          }
          digestsToCheck.forEach(function (digest) {
            if (nonOrphanedDigests.has(digest)) {
              return;
            }
            tx.executeSql(
              'DELETE FROM ' + ATTACH_AND_SEQ_STORE$1 + ' WHERE digest=?',
              [digest]);
            tx.executeSql(
              'DELETE FROM ' + ATTACH_STORE$1 + ' WHERE digest=?', [digest]);
          });
        });
      });
    });
  }

  // update by-seq and attach stores in parallel
  revs.forEach(function (rev$$1) {
    var sql = 'SELECT seq FROM ' + BY_SEQ_STORE$1 +
      ' WHERE doc_id=? AND rev=?';

    tx.executeSql(sql, [docId, rev$$1], function (tx, res) {
      if (!res.rows.length) { // already deleted
        return checkDone();
      }
      var seq = res.rows.item(0).seq;
      seqs.push(seq);

      tx.executeSql(
        'DELETE FROM ' + BY_SEQ_STORE$1 + ' WHERE seq=?', [seq], checkDone);
    });
  });
}

function websqlError(callback) {
  return function (event) {
    guardedConsole('error', 'WebSQL threw an error', event);
    // event may actually be a SQLError object, so report is as such
    var errorNameMatch = event && event.constructor.toString()
        .match(/function ([^(]+)/);
    var errorName = (errorNameMatch && errorNameMatch[1]) || event.type;
    var errorReason = event.target || event.message;
    callback(createError(WSQ_ERROR, errorReason, errorName));
  };
}

function getSize(opts) {
  if ('size' in opts) {
    // triggers immediate popup in iOS, fixes #2347
    // e.g. 5000001 asks for 5 MB, 10000001 asks for 10 MB,
    return opts.size * 1000000;
  }
  // In iOS, doesn't matter as long as it's <= 5000000.
  // Except that if you request too much, our tests fail
  // because of the native "do you accept?" popup.
  // In Android <=4.3, this value is actually used as an
  // honest-to-god ceiling for data, so we need to
  // set it to a decently high number.
  var isAndroid = typeof navigator !== 'undefined' &&
    /Android/.test(navigator.userAgent);
  return isAndroid ? 5000000 : 1; // in PhantomJS, if you use 0 it will crash
}

function websqlBulkDocs(dbOpts, req, opts, api, db, websqlChanges, callback) {
  var newEdits = opts.new_edits;
  var userDocs = req.docs;

  // Parse the docs, give them a sequence number for the result
  var docInfos = userDocs.map(function (doc) {
    if (doc._id && isLocalId(doc._id)) {
      return doc;
    }
    var newDoc = parseDoc(doc, newEdits);
    return newDoc;
  });

  var docInfoErrors = docInfos.filter(function (docInfo) {
    return docInfo.error;
  });
  if (docInfoErrors.length) {
    return callback(docInfoErrors[0]);
  }

  var tx;
  var results = new Array(docInfos.length);
  var fetchedDocs = new ExportedMap();

  var preconditionErrored;
  function complete() {
    if (preconditionErrored) {
      return callback(preconditionErrored);
    }
    websqlChanges.notify(api._name);
    callback(null, results);
  }

  function verifyAttachment(digest, callback) {
    var sql = 'SELECT count(*) as cnt FROM ' + ATTACH_STORE$1 +
      ' WHERE digest=?';
    tx.executeSql(sql, [digest], function (tx, result) {
      if (result.rows.item(0).cnt === 0) {
        var err = createError(MISSING_STUB,
          'unknown stub attachment with digest ' +
          digest);
        callback(err);
      } else {
        callback();
      }
    });
  }

  function verifyAttachments(finish) {
    var digests = [];
    docInfos.forEach(function (docInfo) {
      if (docInfo.data && docInfo.data._attachments) {
        Object.keys(docInfo.data._attachments).forEach(function (filename) {
          var att = docInfo.data._attachments[filename];
          if (att.stub) {
            digests.push(att.digest);
          }
        });
      }
    });
    if (!digests.length) {
      return finish();
    }
    var numDone = 0;
    var err;

    function checkDone() {
      if (++numDone === digests.length) {
        finish(err);
      }
    }
    digests.forEach(function (digest) {
      verifyAttachment(digest, function (attErr) {
        if (attErr && !err) {
          err = attErr;
        }
        checkDone();
      });
    });
  }

  function writeDoc(docInfo, winningRev$$1, winningRevIsDeleted, newRevIsDeleted,
                    isUpdate, delta, resultsIdx, callback) {

    function finish() {
      var data = docInfo.data;
      var deletedInt = newRevIsDeleted ? 1 : 0;

      var id = data._id;
      var rev = data._rev;
      var json = stringifyDoc(data);
      var sql = 'INSERT INTO ' + BY_SEQ_STORE$1 +
        ' (doc_id, rev, json, deleted) VALUES (?, ?, ?, ?);';
      var sqlArgs = [id, rev, json, deletedInt];

      // map seqs to attachment digests, which
      // we will need later during compaction
      function insertAttachmentMappings(seq, callback) {
        var attsAdded = 0;
        var attsToAdd = Object.keys(data._attachments || {});

        if (!attsToAdd.length) {
          return callback();
        }
        function checkDone() {
          if (++attsAdded === attsToAdd.length) {
            callback();
          }
          return false; // ack handling a constraint error
        }
        function add(att) {
          var sql = 'INSERT INTO ' + ATTACH_AND_SEQ_STORE$1 +
            ' (digest, seq) VALUES (?,?)';
          var sqlArgs = [data._attachments[att].digest, seq];
          tx.executeSql(sql, sqlArgs, checkDone, checkDone);
          // second callback is for a constaint error, which we ignore
          // because this docid/rev has already been associated with
          // the digest (e.g. when new_edits == false)
        }
        for (var i = 0; i < attsToAdd.length; i++) {
          add(attsToAdd[i]); // do in parallel
        }
      }

      tx.executeSql(sql, sqlArgs, function (tx, result) {
        var seq = result.insertId;
        insertAttachmentMappings(seq, function () {
          dataWritten(tx, seq);
        });
      }, function () {
        // constraint error, recover by updating instead (see #1638)
        var fetchSql = select('seq', BY_SEQ_STORE$1, null,
          'doc_id=? AND rev=?');
        tx.executeSql(fetchSql, [id, rev], function (tx, res) {
          var seq = res.rows.item(0).seq;
          var sql = 'UPDATE ' + BY_SEQ_STORE$1 +
            ' SET json=?, deleted=? WHERE doc_id=? AND rev=?;';
          var sqlArgs = [json, deletedInt, id, rev];
          tx.executeSql(sql, sqlArgs, function (tx) {
            insertAttachmentMappings(seq, function () {
              dataWritten(tx, seq);
            });
          });
        });
        return false; // ack that we've handled the error
      });
    }

    function collectResults(attachmentErr) {
      if (!err) {
        if (attachmentErr) {
          err = attachmentErr;
          callback(err);
        } else if (recv === attachments.length) {
          finish();
        }
      }
    }

    var err = null;
    var recv = 0;

    docInfo.data._id = docInfo.metadata.id;
    docInfo.data._rev = docInfo.metadata.rev;
    var attachments = Object.keys(docInfo.data._attachments || {});


    if (newRevIsDeleted) {
      docInfo.data._deleted = true;
    }

    function attachmentSaved(err) {
      recv++;
      collectResults(err);
    }

    attachments.forEach(function (key) {
      var att = docInfo.data._attachments[key];
      if (!att.stub) {
        var data = att.data;
        delete att.data;
        att.revpos = parseInt(winningRev$$1, 10);
        var digest = att.digest;
        saveAttachment(digest, data, attachmentSaved);
      } else {
        recv++;
        collectResults();
      }
    });

    if (!attachments.length) {
      finish();
    }

    function dataWritten(tx, seq) {
      var id = docInfo.metadata.id;

      var revsToCompact = docInfo.stemmedRevs || [];
      if (isUpdate && api.auto_compaction) {
        revsToCompact = compactTree(docInfo.metadata).concat(revsToCompact);
      }
      if (revsToCompact.length) {
        compactRevs$1(revsToCompact, id, tx);
      }

      docInfo.metadata.seq = seq;
      var rev = docInfo.metadata.rev;
      delete docInfo.metadata.rev;

      var sql = isUpdate ?
      'UPDATE ' + DOC_STORE$1 +
      ' SET json=?, max_seq=?, winningseq=' +
      '(SELECT seq FROM ' + BY_SEQ_STORE$1 +
      ' WHERE doc_id=' + DOC_STORE$1 + '.id AND rev=?) WHERE id=?'
        : 'INSERT INTO ' + DOC_STORE$1 +
      ' (id, winningseq, max_seq, json) VALUES (?,?,?,?);';
      var metadataStr = safeJsonStringify(docInfo.metadata);
      var params = isUpdate ?
        [metadataStr, seq, winningRev$$1, id] :
        [id, seq, seq, metadataStr];
      tx.executeSql(sql, params, function () {
        results[resultsIdx] = {
          ok: true,
          id: docInfo.metadata.id,
          rev: rev
        };
        fetchedDocs.set(id, docInfo.metadata);
        callback();
      });
    }
  }

  function websqlProcessDocs() {
    processDocs(dbOpts.revs_limit, docInfos, api, fetchedDocs, tx,
                results, writeDoc, opts);
  }

  function fetchExistingDocs(callback) {
    if (!docInfos.length) {
      return callback();
    }

    var numFetched = 0;

    function checkDone() {
      if (++numFetched === docInfos.length) {
        callback();
      }
    }

    docInfos.forEach(function (docInfo) {
      if (docInfo._id && isLocalId(docInfo._id)) {
        return checkDone(); // skip local docs
      }
      var id = docInfo.metadata.id;
      tx.executeSql('SELECT json FROM ' + DOC_STORE$1 +
      ' WHERE id = ?', [id], function (tx, result) {
        if (result.rows.length) {
          var metadata = safeJsonParse(result.rows.item(0).json);
          fetchedDocs.set(id, metadata);
        }
        checkDone();
      });
    });
  }

  function saveAttachment(digest, data, callback) {
    var sql = 'SELECT digest FROM ' + ATTACH_STORE$1 + ' WHERE digest=?';
    tx.executeSql(sql, [digest], function (tx, result) {
      if (result.rows.length) { // attachment already exists
        return callback();
      }
      // we could just insert before selecting and catch the error,
      // but my hunch is that it's cheaper not to serialize the blob
      // from JS to C if we don't have to (TODO: confirm this)
      sql = 'INSERT INTO ' + ATTACH_STORE$1 +
      ' (digest, body, escaped) VALUES (?,?,1)';
      tx.executeSql(sql, [digest, escapeBlob(data)], function () {
        callback();
      }, function () {
        // ignore constaint errors, means it already exists
        callback();
        return false; // ack we handled the error
      });
    });
  }

  preprocessAttachments(docInfos, 'binary', function (err) {
    if (err) {
      return callback(err);
    }
    db.transaction(function (txn) {
      tx = txn;
      verifyAttachments(function (err) {
        if (err) {
          preconditionErrored = err;
        } else {
          fetchExistingDocs(websqlProcessDocs);
        }
      });
    }, websqlError(callback), complete);
  });
}

var cachedDatabases = new ExportedMap();

// openDatabase passed in through opts (e.g. for node-websql)
function openDatabaseWithOpts(opts) {
  return opts.websql(opts.name, opts.version, opts.description, opts.size);
}

function openDBSafely(opts) {
  try {
    return {
      db: openDatabaseWithOpts(opts)
    };
  } catch (err) {
    return {
      error: err
    };
  }
}

function openDB$1(opts) {
  var cachedResult = cachedDatabases.get(opts.name);
  if (!cachedResult) {
    cachedResult = openDBSafely(opts);
    cachedDatabases.set(opts.name, cachedResult);
  }
  return cachedResult;
}

var websqlChanges = new Changes();

function fetchAttachmentsIfNecessary$1(doc, opts, api, txn, cb) {
  var attachments = Object.keys(doc._attachments || {});
  if (!attachments.length) {
    return cb && cb();
  }
  var numDone = 0;

  function checkDone() {
    if (++numDone === attachments.length && cb) {
      cb();
    }
  }

  function fetchAttachment(doc, att) {
    var attObj = doc._attachments[att];
    var attOpts = {binary: opts.binary, ctx: txn};
    api._getAttachment(doc._id, att, attObj, attOpts, function (_, data) {
      doc._attachments[att] = $inject_Object_assign(
        pick(attObj, ['digest', 'content_type']),
        { data: data }
      );
      checkDone();
    });
  }

  attachments.forEach(function (att) {
    if (opts.attachments && opts.include_docs) {
      fetchAttachment(doc, att);
    } else {
      doc._attachments[att].stub = true;
      checkDone();
    }
  });
}

var POUCH_VERSION = 1;

// these indexes cover the ground for most allDocs queries
var BY_SEQ_STORE_DELETED_INDEX_SQL =
  'CREATE INDEX IF NOT EXISTS \'by-seq-deleted-idx\' ON ' +
  BY_SEQ_STORE$1 + ' (seq, deleted)';
var BY_SEQ_STORE_DOC_ID_REV_INDEX_SQL =
  'CREATE UNIQUE INDEX IF NOT EXISTS \'by-seq-doc-id-rev\' ON ' +
    BY_SEQ_STORE$1 + ' (doc_id, rev)';
var DOC_STORE_WINNINGSEQ_INDEX_SQL =
  'CREATE INDEX IF NOT EXISTS \'doc-winningseq-idx\' ON ' +
  DOC_STORE$1 + ' (winningseq)';
var ATTACH_AND_SEQ_STORE_SEQ_INDEX_SQL =
  'CREATE INDEX IF NOT EXISTS \'attach-seq-seq-idx\' ON ' +
    ATTACH_AND_SEQ_STORE$1 + ' (seq)';
var ATTACH_AND_SEQ_STORE_ATTACH_INDEX_SQL =
  'CREATE UNIQUE INDEX IF NOT EXISTS \'attach-seq-digest-idx\' ON ' +
    ATTACH_AND_SEQ_STORE$1 + ' (digest, seq)';

var DOC_STORE_AND_BY_SEQ_JOINER = BY_SEQ_STORE$1 +
  '.seq = ' + DOC_STORE$1 + '.winningseq';

var SELECT_DOCS = BY_SEQ_STORE$1 + '.seq AS seq, ' +
  BY_SEQ_STORE$1 + '.deleted AS deleted, ' +
  BY_SEQ_STORE$1 + '.json AS data, ' +
  BY_SEQ_STORE$1 + '.rev AS rev, ' +
  DOC_STORE$1 + '.json AS metadata';

function WebSqlPouch$1(opts, callback) {
  var api = this;
  var instanceId = null;
  var size = getSize(opts);
  var idRequests = [];
  var encoding;

  api._name = opts.name;

  // extend the options here, because sqlite plugin has a ton of options
  // and they are constantly changing, so it's more prudent to allow anything
  var websqlOpts = $inject_Object_assign({}, opts, {
    version: POUCH_VERSION,
    description: opts.name,
    size: size
  });
  var openDBResult = openDB$1(websqlOpts);
  if (openDBResult.error) {
    return websqlError(callback)(openDBResult.error);
  }
  var db = openDBResult.db;
  if (typeof db.readTransaction !== 'function') {
    // doesn't exist in sqlite plugin
    db.readTransaction = db.transaction;
  }

  function dbCreated() {
    // note the db name in case the browser upgrades to idb
    if (hasLocalStorage()) {
      window.localStorage['_pouch__websqldb_' + api._name] = true;
    }
    callback(null, api);
  }

  // In this migration, we added the 'deleted' and 'local' columns to the
  // by-seq and doc store tables.
  // To preserve existing user data, we re-process all the existing JSON
  // and add these values.
  // Called migration2 because it corresponds to adapter version (db_version) #2
  function runMigration2(tx, callback) {
    // index used for the join in the allDocs query
    tx.executeSql(DOC_STORE_WINNINGSEQ_INDEX_SQL);

    tx.executeSql('ALTER TABLE ' + BY_SEQ_STORE$1 +
      ' ADD COLUMN deleted TINYINT(1) DEFAULT 0', [], function () {
      tx.executeSql(BY_SEQ_STORE_DELETED_INDEX_SQL);
      tx.executeSql('ALTER TABLE ' + DOC_STORE$1 +
        ' ADD COLUMN local TINYINT(1) DEFAULT 0', [], function () {
        tx.executeSql('CREATE INDEX IF NOT EXISTS \'doc-store-local-idx\' ON ' +
          DOC_STORE$1 + ' (local, id)');

        var sql = 'SELECT ' + DOC_STORE$1 + '.winningseq AS seq, ' + DOC_STORE$1 +
          '.json AS metadata FROM ' + BY_SEQ_STORE$1 + ' JOIN ' + DOC_STORE$1 +
          ' ON ' + BY_SEQ_STORE$1 + '.seq = ' + DOC_STORE$1 + '.winningseq';

        tx.executeSql(sql, [], function (tx, result) {

          var deleted = [];
          var local = [];

          for (var i = 0; i < result.rows.length; i++) {
            var item = result.rows.item(i);
            var seq = item.seq;
            var metadata = JSON.parse(item.metadata);
            if (isDeleted(metadata)) {
              deleted.push(seq);
            }
            if (isLocalId(metadata.id)) {
              local.push(metadata.id);
            }
          }
          tx.executeSql('UPDATE ' + DOC_STORE$1 + 'SET local = 1 WHERE id IN ' +
            qMarks(local.length), local, function () {
            tx.executeSql('UPDATE ' + BY_SEQ_STORE$1 +
              ' SET deleted = 1 WHERE seq IN ' +
              qMarks(deleted.length), deleted, callback);
          });
        });
      });
    });
  }

  // in this migration, we make all the local docs unversioned
  function runMigration3(tx, callback) {
    var local = 'CREATE TABLE IF NOT EXISTS ' + LOCAL_STORE$1 +
      ' (id UNIQUE, rev, json)';
    tx.executeSql(local, [], function () {
      var sql = 'SELECT ' + DOC_STORE$1 + '.id AS id, ' +
        BY_SEQ_STORE$1 + '.json AS data ' +
        'FROM ' + BY_SEQ_STORE$1 + ' JOIN ' +
        DOC_STORE$1 + ' ON ' + BY_SEQ_STORE$1 + '.seq = ' +
        DOC_STORE$1 + '.winningseq WHERE local = 1';
      tx.executeSql(sql, [], function (tx, res) {
        var rows = [];
        for (var i = 0; i < res.rows.length; i++) {
          rows.push(res.rows.item(i));
        }
        function doNext() {
          if (!rows.length) {
            return callback(tx);
          }
          var row = rows.shift();
          var rev$$1 = JSON.parse(row.data)._rev;
          tx.executeSql('INSERT INTO ' + LOCAL_STORE$1 +
              ' (id, rev, json) VALUES (?,?,?)',
              [row.id, rev$$1, row.data], function (tx) {
            tx.executeSql('DELETE FROM ' + DOC_STORE$1 + ' WHERE id=?',
                [row.id], function (tx) {
              tx.executeSql('DELETE FROM ' + BY_SEQ_STORE$1 + ' WHERE seq=?',
                  [row.seq], function () {
                doNext();
              });
            });
          });
        }
        doNext();
      });
    });
  }

  // in this migration, we remove doc_id_rev and just use rev
  function runMigration4(tx, callback) {

    function updateRows(rows) {
      function doNext() {
        if (!rows.length) {
          return callback(tx);
        }
        var row = rows.shift();
        var doc_id_rev = parseHexString(row.hex, encoding);
        var idx = doc_id_rev.lastIndexOf('::');
        var doc_id = doc_id_rev.substring(0, idx);
        var rev$$1 = doc_id_rev.substring(idx + 2);
        var sql = 'UPDATE ' + BY_SEQ_STORE$1 +
          ' SET doc_id=?, rev=? WHERE doc_id_rev=?';
        tx.executeSql(sql, [doc_id, rev$$1, doc_id_rev], function () {
          doNext();
        });
      }
      doNext();
    }

    var sql = 'ALTER TABLE ' + BY_SEQ_STORE$1 + ' ADD COLUMN doc_id';
    tx.executeSql(sql, [], function (tx) {
      var sql = 'ALTER TABLE ' + BY_SEQ_STORE$1 + ' ADD COLUMN rev';
      tx.executeSql(sql, [], function (tx) {
        tx.executeSql(BY_SEQ_STORE_DOC_ID_REV_INDEX_SQL, [], function (tx) {
          var sql = 'SELECT hex(doc_id_rev) as hex FROM ' + BY_SEQ_STORE$1;
          tx.executeSql(sql, [], function (tx, res) {
            var rows = [];
            for (var i = 0; i < res.rows.length; i++) {
              rows.push(res.rows.item(i));
            }
            updateRows(rows);
          });
        });
      });
    });
  }

  // in this migration, we add the attach_and_seq table
  // for issue #2818
  function runMigration5(tx, callback) {

    function migrateAttsAndSeqs(tx) {
      // need to actually populate the table. this is the expensive part,
      // so as an optimization, check first that this database even
      // contains attachments
      var sql = 'SELECT COUNT(*) AS cnt FROM ' + ATTACH_STORE$1;
      tx.executeSql(sql, [], function (tx, res) {
        var count = res.rows.item(0).cnt;
        if (!count) {
          return callback(tx);
        }

        var offset = 0;
        var pageSize = 10;
        function nextPage() {
          var sql = select(
            SELECT_DOCS + ', ' + DOC_STORE$1 + '.id AS id',
            [DOC_STORE$1, BY_SEQ_STORE$1],
            DOC_STORE_AND_BY_SEQ_JOINER,
            null,
            DOC_STORE$1 + '.id '
          );
          sql += ' LIMIT ' + pageSize + ' OFFSET ' + offset;
          offset += pageSize;
          tx.executeSql(sql, [], function (tx, res) {
            if (!res.rows.length) {
              return callback(tx);
            }
            var digestSeqs = {};
            function addDigestSeq(digest, seq) {
              // uniq digest/seq pairs, just in case there are dups
              var seqs = digestSeqs[digest] = (digestSeqs[digest] || []);
              if (seqs.indexOf(seq) === -1) {
                seqs.push(seq);
              }
            }
            for (var i = 0; i < res.rows.length; i++) {
              var row = res.rows.item(i);
              var doc = unstringifyDoc(row.data, row.id, row.rev);
              var atts = Object.keys(doc._attachments || {});
              for (var j = 0; j < atts.length; j++) {
                var att = doc._attachments[atts[j]];
                addDigestSeq(att.digest, row.seq);
              }
            }
            var digestSeqPairs = [];
            Object.keys(digestSeqs).forEach(function (digest) {
              var seqs = digestSeqs[digest];
              seqs.forEach(function (seq) {
                digestSeqPairs.push([digest, seq]);
              });
            });
            if (!digestSeqPairs.length) {
              return nextPage();
            }
            var numDone = 0;
            digestSeqPairs.forEach(function (pair) {
              var sql = 'INSERT INTO ' + ATTACH_AND_SEQ_STORE$1 +
                ' (digest, seq) VALUES (?,?)';
              tx.executeSql(sql, pair, function () {
                if (++numDone === digestSeqPairs.length) {
                  nextPage();
                }
              });
            });
          });
        }
        nextPage();
      });
    }

    var attachAndRev = 'CREATE TABLE IF NOT EXISTS ' +
      ATTACH_AND_SEQ_STORE$1 + ' (digest, seq INTEGER)';
    tx.executeSql(attachAndRev, [], function (tx) {
      tx.executeSql(
        ATTACH_AND_SEQ_STORE_ATTACH_INDEX_SQL, [], function (tx) {
          tx.executeSql(
            ATTACH_AND_SEQ_STORE_SEQ_INDEX_SQL, [],
            migrateAttsAndSeqs);
        });
    });
  }

  // in this migration, we use escapeBlob() and unescapeBlob()
  // instead of reading out the binary as HEX, which is slow
  function runMigration6(tx, callback) {
    var sql = 'ALTER TABLE ' + ATTACH_STORE$1 +
      ' ADD COLUMN escaped TINYINT(1) DEFAULT 0';
    tx.executeSql(sql, [], callback);
  }

  // issue #3136, in this migration we need a "latest seq" as well
  // as the "winning seq" in the doc store
  function runMigration7(tx, callback) {
    var sql = 'ALTER TABLE ' + DOC_STORE$1 +
      ' ADD COLUMN max_seq INTEGER';
    tx.executeSql(sql, [], function (tx) {
      var sql = 'UPDATE ' + DOC_STORE$1 + ' SET max_seq=(SELECT MAX(seq) FROM ' +
        BY_SEQ_STORE$1 + ' WHERE doc_id=id)';
      tx.executeSql(sql, [], function (tx) {
        // add unique index after filling, else we'll get a constraint
        // error when we do the ALTER TABLE
        var sql =
          'CREATE UNIQUE INDEX IF NOT EXISTS \'doc-max-seq-idx\' ON ' +
          DOC_STORE$1 + ' (max_seq)';
        tx.executeSql(sql, [], callback);
      });
    });
  }

  function checkEncoding(tx, cb) {
    // UTF-8 on chrome/android, UTF-16 on safari < 7.1
    tx.executeSql('SELECT HEX("a") AS hex', [], function (tx, res) {
        var hex = res.rows.item(0).hex;
        encoding = hex.length === 2 ? 'UTF-8' : 'UTF-16';
        cb();
      }
    );
  }

  function onGetInstanceId() {
    while (idRequests.length > 0) {
      var idCallback = idRequests.pop();
      idCallback(null, instanceId);
    }
  }

  function onGetVersion(tx, dbVersion) {
    if (dbVersion === 0) {
      // initial schema

      var meta = 'CREATE TABLE IF NOT EXISTS ' + META_STORE$1 +
        ' (dbid, db_version INTEGER)';
      var attach = 'CREATE TABLE IF NOT EXISTS ' + ATTACH_STORE$1 +
        ' (digest UNIQUE, escaped TINYINT(1), body BLOB)';
      var attachAndRev = 'CREATE TABLE IF NOT EXISTS ' +
        ATTACH_AND_SEQ_STORE$1 + ' (digest, seq INTEGER)';
      // TODO: migrate winningseq to INTEGER
      var doc = 'CREATE TABLE IF NOT EXISTS ' + DOC_STORE$1 +
        ' (id unique, json, winningseq, max_seq INTEGER UNIQUE)';
      var seq = 'CREATE TABLE IF NOT EXISTS ' + BY_SEQ_STORE$1 +
        ' (seq INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, ' +
        'json, deleted TINYINT(1), doc_id, rev)';
      var local = 'CREATE TABLE IF NOT EXISTS ' + LOCAL_STORE$1 +
        ' (id UNIQUE, rev, json)';

      // creates
      tx.executeSql(attach);
      tx.executeSql(local);
      tx.executeSql(attachAndRev, [], function () {
        tx.executeSql(ATTACH_AND_SEQ_STORE_SEQ_INDEX_SQL);
        tx.executeSql(ATTACH_AND_SEQ_STORE_ATTACH_INDEX_SQL);
      });
      tx.executeSql(doc, [], function () {
        tx.executeSql(DOC_STORE_WINNINGSEQ_INDEX_SQL);
        tx.executeSql(seq, [], function () {
          tx.executeSql(BY_SEQ_STORE_DELETED_INDEX_SQL);
          tx.executeSql(BY_SEQ_STORE_DOC_ID_REV_INDEX_SQL);
          tx.executeSql(meta, [], function () {
            // mark the db version, and new dbid
            var initSeq = 'INSERT INTO ' + META_STORE$1 +
              ' (db_version, dbid) VALUES (?,?)';
            instanceId = uuid();
            var initSeqArgs = [ADAPTER_VERSION$1, instanceId];
            tx.executeSql(initSeq, initSeqArgs, function () {
              onGetInstanceId();
            });
          });
        });
      });
    } else { // version > 0

      var setupDone = function () {
        var migrated = dbVersion < ADAPTER_VERSION$1;
        if (migrated) {
          // update the db version within this transaction
          tx.executeSql('UPDATE ' + META_STORE$1 + ' SET db_version = ' +
            ADAPTER_VERSION$1);
        }
        // notify db.id() callers
        var sql = 'SELECT dbid FROM ' + META_STORE$1;
        tx.executeSql(sql, [], function (tx, result) {
          instanceId = result.rows.item(0).dbid;
          onGetInstanceId();
        });
      };

      // would love to use promises here, but then websql
      // ends the transaction early
      var tasks = [
        runMigration2,
        runMigration3,
        runMigration4,
        runMigration5,
        runMigration6,
        runMigration7,
        setupDone
      ];

      // run each migration sequentially
      var i = dbVersion;
      var nextMigration = function (tx) {
        tasks[i - 1](tx, nextMigration);
        i++;
      };
      nextMigration(tx);
    }
  }

  function setup() {
    db.transaction(function (tx) {
      // first check the encoding
      checkEncoding(tx, function () {
        // then get the version
        fetchVersion(tx);
      });
    }, websqlError(callback), dbCreated);
  }

  function fetchVersion(tx) {
    var sql = 'SELECT sql FROM sqlite_master WHERE tbl_name = ' + META_STORE$1;
    tx.executeSql(sql, [], function (tx, result) {
      if (!result.rows.length) {
        // database hasn't even been created yet (version 0)
        onGetVersion(tx, 0);
      } else if (!/db_version/.test(result.rows.item(0).sql)) {
        // table was created, but without the new db_version column,
        // so add it.
        tx.executeSql('ALTER TABLE ' + META_STORE$1 +
          ' ADD COLUMN db_version INTEGER', [], function () {
          // before version 2, this column didn't even exist
          onGetVersion(tx, 1);
        });
      } else { // column exists, we can safely get it
        tx.executeSql('SELECT db_version FROM ' + META_STORE$1,
          [], function (tx, result) {
          var dbVersion = result.rows.item(0).db_version;
          onGetVersion(tx, dbVersion);
        });
      }
    });
  }

  setup();

  function getMaxSeq(tx, callback) {
    var sql = 'SELECT MAX(seq) AS seq FROM ' + BY_SEQ_STORE$1;
    tx.executeSql(sql, [], function (tx, res) {
      var updateSeq = res.rows.item(0).seq || 0;
      callback(updateSeq);
    });
  }

  function countDocs(tx, callback) {
    // count the total rows
    var sql = select(
      'COUNT(' + DOC_STORE$1 + '.id) AS \'num\'',
      [DOC_STORE$1, BY_SEQ_STORE$1],
      DOC_STORE_AND_BY_SEQ_JOINER,
      BY_SEQ_STORE$1 + '.deleted=0');

    tx.executeSql(sql, [], function (tx, result) {
      callback(result.rows.item(0).num);
    });
  }

  api._remote = false;
  api.type = function () {
    return 'websql';
  };

  api._id = toPromise(function (callback) {
    callback(null, instanceId);
  });

  api._info = function (callback) {
    var seq;
    var docCount;
    db.readTransaction(function (tx) {
      getMaxSeq(tx, function (theSeq) {
        seq = theSeq;
      });
      countDocs(tx, function (theDocCount) {
        docCount = theDocCount;
      });
    }, websqlError(callback), function () {
      callback(null, {
        doc_count: docCount,
        update_seq: seq,
        websql_encoding: encoding
      });
    });
  };

  api._bulkDocs = function (req, reqOpts, callback) {
    websqlBulkDocs(opts, req, reqOpts, api, db, websqlChanges, callback);
  };

  function latest$$1(tx, id, rev$$1, callback, finish) {
    var sql = select(
        SELECT_DOCS,
        [DOC_STORE$1, BY_SEQ_STORE$1],
        DOC_STORE_AND_BY_SEQ_JOINER,
        DOC_STORE$1 + '.id=?');
    var sqlArgs = [id];

    tx.executeSql(sql, sqlArgs, function (a, results) {
      if (!results.rows.length) {
        var err = createError(MISSING_DOC, 'missing');
        return finish(err);
      }
      var item = results.rows.item(0);
      var metadata = safeJsonParse(item.metadata);
      callback(latest(rev$$1, metadata));
    });
  }

  api._get = function (id, opts, callback) {
    var doc;
    var metadata;
    var tx = opts.ctx;
    if (!tx) {
      return db.readTransaction(function (txn) {
        api._get(id, $inject_Object_assign({ctx: txn}, opts), callback);
      });
    }

    function finish(err) {
      callback(err, {doc: doc, metadata: metadata, ctx: tx});
    }

    var sql;
    var sqlArgs;

    if (!opts.rev) {
      sql = select(
        SELECT_DOCS,
        [DOC_STORE$1, BY_SEQ_STORE$1],
        DOC_STORE_AND_BY_SEQ_JOINER,
        DOC_STORE$1 + '.id=?');
      sqlArgs = [id];
    } else if (opts.latest) {
      latest$$1(tx, id, opts.rev, function (latestRev) {
        opts.latest = false;
        opts.rev = latestRev;
        api._get(id, opts, callback);
      }, finish);
      return;
    } else {
      sql = select(
        SELECT_DOCS,
        [DOC_STORE$1, BY_SEQ_STORE$1],
        DOC_STORE$1 + '.id=' + BY_SEQ_STORE$1 + '.doc_id',
        [BY_SEQ_STORE$1 + '.doc_id=?', BY_SEQ_STORE$1 + '.rev=?']);
      sqlArgs = [id, opts.rev];
    }

    tx.executeSql(sql, sqlArgs, function (a, results) {
      if (!results.rows.length) {
        var missingErr = createError(MISSING_DOC, 'missing');
        return finish(missingErr);
      }
      var item = results.rows.item(0);
      metadata = safeJsonParse(item.metadata);
      if (item.deleted && !opts.rev) {
        var deletedErr = createError(MISSING_DOC, 'deleted');
        return finish(deletedErr);
      }
      doc = unstringifyDoc(item.data, metadata.id, item.rev);
      finish();
    });
  };

  api._allDocs = function (opts, callback) {
    var results = [];
    var totalRows;

    var start = 'startkey' in opts ? opts.startkey : false;
    var end = 'endkey' in opts ? opts.endkey : false;
    var key = 'key' in opts ? opts.key : false;
    var descending = 'descending' in opts ? opts.descending : false;
    var limit = 'limit' in opts ? opts.limit : -1;
    var offset = 'skip' in opts ? opts.skip : 0;
    var inclusiveEnd = opts.inclusive_end !== false;

    var sqlArgs = [];
    var criteria = [];

    if (key !== false) {
      criteria.push(DOC_STORE$1 + '.id = ?');
      sqlArgs.push(key);
    } else if (start !== false || end !== false) {
      if (start !== false) {
        criteria.push(DOC_STORE$1 + '.id ' + (descending ? '<=' : '>=') + ' ?');
        sqlArgs.push(start);
      }
      if (end !== false) {
        var comparator = descending ? '>' : '<';
        if (inclusiveEnd) {
          comparator += '=';
        }
        criteria.push(DOC_STORE$1 + '.id ' + comparator + ' ?');
        sqlArgs.push(end);
      }
      if (key !== false) {
        criteria.push(DOC_STORE$1 + '.id = ?');
        sqlArgs.push(key);
      }
    }

    if (opts.deleted !== 'ok') {
      // report deleted if keys are specified
      criteria.push(BY_SEQ_STORE$1 + '.deleted = 0');
    }

    db.readTransaction(function (tx) {
      // count the docs in parallel to other operations
      countDocs(tx, function (docCount) {
        totalRows = docCount;
      });

      if (limit === 0) {
        return;
      }

      // do a single query to fetch the documents
      var sql = select(
        SELECT_DOCS,
        [DOC_STORE$1, BY_SEQ_STORE$1],
        DOC_STORE_AND_BY_SEQ_JOINER,
        criteria,
        DOC_STORE$1 + '.id ' + (descending ? 'DESC' : 'ASC')
        );
      sql += ' LIMIT ' + limit + ' OFFSET ' + offset;

      tx.executeSql(sql, sqlArgs, function (tx, result) {
        for (var i = 0, l = result.rows.length; i < l; i++) {
          var item = result.rows.item(i);
          var metadata = safeJsonParse(item.metadata);
          var id = metadata.id;
          var data = unstringifyDoc(item.data, id, item.rev);
          var winningRev$$1 = data._rev;
          var doc = {
            id: id,
            key: id,
            value: {rev: winningRev$$1}
          };
          if (opts.include_docs) {
            doc.doc = data;
            doc.doc._rev = winningRev$$1;
            if (opts.conflicts) {
              var conflicts = collectConflicts(metadata);
              if (conflicts.length) {
                doc.doc._conflicts = conflicts;
              }
            }
            fetchAttachmentsIfNecessary$1(doc.doc, opts, api, tx);
          }
          if (item.deleted) {
            if (opts.deleted === 'ok') {
              doc.value.deleted = true;
              doc.doc = null;
            } else {
              continue;
            }
          }
          results.push(doc);
        }
      });
    }, websqlError(callback), function () {
      callback(null, {
        total_rows: totalRows,
        offset: opts.skip,
        rows: results
      });
    });
  };

  api._changes = function (opts) {
    opts = clone(opts);

    if (opts.continuous) {
      var id = api._name + ':' + uuid();
      websqlChanges.addListener(api._name, id, api, opts);
      websqlChanges.notify(api._name);
      return {
        cancel: function () {
          websqlChanges.removeListener(api._name, id);
        }
      };
    }

    var descending = opts.descending;

    // Ignore the `since` parameter when `descending` is true
    opts.since = opts.since && !descending ? opts.since : 0;

    var limit = 'limit' in opts ? opts.limit : -1;
    if (limit === 0) {
      limit = 1; // per CouchDB _changes spec
    }

    var returnDocs;
    if ('return_docs' in opts) {
      returnDocs = opts.return_docs;
    } else if ('returnDocs' in opts) {
      // TODO: Remove 'returnDocs' in favor of 'return_docs' in a future release
      returnDocs = opts.returnDocs;
    } else {
      returnDocs = true;
    }
    var results = [];
    var numResults = 0;

    function fetchChanges() {

      var selectStmt =
        DOC_STORE$1 + '.json AS metadata, ' +
        DOC_STORE$1 + '.max_seq AS maxSeq, ' +
        BY_SEQ_STORE$1 + '.json AS winningDoc, ' +
        BY_SEQ_STORE$1 + '.rev AS winningRev ';

      var from = DOC_STORE$1 + ' JOIN ' + BY_SEQ_STORE$1;

      var joiner = DOC_STORE$1 + '.id=' + BY_SEQ_STORE$1 + '.doc_id' +
        ' AND ' + DOC_STORE$1 + '.winningseq=' + BY_SEQ_STORE$1 + '.seq';

      var criteria = ['maxSeq > ?'];
      var sqlArgs = [opts.since];

      if (opts.doc_ids) {
        criteria.push(DOC_STORE$1 + '.id IN ' + qMarks(opts.doc_ids.length));
        sqlArgs = sqlArgs.concat(opts.doc_ids);
      }

      var orderBy = 'maxSeq ' + (descending ? 'DESC' : 'ASC');

      var sql = select(selectStmt, from, joiner, criteria, orderBy);

      var filter = filterChange(opts);
      if (!opts.view && !opts.filter) {
        // we can just limit in the query
        sql += ' LIMIT ' + limit;
      }

      var lastSeq = opts.since || 0;
      db.readTransaction(function (tx) {
        tx.executeSql(sql, sqlArgs, function (tx, result) {
          function reportChange(change) {
            return function () {
              opts.onChange(change);
            };
          }
          for (var i = 0, l = result.rows.length; i < l; i++) {
            var item = result.rows.item(i);
            var metadata = safeJsonParse(item.metadata);
            lastSeq = item.maxSeq;

            var doc = unstringifyDoc(item.winningDoc, metadata.id,
              item.winningRev);
            var change = opts.processChange(doc, metadata, opts);
            change.seq = item.maxSeq;

            var filtered = filter(change);
            if (typeof filtered === 'object') {
              return opts.complete(filtered);
            }

            if (filtered) {
              numResults++;
              if (returnDocs) {
                results.push(change);
              }
              // process the attachment immediately
              // for the benefit of live listeners
              if (opts.attachments && opts.include_docs) {
                fetchAttachmentsIfNecessary$1(doc, opts, api, tx,
                  reportChange(change));
              } else {
                reportChange(change)();
              }
            }
            if (numResults === limit) {
              break;
            }
          }
        });
      }, websqlError(opts.complete), function () {
        if (!opts.continuous) {
          opts.complete(null, {
            results: results,
            last_seq: lastSeq
          });
        }
      });
    }

    fetchChanges();
  };

  api._close = function (callback) {
    //WebSQL databases do not need to be closed
    callback();
  };

  api._getAttachment = function (docId, attachId, attachment, opts, callback) {
    var res;
    var tx = opts.ctx;
    var digest = attachment.digest;
    var type = attachment.content_type;
    var sql = 'SELECT escaped, ' +
      'CASE WHEN escaped = 1 THEN body ELSE HEX(body) END AS body FROM ' +
      ATTACH_STORE$1 + ' WHERE digest=?';
    tx.executeSql(sql, [digest], function (tx, result) {
      // websql has a bug where \u0000 causes early truncation in strings
      // and blobs. to work around this, we used to use the hex() function,
      // but that's not performant. after migration 6, we remove \u0000
      // and add it back in afterwards
      var item = result.rows.item(0);
      var data = item.escaped ? unescapeBlob(item.body) :
        parseHexString(item.body, encoding);
      if (opts.binary) {
        res = binStringToBluffer(data, type);
      } else {
        res = thisBtoa(data);
      }
      callback(null, res);
    });
  };

  api._getRevisionTree = function (docId, callback) {
    db.readTransaction(function (tx) {
      var sql = 'SELECT json AS metadata FROM ' + DOC_STORE$1 + ' WHERE id = ?';
      tx.executeSql(sql, [docId], function (tx, result) {
        if (!result.rows.length) {
          callback(createError(MISSING_DOC));
        } else {
          var data = safeJsonParse(result.rows.item(0).metadata);
          callback(null, data.rev_tree);
        }
      });
    });
  };

  api._doCompaction = function (docId, revs, callback) {
    if (!revs.length) {
      return callback();
    }
    db.transaction(function (tx) {

      // update doc store
      var sql = 'SELECT json AS metadata FROM ' + DOC_STORE$1 + ' WHERE id = ?';
      tx.executeSql(sql, [docId], function (tx, result) {
        var metadata = safeJsonParse(result.rows.item(0).metadata);
        traverseRevTree(metadata.rev_tree, function (isLeaf, pos,
                                                           revHash, ctx, opts) {
          var rev$$1 = pos + '-' + revHash;
          if (revs.indexOf(rev$$1) !== -1) {
            opts.status = 'missing';
          }
        });

        var sql = 'UPDATE ' + DOC_STORE$1 + ' SET json = ? WHERE id = ?';
        tx.executeSql(sql, [safeJsonStringify(metadata), docId]);
      });

      compactRevs$1(revs, docId, tx);
    }, websqlError(callback), function () {
      callback();
    });
  };

  api._getLocal = function (id, callback) {
    db.readTransaction(function (tx) {
      var sql = 'SELECT json, rev FROM ' + LOCAL_STORE$1 + ' WHERE id=?';
      tx.executeSql(sql, [id], function (tx, res) {
        if (res.rows.length) {
          var item = res.rows.item(0);
          var doc = unstringifyDoc(item.json, id, item.rev);
          callback(null, doc);
        } else {
          callback(createError(MISSING_DOC));
        }
      });
    });
  };

  api._putLocal = function (doc, opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    delete doc._revisions; // ignore this, trust the rev
    var oldRev = doc._rev;
    var id = doc._id;
    var newRev;
    if (!oldRev) {
      newRev = doc._rev = '0-1';
    } else {
      newRev = doc._rev = '0-' + (parseInt(oldRev.split('-')[1], 10) + 1);
    }
    var json = stringifyDoc(doc);

    var ret;
    function putLocal(tx) {
      var sql;
      var values;
      if (oldRev) {
        sql = 'UPDATE ' + LOCAL_STORE$1 + ' SET rev=?, json=? ' +
          'WHERE id=? AND rev=?';
        values = [newRev, json, id, oldRev];
      } else {
        sql = 'INSERT INTO ' + LOCAL_STORE$1 + ' (id, rev, json) VALUES (?,?,?)';
        values = [id, newRev, json];
      }
      tx.executeSql(sql, values, function (tx, res) {
        if (res.rowsAffected) {
          ret = {ok: true, id: id, rev: newRev};
          if (opts.ctx) { // return immediately
            callback(null, ret);
          }
        } else {
          callback(createError(REV_CONFLICT));
        }
      }, function () {
        callback(createError(REV_CONFLICT));
        return false; // ack that we handled the error
      });
    }

    if (opts.ctx) {
      putLocal(opts.ctx);
    } else {
      db.transaction(putLocal, websqlError(callback), function () {
        if (ret) {
          callback(null, ret);
        }
      });
    }
  };

  api._removeLocal = function (doc, opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    var ret;

    function removeLocal(tx) {
      var sql = 'DELETE FROM ' + LOCAL_STORE$1 + ' WHERE id=? AND rev=?';
      var params = [doc._id, doc._rev];
      tx.executeSql(sql, params, function (tx, res) {
        if (!res.rowsAffected) {
          return callback(createError(MISSING_DOC));
        }
        ret = {ok: true, id: doc._id, rev: '0-0'};
        if (opts.ctx) { // return immediately
          callback(null, ret);
        }
      });
    }

    if (opts.ctx) {
      removeLocal(opts.ctx);
    } else {
      db.transaction(removeLocal, websqlError(callback), function () {
        if (ret) {
          callback(null, ret);
        }
      });
    }
  };

  api._destroy = function (opts, callback) {
    websqlChanges.removeAllListeners(api._name);
    db.transaction(function (tx) {
      var stores = [DOC_STORE$1, BY_SEQ_STORE$1, ATTACH_STORE$1, META_STORE$1,
        LOCAL_STORE$1, ATTACH_AND_SEQ_STORE$1];
      stores.forEach(function (store) {
        tx.executeSql('DROP TABLE IF EXISTS ' + store, []);
      });
    }, websqlError(callback), function () {
      if (hasLocalStorage()) {
        delete window.localStorage['_pouch__websqldb_' + api._name];
        delete window.localStorage[api._name];
      }
      callback(null, {'ok': true});
    });
  };
}

function canOpenTestDB() {
  try {
    openDatabase('_pouch_validate_websql', 1, '', 1);
    return true;
  } catch (err) {
    return false;
  }
}

// WKWebView had a bug where WebSQL would throw a DOM Exception 18
// (see https://bugs.webkit.org/show_bug.cgi?id=137760 and
// https://github.com/pouchdb/pouchdb/issues/5079)
// This has been fixed in latest WebKit, so we try to detect it here.
function isValidWebSQL() {
  // WKWebView UA:
  //   Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X)
  //   AppleWebKit/601.1.46 (KHTML, like Gecko) Mobile/13C75
  // Chrome for iOS UA:
  //   Mozilla/5.0 (iPhone; U; CPU iPhone OS 5_1_1 like Mac OS X; en)
  //   AppleWebKit/534.46.0 (KHTML, like Gecko) CriOS/19.0.1084.60
  //   Mobile/9B206 Safari/7534.48.3
  // Firefox for iOS UA:
  //   Mozilla/5.0 (iPhone; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4
  //   (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4

  // indexedDB is null on some UIWebViews and undefined in others
  // see: https://bugs.webkit.org/show_bug.cgi?id=137034
  if (typeof indexedDB === 'undefined' || indexedDB === null ||
      !/iP(hone|od|ad)/.test(navigator.userAgent)) {
    // definitely not WKWebView, avoid creating an unnecessary database
    return true;
  }
  // Cache the result in LocalStorage. Reason we do this is because if we
  // call openDatabase() too many times, Safari craps out in SauceLabs and
  // starts throwing DOM Exception 14s.
  var hasLS = hasLocalStorage();
  // Include user agent in the hash, so that if Safari is upgraded, we don't
  // continually think it's broken.
  var localStorageKey = '_pouch__websqldb_valid_' + navigator.userAgent;
  if (hasLS && localStorage[localStorageKey]) {
    return localStorage[localStorageKey] === '1';
  }
  var openedTestDB = canOpenTestDB();
  if (hasLS) {
    localStorage[localStorageKey] = openedTestDB ? '1' : '0';
  }
  return openedTestDB;
}

function valid() {
  if (typeof openDatabase !== 'function') {
    return false;
  }
  return isValidWebSQL();
}

function openDB(name, version, description, size) {
  // Traditional WebSQL API
  return openDatabase(name, version, description, size);
}

function WebSQLPouch(opts, callback) {
  var _opts = $inject_Object_assign({
    websql: openDB
  }, opts);

  WebSqlPouch$1.call(this, _opts, callback);
}

WebSQLPouch.valid = valid;

WebSQLPouch.use_prefix = true;

var WebSqlPouch = function (PouchDB) {
  PouchDB.adapter('websql', WebSQLPouch, true);
};

/* global fetch */
/* global Headers */
function wrappedFetch() {
  var wrappedPromise = {};

  var promise = new PouchPromise$1(function (resolve, reject) {
    wrappedPromise.resolve = resolve;
    wrappedPromise.reject = reject;
  });

  var args = new Array(arguments.length);

  for (var i = 0; i < args.length; i++) {
    args[i] = arguments[i];
  }

  wrappedPromise.promise = promise;

  PouchPromise$1.resolve().then(function () {
    return fetch.apply(null, args);
  }).then(function (response) {
    wrappedPromise.resolve(response);
  }).catch(function (error) {
    wrappedPromise.reject(error);
  });

  return wrappedPromise;
}

function fetchRequest(options, callback) {
  var wrappedPromise, timer, response;

  var headers = new Headers();

  var fetchOptions = {
    method: options.method,
    credentials: 'include',
    headers: headers
  };

  if (options.json) {
    headers.set('Accept', 'application/json');
    headers.set('Content-Type', options.headers['Content-Type'] ||
      'application/json');
  }

  if (options.body &&
      options.processData &&
      typeof options.body !== 'string') {
    fetchOptions.body = JSON.stringify(options.body);
  } else if ('body' in options) {
    fetchOptions.body = options.body;
  } else {
    fetchOptions.body = null;
  }

  Object.keys(options.headers).forEach(function (key) {
    if (options.headers.hasOwnProperty(key)) {
      headers.set(key, options.headers[key]);
    }
  });

  wrappedPromise = wrappedFetch(options.url, fetchOptions);

  if (options.timeout > 0) {
    timer = setTimeout(function () {
      wrappedPromise.reject(new Error('Load timeout for resource: ' +
        options.url));
    }, options.timeout);
  }

  wrappedPromise.promise.then(function (fetchResponse) {
    response = {
      statusCode: fetchResponse.status
    };

    if (options.timeout > 0) {
      clearTimeout(timer);
    }

    if (response.statusCode >= 200 && response.statusCode < 300) {
      return options.binary ? fetchResponse.blob() : fetchResponse.text();
    }

    return fetchResponse.json();
  }).then(function (result) {
    if (response.statusCode >= 200 && response.statusCode < 300) {
      callback(null, response, result);
    } else {
      result.status = response.statusCode;
      callback(result);
    }
  }).catch(function (error) {
    if (!error) {
      // this happens when the listener is canceled
      error = new Error('canceled');
    }
    callback(error);
  });

  return {abort: wrappedPromise.reject};
}

function xhRequest(options, callback) {

  var xhr, timer;
  var timedout = false;

  var abortReq = function () {
    xhr.abort();
    cleanUp();
  };

  var timeoutReq = function () {
    timedout = true;
    xhr.abort();
    cleanUp();
  };

  var ret = {abort: abortReq};

  var cleanUp = function () {
    clearTimeout(timer);
    ret.abort = function () {};
    if (xhr) {
      xhr.onprogress = undefined;
      if (xhr.upload) {
        xhr.upload.onprogress = undefined;
      }
      xhr.onreadystatechange = undefined;
      xhr = undefined;
    }
  };

  if (options.xhr) {
    xhr = new options.xhr();
  } else {
    xhr = new XMLHttpRequest();
  }

  try {
    xhr.open(options.method, options.url);
  } catch (exception) {
    return callback(new Error(exception.name || 'Url is invalid'));
  }

  xhr.withCredentials = ('withCredentials' in options) ?
    options.withCredentials : true;

  if (options.method === 'GET') {
    delete options.headers['Content-Type'];
  } else if (options.json) {
    options.headers.Accept = 'application/json';
    options.headers['Content-Type'] = options.headers['Content-Type'] ||
      'application/json';
    if (options.body &&
        options.processData &&
        typeof options.body !== "string") {
      options.body = JSON.stringify(options.body);
    }
  }

  if (options.binary) {
    xhr.responseType = 'arraybuffer';
  }

  if (!('body' in options)) {
    options.body = null;
  }

  for (var key in options.headers) {
    if (options.headers.hasOwnProperty(key)) {
      xhr.setRequestHeader(key, options.headers[key]);
    }
  }

  if (options.timeout > 0) {
    timer = setTimeout(timeoutReq, options.timeout);
    xhr.onprogress = function () {
      clearTimeout(timer);
      if (xhr.readyState !== 4) {
        timer = setTimeout(timeoutReq, options.timeout);
      }
    };
    if (typeof xhr.upload !== 'undefined') { // does not exist in ie9
      xhr.upload.onprogress = xhr.onprogress;
    }
  }

  xhr.onreadystatechange = function () {
    if (xhr.readyState !== 4) {
      return;
    }

    var response = {
      statusCode: xhr.status
    };

    if (xhr.status >= 200 && xhr.status < 300) {
      var data;
      if (options.binary) {
        data = createBlob([xhr.response || ''], {
          type: xhr.getResponseHeader('Content-Type')
        });
      } else {
        data = xhr.responseText;
      }
      callback(null, response, data);
    } else {
      var err = {};
      if (timedout) {
        err = new Error('ETIMEDOUT');
        err.code = 'ETIMEDOUT';
      } else if (typeof xhr.response === 'string') {
        try {
          err = JSON.parse(xhr.response);
        } catch (e) {}
      }
      err.status = xhr.status;
      callback(err);
    }
    cleanUp();
  };

  if (options.body && (options.body instanceof Blob)) {
    readAsArrayBuffer(options.body, function (arrayBuffer) {
      xhr.send(arrayBuffer);
    });
  } else {
    xhr.send(options.body);
  }

  return ret;
}

function testXhr() {
  try {
    new XMLHttpRequest();
    return true;
  } catch (err) {
    return false;
  }
}

var hasXhr = testXhr();

function ajax$1(options, callback) {
  if (!false && (hasXhr || options.xhr)) {
    return xhRequest(options, callback);
  } else {
    return fetchRequest(options, callback);
  }
}

// the blob already has a type; do nothing
var res$2 = function () {};

function defaultBody() {
  return '';
}

function ajaxCore$1(options, callback) {

  options = clone(options);

  var defaultOptions = {
    method : "GET",
    headers: {},
    json: true,
    processData: true,
    timeout: 10000,
    cache: false
  };

  options = $inject_Object_assign(defaultOptions, options);

  function onSuccess(obj, resp, cb) {
    if (!options.binary && options.json && typeof obj === 'string') {
      /* istanbul ignore next */
      try {
        obj = JSON.parse(obj);
      } catch (e) {
        // Probably a malformed JSON from server
        return cb(e);
      }
    }
    if (Array.isArray(obj)) {
      obj = obj.map(function (v) {
        if (v.error || v.missing) {
          return generateErrorFromResponse(v);
        } else {
          return v;
        }
      });
    }
    if (options.binary) {
      res$2(obj, resp);
    }
    cb(null, obj, resp);
  }

  if (options.json) {
    if (!options.binary) {
      options.headers.Accept = 'application/json';
    }
    options.headers['Content-Type'] = options.headers['Content-Type'] ||
      'application/json';
  }

  if (options.binary) {
    options.encoding = null;
    options.json = false;
  }

  if (!options.processData) {
    options.json = false;
  }

  return ajax$1(options, function (err, response, body) {

    if (err) {
      return callback(generateErrorFromResponse(err));
    }

    var error;
    var content_type = response.headers && response.headers['content-type'];
    var data = body || defaultBody();

    // CouchDB doesn't always return the right content-type for JSON data, so
    // we check for ^{ and }$ (ignoring leading/trailing whitespace)
    if (!options.binary && (options.json || !options.processData) &&
        typeof data !== 'object' &&
        (/json/.test(content_type) ||
         (/^[\s]*\{/.test(data) && /\}[\s]*$/.test(data)))) {
      try {
        data = JSON.parse(data.toString());
      } catch (e) {}
    }

    if (response.statusCode >= 200 && response.statusCode < 300) {
      onSuccess(data, response, callback);
    } else {
      error = generateErrorFromResponse(data);
      error.status = response.statusCode;
      callback(error);
    }
  });
}

function ajax(opts, callback) {

  // cache-buster, specifically designed to work around IE's aggressive caching
  // see http://www.dashbay.com/2011/05/internet-explorer-caches-ajax/
  // Also Safari caches POSTs, so we need to cache-bust those too.
  var ua = (navigator && navigator.userAgent) ?
    navigator.userAgent.toLowerCase() : '';

  var isSafari = ua.indexOf('safari') !== -1 && ua.indexOf('chrome') === -1;
  var isIE = ua.indexOf('msie') !== -1;
  var isEdge = ua.indexOf('edge') !== -1;

  // it appears the new version of safari also caches GETs,
  // see https://github.com/pouchdb/pouchdb/issues/5010
  var shouldCacheBust = (isSafari ||
    ((isIE || isEdge) && opts.method === 'GET'));

  var cache = 'cache' in opts ? opts.cache : true;

  var isBlobUrl = /^blob:/.test(opts.url); // don't append nonces for blob URLs

  if (!isBlobUrl && (shouldCacheBust || !cache)) {
    var hasArgs = opts.url.indexOf('?') !== -1;
    opts.url += (hasArgs ? '&' : '?') + '_nonce=' + Date.now();
  }

  return ajaxCore$1(opts, callback);
}

// dead simple promise pool, inspired by https://github.com/timdp/es6-promise-pool
// but much smaller in code size. limits the number of concurrent promises that are executed


function pool(promiseFactories, limit) {
  return new PouchPromise$1(function (resolve, reject) {
    var running = 0;
    var current = 0;
    var done = 0;
    var len = promiseFactories.length;
    var err;

    function runNext() {
      running++;
      promiseFactories[current++]().then(onSuccess, onError);
    }

    function doNext() {
      if (++done === len) {
        /* istanbul ignore if */
        if (err) {
          reject(err);
        } else {
          resolve();
        }
      } else {
        runNextBatch();
      }
    }

    function onSuccess() {
      running--;
      doNext();
    }

    /* istanbul ignore next */
    function onError(thisErr) {
      running--;
      err = err || thisErr;
      doNext();
    }

    function runNextBatch() {
      while (running < limit && current < len) {
        runNext();
      }
    }

    runNextBatch();
  });
}

var CHANGES_BATCH_SIZE = 25;
var MAX_SIMULTANEOUS_REVS = 50;
var CHANGES_TIMEOUT_BUFFER = 5000;
var DEFAULT_HEARTBEAT = 10000;

var supportsBulkGetMap = {};

function readAttachmentsAsBlobOrBuffer(row) {
  var atts = row.doc && row.doc._attachments;
  if (!atts) {
    return;
  }
  Object.keys(atts).forEach(function (filename) {
    var att = atts[filename];
    att.data = b64ToBluffer(att.data, att.content_type);
  });
}

function encodeDocId(id) {
  if (/^_design/.test(id)) {
    return '_design/' + encodeURIComponent(id.slice(8));
  }
  if (/^_local/.test(id)) {
    return '_local/' + encodeURIComponent(id.slice(7));
  }
  return encodeURIComponent(id);
}

function preprocessAttachments$2(doc) {
  if (!doc._attachments || !Object.keys(doc._attachments)) {
    return PouchPromise$1.resolve();
  }

  return PouchPromise$1.all(Object.keys(doc._attachments).map(function (key) {
    var attachment = doc._attachments[key];
    if (attachment.data && typeof attachment.data !== 'string') {
      return new PouchPromise$1(function (resolve) {
        blobToBase64(attachment.data, resolve);
      }).then(function (b64) {
        attachment.data = b64;
      });
    }
  }));
}

function hasUrlPrefix(opts) {
  if (!opts.prefix) {
    return false;
  }

  var protocol = parseUri(opts.prefix).protocol;

  return protocol === 'http' || protocol === 'https';
}

// Get all the information you possibly can about the URI given by name and
// return it as a suitable object.
function getHost(name, opts) {

  // encode db name if opts.prefix is a url (#5574)
  if (hasUrlPrefix(opts)) {
    var dbName = opts.name.substr(opts.prefix.length);
    name = opts.prefix + encodeURIComponent(dbName);
  }

  // Prase the URI into all its little bits
  var uri = parseUri(name);

  // Store the user and password as a separate auth object
  if (uri.user || uri.password) {
    uri.auth = {username: uri.user, password: uri.password};
  }

  // Split the path part of the URI into parts using '/' as the delimiter
  // after removing any leading '/' and any trailing '/'
  var parts = uri.path.replace(/(^\/|\/$)/g, '').split('/');

  // Store the first part as the database name and remove it from the parts
  // array
  uri.db = parts.pop();
  // Prevent double encoding of URI component
  if (uri.db.indexOf('%') === -1) {
    uri.db = encodeURIComponent(uri.db);
  }

  // Restore the path by joining all the remaining parts (all the parts
  // except for the database name) with '/'s
  uri.path = parts.join('/');

  return uri;
}

// Generate a URL with the host data given by opts and the given path
function genDBUrl(opts, path) {
  return genUrl(opts, opts.db + '/' + path);
}

// Generate a URL with the host data given by opts and the given path
function genUrl(opts, path) {
  // If the host already has a path, then we need to have a path delimiter
  // Otherwise, the path delimiter is the empty string
  var pathDel = !opts.path ? '' : '/';

  // If the host already has a path, then we need to have a path delimiter
  // Otherwise, the path delimiter is the empty string
  return opts.protocol + '://' + opts.host +
         (opts.port ? (':' + opts.port) : '') +
         '/' + opts.path + pathDel + path;
}

function paramsToStr(params) {
  return '?' + Object.keys(params).map(function (k) {
    return k + '=' + encodeURIComponent(params[k]);
  }).join('&');
}

// Implements the PouchDB API for dealing with CouchDB instances over HTTP
function HttpPouch(opts, callback) {

  // The functions that will be publicly available for HttpPouch
  var api = this;

  var host = getHost(opts.name, opts);
  var dbUrl = genDBUrl(host, '');

  opts = clone(opts);
  var ajaxOpts = opts.ajax || {};

  if (opts.auth || host.auth) {
    var nAuth = opts.auth || host.auth;
    var str = nAuth.username + ':' + nAuth.password;
    var token = thisBtoa(unescape(encodeURIComponent(str)));
    ajaxOpts.headers = ajaxOpts.headers || {};
    ajaxOpts.headers.Authorization = 'Basic ' + token;
  }

  // Not strictly necessary, but we do this because numerous tests
  // rely on swapping ajax in and out.
  api._ajax = ajax;

  function ajax$$1(userOpts, options, callback) {
    var reqAjax = userOpts.ajax || {};
    var reqOpts = $inject_Object_assign(clone(ajaxOpts), reqAjax, options);
    var defaultHeaders = clone(ajaxOpts.headers || {});
    reqOpts.headers = $inject_Object_assign(defaultHeaders, reqAjax.headers,
      options.headers || {});
    /* istanbul ignore if */
    if (api.constructor.listeners('debug').length) {
      api.constructor.emit('debug', ['http', reqOpts.method, reqOpts.url]);
    }
    return api._ajax(reqOpts, callback);
  }

  function ajaxPromise(userOpts, opts) {
    return new PouchPromise$1(function (resolve, reject) {
      ajax$$1(userOpts, opts, function (err, res) {
        /* istanbul ignore if */
        if (err) {
          return reject(err);
        }
        resolve(res);
      });
    });
  }

  function adapterFun$$1(name, fun) {
    return adapterFun(name, index$2(function (args) {
      setup().then(function () {
        return fun.apply(this, args);
      }).catch(function (e) {
        var callback = args.pop();
        callback(e);
      });
    }));
  }

  var setupPromise;

  function setup() {
    // TODO: Remove `skipSetup` in favor of `skip_setup` in a future release
    if (opts.skipSetup || opts.skip_setup) {
      return PouchPromise$1.resolve();
    }

    // If there is a setup in process or previous successful setup
    // done then we will use that
    // If previous setups have been rejected we will try again
    if (setupPromise) {
      return setupPromise;
    }

    var checkExists = {method: 'GET', url: dbUrl};
    setupPromise = ajaxPromise({}, checkExists).catch(function (err) {
      if (err && err.status && err.status === 404) {
        // Doesnt exist, create it
        explainError(404, 'PouchDB is just detecting if the remote exists.');
        return ajaxPromise({}, {method: 'PUT', url: dbUrl});
      } else {
        return PouchPromise$1.reject(err);
      }
    }).catch(function (err) {
      // If we try to create a database that already exists, skipped in
      // istanbul since its catching a race condition.
      /* istanbul ignore if */
      if (err && err.status && err.status === 412) {
        return true;
      }
      return PouchPromise$1.reject(err);
    });

    setupPromise.catch(function () {
      setupPromise = null;
    });

    return setupPromise;
  }

  browser$2(function () {
    callback(null, api);
  });

  api._remote = true;
  /* istanbul ignore next */
  api.type = function () {
    return 'http';
  };

  api.id = adapterFun$$1('id', function (callback) {
    ajax$$1({}, {method: 'GET', url: genUrl(host, '')}, function (err, result) {
      var uuid$$1 = (result && result.uuid) ?
        (result.uuid + host.db) : genDBUrl(host, '');
      callback(null, uuid$$1);
    });
  });

  api.request = adapterFun$$1('request', function (options, callback) {
    options.url = genDBUrl(host, options.url);
    ajax$$1({}, options, callback);
  });

  // Sends a POST request to the host calling the couchdb _compact function
  //    version: The version of CouchDB it is running
  api.compact = adapterFun$$1('compact', function (opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    opts = clone(opts);
    ajax$$1(opts, {
      url: genDBUrl(host, '_compact'),
      method: 'POST'
    }, function () {
      function ping() {
        api.info(function (err, res) {
          // CouchDB may send a "compact_running:true" if it's
          // already compacting. PouchDB Server doesn't.
          /* istanbul ignore else */
          if (res && !res.compact_running) {
            callback(null, {ok: true});
          } else {
            setTimeout(ping, opts.interval || 200);
          }
        });
      }
      // Ping the http if it's finished compaction
      ping();
    });
  });

  api.bulkGet = adapterFun('bulkGet', function (opts, callback) {
    var self = this;

    function doBulkGet(cb) {
      var params = {};
      if (opts.revs) {
        params.revs = true;
      }
      if (opts.attachments) {
        /* istanbul ignore next */
        params.attachments = true;
      }
      if (opts.latest) {
        params.latest = true;
      }
      ajax$$1(opts, {
        url: genDBUrl(host, '_bulk_get' + paramsToStr(params)),
        method: 'POST',
        body: { docs: opts.docs}
      }, cb);
    }

    /* istanbul ignore next */
    function doBulkGetShim() {
      // avoid "url too long error" by splitting up into multiple requests
      var batchSize = MAX_SIMULTANEOUS_REVS;
      var numBatches = Math.ceil(opts.docs.length / batchSize);
      var numDone = 0;
      var results = new Array(numBatches);

      function onResult(batchNum) {
        return function (err, res) {
          // err is impossible because shim returns a list of errs in that case
          results[batchNum] = res.results;
          if (++numDone === numBatches) {
            callback(null, {results: flatten(results)});
          }
        };
      }

      for (var i = 0; i < numBatches; i++) {
        var subOpts = pick(opts, ['revs', 'attachments', 'latest']);
        subOpts.ajax = ajaxOpts;
        subOpts.docs = opts.docs.slice(i * batchSize,
          Math.min(opts.docs.length, (i + 1) * batchSize));
        bulkGet(self, subOpts, onResult(i));
      }
    }

    // mark the whole database as either supporting or not supporting _bulk_get
    var dbUrl = genUrl(host, '');
    var supportsBulkGet = supportsBulkGetMap[dbUrl];

    /* istanbul ignore next */
    if (typeof supportsBulkGet !== 'boolean') {
      // check if this database supports _bulk_get
      doBulkGet(function (err, res) {
        if (err) {
          supportsBulkGetMap[dbUrl] = false;
          explainError(
            err.status,
            'PouchDB is just detecting if the remote ' +
            'supports the _bulk_get API.'
          );
          doBulkGetShim();
        } else {
          supportsBulkGetMap[dbUrl] = true;
          callback(null, res);
        }
      });
    } else if (supportsBulkGet) {
      doBulkGet(callback);
    } else {
      doBulkGetShim();
    }
  });

  // Calls GET on the host, which gets back a JSON string containing
  //    couchdb: A welcome string
  //    version: The version of CouchDB it is running
  api._info = function (callback) {
    setup().then(function () {
      ajax$$1({}, {
        method: 'GET',
        url: genDBUrl(host, '')
      }, function (err, res) {
        /* istanbul ignore next */
        if (err) {
        return callback(err);
        }
        res.host = genDBUrl(host, '');
        callback(null, res);
      });
    }).catch(callback);
  };

  // Get the document with the given id from the database given by host.
  // The id could be solely the _id in the database, or it may be a
  // _design/ID or _local/ID path
  api.get = adapterFun$$1('get', function (id, opts, callback) {
    // If no options were given, set the callback to the second parameter
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    opts = clone(opts);

    // List of parameters to add to the GET request
    var params = {};

    if (opts.revs) {
      params.revs = true;
    }

    if (opts.revs_info) {
      params.revs_info = true;
    }

    if (opts.latest) {
      params.latest = true;
    }

    if (opts.open_revs) {
      if (opts.open_revs !== "all") {
        opts.open_revs = JSON.stringify(opts.open_revs);
      }
      params.open_revs = opts.open_revs;
    }

    if (opts.rev) {
      params.rev = opts.rev;
    }

    if (opts.conflicts) {
      params.conflicts = opts.conflicts;
    }

    id = encodeDocId(id);

    // Set the options for the ajax call
    var options = {
      method: 'GET',
      url: genDBUrl(host, id + paramsToStr(params))
    };

    function fetchAttachments(doc) {
      var atts = doc._attachments;
      var filenames = atts && Object.keys(atts);
      if (!atts || !filenames.length) {
        return;
      }
      // we fetch these manually in separate XHRs, because
      // Sync Gateway would normally send it back as multipart/mixed,
      // which we cannot parse. Also, this is more efficient than
      // receiving attachments as base64-encoded strings.
      function fetch(filename) {
        var att = atts[filename];
        var path = encodeDocId(doc._id) + '/' + encodeAttachmentId(filename) +
          '?rev=' + doc._rev;
        return ajaxPromise(opts, {
          method: 'GET',
          url: genDBUrl(host, path),
          binary: true
        }).then(function (blob) {
          if (opts.binary) {
            return blob;
          }
          return new PouchPromise$1(function (resolve) {
            blobToBase64(blob, resolve);
          });
        }).then(function (data) {
          delete att.stub;
          delete att.length;
          att.data = data;
        });
      }

      var promiseFactories = filenames.map(function (filename) {
        return function () {
          return fetch(filename);
        };
      });

      // This limits the number of parallel xhr requests to 5 any time
      // to avoid issues with maximum browser request limits
      return pool(promiseFactories, 5);
    }

    function fetchAllAttachments(docOrDocs) {
      if (Array.isArray(docOrDocs)) {
        return PouchPromise$1.all(docOrDocs.map(function (doc) {
          if (doc.ok) {
            return fetchAttachments(doc.ok);
          }
        }));
      }
      return fetchAttachments(docOrDocs);
    }

    ajaxPromise(opts, options).then(function (res) {
      return PouchPromise$1.resolve().then(function () {
        if (opts.attachments) {
          return fetchAllAttachments(res);
        }
      }).then(function () {
        callback(null, res);
      });
    }).catch(function (e) {
      e.docId = id;
      callback(e);
    });
  });

  // Delete the document given by doc from the database given by host.
  api.remove = adapterFun$$1('remove',
      function (docOrId, optsOrRev, opts, callback) {
    var doc;
    if (typeof optsOrRev === 'string') {
      // id, rev, opts, callback style
      doc = {
        _id: docOrId,
        _rev: optsOrRev
      };
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
    } else {
      // doc, opts, callback style
      doc = docOrId;
      if (typeof optsOrRev === 'function') {
        callback = optsOrRev;
        opts = {};
      } else {
        callback = opts;
        opts = optsOrRev;
      }
    }

    var rev$$1 = (doc._rev || opts.rev);

    // Delete the document
    ajax$$1(opts, {
      method: 'DELETE',
      url: genDBUrl(host, encodeDocId(doc._id)) + '?rev=' + rev$$1
    }, callback);
  });

  function encodeAttachmentId(attachmentId) {
    return attachmentId.split("/").map(encodeURIComponent).join("/");
  }

  // Get the attachment
  api.getAttachment =
    adapterFun$$1('getAttachment', function (docId, attachmentId, opts,
                                                callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    var params = opts.rev ? ('?rev=' + opts.rev) : '';
    var url = genDBUrl(host, encodeDocId(docId)) + '/' +
      encodeAttachmentId(attachmentId) + params;
    ajax$$1(opts, {
      method: 'GET',
      url: url,
      binary: true
    }, callback);
  });

  // Remove the attachment given by the id and rev
  api.removeAttachment =
    adapterFun$$1('removeAttachment', function (docId, attachmentId, rev$$1,
                                                   callback) {

    var url = genDBUrl(host, encodeDocId(docId) + '/' +
      encodeAttachmentId(attachmentId)) + '?rev=' + rev$$1;

    ajax$$1({}, {
      method: 'DELETE',
      url: url
    }, callback);
  });

  // Add the attachment given by blob and its contentType property
  // to the document with the given id, the revision given by rev, and
  // add it to the database given by host.
  api.putAttachment =
    adapterFun$$1('putAttachment', function (docId, attachmentId, rev$$1, blob,
                                                type, callback) {
    if (typeof type === 'function') {
      callback = type;
      type = blob;
      blob = rev$$1;
      rev$$1 = null;
    }
    var id = encodeDocId(docId) + '/' + encodeAttachmentId(attachmentId);
    var url = genDBUrl(host, id);
    if (rev$$1) {
      url += '?rev=' + rev$$1;
    }

    if (typeof blob === 'string') {
      // input is assumed to be a base64 string
      var binary;
      try {
        binary = thisAtob(blob);
      } catch (err) {
        return callback(createError(BAD_ARG,
                        'Attachment is not a valid base64 string'));
      }
      blob = binary ? binStringToBluffer(binary, type) : '';
    }

    var opts = {
      headers: {'Content-Type': type},
      method: 'PUT',
      url: url,
      processData: false,
      body: blob,
      timeout: ajaxOpts.timeout || 60000
    };
    // Add the attachment
    ajax$$1({}, opts, callback);
  });

  // Update/create multiple documents given by req in the database
  // given by host.
  api._bulkDocs = function (req, opts, callback) {
    // If new_edits=false then it prevents the database from creating
    // new revision numbers for the documents. Instead it just uses
    // the old ones. This is used in database replication.
    req.new_edits = opts.new_edits;

    setup().then(function () {
      return PouchPromise$1.all(req.docs.map(preprocessAttachments$2));
    }).then(function () {
      // Update/create the documents
      ajax$$1(opts, {
        method: 'POST',
        url: genDBUrl(host, '_bulk_docs'),
        timeout: opts.timeout,
        body: req
      }, function (err, results) {
        if (err) {
          return callback(err);
        }
        results.forEach(function (result) {
          result.ok = true; // smooths out cloudant not adding this
        });
        callback(null, results);
      });
    }).catch(callback);
  };


  // Update/create document
  api._put = function (doc, opts, callback) {
    setup().then(function () {
      return preprocessAttachments$2(doc);
    }).then(function () {
      // Update/create the document
      ajax$$1(opts, {
        method: 'PUT',
        url: genDBUrl(host, encodeDocId(doc._id)),
        body: doc
      }, function (err, result) {
        if (err) {
          err.docId = doc && doc._id;
          return callback(err);
        }
        callback(null, result);
      });
    }).catch(callback);
  };


  // Get a listing of the documents in the database given
  // by host and ordered by increasing id.
  api.allDocs = adapterFun$$1('allDocs', function (opts, callback) {
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    opts = clone(opts);

    // List of parameters to add to the GET request
    var params = {};
    var body;
    var method = 'GET';

    if (opts.conflicts) {
      params.conflicts = true;
    }

    if (opts.descending) {
      params.descending = true;
    }

    if (opts.include_docs) {
      params.include_docs = true;
    }

    // added in CouchDB 1.6.0
    if (opts.attachments) {
      params.attachments = true;
    }

    if (opts.key) {
      params.key = JSON.stringify(opts.key);
    }

    if (opts.start_key) {
      opts.startkey = opts.start_key;
    }

    if (opts.startkey) {
      params.startkey = JSON.stringify(opts.startkey);
    }

    if (opts.end_key) {
      opts.endkey = opts.end_key;
    }

    if (opts.endkey) {
      params.endkey = JSON.stringify(opts.endkey);
    }

    if (typeof opts.inclusive_end !== 'undefined') {
      params.inclusive_end = !!opts.inclusive_end;
    }

    if (typeof opts.limit !== 'undefined') {
      params.limit = opts.limit;
    }

    if (typeof opts.skip !== 'undefined') {
      params.skip = opts.skip;
    }

    var paramStr = paramsToStr(params);

    if (typeof opts.keys !== 'undefined') {
      method = 'POST';
      body = {keys: opts.keys};
    }

    // Get the document listing
    ajaxPromise(opts, {
      method: method,
      url: genDBUrl(host, '_all_docs' + paramStr),
      body: body
    }).then(function (res) {
      if (opts.include_docs && opts.attachments && opts.binary) {
        res.rows.forEach(readAttachmentsAsBlobOrBuffer);
      }
      callback(null, res);
    }).catch(callback);
  });

  // Get a list of changes made to documents in the database given by host.
  // TODO According to the README, there should be two other methods here,
  // api.changes.addListener and api.changes.removeListener.
  api._changes = function (opts) {

    // We internally page the results of a changes request, this means
    // if there is a large set of changes to be returned we can start
    // processing them quicker instead of waiting on the entire
    // set of changes to return and attempting to process them at once
    var batchSize = 'batch_size' in opts ? opts.batch_size : CHANGES_BATCH_SIZE;

    opts = clone(opts);

    if (opts.continuous && !('heartbeat' in opts)) {
      opts.heartbeat = DEFAULT_HEARTBEAT;
    }

    var requestTimeout = ('timeout' in opts) ? opts.timeout :
      ('timeout' in ajaxOpts) ? ajaxOpts.timeout :
      30 * 1000;

    // ensure CHANGES_TIMEOUT_BUFFER applies
    if ('timeout' in opts && opts.timeout &&
      (requestTimeout - opts.timeout) < CHANGES_TIMEOUT_BUFFER) {
        requestTimeout = opts.timeout + CHANGES_TIMEOUT_BUFFER;
    }

    if ('heartbeat' in opts && opts.heartbeat &&
       (requestTimeout - opts.heartbeat) < CHANGES_TIMEOUT_BUFFER) {
        requestTimeout = opts.heartbeat + CHANGES_TIMEOUT_BUFFER;
    }

    var params = {};
    if ('timeout' in opts && opts.timeout) {
      params.timeout = opts.timeout;
    }

    var limit = (typeof opts.limit !== 'undefined') ? opts.limit : false;
    var returnDocs;
    if ('return_docs' in opts) {
      returnDocs = opts.return_docs;
    } else if ('returnDocs' in opts) {
      // TODO: Remove 'returnDocs' in favor of 'return_docs' in a future release
      returnDocs = opts.returnDocs;
    } else {
      returnDocs = true;
    }
    //
    var leftToFetch = limit;

    if (opts.style) {
      params.style = opts.style;
    }

    if (opts.include_docs || opts.filter && typeof opts.filter === 'function') {
      params.include_docs = true;
    }

    if (opts.attachments) {
      params.attachments = true;
    }

    if (opts.continuous) {
      params.feed = 'longpoll';
    }

    if (opts.conflicts) {
      params.conflicts = true;
    }

    if (opts.descending) {
      params.descending = true;
    }

    if ('heartbeat' in opts) {
      // If the heartbeat value is false, it disables the default heartbeat
      if (opts.heartbeat) {
        params.heartbeat = opts.heartbeat;
      }
    }

    if (opts.filter && typeof opts.filter === 'string') {
      params.filter = opts.filter;
    }

    if (opts.view && typeof opts.view === 'string') {
      params.filter = '_view';
      params.view = opts.view;
    }

    // If opts.query_params exists, pass it through to the changes request.
    // These parameters may be used by the filter on the source database.
    if (opts.query_params && typeof opts.query_params === 'object') {
      for (var param_name in opts.query_params) {
        /* istanbul ignore else */
        if (opts.query_params.hasOwnProperty(param_name)) {
          params[param_name] = opts.query_params[param_name];
        }
      }
    }

    var method = 'GET';
    var body;

    if (opts.doc_ids) {
      // set this automagically for the user; it's annoying that couchdb
      // requires both a "filter" and a "doc_ids" param.
      params.filter = '_doc_ids';
      method = 'POST';
      body = {doc_ids: opts.doc_ids };
    }
    /* istanbul ignore next */
    else if (opts.selector) {
      // set this automagically for the user, similar to above
      params.filter = '_selector';
      method = 'POST';
      body = {selector: opts.selector };
    }

    var xhr;
    var lastFetchedSeq;

    // Get all the changes starting wtih the one immediately after the
    // sequence number given by since.
    var fetch = function (since, callback) {
      if (opts.aborted) {
        return;
      }
      params.since = since;
      // "since" can be any kind of json object in Coudant/CouchDB 2.x
      /* istanbul ignore next */
      if (typeof params.since === "object") {
        params.since = JSON.stringify(params.since);
      }

      if (opts.descending) {
        if (limit) {
          params.limit = leftToFetch;
        }
      } else {
        params.limit = (!limit || leftToFetch > batchSize) ?
          batchSize : leftToFetch;
      }

      // Set the options for the ajax call
      var xhrOpts = {
        method: method,
        url: genDBUrl(host, '_changes' + paramsToStr(params)),
        timeout: requestTimeout,
        body: body
      };
      lastFetchedSeq = since;

      /* istanbul ignore if */
      if (opts.aborted) {
        return;
      }

      // Get the changes
      setup().then(function () {
        xhr = ajax$$1(opts, xhrOpts, callback);
      }).catch(callback);
    };

    // If opts.since exists, get all the changes from the sequence
    // number given by opts.since. Otherwise, get all the changes
    // from the sequence number 0.
    var results = {results: []};

    var fetched = function (err, res) {
      if (opts.aborted) {
        return;
      }
      var raw_results_length = 0;
      // If the result of the ajax call (res) contains changes (res.results)
      if (res && res.results) {
        raw_results_length = res.results.length;
        results.last_seq = res.last_seq;
        // For each change
        var req = {};
        req.query = opts.query_params;
        res.results = res.results.filter(function (c) {
          leftToFetch--;
          var ret = filterChange(opts)(c);
          if (ret) {
            if (opts.include_docs && opts.attachments && opts.binary) {
              readAttachmentsAsBlobOrBuffer(c);
            }
            if (returnDocs) {
              results.results.push(c);
            }
            opts.onChange(c);
          }
          return ret;
        });
      } else if (err) {
        // In case of an error, stop listening for changes and call
        // opts.complete
        opts.aborted = true;
        opts.complete(err);
        return;
      }

      // The changes feed may have timed out with no results
      // if so reuse last update sequence
      if (res && res.last_seq) {
        lastFetchedSeq = res.last_seq;
      }

      var finished = (limit && leftToFetch <= 0) ||
        (res && raw_results_length < batchSize) ||
        (opts.descending);

      if ((opts.continuous && !(limit && leftToFetch <= 0)) || !finished) {
        // Queue a call to fetch again with the newest sequence number
        browser$2(function () { fetch(lastFetchedSeq, fetched); });
      } else {
        // We're done, call the callback
        opts.complete(null, results);
      }
    };

    fetch(opts.since || 0, fetched);

    // Return a method to cancel this method from processing any more
    return {
      cancel: function () {
        opts.aborted = true;
        if (xhr) {
          xhr.abort();
        }
      }
    };
  };

  // Given a set of document/revision IDs (given by req), tets the subset of
  // those that do NOT correspond to revisions stored in the database.
  // See http://wiki.apache.org/couchdb/HttpPostRevsDiff
  api.revsDiff = adapterFun$$1('revsDiff', function (req, opts, callback) {
    // If no options were given, set the callback to be the second parameter
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }

    // Get the missing document/revision IDs
    ajax$$1(opts, {
      method: 'POST',
      url: genDBUrl(host, '_revs_diff'),
      body: req
    }, callback);
  });

  api._close = function (callback) {
    callback();
  };

  api._destroy = function (options, callback) {
    ajax$$1(options, {
      url: genDBUrl(host, ''),
      method: 'DELETE'
    }, function (err, resp) {
      if (err && err.status && err.status !== 404) {
        return callback(err);
      }
      callback(null, resp);
    });
  };
}

// HttpPouch is a valid adapter.
HttpPouch.valid = function () {
  return true;
};

var HttpPouch$1 = function (PouchDB) {
  PouchDB.adapter('http', HttpPouch, false);
  PouchDB.adapter('https', HttpPouch, false);
};

function QueryParseError(message) {
  this.status = 400;
  this.name = 'query_parse_error';
  this.message = message;
  this.error = true;
  try {
    Error.captureStackTrace(this, QueryParseError);
  } catch (e) {}
}

inherits_browser$1(QueryParseError, Error);

function NotFoundError(message) {
  this.status = 404;
  this.name = 'not_found';
  this.message = message;
  this.error = true;
  try {
    Error.captureStackTrace(this, NotFoundError);
  } catch (e) {}
}

inherits_browser$1(NotFoundError, Error);

function BuiltInError(message) {
  this.status = 500;
  this.name = 'invalid_value';
  this.message = message;
  this.error = true;
  try {
    Error.captureStackTrace(this, BuiltInError);
  } catch (e) {}
}

inherits_browser$1(BuiltInError, Error);

function promisedCallback(promise, callback) {
  if (callback) {
    promise.then(function (res) {
      browser$2(function () {
        callback(null, res);
      });
    }, function (reason) {
      browser$2(function () {
        callback(reason);
      });
    });
  }
  return promise;
}

function callbackify(fun) {
  return index$2(function (args) {
    var cb = args.pop();
    var promise = fun.apply(this, args);
    if (typeof cb === 'function') {
      promisedCallback(promise, cb);
    }
    return promise;
  });
}

// Promise finally util similar to Q.finally
function fin(promise, finalPromiseFactory) {
  return promise.then(function (res) {
    return finalPromiseFactory().then(function () {
      return res;
    });
  }, function (reason) {
    return finalPromiseFactory().then(function () {
      throw reason;
    });
  });
}

function sequentialize(queue, promiseFactory) {
  return function () {
    var args = arguments;
    var that = this;
    return queue.add(function () {
      return promiseFactory.apply(that, args);
    });
  };
}

// uniq an array of strings, order not guaranteed
// similar to underscore/lodash _.uniq
function uniq(arr) {
  var theSet = new ExportedSet(arr);
  var result = new Array(theSet.size);
  var index = -1;
  theSet.forEach(function (value) {
    result[++index] = value;
  });
  return result;
}

function mapToKeysArray(map) {
  var result = new Array(map.size);
  var index = -1;
  map.forEach(function (value, key) {
    result[++index] = key;
  });
  return result;
}

function createBuiltInError(name) {
  var message = 'builtin ' + name +
    ' function requires map values to be numbers' +
    ' or number arrays';
  return new BuiltInError(message);
}

function sum(values) {
  var result = 0;
  for (var i = 0, len = values.length; i < len; i++) {
    var num = values[i];
    if (typeof num !== 'number') {
      if (Array.isArray(num)) {
        // lists of numbers are also allowed, sum them separately
        result = typeof result === 'number' ? [result] : result;
        for (var j = 0, jLen = num.length; j < jLen; j++) {
          var jNum = num[j];
          if (typeof jNum !== 'number') {
            throw createBuiltInError('_sum');
          } else if (typeof result[j] === 'undefined') {
            result.push(jNum);
          } else {
            result[j] += jNum;
          }
        }
      } else { // not array/number
        throw createBuiltInError('_sum');
      }
    } else if (typeof result === 'number') {
      result += num;
    } else { // add number to array
      result[0] += num;
    }
  }
  return result;
}

var log = guardedConsole.bind(null, 'log');
var isArray = Array.isArray;
var toJSON = JSON.parse;

function evalFunctionWithEval(func, emit) {
  return scopeEval(
    "return (" + func.replace(/;\s*$/, "") + ");",
    {
      emit: emit,
      sum: sum,
      log: log,
      isArray: isArray,
      toJSON: toJSON
    }
  );
}

/*
 * Simple task queue to sequentialize actions. Assumes
 * callbacks will eventually fire (once).
 */


function TaskQueue$2() {
  this.promise = new PouchPromise$1(function (fulfill) {fulfill(); });
}
TaskQueue$2.prototype.add = function (promiseFactory) {
  this.promise = this.promise.catch(function () {
    // just recover
  }).then(function () {
    return promiseFactory();
  });
  return this.promise;
};
TaskQueue$2.prototype.finish = function () {
  return this.promise;
};

function stringify(input) {
  if (!input) {
    return 'undefined'; // backwards compat for empty reduce
  }
  // for backwards compat with mapreduce, functions/strings are stringified
  // as-is. everything else is JSON-stringified.
  switch (typeof input) {
    case 'function':
      // e.g. a mapreduce map
      return input.toString();
    case 'string':
      // e.g. a mapreduce built-in _reduce function
      return input.toString();
    default:
      // e.g. a JSON object in the case of mango queries
      return JSON.stringify(input);
  }
}

/* create a string signature for a view so we can cache it and uniq it */
function createViewSignature(mapFun, reduceFun) {
  // the "undefined" part is for backwards compatibility
  return stringify(mapFun) + stringify(reduceFun) + 'undefined';
}

function createView(sourceDB, viewName, mapFun, reduceFun, temporary, localDocName) {
  var viewSignature = createViewSignature(mapFun, reduceFun);

  var cachedViews;
  if (!temporary) {
    // cache this to ensure we don't try to update the same view twice
    cachedViews = sourceDB._cachedViews = sourceDB._cachedViews || {};
    if (cachedViews[viewSignature]) {
      return cachedViews[viewSignature];
    }
  }

  var promiseForView = sourceDB.info().then(function (info) {

    var depDbName = info.db_name + '-mrview-' +
      (temporary ? 'temp' : stringMd5(viewSignature));

    // save the view name in the source db so it can be cleaned up if necessary
    // (e.g. when the _design doc is deleted, remove all associated view data)
    function diffFunction(doc) {
      doc.views = doc.views || {};
      var fullViewName = viewName;
      if (fullViewName.indexOf('/') === -1) {
        fullViewName = viewName + '/' + viewName;
      }
      var depDbs = doc.views[fullViewName] = doc.views[fullViewName] || {};
      /* istanbul ignore if */
      if (depDbs[depDbName]) {
        return; // no update necessary
      }
      depDbs[depDbName] = true;
      return doc;
    }
    return upsert(sourceDB, '_local/' + localDocName, diffFunction).then(function () {
      return sourceDB.registerDependentDatabase(depDbName).then(function (res) {
        var db = res.db;
        db.auto_compaction = true;
        var view = {
          name: depDbName,
          db: db,
          sourceDB: sourceDB,
          adapter: sourceDB.adapter,
          mapFun: mapFun,
          reduceFun: reduceFun
        };
        return view.db.get('_local/lastSeq').catch(function (err) {
          /* istanbul ignore if */
          if (err.status !== 404) {
            throw err;
          }
        }).then(function (lastSeqDoc) {
          view.seq = lastSeqDoc ? lastSeqDoc.seq : 0;
          if (cachedViews) {
            view.db.once('destroyed', function () {
              delete cachedViews[viewSignature];
            });
          }
          return view;
        });
      });
    });
  });

  if (cachedViews) {
    cachedViews[viewSignature] = promiseForView;
  }
  return promiseForView;
}

var persistentQueues = {};
var tempViewQueue = new TaskQueue$2();
var CHANGES_BATCH_SIZE$1 = 50;

function parseViewName(name) {
  // can be either 'ddocname/viewname' or just 'viewname'
  // (where the ddoc name is the same)
  return name.indexOf('/') === -1 ? [name, name] : name.split('/');
}

function isGenOne(changes) {
  // only return true if the current change is 1-
  // and there are no other leafs
  return changes.length === 1 && /^1-/.test(changes[0].rev);
}

function emitError(db, e) {
  try {
    db.emit('error', e);
  } catch (err) {
    guardedConsole('error',
      'The user\'s map/reduce function threw an uncaught error.\n' +
      'You can debug this error by doing:\n' +
      'myDatabase.on(\'error\', function (err) { debugger; });\n' +
      'Please double-check your map/reduce function.');
    guardedConsole('error', e);
  }
}

/**
 * Returns an "abstract" mapreduce object of the form:
 *
 *   {
 *     query: queryFun,
 *     viewCleanup: viewCleanupFun
 *   }
 *
 * Arguments are:
 *
 * localDoc: string
 *   This is for the local doc that gets saved in order to track the
 *   "dependent" DBs and clean them up for viewCleanup. It should be
 *   unique, so that indexer plugins don't collide with each other.
 * mapper: function (mapFunDef, emit)
 *   Returns a map function based on the mapFunDef, which in the case of
 *   normal map/reduce is just the de-stringified function, but may be
 *   something else, such as an object in the case of pouchdb-find.
 * reducer: function (reduceFunDef)
 *   Ditto, but for reducing. Modules don't have to support reducing
 *   (e.g. pouchdb-find).
 * ddocValidator: function (ddoc, viewName)
 *   Throws an error if the ddoc or viewName is not valid.
 *   This could be a way to communicate to the user that the configuration for the
 *   indexer is invalid.
 */
function createAbstractMapReduce(localDocName, mapper, reducer, ddocValidator) {

  function tryMap(db, fun, doc) {
    // emit an event if there was an error thrown by a map function.
    // putting try/catches in a single function also avoids deoptimizations.
    try {
      fun(doc);
    } catch (e) {
      emitError(db, e);
    }
  }

  function tryReduce(db, fun, keys, values, rereduce) {
    // same as above, but returning the result or an error. there are two separate
    // functions to avoid extra memory allocations since the tryCode() case is used
    // for custom map functions (common) vs this function, which is only used for
    // custom reduce functions (rare)
    try {
      return {output : fun(keys, values, rereduce)};
    } catch (e) {
      emitError(db, e);
      return {error: e};
    }
  }

  function sortByKeyThenValue(x, y) {
    var keyCompare = collate(x.key, y.key);
    return keyCompare !== 0 ? keyCompare : collate(x.value, y.value);
  }

  function sliceResults(results, limit, skip) {
    skip = skip || 0;
    if (typeof limit === 'number') {
      return results.slice(skip, limit + skip);
    } else if (skip > 0) {
      return results.slice(skip);
    }
    return results;
  }

  function rowToDocId(row) {
    var val = row.value;
    // Users can explicitly specify a joined doc _id, or it
    // defaults to the doc _id that emitted the key/value.
    var docId = (val && typeof val === 'object' && val._id) || row.id;
    return docId;
  }

  function readAttachmentsAsBlobOrBuffer(res) {
    res.rows.forEach(function (row) {
      var atts = row.doc && row.doc._attachments;
      if (!atts) {
        return;
      }
      Object.keys(atts).forEach(function (filename) {
        var att = atts[filename];
        atts[filename].data = b64ToBluffer(att.data, att.content_type);
      });
    });
  }

  function postprocessAttachments(opts) {
    return function (res) {
      if (opts.include_docs && opts.attachments && opts.binary) {
        readAttachmentsAsBlobOrBuffer(res);
      }
      return res;
    };
  }

  function addHttpParam(paramName, opts, params, asJson) {
    // add an http param from opts to params, optionally json-encoded
    var val = opts[paramName];
    if (typeof val !== 'undefined') {
      if (asJson) {
        val = encodeURIComponent(JSON.stringify(val));
      }
      params.push(paramName + '=' + val);
    }
  }

  function coerceInteger(integerCandidate) {
    if (typeof integerCandidate !== 'undefined') {
      var asNumber = Number(integerCandidate);
      // prevents e.g. '1foo' or '1.1' being coerced to 1
      if (!isNaN(asNumber) && asNumber === parseInt(integerCandidate, 10)) {
        return asNumber;
      } else {
        return integerCandidate;
      }
    }
  }

  function coerceOptions(opts) {
    opts.group_level = coerceInteger(opts.group_level);
    opts.limit = coerceInteger(opts.limit);
    opts.skip = coerceInteger(opts.skip);
    return opts;
  }

  function checkPositiveInteger(number) {
    if (number) {
      if (typeof number !== 'number') {
        return  new QueryParseError('Invalid value for integer: "' +
          number + '"');
      }
      if (number < 0) {
        return new QueryParseError('Invalid value for positive integer: ' +
          '"' + number + '"');
      }
    }
  }

  function checkQueryParseError(options, fun) {
    var startkeyName = options.descending ? 'endkey' : 'startkey';
    var endkeyName = options.descending ? 'startkey' : 'endkey';

    if (typeof options[startkeyName] !== 'undefined' &&
      typeof options[endkeyName] !== 'undefined' &&
      collate(options[startkeyName], options[endkeyName]) > 0) {
      throw new QueryParseError('No rows can match your key range, ' +
        'reverse your start_key and end_key or set {descending : true}');
    } else if (fun.reduce && options.reduce !== false) {
      if (options.include_docs) {
        throw new QueryParseError('{include_docs:true} is invalid for reduce');
      } else if (options.keys && options.keys.length > 1 &&
        !options.group && !options.group_level) {
        throw new QueryParseError('Multi-key fetches for reduce views must use ' +
          '{group: true}');
      }
    }
    ['group_level', 'limit', 'skip'].forEach(function (optionName) {
      var error = checkPositiveInteger(options[optionName]);
      if (error) {
        throw error;
      }
    });
  }

  function httpQuery(db, fun, opts) {
    // List of parameters to add to the PUT request
    var params = [];
    var body;
    var method = 'GET';

    // If opts.reduce exists and is defined, then add it to the list
    // of parameters.
    // If reduce=false then the results are that of only the map function
    // not the final result of map and reduce.
    addHttpParam('reduce', opts, params);
    addHttpParam('include_docs', opts, params);
    addHttpParam('attachments', opts, params);
    addHttpParam('limit', opts, params);
    addHttpParam('descending', opts, params);
    addHttpParam('group', opts, params);
    addHttpParam('group_level', opts, params);
    addHttpParam('skip', opts, params);
    addHttpParam('stale', opts, params);
    addHttpParam('conflicts', opts, params);
    addHttpParam('startkey', opts, params, true);
    addHttpParam('start_key', opts, params, true);
    addHttpParam('endkey', opts, params, true);
    addHttpParam('end_key', opts, params, true);
    addHttpParam('inclusive_end', opts, params);
    addHttpParam('key', opts, params, true);

    // Format the list of parameters into a valid URI query string
    params = params.join('&');
    params = params === '' ? '' : '?' + params;

    // If keys are supplied, issue a POST to circumvent GET query string limits
    // see http://wiki.apache.org/couchdb/HTTP_view_API#Querying_Options
    if (typeof opts.keys !== 'undefined') {
      var MAX_URL_LENGTH = 2000;
      // according to http://stackoverflow.com/a/417184/680742,
      // the de facto URL length limit is 2000 characters

      var keysAsString =
        'keys=' + encodeURIComponent(JSON.stringify(opts.keys));
      if (keysAsString.length + params.length + 1 <= MAX_URL_LENGTH) {
        // If the keys are short enough, do a GET. we do this to work around
        // Safari not understanding 304s on POSTs (see pouchdb/pouchdb#1239)
        params += (params[0] === '?' ? '&' : '?') + keysAsString;
      } else {
        method = 'POST';
        if (typeof fun === 'string') {
          body = {keys: opts.keys};
        } else { // fun is {map : mapfun}, so append to this
          fun.keys = opts.keys;
        }
      }
    }

    // We are referencing a query defined in the design doc
    if (typeof fun === 'string') {
      var parts = parseViewName(fun);
      return db.request({
        method: method,
        url: '_design/' + parts[0] + '/_view/' + parts[1] + params,
        body: body
      }).then(
        /* istanbul ignore next */
        function (result) {
          // fail the entire request if the result contains an error
          result.rows.forEach(function (row) {
            if (row.value && row.value.error && row.value.error === "builtin_reduce_error") {
              throw new Error(row.reason);
            }
          });

          return result;
      })
      .then(postprocessAttachments(opts));
    }

    // We are using a temporary view, terrible for performance, good for testing
    body = body || {};
    Object.keys(fun).forEach(function (key) {
      if (Array.isArray(fun[key])) {
        body[key] = fun[key];
      } else {
        body[key] = fun[key].toString();
      }
    });
    return db.request({
      method: 'POST',
      url: '_temp_view' + params,
      body: body
    }).then(postprocessAttachments(opts));
  }

  // custom adapters can define their own api._query
  // and override the default behavior
  /* istanbul ignore next */
  function customQuery(db, fun, opts) {
    return new PouchPromise$1(function (resolve, reject) {
      db._query(fun, opts, function (err, res) {
        if (err) {
          return reject(err);
        }
        resolve(res);
      });
    });
  }

  // custom adapters can define their own api._viewCleanup
  // and override the default behavior
  /* istanbul ignore next */
  function customViewCleanup(db) {
    return new PouchPromise$1(function (resolve, reject) {
      db._viewCleanup(function (err, res) {
        if (err) {
          return reject(err);
        }
        resolve(res);
      });
    });
  }

  function defaultsTo(value) {
    return function (reason) {
      /* istanbul ignore else */
      if (reason.status === 404) {
        return value;
      } else {
        throw reason;
      }
    };
  }

  // returns a promise for a list of docs to update, based on the input docId.
  // the order doesn't matter, because post-3.2.0, bulkDocs
  // is an atomic operation in all three adapters.
  function getDocsToPersist(docId, view, docIdsToChangesAndEmits) {
    var metaDocId = '_local/doc_' + docId;
    var defaultMetaDoc = {_id: metaDocId, keys: []};
    var docData = docIdsToChangesAndEmits.get(docId);
    var indexableKeysToKeyValues = docData[0];
    var changes = docData[1];

    function getMetaDoc() {
      if (isGenOne(changes)) {
        // generation 1, so we can safely assume initial state
        // for performance reasons (avoids unnecessary GETs)
        return PouchPromise$1.resolve(defaultMetaDoc);
      }
      return view.db.get(metaDocId).catch(defaultsTo(defaultMetaDoc));
    }

    function getKeyValueDocs(metaDoc) {
      if (!metaDoc.keys.length) {
        // no keys, no need for a lookup
        return PouchPromise$1.resolve({rows: []});
      }
      return view.db.allDocs({
        keys: metaDoc.keys,
        include_docs: true
      });
    }

    function processKeyValueDocs(metaDoc, kvDocsRes) {
      var kvDocs = [];
      var oldKeys = new ExportedSet();

      for (var i = 0, len = kvDocsRes.rows.length; i < len; i++) {
        var row = kvDocsRes.rows[i];
        var doc = row.doc;
        if (!doc) { // deleted
          continue;
        }
        kvDocs.push(doc);
        oldKeys.add(doc._id);
        doc._deleted = !indexableKeysToKeyValues.has(doc._id);
        if (!doc._deleted) {
          var keyValue = indexableKeysToKeyValues.get(doc._id);
          if ('value' in keyValue) {
            doc.value = keyValue.value;
          }
        }
      }
      var newKeys = mapToKeysArray(indexableKeysToKeyValues);
      newKeys.forEach(function (key) {
        if (!oldKeys.has(key)) {
          // new doc
          var kvDoc = {
            _id: key
          };
          var keyValue = indexableKeysToKeyValues.get(key);
          if ('value' in keyValue) {
            kvDoc.value = keyValue.value;
          }
          kvDocs.push(kvDoc);
        }
      });
      metaDoc.keys = uniq(newKeys.concat(metaDoc.keys));
      kvDocs.push(metaDoc);

      return kvDocs;
    }

    return getMetaDoc().then(function (metaDoc) {
      return getKeyValueDocs(metaDoc).then(function (kvDocsRes) {
        return processKeyValueDocs(metaDoc, kvDocsRes);
      });
    });
  }

  // updates all emitted key/value docs and metaDocs in the mrview database
  // for the given batch of documents from the source database
  function saveKeyValues(view, docIdsToChangesAndEmits, seq) {
    var seqDocId = '_local/lastSeq';
    return view.db.get(seqDocId)
      .catch(defaultsTo({_id: seqDocId, seq: 0}))
      .then(function (lastSeqDoc) {
        var docIds = mapToKeysArray(docIdsToChangesAndEmits);
        return PouchPromise$1.all(docIds.map(function (docId) {
          return getDocsToPersist(docId, view, docIdsToChangesAndEmits);
        })).then(function (listOfDocsToPersist) {
          var docsToPersist = flatten(listOfDocsToPersist);
          lastSeqDoc.seq = seq;
          docsToPersist.push(lastSeqDoc);
          // write all docs in a single operation, update the seq once
          return view.db.bulkDocs({docs : docsToPersist});
        });
      });
  }

  function getQueue(view) {
    var viewName = typeof view === 'string' ? view : view.name;
    var queue = persistentQueues[viewName];
    if (!queue) {
      queue = persistentQueues[viewName] = new TaskQueue$2();
    }
    return queue;
  }

  function updateView(view) {
    return sequentialize(getQueue(view), function () {
      return updateViewInQueue(view);
    })();
  }

  function updateViewInQueue(view) {
    // bind the emit function once
    var mapResults;
    var doc;

    function emit(key, value) {
      var output = {id: doc._id, key: normalizeKey(key)};
      // Don't explicitly store the value unless it's defined and non-null.
      // This saves on storage space, because often people don't use it.
      if (typeof value !== 'undefined' && value !== null) {
        output.value = normalizeKey(value);
      }
      mapResults.push(output);
    }

    var mapFun = mapper(view.mapFun, emit);

    var currentSeq = view.seq || 0;

    function processChange(docIdsToChangesAndEmits, seq) {
      return function () {
        return saveKeyValues(view, docIdsToChangesAndEmits, seq);
      };
    }

    var queue = new TaskQueue$2();

    function processNextBatch() {
      return view.sourceDB.changes({
        conflicts: true,
        include_docs: true,
        style: 'all_docs',
        since: currentSeq,
        limit: CHANGES_BATCH_SIZE$1
      }).then(processBatch);
    }

    function processBatch(response) {
      var results = response.results;
      if (!results.length) {
        return;
      }
      var docIdsToChangesAndEmits = createDocIdsToChangesAndEmits(results);
      queue.add(processChange(docIdsToChangesAndEmits, currentSeq));
      if (results.length < CHANGES_BATCH_SIZE$1) {
        return;
      }
      return processNextBatch();
    }

    function createDocIdsToChangesAndEmits(results) {
      var docIdsToChangesAndEmits = new ExportedMap();
      for (var i = 0, len = results.length; i < len; i++) {
        var change = results[i];
        if (change.doc._id[0] !== '_') {
          mapResults = [];
          doc = change.doc;

          if (!doc._deleted) {
            tryMap(view.sourceDB, mapFun, doc);
          }
          mapResults.sort(sortByKeyThenValue);

          var indexableKeysToKeyValues = createIndexableKeysToKeyValues(mapResults);
          docIdsToChangesAndEmits.set(change.doc._id, [
            indexableKeysToKeyValues,
            change.changes
          ]);
        }
        currentSeq = change.seq;
      }
      return docIdsToChangesAndEmits;
    }

    function createIndexableKeysToKeyValues(mapResults) {
      var indexableKeysToKeyValues = new ExportedMap();
      var lastKey;
      for (var i = 0, len = mapResults.length; i < len; i++) {
        var emittedKeyValue = mapResults[i];
        var complexKey = [emittedKeyValue.key, emittedKeyValue.id];
        if (i > 0 && collate(emittedKeyValue.key, lastKey) === 0) {
          complexKey.push(i); // dup key+id, so make it unique
        }
        indexableKeysToKeyValues.set(toIndexableString(complexKey), emittedKeyValue);
        lastKey = emittedKeyValue.key;
      }
      return indexableKeysToKeyValues;
    }

    return processNextBatch().then(function () {
      return queue.finish();
    }).then(function () {
      view.seq = currentSeq;
    });
  }

  function reduceView(view, results, options) {
    if (options.group_level === 0) {
      delete options.group_level;
    }

    var shouldGroup = options.group || options.group_level;

    var reduceFun = reducer(view.reduceFun);

    var groups = [];
    var lvl = isNaN(options.group_level) ? Number.POSITIVE_INFINITY :
      options.group_level;
    results.forEach(function (e) {
      var last = groups[groups.length - 1];
      var groupKey = shouldGroup ? e.key : null;

      // only set group_level for array keys
      if (shouldGroup && Array.isArray(groupKey)) {
        groupKey = groupKey.slice(0, lvl);
      }

      if (last && collate(last.groupKey, groupKey) === 0) {
        last.keys.push([e.key, e.id]);
        last.values.push(e.value);
        return;
      }
      groups.push({
        keys: [[e.key, e.id]],
        values: [e.value],
        groupKey: groupKey
      });
    });
    results = [];
    for (var i = 0, len = groups.length; i < len; i++) {
      var e = groups[i];
      var reduceTry = tryReduce(view.sourceDB, reduceFun, e.keys, e.values, false);
      if (reduceTry.error && reduceTry.error instanceof BuiltInError) {
        // CouchDB returns an error if a built-in errors out
        throw reduceTry.error;
      }
      results.push({
        // CouchDB just sets the value to null if a non-built-in errors out
        value: reduceTry.error ? null : reduceTry.output,
        key: e.groupKey
      });
    }
    // no total_rows/offset when reducing
    return {rows: sliceResults(results, options.limit, options.skip)};
  }

  function queryView(view, opts) {
    return sequentialize(getQueue(view), function () {
      return queryViewInQueue(view, opts);
    })();
  }

  function queryViewInQueue(view, opts) {
    var totalRows;
    var shouldReduce = view.reduceFun && opts.reduce !== false;
    var skip = opts.skip || 0;
    if (typeof opts.keys !== 'undefined' && !opts.keys.length) {
      // equivalent query
      opts.limit = 0;
      delete opts.keys;
    }

    function fetchFromView(viewOpts) {
      viewOpts.include_docs = true;
      return view.db.allDocs(viewOpts).then(function (res) {
        totalRows = res.total_rows;
        return res.rows.map(function (result) {

          // implicit migration - in older versions of PouchDB,
          // we explicitly stored the doc as {id: ..., key: ..., value: ...}
          // this is tested in a migration test
          /* istanbul ignore next */
          if ('value' in result.doc && typeof result.doc.value === 'object' &&
            result.doc.value !== null) {
            var keys = Object.keys(result.doc.value).sort();
            // this detection method is not perfect, but it's unlikely the user
            // emitted a value which was an object with these 3 exact keys
            var expectedKeys = ['id', 'key', 'value'];
            if (!(keys < expectedKeys || keys > expectedKeys)) {
              return result.doc.value;
            }
          }

          var parsedKeyAndDocId = parseIndexableString(result.doc._id);
          return {
            key: parsedKeyAndDocId[0],
            id: parsedKeyAndDocId[1],
            value: ('value' in result.doc ? result.doc.value : null)
          };
        });
      });
    }

    function onMapResultsReady(rows) {
      var finalResults;
      if (shouldReduce) {
        finalResults = reduceView(view, rows, opts);
      } else {
        finalResults = {
          total_rows: totalRows,
          offset: skip,
          rows: rows
        };
      }
      if (opts.include_docs) {
        var docIds = uniq(rows.map(rowToDocId));

        return view.sourceDB.allDocs({
          keys: docIds,
          include_docs: true,
          conflicts: opts.conflicts,
          attachments: opts.attachments,
          binary: opts.binary
        }).then(function (allDocsRes) {
          var docIdsToDocs = new ExportedMap();
          allDocsRes.rows.forEach(function (row) {
            docIdsToDocs.set(row.id, row.doc);
          });
          rows.forEach(function (row) {
            var docId = rowToDocId(row);
            var doc = docIdsToDocs.get(docId);
            if (doc) {
              row.doc = doc;
            }
          });
          return finalResults;
        });
      } else {
        return finalResults;
      }
    }

    if (typeof opts.keys !== 'undefined') {
      var keys = opts.keys;
      var fetchPromises = keys.map(function (key) {
        var viewOpts = {
          startkey : toIndexableString([key]),
          endkey   : toIndexableString([key, {}])
        };
        return fetchFromView(viewOpts);
      });
      return PouchPromise$1.all(fetchPromises).then(flatten).then(onMapResultsReady);
    } else { // normal query, no 'keys'
      var viewOpts = {
        descending : opts.descending
      };
      var startkey;
      var endkey;
      if ('start_key' in opts) {
        startkey = opts.start_key;
      }
      if ('startkey' in opts) {
        startkey = opts.startkey;
      }
      if ('end_key' in opts) {
        endkey = opts.end_key;
      }
      if ('endkey' in opts) {
        endkey = opts.endkey;
      }
      if (typeof startkey !== 'undefined') {
        viewOpts.startkey = opts.descending ?
          toIndexableString([startkey, {}]) :
          toIndexableString([startkey]);
      }
      if (typeof endkey !== 'undefined') {
        var inclusiveEnd = opts.inclusive_end !== false;
        if (opts.descending) {
          inclusiveEnd = !inclusiveEnd;
        }

        viewOpts.endkey = toIndexableString(
          inclusiveEnd ? [endkey, {}] : [endkey]);
      }
      if (typeof opts.key !== 'undefined') {
        var keyStart = toIndexableString([opts.key]);
        var keyEnd = toIndexableString([opts.key, {}]);
        if (viewOpts.descending) {
          viewOpts.endkey = keyStart;
          viewOpts.startkey = keyEnd;
        } else {
          viewOpts.startkey = keyStart;
          viewOpts.endkey = keyEnd;
        }
      }
      if (!shouldReduce) {
        if (typeof opts.limit === 'number') {
          viewOpts.limit = opts.limit;
        }
        viewOpts.skip = skip;
      }
      return fetchFromView(viewOpts).then(onMapResultsReady);
    }
  }

  function httpViewCleanup(db) {
    return db.request({
      method: 'POST',
      url: '_view_cleanup'
    });
  }

  function localViewCleanup(db) {
    return db.get('_local/' + localDocName).then(function (metaDoc) {
      var docsToViews = new ExportedMap();
      Object.keys(metaDoc.views).forEach(function (fullViewName) {
        var parts = parseViewName(fullViewName);
        var designDocName = '_design/' + parts[0];
        var viewName = parts[1];
        var views = docsToViews.get(designDocName);
        if (!views) {
          views = new ExportedSet();
          docsToViews.set(designDocName, views);
        }
        views.add(viewName);
      });
      var opts = {
        keys : mapToKeysArray(docsToViews),
        include_docs : true
      };
      return db.allDocs(opts).then(function (res) {
        var viewsToStatus = {};
        res.rows.forEach(function (row) {
          var ddocName = row.key.substring(8); // cuts off '_design/'
          docsToViews.get(row.key).forEach(function (viewName) {
            var fullViewName = ddocName + '/' + viewName;
            /* istanbul ignore if */
            if (!metaDoc.views[fullViewName]) {
              // new format, without slashes, to support PouchDB 2.2.0
              // migration test in pouchdb's browser.migration.js verifies this
              fullViewName = viewName;
            }
            var viewDBNames = Object.keys(metaDoc.views[fullViewName]);
            // design doc deleted, or view function nonexistent
            var statusIsGood = row.doc && row.doc.views &&
              row.doc.views[viewName];
            viewDBNames.forEach(function (viewDBName) {
              viewsToStatus[viewDBName] =
                viewsToStatus[viewDBName] || statusIsGood;
            });
          });
        });
        var dbsToDelete = Object.keys(viewsToStatus).filter(
          function (viewDBName) { return !viewsToStatus[viewDBName]; });
        var destroyPromises = dbsToDelete.map(function (viewDBName) {
          return sequentialize(getQueue(viewDBName), function () {
            return new db.constructor(viewDBName, db.__opts).destroy();
          })();
        });
        return PouchPromise$1.all(destroyPromises).then(function () {
          return {ok: true};
        });
      });
    }, defaultsTo({ok: true}));
  }

  function queryPromised(db, fun, opts) {
    /* istanbul ignore next */
    if (typeof db._query === 'function') {
      return customQuery(db, fun, opts);
    }
    if (isRemote(db)) {
      return httpQuery(db, fun, opts);
    }

    if (typeof fun !== 'string') {
      // temp_view
      checkQueryParseError(opts, fun);

      tempViewQueue.add(function () {
        var createViewPromise = createView(
          /* sourceDB */ db,
          /* viewName */ 'temp_view/temp_view',
          /* mapFun */ fun.map,
          /* reduceFun */ fun.reduce,
          /* temporary */ true,
          /* localDocName */ localDocName);
        return createViewPromise.then(function (view) {
          return fin(updateView(view).then(function () {
            return queryView(view, opts);
          }), function () {
            return view.db.destroy();
          });
        });
      });
      return tempViewQueue.finish();
    } else {
      // persistent view
      var fullViewName = fun;
      var parts = parseViewName(fullViewName);
      var designDocName = parts[0];
      var viewName = parts[1];
      return db.get('_design/' + designDocName).then(function (doc) {
        var fun = doc.views && doc.views[viewName];

        if (!fun) {
          // basic validator; it's assumed that every subclass would want this
          throw new NotFoundError('ddoc ' + doc._id + ' has no view named ' +
            viewName);
        }

        ddocValidator(doc, viewName);
        checkQueryParseError(opts, fun);

        var createViewPromise = createView(
          /* sourceDB */ db,
          /* viewName */ fullViewName,
          /* mapFun */ fun.map,
          /* reduceFun */ fun.reduce,
          /* temporary */ false,
          /* localDocName */ localDocName);
        return createViewPromise.then(function (view) {
          if (opts.stale === 'ok' || opts.stale === 'update_after') {
            if (opts.stale === 'update_after') {
              browser$2(function () {
                updateView(view);
              });
            }
            return queryView(view, opts);
          } else { // stale not ok
            return updateView(view).then(function () {
              return queryView(view, opts);
            });
          }
        });
      });
    }
  }

  function abstractQuery(fun, opts, callback) {
    var db = this;
    if (typeof opts === 'function') {
      callback = opts;
      opts = {};
    }
    opts = opts ? coerceOptions(opts) : {};

    if (typeof fun === 'function') {
      fun = {map : fun};
    }

    var promise = PouchPromise$1.resolve().then(function () {
      return queryPromised(db, fun, opts);
    });
    promisedCallback(promise, callback);
    return promise;
  }

  var abstractViewCleanup = callbackify(function () {
    var db = this;
    /* istanbul ignore next */
    if (typeof db._viewCleanup === 'function') {
      return customViewCleanup(db);
    }
    if (isRemote(db)) {
      return httpViewCleanup(db);
    }
    return localViewCleanup(db);
  });

  return {
    query: abstractQuery,
    viewCleanup: abstractViewCleanup
  };
}

var builtInReduce = {
  _sum: function (keys, values) {
    return sum(values);
  },

  _count: function (keys, values) {
    return values.length;
  },

  _stats: function (keys, values) {
    // no need to implement rereduce=true, because Pouch
    // will never call it
    function sumsqr(values) {
      var _sumsqr = 0;
      for (var i = 0, len = values.length; i < len; i++) {
        var num = values[i];
        _sumsqr += (num * num);
      }
      return _sumsqr;
    }
    return {
      sum     : sum(values),
      min     : Math.min.apply(null, values),
      max     : Math.max.apply(null, values),
      count   : values.length,
      sumsqr : sumsqr(values)
    };
  }
};

function getBuiltIn(reduceFunString) {
  if (/^_sum/.test(reduceFunString)) {
    return builtInReduce._sum;
  } else if (/^_count/.test(reduceFunString)) {
    return builtInReduce._count;
  } else if (/^_stats/.test(reduceFunString)) {
    return builtInReduce._stats;
  } else if (/^_/.test(reduceFunString)) {
    throw new Error(reduceFunString + ' is not a supported reduce function.');
  }
}

function mapper(mapFun, emit) {
  // for temp_views one can use emit(doc, emit), see #38
  if (typeof mapFun === "function" && mapFun.length === 2) {
    var origMap = mapFun;
    return function (doc) {
      return origMap(doc, emit);
    };
  } else {
    return evalFunctionWithEval(mapFun.toString(), emit);
  }
}

function reducer(reduceFun) {
  var reduceFunString = reduceFun.toString();
  var builtIn = getBuiltIn(reduceFunString);
  if (builtIn) {
    return builtIn;
  } else {
    return evalFunctionWithEval(reduceFunString);
  }
}

function ddocValidator(ddoc, viewName) {
  var fun = ddoc.views && ddoc.views[viewName];
  if (typeof fun.map !== 'string') {
    throw new NotFoundError('ddoc ' + ddoc._id + ' has no string view named ' +
      viewName + ', instead found object of type: ' + typeof fun.map);
  }
}

var localDocName = 'mrviews';
var abstract = createAbstractMapReduce(localDocName, mapper, reducer, ddocValidator);

function query(fun, opts, callback) {
  return abstract.query.call(this, fun, opts, callback);
}

function viewCleanup(callback) {
  return abstract.viewCleanup.call(this, callback);
}

var mapreduce = {
  query: query,
  viewCleanup: viewCleanup
};

function isGenOne$1(rev$$1) {
  return /^1-/.test(rev$$1);
}

function fileHasChanged(localDoc, remoteDoc, filename) {
  return !localDoc._attachments ||
         !localDoc._attachments[filename] ||
         localDoc._attachments[filename].digest !== remoteDoc._attachments[filename].digest;
}

function getDocAttachments(db, doc) {
  var filenames = Object.keys(doc._attachments);
  return PouchPromise$1.all(filenames.map(function (filename) {
    return db.getAttachment(doc._id, filename, {rev: doc._rev});
  }));
}

function getDocAttachmentsFromTargetOrSource(target, src, doc) {
  var doCheckForLocalAttachments = isRemote(src) && !isRemote(target);
  var filenames = Object.keys(doc._attachments);

  if (!doCheckForLocalAttachments) {
    return getDocAttachments(src, doc);
  }

  return target.get(doc._id).then(function (localDoc) {
    return PouchPromise$1.all(filenames.map(function (filename) {
      if (fileHasChanged(localDoc, doc, filename)) {
        return src.getAttachment(doc._id, filename);
      }

      return target.getAttachment(localDoc._id, filename);
    }));
  }).catch(function (error) {
    /* istanbul ignore if */
    if (error.status !== 404) {
      throw error;
    }

    return getDocAttachments(src, doc);
  });
}

function createBulkGetOpts(diffs) {
  var requests = [];
  Object.keys(diffs).forEach(function (id) {
    var missingRevs = diffs[id].missing;
    missingRevs.forEach(function (missingRev) {
      requests.push({
        id: id,
        rev: missingRev
      });
    });
  });

  return {
    docs: requests,
    revs: true,
    latest: true
  };
}

//
// Fetch all the documents from the src as described in the "diffs",
// which is a mapping of docs IDs to revisions. If the state ever
// changes to "cancelled", then the returned promise will be rejected.
// Else it will be resolved with a list of fetched documents.
//
function getDocs(src, target, diffs, state) {
  diffs = clone(diffs); // we do not need to modify this

  var resultDocs = [],
      ok = true;

  function getAllDocs() {

    var bulkGetOpts = createBulkGetOpts(diffs);

    if (!bulkGetOpts.docs.length) { // optimization: skip empty requests
      return;
    }

    return src.bulkGet(bulkGetOpts).then(function (bulkGetResponse) {
      /* istanbul ignore if */
      if (state.cancelled) {
        throw new Error('cancelled');
      }
      return PouchPromise$1.all(bulkGetResponse.results.map(function (bulkGetInfo) {
        return PouchPromise$1.all(bulkGetInfo.docs.map(function (doc) {
          var remoteDoc = doc.ok;

          if (doc.error) {
            // when AUTO_COMPACTION is set, docs can be returned which look
            // like this: {"missing":"1-7c3ac256b693c462af8442f992b83696"}
            ok = false;
          }

          if (!remoteDoc || !remoteDoc._attachments) {
            return remoteDoc;
          }

          return getDocAttachmentsFromTargetOrSource(target, src, remoteDoc)
                   .then(function (attachments) {
                           var filenames = Object.keys(remoteDoc._attachments);
                           attachments
                             .forEach(function (attachment, i) {
                                        var att = remoteDoc._attachments[filenames[i]];
                                        delete att.stub;
                                        delete att.length;
                                        att.data = attachment;
                                      });

                                      return remoteDoc;
                                    });
        }));
      }))

      .then(function (results) {
        resultDocs = resultDocs.concat(flatten(results).filter(Boolean));
      });
    });
  }

  function hasAttachments(doc) {
    return doc._attachments && Object.keys(doc._attachments).length > 0;
  }

  function hasConflicts(doc) {
    return doc._conflicts && doc._conflicts.length > 0;
  }

  function fetchRevisionOneDocs(ids) {
    // Optimization: fetch gen-1 docs and attachments in
    // a single request using _all_docs
    return src.allDocs({
      keys: ids,
      include_docs: true,
      conflicts: true
    }).then(function (res) {
      if (state.cancelled) {
        throw new Error('cancelled');
      }
      res.rows.forEach(function (row) {
        if (row.deleted || !row.doc || !isGenOne$1(row.value.rev) ||
            hasAttachments(row.doc) || hasConflicts(row.doc)) {
          // if any of these conditions apply, we need to fetch using get()
          return;
        }

        // strip _conflicts array to appease CSG (#5793)
        /* istanbul ignore if */
        if (row.doc._conflicts) {
          delete row.doc._conflicts;
        }

        // the doc we got back from allDocs() is sufficient
        resultDocs.push(row.doc);
        delete diffs[row.id];
      });
    });
  }

  function getRevisionOneDocs() {
    // filter out the generation 1 docs and get them
    // leaving the non-generation one docs to be got otherwise
    var ids = Object.keys(diffs).filter(function (id) {
      var missing = diffs[id].missing;
      return missing.length === 1 && isGenOne$1(missing[0]);
    });
    if (ids.length > 0) {
      return fetchRevisionOneDocs(ids);
    }
  }

  function returnResult() {
    return { ok:ok, docs:resultDocs };
  }

  return PouchPromise$1.resolve()
    .then(getRevisionOneDocs)
    .then(getAllDocs)
    .then(returnResult);
}

var CHECKPOINT_VERSION = 1;
var REPLICATOR = "pouchdb";
// This is an arbitrary number to limit the
// amount of replication history we save in the checkpoint.
// If we save too much, the checkpoing docs will become very big,
// if we save fewer, we'll run a greater risk of having to
// read all the changes from 0 when checkpoint PUTs fail
// CouchDB 2.0 has a more involved history pruning,
// but let's go for the simple version for now.
var CHECKPOINT_HISTORY_SIZE = 5;
var LOWEST_SEQ = 0;

function updateCheckpoint(db, id, checkpoint, session, returnValue) {
  return db.get(id).catch(function (err) {
    if (err.status === 404) {
      if (db.adapter === 'http' || db.adapter === 'https') {
        explainError(
          404, 'PouchDB is just checking if a remote checkpoint exists.'
        );
      }
      return {
        session_id: session,
        _id: id,
        history: [],
        replicator: REPLICATOR,
        version: CHECKPOINT_VERSION
      };
    }
    throw err;
  }).then(function (doc) {
    if (returnValue.cancelled) {
      return;
    }

    // if the checkpoint has not changed, do not update
    if (doc.last_seq === checkpoint) {
      return;
    }

    // Filter out current entry for this replication
    doc.history = (doc.history || []).filter(function (item) {
      return item.session_id !== session;
    });

    // Add the latest checkpoint to history
    doc.history.unshift({
      last_seq: checkpoint,
      session_id: session
    });

    // Just take the last pieces in history, to
    // avoid really big checkpoint docs.
    // see comment on history size above
    doc.history = doc.history.slice(0, CHECKPOINT_HISTORY_SIZE);

    doc.version = CHECKPOINT_VERSION;
    doc.replicator = REPLICATOR;

    doc.session_id = session;
    doc.last_seq = checkpoint;

    return db.put(doc).catch(function (err) {
      if (err.status === 409) {
        // retry; someone is trying to write a checkpoint simultaneously
        return updateCheckpoint(db, id, checkpoint, session, returnValue);
      }
      throw err;
    });
  });
}

function Checkpointer(src, target, id, returnValue, opts) {
  this.src = src;
  this.target = target;
  this.id = id;
  this.returnValue = returnValue;
  this.opts = opts;
}

Checkpointer.prototype.writeCheckpoint = function (checkpoint, session) {
  var self = this;
  return this.updateTarget(checkpoint, session).then(function () {
    return self.updateSource(checkpoint, session);
  });
};

Checkpointer.prototype.updateTarget = function (checkpoint, session) {
  if (this.opts.writeTargetCheckpoint) {
    return updateCheckpoint(this.target, this.id, checkpoint,
      session, this.returnValue);
  } else {
    return PouchPromise$1.resolve(true);
  }
};

Checkpointer.prototype.updateSource = function (checkpoint, session) {
  if (this.opts.writeSourceCheckpoint) {
    var self = this;
    if (this.readOnlySource) {
      return PouchPromise$1.resolve(true);
    }
    return updateCheckpoint(this.src, this.id, checkpoint,
      session, this.returnValue)
      .catch(function (err) {
        if (isForbiddenError(err)) {
          self.readOnlySource = true;
          return true;
        }
        throw err;
      });
  } else {
    return PouchPromise$1.resolve(true);
  }
};

var comparisons = {
  "undefined": function (targetDoc, sourceDoc) {
    // This is the previous comparison function
    if (collate(targetDoc.last_seq, sourceDoc.last_seq) === 0) {
      return sourceDoc.last_seq;
    }
    /* istanbul ignore next */
    return 0;
  },
  "1": function (targetDoc, sourceDoc) {
    // This is the comparison function ported from CouchDB
    return compareReplicationLogs(sourceDoc, targetDoc).last_seq;
  }
};

Checkpointer.prototype.getCheckpoint = function () {
  var self = this;
  return self.target.get(self.id).then(function (targetDoc) {
    if (self.readOnlySource) {
      return PouchPromise$1.resolve(targetDoc.last_seq);
    }

    return self.src.get(self.id).then(function (sourceDoc) {
      // Since we can't migrate an old version doc to a new one
      // (no session id), we just go with the lowest seq in this case
      /* istanbul ignore if */
      if (targetDoc.version !== sourceDoc.version) {
        return LOWEST_SEQ;
      }

      var version;
      if (targetDoc.version) {
        version = targetDoc.version.toString();
      } else {
        version = "undefined";
      }

      if (version in comparisons) {
        return comparisons[version](targetDoc, sourceDoc);
      }
      /* istanbul ignore next */
      return LOWEST_SEQ;
    }, function (err) {
      if (err.status === 404 && targetDoc.last_seq) {
        return self.src.put({
          _id: self.id,
          last_seq: LOWEST_SEQ
        }).then(function () {
          return LOWEST_SEQ;
        }, function (err) {
          if (isForbiddenError(err)) {
            self.readOnlySource = true;
            return targetDoc.last_seq;
          }
          /* istanbul ignore next */
          return LOWEST_SEQ;
        });
      }
      throw err;
    });
  }).catch(function (err) {
    if (err.status !== 404) {
      throw err;
    }
    return LOWEST_SEQ;
  });
};
// This checkpoint comparison is ported from CouchDBs source
// they come from here:
// https://github.com/apache/couchdb-couch-replicator/blob/master/src/couch_replicator.erl#L863-L906

function compareReplicationLogs(srcDoc, tgtDoc) {
  if (srcDoc.session_id === tgtDoc.session_id) {
    return {
      last_seq: srcDoc.last_seq,
      history: srcDoc.history
    };
  }

  return compareReplicationHistory(srcDoc.history, tgtDoc.history);
}

function compareReplicationHistory(sourceHistory, targetHistory) {
  // the erlang loop via function arguments is not so easy to repeat in JS
  // therefore, doing this as recursion
  var S = sourceHistory[0];
  var sourceRest = sourceHistory.slice(1);
  var T = targetHistory[0];
  var targetRest = targetHistory.slice(1);

  if (!S || targetHistory.length === 0) {
    return {
      last_seq: LOWEST_SEQ,
      history: []
    };
  }

  var sourceId = S.session_id;
  /* istanbul ignore if */
  if (hasSessionId(sourceId, targetHistory)) {
    return {
      last_seq: S.last_seq,
      history: sourceHistory
    };
  }

  var targetId = T.session_id;
  if (hasSessionId(targetId, sourceRest)) {
    return {
      last_seq: T.last_seq,
      history: targetRest
    };
  }

  return compareReplicationHistory(sourceRest, targetRest);
}

function hasSessionId(sessionId, history) {
  var props = history[0];
  var rest = history.slice(1);

  if (!sessionId || history.length === 0) {
    return false;
  }

  if (sessionId === props.session_id) {
    return true;
  }

  return hasSessionId(sessionId, rest);
}

function isForbiddenError(err) {
  return typeof err.status === 'number' && Math.floor(err.status / 100) === 4;
}

var STARTING_BACK_OFF = 0;

function backOff(opts, returnValue, error, callback) {
  if (opts.retry === false) {
    returnValue.emit('error', error);
    returnValue.removeAllListeners();
    return;
  }
  if (typeof opts.back_off_function !== 'function') {
    opts.back_off_function = defaultBackOff;
  }
  returnValue.emit('requestError', error);
  if (returnValue.state === 'active' || returnValue.state === 'pending') {
    returnValue.emit('paused', error);
    returnValue.state = 'stopped';
    var backOffSet = function backoffTimeSet() {
      opts.current_back_off = STARTING_BACK_OFF;
    };
    var removeBackOffSetter = function removeBackOffTimeSet() {
      returnValue.removeListener('active', backOffSet);
    };
    returnValue.once('paused', removeBackOffSetter);
    returnValue.once('active', backOffSet);
  }

  opts.current_back_off = opts.current_back_off || STARTING_BACK_OFF;
  opts.current_back_off = opts.back_off_function(opts.current_back_off);
  setTimeout(callback, opts.current_back_off);
}

function sortObjectPropertiesByKey(queryParams) {
  return Object.keys(queryParams).sort(collate).reduce(function (result, key) {
    result[key] = queryParams[key];
    return result;
  }, {});
}

// Generate a unique id particular to this replication.
// Not guaranteed to align perfectly with CouchDB's rep ids.
function generateReplicationId(src, target, opts) {
  var docIds = opts.doc_ids ? opts.doc_ids.sort(collate) : '';
  var filterFun = opts.filter ? opts.filter.toString() : '';
  var queryParams = '';
  var filterViewName =  '';
  var selector = '';

  // possibility for checkpoints to be lost here as behaviour of
  // JSON.stringify is not stable (see #6226)
  /* istanbul ignore if */
  if (opts.selector) {
    selector = JSON.stringify(opts.selector);
  }

  if (opts.filter && opts.query_params) {
    queryParams = JSON.stringify(sortObjectPropertiesByKey(opts.query_params));
  }

  if (opts.filter && opts.filter === '_view') {
    filterViewName = opts.view.toString();
  }

  return PouchPromise$1.all([src.id(), target.id()]).then(function (res) {
    var queryData = res[0] + res[1] + filterFun + filterViewName +
      queryParams + docIds + selector;
    return new PouchPromise$1(function (resolve) {
      binaryMd5(queryData, resolve);
    });
  }).then(function (md5sum) {
    // can't use straight-up md5 alphabet, because
    // the char '/' is interpreted as being for attachments,
    // and + is also not url-safe
    md5sum = md5sum.replace(/\//g, '.').replace(/\+/g, '_');
    return '_local/' + md5sum;
  });
}

function replicate(src, target, opts, returnValue, result) {
  var batches = [];               // list of batches to be processed
  var currentBatch;               // the batch currently being processed
  var pendingBatch = {
    seq: 0,
    changes: [],
    docs: []
  }; // next batch, not yet ready to be processed
  var writingCheckpoint = false;  // true while checkpoint is being written
  var changesCompleted = false;   // true when all changes received
  var replicationCompleted = false; // true when replication has completed
  var last_seq = 0;
  var continuous = opts.continuous || opts.live || false;
  var batch_size = opts.batch_size || 100;
  var batches_limit = opts.batches_limit || 10;
  var changesPending = false;     // true while src.changes is running
  var doc_ids = opts.doc_ids;
  var selector = opts.selector;
  var repId;
  var checkpointer;
  var changedDocs = [];
  // Like couchdb, every replication gets a unique session id
  var session = uuid();

  result = result || {
    ok: true,
    start_time: new Date(),
    docs_read: 0,
    docs_written: 0,
    doc_write_failures: 0,
    errors: []
  };

  var changesOpts = {};
  returnValue.ready(src, target);

  function initCheckpointer() {
    if (checkpointer) {
      return PouchPromise$1.resolve();
    }
    return generateReplicationId(src, target, opts).then(function (res) {
      repId = res;

      var checkpointOpts = {};
      if (opts.checkpoint === false) {
        checkpointOpts = { writeSourceCheckpoint: false, writeTargetCheckpoint: false };
      } else if (opts.checkpoint === 'source') {
        checkpointOpts = { writeSourceCheckpoint: true, writeTargetCheckpoint: false };
      } else if (opts.checkpoint === 'target') {
        checkpointOpts = { writeSourceCheckpoint: false, writeTargetCheckpoint: true };
      } else {
        checkpointOpts = { writeSourceCheckpoint: true, writeTargetCheckpoint: true };
      }

      checkpointer = new Checkpointer(src, target, repId, returnValue, checkpointOpts);
    });
  }

  function writeDocs() {
    changedDocs = [];

    if (currentBatch.docs.length === 0) {
      return;
    }
    var docs = currentBatch.docs;
    var bulkOpts = {timeout: opts.timeout};
    return target.bulkDocs({docs: docs, new_edits: false}, bulkOpts).then(function (res) {
      /* istanbul ignore if */
      if (returnValue.cancelled) {
        completeReplication();
        throw new Error('cancelled');
      }

      // `res` doesn't include full documents (which live in `docs`), so we create a map of 
      // (id -> error), and check for errors while iterating over `docs`
      var errorsById = Object.create(null);
      res.forEach(function (res) {
        if (res.error) {
          errorsById[res.id] = res;
        }
      });

      var errorsNo = Object.keys(errorsById).length;
      result.doc_write_failures += errorsNo;
      result.docs_written += docs.length - errorsNo;

      docs.forEach(function (doc) {
        var error = errorsById[doc._id];
        if (error) {
          result.errors.push(error);
          if (error.name === 'unauthorized' || error.name === 'forbidden') {
            returnValue.emit('denied', clone(error));
          } else {
            throw error;
          }
        } else {
          changedDocs.push(doc);
        }
      });

    }, function (err) {
      result.doc_write_failures += docs.length;
      throw err;
    });
  }

  function finishBatch() {
    if (currentBatch.error) {
      throw new Error('There was a problem getting docs.');
    }
    result.last_seq = last_seq = currentBatch.seq;
    var outResult = clone(result);
    if (changedDocs.length) {
      outResult.docs = changedDocs;
      returnValue.emit('change', outResult);
    }
    writingCheckpoint = true;
    return checkpointer.writeCheckpoint(currentBatch.seq,
        session).then(function () {
      writingCheckpoint = false;
      /* istanbul ignore if */
      if (returnValue.cancelled) {
        completeReplication();
        throw new Error('cancelled');
      }
      currentBatch = undefined;
      getChanges();
    }).catch(function (err) {
      onCheckpointError(err);
      throw err;
    });
  }

  function getDiffs() {
    var diff = {};
    currentBatch.changes.forEach(function (change) {
      // Couchbase Sync Gateway emits these, but we can ignore them
      /* istanbul ignore if */
      if (change.id === "_user/") {
        return;
      }
      diff[change.id] = change.changes.map(function (x) {
        return x.rev;
      });
    });
    return target.revsDiff(diff).then(function (diffs) {
      /* istanbul ignore if */
      if (returnValue.cancelled) {
        completeReplication();
        throw new Error('cancelled');
      }
      // currentBatch.diffs elements are deleted as the documents are written
      currentBatch.diffs = diffs;
    });
  }

  function getBatchDocs() {
    return getDocs(src, target, currentBatch.diffs, returnValue).then(function (got) {
      currentBatch.error = !got.ok;
      got.docs.forEach(function (doc) {
        delete currentBatch.diffs[doc._id];
        result.docs_read++;
        currentBatch.docs.push(doc);
      });
    });
  }

  function startNextBatch() {
    if (returnValue.cancelled || currentBatch) {
      return;
    }
    if (batches.length === 0) {
      processPendingBatch(true);
      return;
    }
    currentBatch = batches.shift();
    getDiffs()
      .then(getBatchDocs)
      .then(writeDocs)
      .then(finishBatch)
      .then(startNextBatch)
      .catch(function (err) {
        abortReplication('batch processing terminated with error', err);
      });
  }


  function processPendingBatch(immediate) {
    if (pendingBatch.changes.length === 0) {
      if (batches.length === 0 && !currentBatch) {
        if ((continuous && changesOpts.live) || changesCompleted) {
          returnValue.state = 'pending';
          returnValue.emit('paused');
        }
        if (changesCompleted) {
          completeReplication();
        }
      }
      return;
    }
    if (
      immediate ||
      changesCompleted ||
      pendingBatch.changes.length >= batch_size
    ) {
      batches.push(pendingBatch);
      pendingBatch = {
        seq: 0,
        changes: [],
        docs: []
      };
      if (returnValue.state === 'pending' || returnValue.state === 'stopped') {
        returnValue.state = 'active';
        returnValue.emit('active');
      }
      startNextBatch();
    }
  }


  function abortReplication(reason, err) {
    if (replicationCompleted) {
      return;
    }
    if (!err.message) {
      err.message = reason;
    }
    result.ok = false;
    result.status = 'aborting';
    batches = [];
    pendingBatch = {
      seq: 0,
      changes: [],
      docs: []
    };
    completeReplication(err);
  }


  function completeReplication(fatalError) {
    if (replicationCompleted) {
      return;
    }
    /* istanbul ignore if */
    if (returnValue.cancelled) {
      result.status = 'cancelled';
      if (writingCheckpoint) {
        return;
      }
    }
    result.status = result.status || 'complete';
    result.end_time = new Date();
    result.last_seq = last_seq;
    replicationCompleted = true;

    if (fatalError) {
      // need to extend the error because Firefox considers ".result" read-only
      fatalError = createError(fatalError);
      fatalError.result = result;

      if (fatalError.name === 'unauthorized' || fatalError.name === 'forbidden') {
        returnValue.emit('error', fatalError);
        returnValue.removeAllListeners();
      } else {
        backOff(opts, returnValue, fatalError, function () {
          replicate(src, target, opts, returnValue);
        });
      }
    } else {
      returnValue.emit('complete', result);
      returnValue.removeAllListeners();
    }
  }


  function onChange(change) {
    /* istanbul ignore if */
    if (returnValue.cancelled) {
      return completeReplication();
    }
    var filter = filterChange(opts)(change);
    if (!filter) {
      return;
    }
    pendingBatch.seq = change.seq;
    pendingBatch.changes.push(change);
    processPendingBatch(batches.length === 0 && changesOpts.live);
  }


  function onChangesComplete(changes) {
    changesPending = false;
    /* istanbul ignore if */
    if (returnValue.cancelled) {
      return completeReplication();
    }

    // if no results were returned then we're done,
    // else fetch more
    if (changes.results.length > 0) {
      changesOpts.since = changes.last_seq;
      getChanges();
      processPendingBatch(true);
    } else {

      var complete = function () {
        if (continuous) {
          changesOpts.live = true;
          getChanges();
        } else {
          changesCompleted = true;
        }
        processPendingBatch(true);
      };

      // update the checkpoint so we start from the right seq next time
      if (!currentBatch && changes.results.length === 0) {
        writingCheckpoint = true;
        checkpointer.writeCheckpoint(changes.last_seq,
            session).then(function () {
          writingCheckpoint = false;
          result.last_seq = last_seq = changes.last_seq;
          complete();
        })
        .catch(onCheckpointError);
      } else {
        complete();
      }
    }
  }


  function onChangesError(err) {
    changesPending = false;
    /* istanbul ignore if */
    if (returnValue.cancelled) {
      return completeReplication();
    }
    abortReplication('changes rejected', err);
  }


  function getChanges() {
    if (!(
      !changesPending &&
      !changesCompleted &&
      batches.length < batches_limit
      )) {
      return;
    }
    changesPending = true;
    function abortChanges() {
      changes.cancel();
    }
    function removeListener() {
      returnValue.removeListener('cancel', abortChanges);
    }

    if (returnValue._changes) { // remove old changes() and listeners
      returnValue.removeListener('cancel', returnValue._abortChanges);
      returnValue._changes.cancel();
    }
    returnValue.once('cancel', abortChanges);

    var changes = src.changes(changesOpts)
      .on('change', onChange);
    changes.then(removeListener, removeListener);
    changes.then(onChangesComplete)
      .catch(onChangesError);

    if (opts.retry) {
      // save for later so we can cancel if necessary
      returnValue._changes = changes;
      returnValue._abortChanges = abortChanges;
    }
  }


  function startChanges() {
    initCheckpointer().then(function () {
      /* istanbul ignore if */
      if (returnValue.cancelled) {
        completeReplication();
        return;
      }
      return checkpointer.getCheckpoint().then(function (checkpoint) {
        last_seq = checkpoint;
        changesOpts = {
          since: last_seq,
          limit: batch_size,
          batch_size: batch_size,
          style: 'all_docs',
          doc_ids: doc_ids,
          selector: selector,
          return_docs: true // required so we know when we're done
        };
        if (opts.filter) {
          if (typeof opts.filter !== 'string') {
            // required for the client-side filter in onChange
            changesOpts.include_docs = true;
          } else { // ddoc filter
            changesOpts.filter = opts.filter;
          }
        }
        if ('heartbeat' in opts) {
          changesOpts.heartbeat = opts.heartbeat;
        }
        if ('timeout' in opts) {
          changesOpts.timeout = opts.timeout;
        }
        if (opts.query_params) {
          changesOpts.query_params = opts.query_params;
        }
        if (opts.view) {
          changesOpts.view = opts.view;
        }
        getChanges();
      });
    }).catch(function (err) {
      abortReplication('getCheckpoint rejected with ', err);
    });
  }

  /* istanbul ignore next */
  function onCheckpointError(err) {
    writingCheckpoint = false;
    abortReplication('writeCheckpoint completed with error', err);
  }

  /* istanbul ignore if */
  if (returnValue.cancelled) { // cancelled immediately
    completeReplication();
    return;
  }

  if (!returnValue._addedListeners) {
    returnValue.once('cancel', completeReplication);

    if (typeof opts.complete === 'function') {
      returnValue.once('error', opts.complete);
      returnValue.once('complete', function (result) {
        opts.complete(null, result);
      });
    }
    returnValue._addedListeners = true;
  }

  if (typeof opts.since === 'undefined') {
    startChanges();
  } else {
    initCheckpointer().then(function () {
      writingCheckpoint = true;
      return checkpointer.writeCheckpoint(opts.since, session);
    }).then(function () {
      writingCheckpoint = false;
      /* istanbul ignore if */
      if (returnValue.cancelled) {
        completeReplication();
        return;
      }
      last_seq = opts.since;
      startChanges();
    }).catch(onCheckpointError);
  }
}

// We create a basic promise so the caller can cancel the replication possibly
// before we have actually started listening to changes etc
inherits_browser$1(Replication, EventEmitter);
function Replication() {
  EventEmitter.call(this);
  this.cancelled = false;
  this.state = 'pending';
  var self = this;
  var promise = new PouchPromise$1(function (fulfill, reject) {
    self.once('complete', fulfill);
    self.once('error', reject);
  });
  self.then = function (resolve, reject) {
    return promise.then(resolve, reject);
  };
  self.catch = function (reject) {
    return promise.catch(reject);
  };
  // As we allow error handling via "error" event as well,
  // put a stub in here so that rejecting never throws UnhandledError.
  self.catch(function () {});
}

Replication.prototype.cancel = function () {
  this.cancelled = true;
  this.state = 'cancelled';
  this.emit('cancel');
};

Replication.prototype.ready = function (src, target) {
  var self = this;
  if (self._readyCalled) {
    return;
  }
  self._readyCalled = true;

  function onDestroy() {
    self.cancel();
  }
  src.once('destroyed', onDestroy);
  target.once('destroyed', onDestroy);
  function cleanup() {
    src.removeListener('destroyed', onDestroy);
    target.removeListener('destroyed', onDestroy);
  }
  self.once('complete', cleanup);
};

function toPouch(db, opts) {
  var PouchConstructor = opts.PouchConstructor;
  if (typeof db === 'string') {
    return new PouchConstructor(db, opts);
  } else {
    return db;
  }
}

function replicateWrapper(src, target, opts, callback) {

  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  if (typeof opts === 'undefined') {
    opts = {};
  }

  if (opts.doc_ids && !Array.isArray(opts.doc_ids)) {
    throw createError(BAD_REQUEST,
                       "`doc_ids` filter parameter is not a list.");
  }

  opts.complete = callback;
  opts = clone(opts);
  opts.continuous = opts.continuous || opts.live;
  opts.retry = ('retry' in opts) ? opts.retry : false;
  /*jshint validthis:true */
  opts.PouchConstructor = opts.PouchConstructor || this;
  var replicateRet = new Replication(opts);
  var srcPouch = toPouch(src, opts);
  var targetPouch = toPouch(target, opts);
  replicate(srcPouch, targetPouch, opts, replicateRet);
  return replicateRet;
}

inherits_browser$1(Sync, EventEmitter);
function sync$1(src, target, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  if (typeof opts === 'undefined') {
    opts = {};
  }
  opts = clone(opts);
  /*jshint validthis:true */
  opts.PouchConstructor = opts.PouchConstructor || this;
  src = toPouch(src, opts);
  target = toPouch(target, opts);
  return new Sync(src, target, opts, callback);
}

function Sync(src, target, opts, callback) {
  var self = this;
  this.canceled = false;

  var optsPush = opts.push ? $inject_Object_assign({}, opts, opts.push) : opts;
  var optsPull = opts.pull ? $inject_Object_assign({}, opts, opts.pull) : opts;

  this.push = replicateWrapper(src, target, optsPush);
  this.pull = replicateWrapper(target, src, optsPull);

  this.pushPaused = true;
  this.pullPaused = true;

  function pullChange(change) {
    self.emit('change', {
      direction: 'pull',
      change: change
    });
  }
  function pushChange(change) {
    self.emit('change', {
      direction: 'push',
      change: change
    });
  }
  function pushDenied(doc) {
    self.emit('denied', {
      direction: 'push',
      doc: doc
    });
  }
  function pullDenied(doc) {
    self.emit('denied', {
      direction: 'pull',
      doc: doc
    });
  }
  function pushPaused() {
    self.pushPaused = true;
    /* istanbul ignore if */
    if (self.pullPaused) {
      self.emit('paused');
    }
  }
  function pullPaused() {
    self.pullPaused = true;
    /* istanbul ignore if */
    if (self.pushPaused) {
      self.emit('paused');
    }
  }
  function pushActive() {
    self.pushPaused = false;
    /* istanbul ignore if */
    if (self.pullPaused) {
      self.emit('active', {
        direction: 'push'
      });
    }
  }
  function pullActive() {
    self.pullPaused = false;
    /* istanbul ignore if */
    if (self.pushPaused) {
      self.emit('active', {
        direction: 'pull'
      });
    }
  }

  var removed = {};

  function removeAll(type) { // type is 'push' or 'pull'
    return function (event, func) {
      var isChange = event === 'change' &&
        (func === pullChange || func === pushChange);
      var isDenied = event === 'denied' &&
        (func === pullDenied || func === pushDenied);
      var isPaused = event === 'paused' &&
        (func === pullPaused || func === pushPaused);
      var isActive = event === 'active' &&
        (func === pullActive || func === pushActive);

      if (isChange || isDenied || isPaused || isActive) {
        if (!(event in removed)) {
          removed[event] = {};
        }
        removed[event][type] = true;
        if (Object.keys(removed[event]).length === 2) {
          // both push and pull have asked to be removed
          self.removeAllListeners(event);
        }
      }
    };
  }

  if (opts.live) {
    this.push.on('complete', self.pull.cancel.bind(self.pull));
    this.pull.on('complete', self.push.cancel.bind(self.push));
  }

  function addOneListener(ee, event, listener) {
    if (ee.listeners(event).indexOf(listener) == -1) {
      ee.on(event, listener);
    }
  }

  this.on('newListener', function (event) {
    if (event === 'change') {
      addOneListener(self.pull, 'change', pullChange);
      addOneListener(self.push, 'change', pushChange);
    } else if (event === 'denied') {
      addOneListener(self.pull, 'denied', pullDenied);
      addOneListener(self.push, 'denied', pushDenied);
    } else if (event === 'active') {
      addOneListener(self.pull, 'active', pullActive);
      addOneListener(self.push, 'active', pushActive);
    } else if (event === 'paused') {
      addOneListener(self.pull, 'paused', pullPaused);
      addOneListener(self.push, 'paused', pushPaused);
    }
  });

  this.on('removeListener', function (event) {
    if (event === 'change') {
      self.pull.removeListener('change', pullChange);
      self.push.removeListener('change', pushChange);
    } else if (event === 'denied') {
      self.pull.removeListener('denied', pullDenied);
      self.push.removeListener('denied', pushDenied);
    } else if (event === 'active') {
      self.pull.removeListener('active', pullActive);
      self.push.removeListener('active', pushActive);
    } else if (event === 'paused') {
      self.pull.removeListener('paused', pullPaused);
      self.push.removeListener('paused', pushPaused);
    }
  });

  this.pull.on('removeListener', removeAll('pull'));
  this.push.on('removeListener', removeAll('push'));

  var promise = PouchPromise$1.all([
    this.push,
    this.pull
  ]).then(function (resp) {
    var out = {
      push: resp[0],
      pull: resp[1]
    };
    self.emit('complete', out);
    if (callback) {
      callback(null, out);
    }
    self.removeAllListeners();
    return out;
  }, function (err) {
    self.cancel();
    if (callback) {
      // if there's a callback, then the callback can receive
      // the error event
      callback(err);
    } else {
      // if there's no callback, then we're safe to emit an error
      // event, which would otherwise throw an unhandled error
      // due to 'error' being a special event in EventEmitters
      self.emit('error', err);
    }
    self.removeAllListeners();
    if (callback) {
      // no sense throwing if we're already emitting an 'error' event
      throw err;
    }
  });

  this.then = function (success, err) {
    return promise.then(success, err);
  };

  this.catch = function (err) {
    return promise.catch(err);
  };
}

Sync.prototype.cancel = function () {
  if (!this.canceled) {
    this.canceled = true;
    this.push.cancel();
    this.pull.cancel();
  }
};

function replication(PouchDB) {
  PouchDB.replicate = replicateWrapper;
  PouchDB.sync = sync$1;

  Object.defineProperty(PouchDB.prototype, 'replicate', {
    get: function () {
      var self = this;
      return {
        from: function (other, opts, callback) {
          return self.constructor.replicate(other, self, opts, callback);
        },
        to: function (other, opts, callback) {
          return self.constructor.replicate(self, other, opts, callback);
        }
      };
    }
  });

  PouchDB.prototype.sync = function (dbName, opts, callback) {
    return this.constructor.sync(this, dbName, opts, callback);
  };
}

PouchDB$3$1.plugin(IDBPouch)
  .plugin(WebSqlPouch)
  .plugin(HttpPouch$1)
  .plugin(mapreduce)
  .plugin(replication);

/* global Promise, isServer */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

try {
	var db = isServer ? null : new PouchDB$3$1('web-code', {});
} catch (e) {
	console.log(e);
}
function updateDBDoc(_id, obj) {

	updateDBDoc.promise = updateDBDoc.promise || Promise.resolve();

	/* update last open folder in db */
	return updateDBDoc.promise = updateDBDoc.promise
		.then(function () {
			return db.get(_id)
		})
		.catch(function (e) {
			if (e.status === 404) {
				return { _id: _id }
			}
			if (e.name === 'indexed_db_went_bad') {
				console.log('Updating DB Failed: ' + e.reason);
				return;
			}
			throw e;
		})
		.then(function (doc) {
			if (!doc) return;
			Object.keys(obj).forEach(function (key) {
				doc[key] = obj[key];
			});
			db.put(doc);
		});
}

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// resolves . and .. elements in a path array with directory names there
// must be no slashes, empty elements, or device names (c:\) in the array
// (so also no leading and trailing slashes - it does not distinguish
// relative and absolute paths)
function normalizeArray(parts, allowAboveRoot) {
  // if the path tries to go above the root, `up` ends up > 0
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
    var last = parts[i];
    if (last === '.') {
      parts.splice(i, 1);
    } else if (last === '..') {
      parts.splice(i, 1);
      up++;
    } else if (up) {
      parts.splice(i, 1);
      up--;
    }
  }

  // if the path is allowed to go above the root, restore leading ..s
  if (allowAboveRoot) {
    for (; up--; up) {
      parts.unshift('..');
    }
  }

  return parts;
}

// Split a filename into [root, dir, basename, ext], unix version
// 'root' is just a slash, or nothing.
var splitPathRe =
    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
var splitPath = function(filename) {
  return splitPathRe.exec(filename).slice(1);
};

// path.resolve([from ...], to)
// posix version
function resolve$1() {
  var resolvedPath = '',
      resolvedAbsolute = false;

  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    var path = (i >= 0) ? arguments[i] : '/';

    // Skip empty and invalid entries
    if (typeof path !== 'string') {
      throw new TypeError('Arguments to path.resolve must be strings');
    } else if (!path) {
      continue;
    }

    resolvedPath = path + '/' + resolvedPath;
    resolvedAbsolute = path.charAt(0) === '/';
  }

  // At this point the path should be resolved to a full absolute path, but
  // handle relative paths to be safe (might happen when process.cwd() fails)

  // Normalize the path
  resolvedPath = normalizeArray(filter$1(resolvedPath.split('/'), function(p) {
    return !!p;
  }), !resolvedAbsolute).join('/');

  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
}

// path.normalize(path)
// posix version
function normalize$1(path) {
  var isPathAbsolute = isAbsolute(path),
      trailingSlash = substr(path, -1) === '/';

  // Normalize the path
  path = normalizeArray(filter$1(path.split('/'), function(p) {
    return !!p;
  }), !isPathAbsolute).join('/');

  if (!path && !isPathAbsolute) {
    path = '.';
  }
  if (path && trailingSlash) {
    path += '/';
  }

  return (isPathAbsolute ? '/' : '') + path;
}

// posix version
function isAbsolute(path) {
  return path.charAt(0) === '/';
}

// posix version
function join() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return normalize$1(filter$1(paths, function(p, index) {
    if (typeof p !== 'string') {
      throw new TypeError('Arguments to path.join must be strings');
    }
    return p;
  }).join('/'));
}


// path.relative(from, to)
// posix version





function dirname(path) {
  var result = splitPath(path),
      root = result[0],
      dir = result[1];

  if (!root && !dir) {
    // No dirname whatsoever
    return '.';
  }

  if (dir) {
    // It has a dirname, strip trailing slash
    dir = dir.substr(0, dir.length - 1);
  }

  return root + dir;
}

function basename(path, ext) {
  var f = splitPath(path)[2];
  // TODO: make this comparison case-insensitive on windows?
  if (ext && f.substr(-1 * ext.length) === ext) {
    f = f.substr(0, f.length - ext.length);
  }
  return f;
}


function extname(path) {
  return splitPath(path)[3];
}
function filter$1 (xs, f) {
    if (xs.filter) return xs.filter(f);
    var res = [];
    for (var i = 0; i < xs.length; i++) {
        if (f(xs[i], i, xs)) res.push(xs[i]);
    }
    return res;
}

// String.prototype.substr - negative index don't work in IE8
var substr = 'ab'.substr(-1) === 'b' ?
    function (str, start, len) { return str.substr(start, len) } :
    function (str, start, len) {
        if (start < 0) start = str.length + start;
        return str.substr(start, len);
    };

var empty = {};


var empty$1 = Object.freeze({
	default: empty
});

var types = {
	"application/andrew-inset": ["ez"],
	"application/applixware": ["aw"],
	"application/atom+xml": ["atom"],
	"application/atomcat+xml": ["atomcat"],
	"application/atomsvc+xml": ["atomsvc"],
	"application/bdoc": ["bdoc"],
	"application/ccxml+xml": ["ccxml"],
	"application/cdmi-capability": ["cdmia"],
	"application/cdmi-container": ["cdmic"],
	"application/cdmi-domain": ["cdmid"],
	"application/cdmi-object": ["cdmio"],
	"application/cdmi-queue": ["cdmiq"],
	"application/cu-seeme": ["cu"],
	"application/dash+xml": ["mpd"],
	"application/davmount+xml": ["davmount"],
	"application/docbook+xml": ["dbk"],
	"application/dssc+der": ["dssc"],
	"application/dssc+xml": ["xdssc"],
	"application/ecmascript": ["ecma"],
	"application/emma+xml": ["emma"],
	"application/epub+zip": ["epub"],
	"application/exi": ["exi"],
	"application/font-tdpfr": ["pfr"],
	"application/font-woff": [],
	"application/font-woff2": [],
	"application/geo+json": ["geojson"],
	"application/gml+xml": ["gml"],
	"application/gpx+xml": ["gpx"],
	"application/gxf": ["gxf"],
	"application/gzip": ["gz"],
	"application/hyperstudio": ["stk"],
	"application/inkml+xml": ["ink","inkml"],
	"application/ipfix": ["ipfix"],
	"application/java-archive": ["jar","war","ear"],
	"application/java-serialized-object": ["ser"],
	"application/java-vm": ["class"],
	"application/javascript": ["js","mjs"],
	"application/json": ["json","map"],
	"application/json5": ["json5"],
	"application/jsonml+json": ["jsonml"],
	"application/ld+json": ["jsonld"],
	"application/lost+xml": ["lostxml"],
	"application/mac-binhex40": ["hqx"],
	"application/mac-compactpro": ["cpt"],
	"application/mads+xml": ["mads"],
	"application/manifest+json": ["webmanifest"],
	"application/marc": ["mrc"],
	"application/marcxml+xml": ["mrcx"],
	"application/mathematica": ["ma","nb","mb"],
	"application/mathml+xml": ["mathml"],
	"application/mbox": ["mbox"],
	"application/mediaservercontrol+xml": ["mscml"],
	"application/metalink+xml": ["metalink"],
	"application/metalink4+xml": ["meta4"],
	"application/mets+xml": ["mets"],
	"application/mods+xml": ["mods"],
	"application/mp21": ["m21","mp21"],
	"application/mp4": ["mp4s","m4p"],
	"application/msword": ["doc","dot"],
	"application/mxf": ["mxf"],
	"application/octet-stream": ["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"],
	"application/oda": ["oda"],
	"application/oebps-package+xml": ["opf"],
	"application/ogg": ["ogx"],
	"application/omdoc+xml": ["omdoc"],
	"application/onenote": ["onetoc","onetoc2","onetmp","onepkg"],
	"application/oxps": ["oxps"],
	"application/patch-ops-error+xml": ["xer"],
	"application/pdf": ["pdf"],
	"application/pgp-encrypted": ["pgp"],
	"application/pgp-signature": ["asc","sig"],
	"application/pics-rules": ["prf"],
	"application/pkcs10": ["p10"],
	"application/pkcs7-mime": ["p7m","p7c"],
	"application/pkcs7-signature": ["p7s"],
	"application/pkcs8": ["p8"],
	"application/pkix-attr-cert": ["ac"],
	"application/pkix-cert": ["cer"],
	"application/pkix-crl": ["crl"],
	"application/pkix-pkipath": ["pkipath"],
	"application/pkixcmp": ["pki"],
	"application/pls+xml": ["pls"],
	"application/postscript": ["ai","eps","ps"],
	"application/prs.cww": ["cww"],
	"application/pskc+xml": ["pskcxml"],
	"application/raml+yaml": ["raml"],
	"application/rdf+xml": ["rdf"],
	"application/reginfo+xml": ["rif"],
	"application/relax-ng-compact-syntax": ["rnc"],
	"application/resource-lists+xml": ["rl"],
	"application/resource-lists-diff+xml": ["rld"],
	"application/rls-services+xml": ["rs"],
	"application/rpki-ghostbusters": ["gbr"],
	"application/rpki-manifest": ["mft"],
	"application/rpki-roa": ["roa"],
	"application/rsd+xml": ["rsd"],
	"application/rss+xml": ["rss"],
	"application/rtf": ["rtf"],
	"application/sbml+xml": ["sbml"],
	"application/scvp-cv-request": ["scq"],
	"application/scvp-cv-response": ["scs"],
	"application/scvp-vp-request": ["spq"],
	"application/scvp-vp-response": ["spp"],
	"application/sdp": ["sdp"],
	"application/set-payment-initiation": ["setpay"],
	"application/set-registration-initiation": ["setreg"],
	"application/shf+xml": ["shf"],
	"application/smil+xml": ["smi","smil"],
	"application/sparql-query": ["rq"],
	"application/sparql-results+xml": ["srx"],
	"application/srgs": ["gram"],
	"application/srgs+xml": ["grxml"],
	"application/sru+xml": ["sru"],
	"application/ssdl+xml": ["ssdl"],
	"application/ssml+xml": ["ssml"],
	"application/tei+xml": ["tei","teicorpus"],
	"application/thraud+xml": ["tfi"],
	"application/timestamped-data": ["tsd"],
	"application/vnd.3gpp.pic-bw-large": ["plb"],
	"application/vnd.3gpp.pic-bw-small": ["psb"],
	"application/vnd.3gpp.pic-bw-var": ["pvb"],
	"application/vnd.3gpp2.tcap": ["tcap"],
	"application/vnd.3m.post-it-notes": ["pwn"],
	"application/vnd.accpac.simply.aso": ["aso"],
	"application/vnd.accpac.simply.imp": ["imp"],
	"application/vnd.acucobol": ["acu"],
	"application/vnd.acucorp": ["atc","acutc"],
	"application/vnd.adobe.air-application-installer-package+zip": ["air"],
	"application/vnd.adobe.formscentral.fcdt": ["fcdt"],
	"application/vnd.adobe.fxp": ["fxp","fxpl"],
	"application/vnd.adobe.xdp+xml": ["xdp"],
	"application/vnd.adobe.xfdf": ["xfdf"],
	"application/vnd.ahead.space": ["ahead"],
	"application/vnd.airzip.filesecure.azf": ["azf"],
	"application/vnd.airzip.filesecure.azs": ["azs"],
	"application/vnd.amazon.ebook": ["azw"],
	"application/vnd.americandynamics.acc": ["acc"],
	"application/vnd.amiga.ami": ["ami"],
	"application/vnd.android.package-archive": ["apk"],
	"application/vnd.anser-web-certificate-issue-initiation": ["cii"],
	"application/vnd.anser-web-funds-transfer-initiation": ["fti"],
	"application/vnd.antix.game-component": ["atx"],
	"application/vnd.apple.installer+xml": ["mpkg"],
	"application/vnd.apple.mpegurl": ["m3u8"],
	"application/vnd.apple.pkpass": ["pkpass"],
	"application/vnd.aristanetworks.swi": ["swi"],
	"application/vnd.astraea-software.iota": ["iota"],
	"application/vnd.audiograph": ["aep"],
	"application/vnd.blueice.multipass": ["mpm"],
	"application/vnd.bmi": ["bmi"],
	"application/vnd.businessobjects": ["rep"],
	"application/vnd.chemdraw+xml": ["cdxml"],
	"application/vnd.chipnuts.karaoke-mmd": ["mmd"],
	"application/vnd.cinderella": ["cdy"],
	"application/vnd.claymore": ["cla"],
	"application/vnd.cloanto.rp9": ["rp9"],
	"application/vnd.clonk.c4group": ["c4g","c4d","c4f","c4p","c4u"],
	"application/vnd.cluetrust.cartomobile-config": ["c11amc"],
	"application/vnd.cluetrust.cartomobile-config-pkg": ["c11amz"],
	"application/vnd.commonspace": ["csp"],
	"application/vnd.contact.cmsg": ["cdbcmsg"],
	"application/vnd.cosmocaller": ["cmc"],
	"application/vnd.crick.clicker": ["clkx"],
	"application/vnd.crick.clicker.keyboard": ["clkk"],
	"application/vnd.crick.clicker.palette": ["clkp"],
	"application/vnd.crick.clicker.template": ["clkt"],
	"application/vnd.crick.clicker.wordbank": ["clkw"],
	"application/vnd.criticaltools.wbs+xml": ["wbs"],
	"application/vnd.ctc-posml": ["pml"],
	"application/vnd.cups-ppd": ["ppd"],
	"application/vnd.curl.car": ["car"],
	"application/vnd.curl.pcurl": ["pcurl"],
	"application/vnd.dart": ["dart"],
	"application/vnd.data-vision.rdz": ["rdz"],
	"application/vnd.dece.data": ["uvf","uvvf","uvd","uvvd"],
	"application/vnd.dece.ttml+xml": ["uvt","uvvt"],
	"application/vnd.dece.unspecified": ["uvx","uvvx"],
	"application/vnd.dece.zip": ["uvz","uvvz"],
	"application/vnd.denovo.fcselayout-link": ["fe_launch"],
	"application/vnd.dna": ["dna"],
	"application/vnd.dolby.mlp": ["mlp"],
	"application/vnd.dpgraph": ["dpg"],
	"application/vnd.dreamfactory": ["dfac"],
	"application/vnd.ds-keypoint": ["kpxx"],
	"application/vnd.dvb.ait": ["ait"],
	"application/vnd.dvb.service": ["svc"],
	"application/vnd.dynageo": ["geo"],
	"application/vnd.ecowin.chart": ["mag"],
	"application/vnd.enliven": ["nml"],
	"application/vnd.epson.esf": ["esf"],
	"application/vnd.epson.msf": ["msf"],
	"application/vnd.epson.quickanime": ["qam"],
	"application/vnd.epson.salt": ["slt"],
	"application/vnd.epson.ssf": ["ssf"],
	"application/vnd.eszigno3+xml": ["es3","et3"],
	"application/vnd.ezpix-album": ["ez2"],
	"application/vnd.ezpix-package": ["ez3"],
	"application/vnd.fdf": ["fdf"],
	"application/vnd.fdsn.mseed": ["mseed"],
	"application/vnd.fdsn.seed": ["seed","dataless"],
	"application/vnd.flographit": ["gph"],
	"application/vnd.fluxtime.clip": ["ftc"],
	"application/vnd.framemaker": ["fm","frame","maker","book"],
	"application/vnd.frogans.fnc": ["fnc"],
	"application/vnd.frogans.ltf": ["ltf"],
	"application/vnd.fsc.weblaunch": ["fsc"],
	"application/vnd.fujitsu.oasys": ["oas"],
	"application/vnd.fujitsu.oasys2": ["oa2"],
	"application/vnd.fujitsu.oasys3": ["oa3"],
	"application/vnd.fujitsu.oasysgp": ["fg5"],
	"application/vnd.fujitsu.oasysprs": ["bh2"],
	"application/vnd.fujixerox.ddd": ["ddd"],
	"application/vnd.fujixerox.docuworks": ["xdw"],
	"application/vnd.fujixerox.docuworks.binder": ["xbd"],
	"application/vnd.fuzzysheet": ["fzs"],
	"application/vnd.genomatix.tuxedo": ["txd"],
	"application/vnd.geogebra.file": ["ggb"],
	"application/vnd.geogebra.tool": ["ggt"],
	"application/vnd.geometry-explorer": ["gex","gre"],
	"application/vnd.geonext": ["gxt"],
	"application/vnd.geoplan": ["g2w"],
	"application/vnd.geospace": ["g3w"],
	"application/vnd.gmx": ["gmx"],
	"application/vnd.google-apps.document": ["gdoc"],
	"application/vnd.google-apps.presentation": ["gslides"],
	"application/vnd.google-apps.spreadsheet": ["gsheet"],
	"application/vnd.google-earth.kml+xml": ["kml"],
	"application/vnd.google-earth.kmz": ["kmz"],
	"application/vnd.grafeq": ["gqf","gqs"],
	"application/vnd.groove-account": ["gac"],
	"application/vnd.groove-help": ["ghf"],
	"application/vnd.groove-identity-message": ["gim"],
	"application/vnd.groove-injector": ["grv"],
	"application/vnd.groove-tool-message": ["gtm"],
	"application/vnd.groove-tool-template": ["tpl"],
	"application/vnd.groove-vcard": ["vcg"],
	"application/vnd.hal+xml": ["hal"],
	"application/vnd.handheld-entertainment+xml": ["zmm"],
	"application/vnd.hbci": ["hbci"],
	"application/vnd.hhe.lesson-player": ["les"],
	"application/vnd.hp-hpgl": ["hpgl"],
	"application/vnd.hp-hpid": ["hpid"],
	"application/vnd.hp-hps": ["hps"],
	"application/vnd.hp-jlyt": ["jlt"],
	"application/vnd.hp-pcl": ["pcl"],
	"application/vnd.hp-pclxl": ["pclxl"],
	"application/vnd.hydrostatix.sof-data": ["sfd-hdstx"],
	"application/vnd.ibm.minipay": ["mpy"],
	"application/vnd.ibm.modcap": ["afp","listafp","list3820"],
	"application/vnd.ibm.rights-management": ["irm"],
	"application/vnd.ibm.secure-container": ["sc"],
	"application/vnd.iccprofile": ["icc","icm"],
	"application/vnd.igloader": ["igl"],
	"application/vnd.immervision-ivp": ["ivp"],
	"application/vnd.immervision-ivu": ["ivu"],
	"application/vnd.insors.igm": ["igm"],
	"application/vnd.intercon.formnet": ["xpw","xpx"],
	"application/vnd.intergeo": ["i2g"],
	"application/vnd.intu.qbo": ["qbo"],
	"application/vnd.intu.qfx": ["qfx"],
	"application/vnd.ipunplugged.rcprofile": ["rcprofile"],
	"application/vnd.irepository.package+xml": ["irp"],
	"application/vnd.is-xpr": ["xpr"],
	"application/vnd.isac.fcs": ["fcs"],
	"application/vnd.jam": ["jam"],
	"application/vnd.jcp.javame.midlet-rms": ["rms"],
	"application/vnd.jisp": ["jisp"],
	"application/vnd.joost.joda-archive": ["joda"],
	"application/vnd.kahootz": ["ktz","ktr"],
	"application/vnd.kde.karbon": ["karbon"],
	"application/vnd.kde.kchart": ["chrt"],
	"application/vnd.kde.kformula": ["kfo"],
	"application/vnd.kde.kivio": ["flw"],
	"application/vnd.kde.kontour": ["kon"],
	"application/vnd.kde.kpresenter": ["kpr","kpt"],
	"application/vnd.kde.kspread": ["ksp"],
	"application/vnd.kde.kword": ["kwd","kwt"],
	"application/vnd.kenameaapp": ["htke"],
	"application/vnd.kidspiration": ["kia"],
	"application/vnd.kinar": ["kne","knp"],
	"application/vnd.koan": ["skp","skd","skt","skm"],
	"application/vnd.kodak-descriptor": ["sse"],
	"application/vnd.las.las+xml": ["lasxml"],
	"application/vnd.llamagraphics.life-balance.desktop": ["lbd"],
	"application/vnd.llamagraphics.life-balance.exchange+xml": ["lbe"],
	"application/vnd.lotus-1-2-3": ["123"],
	"application/vnd.lotus-approach": ["apr"],
	"application/vnd.lotus-freelance": ["pre"],
	"application/vnd.lotus-notes": ["nsf"],
	"application/vnd.lotus-organizer": ["org"],
	"application/vnd.lotus-screencam": ["scm"],
	"application/vnd.lotus-wordpro": ["lwp"],
	"application/vnd.macports.portpkg": ["portpkg"],
	"application/vnd.mcd": ["mcd"],
	"application/vnd.medcalcdata": ["mc1"],
	"application/vnd.mediastation.cdkey": ["cdkey"],
	"application/vnd.mfer": ["mwf"],
	"application/vnd.mfmp": ["mfm"],
	"application/vnd.micrografx.flo": ["flo"],
	"application/vnd.micrografx.igx": ["igx"],
	"application/vnd.mif": ["mif"],
	"application/vnd.mobius.daf": ["daf"],
	"application/vnd.mobius.dis": ["dis"],
	"application/vnd.mobius.mbk": ["mbk"],
	"application/vnd.mobius.mqy": ["mqy"],
	"application/vnd.mobius.msl": ["msl"],
	"application/vnd.mobius.plc": ["plc"],
	"application/vnd.mobius.txf": ["txf"],
	"application/vnd.mophun.application": ["mpn"],
	"application/vnd.mophun.certificate": ["mpc"],
	"application/vnd.mozilla.xul+xml": ["xul"],
	"application/vnd.ms-artgalry": ["cil"],
	"application/vnd.ms-cab-compressed": ["cab"],
	"application/vnd.ms-excel": ["xls","xlm","xla","xlc","xlt","xlw"],
	"application/vnd.ms-excel.addin.macroenabled.12": ["xlam"],
	"application/vnd.ms-excel.sheet.binary.macroenabled.12": ["xlsb"],
	"application/vnd.ms-excel.sheet.macroenabled.12": ["xlsm"],
	"application/vnd.ms-excel.template.macroenabled.12": ["xltm"],
	"application/vnd.ms-fontobject": ["eot"],
	"application/vnd.ms-htmlhelp": ["chm"],
	"application/vnd.ms-ims": ["ims"],
	"application/vnd.ms-lrm": ["lrm"],
	"application/vnd.ms-officetheme": ["thmx"],
	"application/vnd.ms-outlook": ["msg"],
	"application/vnd.ms-pki.seccat": ["cat"],
	"application/vnd.ms-pki.stl": ["stl"],
	"application/vnd.ms-powerpoint": ["ppt","pps","pot"],
	"application/vnd.ms-powerpoint.addin.macroenabled.12": ["ppam"],
	"application/vnd.ms-powerpoint.presentation.macroenabled.12": ["pptm"],
	"application/vnd.ms-powerpoint.slide.macroenabled.12": ["sldm"],
	"application/vnd.ms-powerpoint.slideshow.macroenabled.12": ["ppsm"],
	"application/vnd.ms-powerpoint.template.macroenabled.12": ["potm"],
	"application/vnd.ms-project": ["mpp","mpt"],
	"application/vnd.ms-word.document.macroenabled.12": ["docm"],
	"application/vnd.ms-word.template.macroenabled.12": ["dotm"],
	"application/vnd.ms-works": ["wps","wks","wcm","wdb"],
	"application/vnd.ms-wpl": ["wpl"],
	"application/vnd.ms-xpsdocument": ["xps"],
	"application/vnd.mseq": ["mseq"],
	"application/vnd.musician": ["mus"],
	"application/vnd.muvee.style": ["msty"],
	"application/vnd.mynfc": ["taglet"],
	"application/vnd.neurolanguage.nlu": ["nlu"],
	"application/vnd.nitf": ["ntf","nitf"],
	"application/vnd.noblenet-directory": ["nnd"],
	"application/vnd.noblenet-sealer": ["nns"],
	"application/vnd.noblenet-web": ["nnw"],
	"application/vnd.nokia.n-gage.data": ["ngdat"],
	"application/vnd.nokia.n-gage.symbian.install": ["n-gage"],
	"application/vnd.nokia.radio-preset": ["rpst"],
	"application/vnd.nokia.radio-presets": ["rpss"],
	"application/vnd.novadigm.edm": ["edm"],
	"application/vnd.novadigm.edx": ["edx"],
	"application/vnd.novadigm.ext": ["ext"],
	"application/vnd.oasis.opendocument.chart": ["odc"],
	"application/vnd.oasis.opendocument.chart-template": ["otc"],
	"application/vnd.oasis.opendocument.database": ["odb"],
	"application/vnd.oasis.opendocument.formula": ["odf"],
	"application/vnd.oasis.opendocument.formula-template": ["odft"],
	"application/vnd.oasis.opendocument.graphics": ["odg"],
	"application/vnd.oasis.opendocument.graphics-template": ["otg"],
	"application/vnd.oasis.opendocument.image": ["odi"],
	"application/vnd.oasis.opendocument.image-template": ["oti"],
	"application/vnd.oasis.opendocument.presentation": ["odp"],
	"application/vnd.oasis.opendocument.presentation-template": ["otp"],
	"application/vnd.oasis.opendocument.spreadsheet": ["ods"],
	"application/vnd.oasis.opendocument.spreadsheet-template": ["ots"],
	"application/vnd.oasis.opendocument.text": ["odt"],
	"application/vnd.oasis.opendocument.text-master": ["odm"],
	"application/vnd.oasis.opendocument.text-template": ["ott"],
	"application/vnd.oasis.opendocument.text-web": ["oth"],
	"application/vnd.olpc-sugar": ["xo"],
	"application/vnd.oma.dd2+xml": ["dd2"],
	"application/vnd.openofficeorg.extension": ["oxt"],
	"application/vnd.openxmlformats-officedocument.presentationml.presentation": ["pptx"],
	"application/vnd.openxmlformats-officedocument.presentationml.slide": ["sldx"],
	"application/vnd.openxmlformats-officedocument.presentationml.slideshow": ["ppsx"],
	"application/vnd.openxmlformats-officedocument.presentationml.template": ["potx"],
	"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": ["xlsx"],
	"application/vnd.openxmlformats-officedocument.spreadsheetml.template": ["xltx"],
	"application/vnd.openxmlformats-officedocument.wordprocessingml.document": ["docx"],
	"application/vnd.openxmlformats-officedocument.wordprocessingml.template": ["dotx"],
	"application/vnd.osgeo.mapguide.package": ["mgp"],
	"application/vnd.osgi.dp": ["dp"],
	"application/vnd.osgi.subsystem": ["esa"],
	"application/vnd.palm": ["pdb","pqa","oprc"],
	"application/vnd.pawaafile": ["paw"],
	"application/vnd.pg.format": ["str"],
	"application/vnd.pg.osasli": ["ei6"],
	"application/vnd.picsel": ["efif"],
	"application/vnd.pmi.widget": ["wg"],
	"application/vnd.pocketlearn": ["plf"],
	"application/vnd.powerbuilder6": ["pbd"],
	"application/vnd.previewsystems.box": ["box"],
	"application/vnd.proteus.magazine": ["mgz"],
	"application/vnd.publishare-delta-tree": ["qps"],
	"application/vnd.pvi.ptid1": ["ptid"],
	"application/vnd.quark.quarkxpress": ["qxd","qxt","qwd","qwt","qxl","qxb"],
	"application/vnd.realvnc.bed": ["bed"],
	"application/vnd.recordare.musicxml": ["mxl"],
	"application/vnd.recordare.musicxml+xml": ["musicxml"],
	"application/vnd.rig.cryptonote": ["cryptonote"],
	"application/vnd.rim.cod": ["cod"],
	"application/vnd.rn-realmedia": ["rm"],
	"application/vnd.rn-realmedia-vbr": ["rmvb"],
	"application/vnd.route66.link66+xml": ["link66"],
	"application/vnd.sailingtracker.track": ["st"],
	"application/vnd.seemail": ["see"],
	"application/vnd.sema": ["sema"],
	"application/vnd.semd": ["semd"],
	"application/vnd.semf": ["semf"],
	"application/vnd.shana.informed.formdata": ["ifm"],
	"application/vnd.shana.informed.formtemplate": ["itp"],
	"application/vnd.shana.informed.interchange": ["iif"],
	"application/vnd.shana.informed.package": ["ipk"],
	"application/vnd.simtech-mindmapper": ["twd","twds"],
	"application/vnd.smaf": ["mmf"],
	"application/vnd.smart.teacher": ["teacher"],
	"application/vnd.solent.sdkm+xml": ["sdkm","sdkd"],
	"application/vnd.spotfire.dxp": ["dxp"],
	"application/vnd.spotfire.sfs": ["sfs"],
	"application/vnd.stardivision.calc": ["sdc"],
	"application/vnd.stardivision.draw": ["sda"],
	"application/vnd.stardivision.impress": ["sdd"],
	"application/vnd.stardivision.math": ["smf"],
	"application/vnd.stardivision.writer": ["sdw","vor"],
	"application/vnd.stardivision.writer-global": ["sgl"],
	"application/vnd.stepmania.package": ["smzip"],
	"application/vnd.stepmania.stepchart": ["sm"],
	"application/vnd.sun.wadl+xml": ["wadl"],
	"application/vnd.sun.xml.calc": ["sxc"],
	"application/vnd.sun.xml.calc.template": ["stc"],
	"application/vnd.sun.xml.draw": ["sxd"],
	"application/vnd.sun.xml.draw.template": ["std"],
	"application/vnd.sun.xml.impress": ["sxi"],
	"application/vnd.sun.xml.impress.template": ["sti"],
	"application/vnd.sun.xml.math": ["sxm"],
	"application/vnd.sun.xml.writer": ["sxw"],
	"application/vnd.sun.xml.writer.global": ["sxg"],
	"application/vnd.sun.xml.writer.template": ["stw"],
	"application/vnd.sus-calendar": ["sus","susp"],
	"application/vnd.svd": ["svd"],
	"application/vnd.symbian.install": ["sis","sisx"],
	"application/vnd.syncml+xml": ["xsm"],
	"application/vnd.syncml.dm+wbxml": ["bdm"],
	"application/vnd.syncml.dm+xml": ["xdm"],
	"application/vnd.tao.intent-module-archive": ["tao"],
	"application/vnd.tcpdump.pcap": ["pcap","cap","dmp"],
	"application/vnd.tmobile-livetv": ["tmo"],
	"application/vnd.trid.tpt": ["tpt"],
	"application/vnd.triscape.mxs": ["mxs"],
	"application/vnd.trueapp": ["tra"],
	"application/vnd.ufdl": ["ufd","ufdl"],
	"application/vnd.uiq.theme": ["utz"],
	"application/vnd.umajin": ["umj"],
	"application/vnd.unity": ["unityweb"],
	"application/vnd.uoml+xml": ["uoml"],
	"application/vnd.vcx": ["vcx"],
	"application/vnd.visio": ["vsd","vst","vss","vsw"],
	"application/vnd.visionary": ["vis"],
	"application/vnd.vsf": ["vsf"],
	"application/vnd.wap.wbxml": ["wbxml"],
	"application/vnd.wap.wmlc": ["wmlc"],
	"application/vnd.wap.wmlscriptc": ["wmlsc"],
	"application/vnd.webturbo": ["wtb"],
	"application/vnd.wolfram.player": ["nbp"],
	"application/vnd.wordperfect": ["wpd"],
	"application/vnd.wqd": ["wqd"],
	"application/vnd.wt.stf": ["stf"],
	"application/vnd.xara": ["xar"],
	"application/vnd.xfdl": ["xfdl"],
	"application/vnd.yamaha.hv-dic": ["hvd"],
	"application/vnd.yamaha.hv-script": ["hvs"],
	"application/vnd.yamaha.hv-voice": ["hvp"],
	"application/vnd.yamaha.openscoreformat": ["osf"],
	"application/vnd.yamaha.openscoreformat.osfpvg+xml": ["osfpvg"],
	"application/vnd.yamaha.smaf-audio": ["saf"],
	"application/vnd.yamaha.smaf-phrase": ["spf"],
	"application/vnd.yellowriver-custom-menu": ["cmp"],
	"application/vnd.zul": ["zir","zirz"],
	"application/vnd.zzazz.deck+xml": ["zaz"],
	"application/voicexml+xml": ["vxml"],
	"application/wasm": ["wasm"],
	"application/widget": ["wgt"],
	"application/winhlp": ["hlp"],
	"application/wsdl+xml": ["wsdl"],
	"application/wspolicy+xml": ["wspolicy"],
	"application/x-7z-compressed": ["7z"],
	"application/x-abiword": ["abw"],
	"application/x-ace-compressed": ["ace"],
	"application/x-apple-diskimage": [],
	"application/x-arj": ["arj"],
	"application/x-authorware-bin": ["aab","x32","u32","vox"],
	"application/x-authorware-map": ["aam"],
	"application/x-authorware-seg": ["aas"],
	"application/x-bcpio": ["bcpio"],
	"application/x-bdoc": [],
	"application/x-bittorrent": ["torrent"],
	"application/x-blorb": ["blb","blorb"],
	"application/x-bzip": ["bz"],
	"application/x-bzip2": ["bz2","boz"],
	"application/x-cbr": ["cbr","cba","cbt","cbz","cb7"],
	"application/x-cdlink": ["vcd"],
	"application/x-cfs-compressed": ["cfs"],
	"application/x-chat": ["chat"],
	"application/x-chess-pgn": ["pgn"],
	"application/x-chrome-extension": ["crx"],
	"application/x-cocoa": ["cco"],
	"application/x-conference": ["nsc"],
	"application/x-cpio": ["cpio"],
	"application/x-csh": ["csh"],
	"application/x-debian-package": ["udeb"],
	"application/x-dgc-compressed": ["dgc"],
	"application/x-director": ["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"],
	"application/x-doom": ["wad"],
	"application/x-dtbncx+xml": ["ncx"],
	"application/x-dtbook+xml": ["dtb"],
	"application/x-dtbresource+xml": ["res"],
	"application/x-dvi": ["dvi"],
	"application/x-envoy": ["evy"],
	"application/x-eva": ["eva"],
	"application/x-font-bdf": ["bdf"],
	"application/x-font-ghostscript": ["gsf"],
	"application/x-font-linux-psf": ["psf"],
	"application/x-font-pcf": ["pcf"],
	"application/x-font-snf": ["snf"],
	"application/x-font-type1": ["pfa","pfb","pfm","afm"],
	"application/x-freearc": ["arc"],
	"application/x-futuresplash": ["spl"],
	"application/x-gca-compressed": ["gca"],
	"application/x-glulx": ["ulx"],
	"application/x-gnumeric": ["gnumeric"],
	"application/x-gramps-xml": ["gramps"],
	"application/x-gtar": ["gtar"],
	"application/x-hdf": ["hdf"],
	"application/x-httpd-php": ["php"],
	"application/x-install-instructions": ["install"],
	"application/x-iso9660-image": [],
	"application/x-java-archive-diff": ["jardiff"],
	"application/x-java-jnlp-file": ["jnlp"],
	"application/x-latex": ["latex"],
	"application/x-lua-bytecode": ["luac"],
	"application/x-lzh-compressed": ["lzh","lha"],
	"application/x-makeself": ["run"],
	"application/x-mie": ["mie"],
	"application/x-mobipocket-ebook": ["prc","mobi"],
	"application/x-ms-application": ["application"],
	"application/x-ms-shortcut": ["lnk"],
	"application/x-ms-wmd": ["wmd"],
	"application/x-ms-wmz": ["wmz"],
	"application/x-ms-xbap": ["xbap"],
	"application/x-msaccess": ["mdb"],
	"application/x-msbinder": ["obd"],
	"application/x-mscardfile": ["crd"],
	"application/x-msclip": ["clp"],
	"application/x-msdos-program": [],
	"application/x-msdownload": ["com","bat"],
	"application/x-msmediaview": ["mvb","m13","m14"],
	"application/x-msmetafile": ["wmf","emf","emz"],
	"application/x-msmoney": ["mny"],
	"application/x-mspublisher": ["pub"],
	"application/x-msschedule": ["scd"],
	"application/x-msterminal": ["trm"],
	"application/x-mswrite": ["wri"],
	"application/x-netcdf": ["nc","cdf"],
	"application/x-ns-proxy-autoconfig": ["pac"],
	"application/x-nzb": ["nzb"],
	"application/x-perl": ["pl","pm"],
	"application/x-pilot": [],
	"application/x-pkcs12": ["p12","pfx"],
	"application/x-pkcs7-certificates": ["p7b","spc"],
	"application/x-pkcs7-certreqresp": ["p7r"],
	"application/x-rar-compressed": ["rar"],
	"application/x-redhat-package-manager": ["rpm"],
	"application/x-research-info-systems": ["ris"],
	"application/x-sea": ["sea"],
	"application/x-sh": ["sh"],
	"application/x-shar": ["shar"],
	"application/x-shockwave-flash": ["swf"],
	"application/x-silverlight-app": ["xap"],
	"application/x-sql": ["sql"],
	"application/x-stuffit": ["sit"],
	"application/x-stuffitx": ["sitx"],
	"application/x-subrip": ["srt"],
	"application/x-sv4cpio": ["sv4cpio"],
	"application/x-sv4crc": ["sv4crc"],
	"application/x-t3vm-image": ["t3"],
	"application/x-tads": ["gam"],
	"application/x-tar": ["tar"],
	"application/x-tcl": ["tcl","tk"],
	"application/x-tex": ["tex"],
	"application/x-tex-tfm": ["tfm"],
	"application/x-texinfo": ["texinfo","texi"],
	"application/x-tgif": ["obj"],
	"application/x-ustar": ["ustar"],
	"application/x-virtualbox-hdd": ["hdd"],
	"application/x-virtualbox-ova": ["ova"],
	"application/x-virtualbox-ovf": ["ovf"],
	"application/x-virtualbox-vbox": ["vbox"],
	"application/x-virtualbox-vbox-extpack": ["vbox-extpack"],
	"application/x-virtualbox-vdi": ["vdi"],
	"application/x-virtualbox-vhd": ["vhd"],
	"application/x-virtualbox-vmdk": ["vmdk"],
	"application/x-wais-source": ["src"],
	"application/x-web-app-manifest+json": ["webapp"],
	"application/x-x509-ca-cert": ["der","crt","pem"],
	"application/x-xfig": ["fig"],
	"application/x-xliff+xml": ["xlf"],
	"application/x-xpinstall": ["xpi"],
	"application/x-xz": ["xz"],
	"application/x-zmachine": ["z1","z2","z3","z4","z5","z6","z7","z8"],
	"application/xaml+xml": ["xaml"],
	"application/xcap-diff+xml": ["xdf"],
	"application/xenc+xml": ["xenc"],
	"application/xhtml+xml": ["xhtml","xht"],
	"application/xml": ["xml","xsl","xsd","rng"],
	"application/xml-dtd": ["dtd"],
	"application/xop+xml": ["xop"],
	"application/xproc+xml": ["xpl"],
	"application/xslt+xml": ["xslt"],
	"application/xspf+xml": ["xspf"],
	"application/xv+xml": ["mxml","xhvml","xvml","xvm"],
	"application/yang": ["yang"],
	"application/yin+xml": ["yin"],
	"application/zip": ["zip"],
	"audio/3gpp": [],
	"audio/adpcm": ["adp"],
	"audio/basic": ["au","snd"],
	"audio/midi": ["mid","midi","kar","rmi"],
	"audio/mp3": [],
	"audio/mp4": ["m4a","mp4a"],
	"audio/mpeg": ["mpga","mp2","mp2a","mp3","m2a","m3a"],
	"audio/ogg": ["oga","ogg","spx"],
	"audio/s3m": ["s3m"],
	"audio/silk": ["sil"],
	"audio/vnd.dece.audio": ["uva","uvva"],
	"audio/vnd.digital-winds": ["eol"],
	"audio/vnd.dra": ["dra"],
	"audio/vnd.dts": ["dts"],
	"audio/vnd.dts.hd": ["dtshd"],
	"audio/vnd.lucent.voice": ["lvp"],
	"audio/vnd.ms-playready.media.pya": ["pya"],
	"audio/vnd.nuera.ecelp4800": ["ecelp4800"],
	"audio/vnd.nuera.ecelp7470": ["ecelp7470"],
	"audio/vnd.nuera.ecelp9600": ["ecelp9600"],
	"audio/vnd.rip": ["rip"],
	"audio/wav": ["wav"],
	"audio/wave": [],
	"audio/webm": ["weba"],
	"audio/x-aac": ["aac"],
	"audio/x-aiff": ["aif","aiff","aifc"],
	"audio/x-caf": ["caf"],
	"audio/x-flac": ["flac"],
	"audio/x-m4a": [],
	"audio/x-matroska": ["mka"],
	"audio/x-mpegurl": ["m3u"],
	"audio/x-ms-wax": ["wax"],
	"audio/x-ms-wma": ["wma"],
	"audio/x-pn-realaudio": ["ram","ra"],
	"audio/x-pn-realaudio-plugin": ["rmp"],
	"audio/x-realaudio": [],
	"audio/x-wav": [],
	"audio/xm": ["xm"],
	"chemical/x-cdx": ["cdx"],
	"chemical/x-cif": ["cif"],
	"chemical/x-cmdf": ["cmdf"],
	"chemical/x-cml": ["cml"],
	"chemical/x-csml": ["csml"],
	"chemical/x-xyz": ["xyz"],
	"font/collection": ["ttc"],
	"font/otf": ["otf"],
	"font/ttf": ["ttf"],
	"font/woff": ["woff"],
	"font/woff2": ["woff2"],
	"image/apng": ["apng"],
	"image/bmp": ["bmp"],
	"image/cgm": ["cgm"],
	"image/g3fax": ["g3"],
	"image/gif": ["gif"],
	"image/ief": ["ief"],
	"image/jp2": ["jp2","jpg2"],
	"image/jpeg": ["jpeg","jpg","jpe"],
	"image/jpm": ["jpm"],
	"image/jpx": ["jpx","jpf"],
	"image/ktx": ["ktx"],
	"image/png": ["png"],
	"image/prs.btif": ["btif"],
	"image/sgi": ["sgi"],
	"image/svg+xml": ["svg","svgz"],
	"image/tiff": ["tiff","tif"],
	"image/vnd.adobe.photoshop": ["psd"],
	"image/vnd.dece.graphic": ["uvi","uvvi","uvg","uvvg"],
	"image/vnd.djvu": ["djvu","djv"],
	"image/vnd.dvb.subtitle": [],
	"image/vnd.dwg": ["dwg"],
	"image/vnd.dxf": ["dxf"],
	"image/vnd.fastbidsheet": ["fbs"],
	"image/vnd.fpx": ["fpx"],
	"image/vnd.fst": ["fst"],
	"image/vnd.fujixerox.edmics-mmr": ["mmr"],
	"image/vnd.fujixerox.edmics-rlc": ["rlc"],
	"image/vnd.ms-modi": ["mdi"],
	"image/vnd.ms-photo": ["wdp"],
	"image/vnd.net-fpx": ["npx"],
	"image/vnd.wap.wbmp": ["wbmp"],
	"image/vnd.xiff": ["xif"],
	"image/webp": ["webp"],
	"image/x-3ds": ["3ds"],
	"image/x-cmu-raster": ["ras"],
	"image/x-cmx": ["cmx"],
	"image/x-freehand": ["fh","fhc","fh4","fh5","fh7"],
	"image/x-icon": ["ico"],
	"image/x-jng": ["jng"],
	"image/x-mrsid-image": ["sid"],
	"image/x-ms-bmp": [],
	"image/x-pcx": ["pcx"],
	"image/x-pict": ["pic","pct"],
	"image/x-portable-anymap": ["pnm"],
	"image/x-portable-bitmap": ["pbm"],
	"image/x-portable-graymap": ["pgm"],
	"image/x-portable-pixmap": ["ppm"],
	"image/x-rgb": ["rgb"],
	"image/x-tga": ["tga"],
	"image/x-xbitmap": ["xbm"],
	"image/x-xpixmap": ["xpm"],
	"image/x-xwindowdump": ["xwd"],
	"message/rfc822": ["eml","mime"],
	"model/gltf+json": ["gltf"],
	"model/gltf-binary": ["glb"],
	"model/iges": ["igs","iges"],
	"model/mesh": ["msh","mesh","silo"],
	"model/vnd.collada+xml": ["dae"],
	"model/vnd.dwf": ["dwf"],
	"model/vnd.gdl": ["gdl"],
	"model/vnd.gtw": ["gtw"],
	"model/vnd.mts": ["mts"],
	"model/vnd.vtu": ["vtu"],
	"model/vrml": ["wrl","vrml"],
	"model/x3d+binary": ["x3db","x3dbz"],
	"model/x3d+vrml": ["x3dv","x3dvz"],
	"model/x3d+xml": ["x3d","x3dz"],
	"text/cache-manifest": ["appcache","manifest"],
	"text/calendar": ["ics","ifb"],
	"text/coffeescript": ["coffee","litcoffee"],
	"text/css": ["css"],
	"text/csv": ["csv"],
	"text/hjson": ["hjson"],
	"text/html": ["html","htm","shtml"],
	"text/jade": ["jade"],
	"text/jsx": ["jsx"],
	"text/less": ["less"],
	"text/markdown": ["markdown","md"],
	"text/mathml": ["mml"],
	"text/n3": ["n3"],
	"text/plain": ["txt","text","conf","def","list","log","in","ini"],
	"text/prs.lines.tag": ["dsc"],
	"text/richtext": ["rtx"],
	"text/rtf": [],
	"text/sgml": ["sgml","sgm"],
	"text/slim": ["slim","slm"],
	"text/stylus": ["stylus","styl"],
	"text/tab-separated-values": ["tsv"],
	"text/troff": ["t","tr","roff","man","me","ms"],
	"text/turtle": ["ttl"],
	"text/uri-list": ["uri","uris","urls"],
	"text/vcard": ["vcard"],
	"text/vnd.curl": ["curl"],
	"text/vnd.curl.dcurl": ["dcurl"],
	"text/vnd.curl.mcurl": ["mcurl"],
	"text/vnd.curl.scurl": ["scurl"],
	"text/vnd.dvb.subtitle": ["sub"],
	"text/vnd.fly": ["fly"],
	"text/vnd.fmi.flexstor": ["flx"],
	"text/vnd.graphviz": ["gv"],
	"text/vnd.in3d.3dml": ["3dml"],
	"text/vnd.in3d.spot": ["spot"],
	"text/vnd.sun.j2me.app-descriptor": ["jad"],
	"text/vnd.wap.wml": ["wml"],
	"text/vnd.wap.wmlscript": ["wmls"],
	"text/vtt": ["vtt"],
	"text/x-asm": ["s","asm"],
	"text/x-c": ["c","cc","cxx","cpp","h","hh","dic"],
	"text/x-component": ["htc"],
	"text/x-fortran": ["f","for","f77","f90"],
	"text/x-handlebars-template": ["hbs"],
	"text/x-java-source": ["java"],
	"text/x-lua": ["lua"],
	"text/x-markdown": ["mkd"],
	"text/x-nfo": ["nfo"],
	"text/x-opml": ["opml"],
	"text/x-org": [],
	"text/x-pascal": ["p","pas"],
	"text/x-processing": ["pde"],
	"text/x-sass": ["sass"],
	"text/x-scss": ["scss"],
	"text/x-setext": ["etx"],
	"text/x-sfv": ["sfv"],
	"text/x-suse-ymp": ["ymp"],
	"text/x-uuencode": ["uu"],
	"text/x-vcalendar": ["vcs"],
	"text/x-vcard": ["vcf"],
	"text/xml": [],
	"text/yaml": ["yaml","yml"],
	"video/3gpp": ["3gp","3gpp"],
	"video/3gpp2": ["3g2"],
	"video/h261": ["h261"],
	"video/h263": ["h263"],
	"video/h264": ["h264"],
	"video/jpeg": ["jpgv"],
	"video/jpm": ["jpgm"],
	"video/mj2": ["mj2","mjp2"],
	"video/mp2t": ["ts"],
	"video/mp4": ["mp4","mp4v","mpg4"],
	"video/mpeg": ["mpeg","mpg","mpe","m1v","m2v"],
	"video/ogg": ["ogv"],
	"video/quicktime": ["qt","mov"],
	"video/vnd.dece.hd": ["uvh","uvvh"],
	"video/vnd.dece.mobile": ["uvm","uvvm"],
	"video/vnd.dece.pd": ["uvp","uvvp"],
	"video/vnd.dece.sd": ["uvs","uvvs"],
	"video/vnd.dece.video": ["uvv","uvvv"],
	"video/vnd.dvb.file": ["dvb"],
	"video/vnd.fvt": ["fvt"],
	"video/vnd.mpegurl": ["mxu","m4u"],
	"video/vnd.ms-playready.media.pyv": ["pyv"],
	"video/vnd.uvvu.mp4": ["uvu","uvvu"],
	"video/vnd.vivo": ["viv"],
	"video/webm": ["webm"],
	"video/x-f4v": ["f4v"],
	"video/x-fli": ["fli"],
	"video/x-flv": ["flv"],
	"video/x-m4v": ["m4v"],
	"video/x-matroska": ["mkv","mk3d","mks"],
	"video/x-mng": ["mng"],
	"video/x-ms-asf": ["asf","asx"],
	"video/x-ms-vob": ["vob"],
	"video/x-ms-wm": ["wm"],
	"video/x-ms-wmv": ["wmv"],
	"video/x-ms-wmx": ["wmx"],
	"video/x-ms-wvx": ["wvx"],
	"video/x-msvideo": ["avi"],
	"video/x-sgi-movie": ["movie"],
	"video/x-smv": ["smv"],
	"x-conference/x-cooltalk": ["ice"]
};

var types$1 = Object.freeze({
	default: types
});

var fs$1 = ( empty$1 && empty ) || empty$1;

var require$$0$2 = ( types$1 && types ) || types$1;

function Mime() {
  // Map of extension -> mime type
  this.types = Object.create(null);

  // Map of mime type -> extension
  this.extensions = Object.create(null);
}

/**
 * Define mimetype -> extension mappings.  Each key is a mime-type that maps
 * to an array of extensions associated with the type.  The first extension is
 * used as the default extension for the type.
 *
 * e.g. mime.define({'audio/ogg', ['oga', 'ogg', 'spx']});
 *
 * @param map (Object) type definitions
 */
Mime.prototype.define = function (map) {
  for (var type in map) {
    var exts = map[type];
    for (var i = 0; i < exts.length; i++) {
      if (process.env.DEBUG_MIME && this.types[exts[i]]) {
        console.warn((this._loading || "define()").replace(/.*\//, ''), 'changes "' + exts[i] + '" extension type from ' +
          this.types[exts[i]] + ' to ' + type);
      }

      this.types[exts[i]] = type;
    }

    // Default extension is the first one we encounter
    if (!this.extensions[type]) {
      this.extensions[type] = exts[0];
    }
  }
};

/**
 * Load an Apache2-style ".types" file
 *
 * This may be called multiple times (it's expected).  Where files declare
 * overlapping types/extensions, the last file wins.
 *
 * @param file (String) path of file to load.
 */
Mime.prototype.load = function(file) {
  this._loading = file;
  // Read file and split into lines
  var map = {},
      content = fs$1.readFileSync(file, 'ascii'),
      lines = content.split(/[\r\n]+/);

  lines.forEach(function(line) {
    // Clean up whitespace/comments, and split into fields
    var fields = line.replace(/\s*#.*|^\s*|\s*$/g, '').split(/\s+/);
    map[fields.shift()] = fields;
  });

  this.define(map);

  this._loading = null;
};

/**
 * Lookup a mime type based on extension
 */
Mime.prototype.lookup = function(path, fallback) {
  var ext = path.replace(/^.*[\.\/\\]/, '').toLowerCase();

  return this.types[ext] || fallback || this.default_type;
};

/**
 * Return file extension associated with a mime type
 */
Mime.prototype.extension = function(mimeType) {
  var type = mimeType.match(/^\s*([^;\s]*)(?:;|\s|$)/)[1].toLowerCase();
  return this.extensions[type];
};

// Default instance
var mime = new Mime();

// Define built-in types
mime.define(require$$0$2);

// Default type
mime.default_type = mime.lookup('bin');

//
// Additional API specific to the default instance
//

mime.Mime = Mime;

/**
 * Lookup a charset based on mime type.
 */
mime.charsets = {
  lookup: function(mimeType, fallback) {
    // Assume text types are utf8
    return (/^text\/|^application\/(javascript|json)/).test(mimeType) ? 'UTF-8' : fallback;
  }
};

var mime_1 = mime;

/* Like web-code-stats but for storing the file inside and not as a seperate file */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

var idToBufferFileMap = new Map();

var compulsaryAttrs = [
	'name',
	'id',
	'icon'
];

var optionalAttrs = [
	'mime'
];

var keys$2 = compulsaryAttrs.concat(optionalAttrs);

function BufferFile(data) {

	this.data = {};

	compulsaryAttrs.forEach(function (key) {
		if (data[key]) {
			this.data[key] = data[key];
		} else {
			throw Error('Missing Key: ' + key);
		}
	}.bind(this));

	if (idToBufferFileMap.has(data.id)) {
		return idToBufferFileMap.get(data.id);
	}
	idToBufferFileMap.set(data.id, this);

	optionalAttrs.forEach(function (key) {
		if (data[key]) {
			this.data[key] = data[key];
		}
	}.bind(this));

	//  Try fetching from DB
	this.valuePromise = db.get(data.id)
	.catch(function (e) {
		if (e.status === 404) {
			var doc = this.toDoc();
			doc._id = this.data.id;
			doc.value = '';
			return db.put(doc).then(function () {
				return doc;	
			});
		}
		throw e;
	}.bind(this))
	.then(function (doc) {
		this.value = doc.value;
		return doc.value;
	}.bind(this));
}

BufferFile.prototype.update = function update(value) {
	// save doc to disk
	return this.valuePromise = this.valuePromise
	.then(function () {
		return updateDBDoc(this.data.id, {
			value: value
		});
	}.bind(this))
	.then(function () {
		return value;
	});
};

BufferFile.prototype.toDoc = function toDoc() {
	var out = {
		isBufferFileDoc: true
	};
	keys$2.forEach(function (key) {
		out[key] = this.data[key];
	}.bind(this));
	return out;
};

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function renderFileList(el, array, options) {

	options = options || {};
	var useOptions = {
		hideDotFiles: (options.hideDotFiles !== undefined ? options.hideDotFiles : true),
		nested: (options.nested !== undefined ? options.nested : true),
		nestingLimit: (options.nestingLimit || 5) - 1,
		sort: options.sort === false ? false : true
	};
	if (options.nestingLimit === 0) return;

	var sortedData = !useOptions.sort ? array : Array.from(array)
		.filter(function (stats) {

			// Whether to hide dotfiles
			if (stats.data.name !== '..' && useOptions.hideDotFiles !== false) {
				return stats.data.name[0] !== '.';
			}
			return true;
		})
		.sort(function (a, b) {
			if (a.name === '..') {
				return -1;
			}
			if (b.name === '..') {
				return 1;
			}
			if (
				(a.isDirectory() === b.isDirectory()) &&
				(a.isFile() === b.isFile())
			) {
				return ([a.data.name, b.data.name].sort(function (a, b) {
					return a.toLowerCase().localeCompare(b.toLowerCase());
				})[0] === a.data.name ? -1 : 1);
			} else {
				if (a.isDirectory()) return -1;
				return 1;
			}
		});

	sortedData.map(function (stats) {

		var li = document.createElement('li');
		li.classList.add('has-icon');
		li.tabIndex = 0;
		li.tabKey = stats;

		if (stats.constructor === Stats) {
			li.dataset.mime = stats.data.mime;
			li.dataset.name = stats.data.name;
			li.dataset.size = stats.data.size;
			li.textContent = stats.data.name;
			li.stats = stats;

			if (stats.isDirectory() && useOptions.nested !== false) {
				var newFileList = document.createElement('ul');
				newFileList.classList.add('filelist');
				li.appendChild(newFileList);
				if (stats.expanded && stats.children) {
					stats.renderFileList(newFileList, useOptions);
				}
			}
		} else if (stats.constructor === BufferFile) {
			li.dataset.name = stats.data.name;
			li.textContent = stats.data.name;
			if (stats.data.icon) {
				li.classList.add('has-icon');
				li.dataset.icon = stats.icon;
			}
			if (stats.data.mime) {
				li.dataset.mime = stats.mime;
			}
		}

		el.appendChild(li);
	});


}

/* global Map, Set, Promise, fs, isServer */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

// Map to prevent duplicate data objects for each file
var pathToDataMap = new Map();

var fsFromFn = ['isFile', 'isDirectory', 'isBlockDevice', 'isCharacterDevice', 'isSymbolicLink', 'isFIFO', 'isSocket'];
var fsStatic = [
	'dev',
	'mode',
	'nlink',
	'uid',
	'gid',
	'rdev',
	'blksize',
	'ino',
	'size',
	'blocks',
	'atime',
	'mtime',
	'ctime',
	'birthtime',
	'path'
];
var keys$1 = fsStatic.concat(fsFromFn);


/**
 * Special type of singleton which returns the same object for each path.
 */
function Stats (data) {
	if (pathToDataMap.has(data.path)) {
		var existing = pathToDataMap.get(data.path);
		existing.update(data);
		return existing;
	}
	this.fileLists = new Set();
	this.data = {};
	this.update(data);
	pathToDataMap.set(data.path, this);
}

Stats.prototype.update = function update(data) {

	var self = this;

	this.data.name = basename(data.path);
	this.data.dirName = dirname(data.path);
	this.data.extension = extname(data.path).toLowerCase();
	this.data.mime = data.isFile ? mime_1.lookup(data.path) : 'directory';

	keys$1.forEach(function (key) {
		this.data[key] = data[key];
	}.bind(this));

	if (this.isDirectory() && !this.children) {
		this.children = [];
		this.childrenPopulated = false;
	}

    // Rerender file lists
	if (this.fileLists.size) {
		Array.from(this.fileLists).forEach(function (filelistEl) {
			filelistEl.innerHTML = '';
			self.renderFileList(filelistEl, filelistEl.filelistOptions);
		});
	}
};

Stats.prototype.toDoc = function toDoc() {
	var out = {
		__webStatDoc: true
	};
	keys$1.forEach(function (key) {
		out[key] = this.data[key];
	}.bind(this));
	return out;
};

Stats.prototype.updateChildren = function () {
	if(!this.isDirectory()) throw Error('Not a directory');

	var self = this;
	return fs.readdir(self.data.path)
	.then(function (arr) {
		return Promise.all(arr.map(function (child) {
			return Stats.fromPath(join(self.data.path, child));
		}));
	})
	.then(function (statsArray) {
		self.children.splice(0);
		self.children.push.apply(self.children, statsArray);

		// Let server know	
		if (!isServer) remoteCmd('CLIENT', {
			cmd: 'watchPath',
			arguments: [self.data.path]
		});

		self.update(self.data);

		return self;  
	});
};

Stats.prototype.destroyFileList = function (el) {
	el.stats = undefined;
	this.fileLists.delete(el);
	el.innerHTML = '';
};

Stats.prototype.renderFileList = function (el, options) {

	el.filelistOptions = options;

	el.stats = this;
	this.fileLists.add(el);
	el.dataset.mime = this.data.mime;
	el.dataset.name = this.data.name;
	el.dataset.size = this.data.size;

	renderFileList(el, this.children, options);
};

// add isFile isDirectory etc
fsFromFn.forEach(function (key) {
	Stats.prototype[key] = new Function('return this.data["' + key + '"];');
});

Stats.fromPath = function (path$$1) {
	return fs.stat(path$$1);
};

Stats.fromDoc = function (data) {
	return new Stats(data);
};

Stats.fromNodeStats = function (path$$1, nodeStat) {

	var out = {};

	fsFromFn.forEach(key => out[key] = nodeStat[key]());
	keys$1.forEach(key => {
		if (typeof nodeStat[key] !== 'function' && typeof nodeStat[key] !== 'object') {
			out[key] = nodeStat[key];
		}
	});

	out.path = resolve$1(path$$1);

	return new Stats(out);
};

/* eslint no-var: 0, no-console: 0 */

function displayError(type, text, timeout) {

	var errorEl = document.getElementById('errors');

	var li = document.createElement('li');

	var textEl = document.createElement('span');
	textEl.classList.add('error-text');
	textEl.textContent = text;

	var typeEl = document.createElement('span');
	typeEl.classList.add('error-type');
	typeEl.textContent = type;

	li.appendChild(typeEl);
	li.appendChild(textEl);

	if (timeout) {
		setTimeout(function () {
			errorEl.removeChild(li);
		}, timeout);
	}

	errorEl.appendChild(li);
	return li;
}

function removeError(el) {
	var errorEl = document.getElementById('errors');
	errorEl.removeChild(el);
}

/* eslint no-var: 0 */
var data = {};

var state = {
	set: function set(key, datum) {
		data[key] = datum;
	},

	sync: function () {

		// Tell the server the root path for this window has changed
		return remoteCmd('SYNC_STATE', data);
	},

	get: function get(key) {
		return data[key];
	}
};

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function fsProxy() {
	var args = Array.from(arguments);
	var cmd = args.shift();

	function execute() {
		var args = Array.from(arguments);
		return remoteCmd('FS_PROXY', {
			cmd: cmd,
			arguments: args
		})
		.then(function (data) {
			if (typeof data !== 'object') return data;
			if (data.__webStatDoc) return Stats.fromDoc(data);
			return data;
		});
	}

	if (args.length === 0) return execute;
	return execute.apply(null, args);
}

var fs$2 = {};

[
	'stat',
	'readFile',
	'writeFile',
	'readdir',
	'mkdir',
	'rename',
	'unlink',
	'rmdir'
].forEach(function (cmd) {
	fs$2[cmd] = fsProxy(cmd);
});

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function saveOpenTab() {
	var tab = tabController.getOpenTab();
	var stats;
	if (tab && tab.editor) {
		stats = tab.stats;
	} else {
		return;
	}
	saveTextFileFromEditor(stats, tab.editor);
}

function closeOpenTab() {
	var tab = tabController.getOpenTab();
	if (tab) tabController.closeTab(tab);
}

var tabController = (function setUpTabs() {
	var currentlyOpenFilesEl = document.querySelector('#currently-open-files');
	var containerEl = document.getElementById('container');
	var tabsEl = document.querySelector('#tabs');

	function updateOpenFileEl() {
		currentlyOpenFilesEl.innerHTML = '';
		renderFileList(currentlyOpenFilesEl, Array.from(tabController.currentlyOpenFilesMap.keys()), {
			sort: false
		});
	}

	function Tab(stats) {

		var addCloseButton = false;

		// It is a reference to a file
		if (stats.constructor === Stats) {
			this.stats = stats;
			this.el = document.createElement('a');
			this.el.classList.add('tab');
			this.el.classList.add('has-icon');
			this.el.dataset.mime = stats.data.mime;
			this.el.dataset.name = stats.data.name;
			this.el.textContent = stats.data.name;
			this.el.tabIndex = 0;
			addCloseButton = true;
		} else if (stats.constructor === BufferFile) {
			this.stats = stats;
			this.el = document.createElement('a');
			this.el.classList.add('tab');
			this.el.dataset.name = stats.data.name;
			this.el.textContent = stats.data.name;
			if (stats.data.icon) {
				this.el.classList.add('has-icon');
				this.el.dataset.icon = stats.data.icon;
			}
			if (stats.data.mime) {
				this.el.dataset.mime = stats.data.mime;
			}
			if (stats.data.hasTabCloseButton !== false) {
				addCloseButton = true;
			}
			this.el.tabIndex = 0;
		}

		if (addCloseButton) {

			this.closeEl = document.createElement('button');
			this.closeEl.classList.add('tab_close');
			this.closeEl.setAttribute('aria-label', 'Close Tab ' + stats.data.name);
			this.el.appendChild(this.closeEl);
			this.closeEl.tabIndex = 0;

			var self = this;
			this.closeEl.addEventListener('click', function () {
				tabController.closeTab(self);
			});
		}

		tabsEl.appendChild(this.el);

		this.el.webCodeTab = this;

		this.contentEl = document.createElement('div');
		this.contentEl.classList.add('tab-content');
		containerEl.appendChild(this.contentEl);
		
	}

	Tab.prototype.destroy = function () {
		this.el.parentNode.removeChild(this.el);
		this.contentEl.parentNode.removeChild(this.contentEl);
	};

	function TabController() {
		this.currentlyOpenFilesMap = new Map();
		this.focusedTab = null;
	}

	TabController.prototype.hasTab = function (stats) {
		return this.currentlyOpenFilesMap.has(stats);
	};

	TabController.prototype.getOpenTab = function () {
		return this.focusedTab;
	};

	TabController.prototype.newTab = function (stats) {
		var tab = new Tab(stats);
		this.currentlyOpenFilesMap.set(stats, tab);
		updateOpenFileEl();
		this.storeOpenTabs();

		if (!this.focusedTab) {
			this.focusTab(tab);
		}

		return tab;
	};

	TabController.prototype.focusTab = function (stats) {
		var focusedTab = stats.constructor === Tab ? stats : this.currentlyOpenFilesMap.get(stats);
		this.focusedTab = focusedTab;
		Array.from(this.currentlyOpenFilesMap.values()).forEach(function (tab) {
			tab.contentEl.classList.toggle('has-focus', tab === focusedTab);
			tab.el.classList.toggle('has-focus', tab === focusedTab);
		});
		if (focusedTab.editor) focusedTab.editor.layout();
	};

	TabController.prototype.getTabFromKey = function (stats) {
		var tab = stats.constructor === Tab ? stats : this.currentlyOpenFilesMap.get(stats);
		return tab;
	};

	TabController.prototype.closeTab = function (stats) {
		var tab = stats.constructor === Tab ? stats : this.currentlyOpenFilesMap.get(stats);
		var tabState = Array.from(this.currentlyOpenFilesMap.values());
		var tabIndex = tabState.indexOf(tab);
		var nextTab = (tabIndex >= 1) ? tabState[tabIndex - 1] : tabState[tabIndex + 1];

		this.currentlyOpenFilesMap.delete(tab.stats);
		tab.destroy();
		updateOpenFileEl();
		this.storeOpenTabs();
		if (this.focusedTab === tab && nextTab) {	
			this.focusTab(nextTab);
		}
		if (this.focusedTab === tab) {
			this.focusedTab = null;
		}
		// if (this.currentlyOpenFilesMap.size === 0) {
		// 	newFile();
		// }
	};

	TabController.prototype.closeAll = function () {
		var self=this;
		Array.from(this.currentlyOpenFilesMap.values()).forEach(function (tab) {
			self.closeTab(tab);
		});
	};

	TabController.prototype.storeOpenTabs = function () {
		if (!state.get('currentlyOpenedPath')) return;
		updateDBDoc('OPEN_TABS_FOR_' + state.get('currentlyOpenedPath'), {
			open_tabs: Array.from(this.currentlyOpenFilesMap.keys()).map(function (stats) {
				return stats.toDoc();
			})
		})
		.catch(function (err) {
			console.log(err);
		});
	};

	TabController.prototype.getTabsAsArray = function () {
		return Array.from(tabsEl.children);
	};

	/**
	 * All the elements in the array are moved to the start in the order they appear.
	 */
	TabController.prototype.setOrder= function(arr) {
		var old = new Set(this.getTabsAsArray());
		tabsEl.innerHTML = '';
		arr.forEach(function (el) {
			if (el.constructor === Tab) {
				el = el.el;
			}
			if (old.has(el.el)) {
				tabsEl.appendChild(el);
				old.delete(el);
			}
		});
		Array.from(old).forEach(function (el) {
			tabsEl.appendChild(el);
		});
	};

	var tabController = new TabController();

	tabsEl.addEventListener('mouseup', function (e) {
		if (e.target.matches('.tab')) {
			if (e.button === 0) {
				tabController.focusTab(e.target.webCodeTab);
			}
			if (e.button === 1) {
				tabController.closeTab(e.target.webCodeTab);
			}
		}
	});

	currentlyOpenFilesEl.addEventListener('mouseup', function (e) {
		if (e.target.tabKey) {
			if (e.button === 0) {
				tabController.focusTab(e.target.tabKey);
			}
			if (e.button === 1) {
				tabController.closeTab(e.target.tabKey);
			}
		}
	});

	return tabController;
}());

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;
var nativeMin = Math.min;

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */
function debounce(func, wait, options) {
  var lastArgs,
      lastThis,
      maxWait,
      result,
      timerId,
      lastCallTime,
      lastInvokeTime = 0,
      leading = false,
      maxing = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function invokeFunc(time) {
    var args = lastArgs,
        thisArg = lastThis;

    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    // Invoke the leading edge.
    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime,
        result = wait - timeSinceLastCall;

    return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
  }

  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  }

  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }

  function flush() {
    return timerId === undefined ? result : trailingEdge(now());
  }

  function debounced() {
    var time = now(),
        isInvoking = shouldInvoke(time);

    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

var index$6 = debounce;

/* global monaco, Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

var settings = {
	theme: 'web-code',
	fontSize: 14,
	fontLigatures: true,
	fontFamily: '"Operator Mono", "Fira Code"'
};
var settingsKeys = Object.keys(settings);

function monacoSettings(inObj) {
	inObj = inObj || {};
	settingsKeys.forEach(function (key) {
		if (inObj[key] === undefined) {
			inObj[key] = settings[key];
		}
	});
	return inObj;
}

function strHash(s) {
	return s.split("").reduce(function(a, b) {
       a = ((a << 5) - a) + b.charCodeAt(0);
       return a & a
     }, 0);
}

require.config({ paths: { 'vs': 'vs' } });

var monacoPromise = new Promise(function (resolve) {
	require(['vs/editor/editor.main'], resolve);
})
.then(function () {
	monaco.editor.defineTheme('web-code', {
		base: 'vs-dark',
		inherit: true,
		rules: [
			{ token: 'comment', foreground: 'ffa500', fontStyle: 'italic' },
			{ token: 'punctuation.definition.comment', fontStyle: 'italic' },
			{ token: 'constant.language.this.js', fontStyle: 'italic' },
			{ token: 'variable.language', fontStyle: 'italic' },
			{ token: 'entity.other.attribute-name', fontStyle: 'italic' },
			{ token: 'tag.decorator.js', fontStyle: 'italic' },
			{ token: 'entity.name.tag.js,', fontStyle: 'italic' },
			{ token: 'tag.decorator.js', fontStyle: 'italic' },
			{ token: 'punctuation.definition.tag.js', fontStyle: 'italic' },
			{ token: 'source.js', fontStyle: 'italic' },
			{ token: 'constant.other.object.key.js', fontStyle: 'italic' },
			{ token: 'string.unquoted.label.js', fontStyle: 'italic' },
		]
	});
});

function getMonacoLanguageFromMimes(mime) {
	return (monaco.languages.getLanguages().filter(function (languageObj) {
		return languageObj.mimetypes && languageObj.mimetypes.includes(mime);
	})[0] || {})['id'];
}

function getMonacoLanguageFromExtensions(extension) {
	return (monaco.languages.getLanguages().filter(function (languageObj) {
		return languageObj.extensions && languageObj.extensions.includes(extension);
	})[0] || {})['id'];
}

function selectNextEl() {
	document.querySelector('a, button, [tabindex]').focus();
}

function selectPreviousEl() {
	document.querySelectorAll('a, button, [tabindex]').focus();
}

function nextTab() {
	console.log('STUB: FOCUS NEXT TAB');
}

function previousTab() {
	console.log('STUB: FOCUS PREVIOUS TAB');
}

function addBindings(editor, tab) {
	editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_O, promptForOpen);
	editor.addCommand(monaco.KeyCode.KEY_W | monaco.KeyMod.CtrlCmd, closeOpenTab);
	editor.addCommand(monaco.KeyCode.F6, selectNextEl);
	editor.addCommand(monaco.KeyCode.F6 | monaco.KeyMod.Shift, selectPreviousEl);
	editor.addCommand(monaco.KeyCode.Tab | monaco.KeyMod.CtrlCmd, nextTab);
	editor.addCommand(monaco.KeyCode.Tab | monaco.KeyMod.Shift | monaco.KeyMod.CtrlCmd, previousTab);
	editor.addCommand(monaco.KeyCode.KEY_P | monaco.KeyMod.Shift | monaco.KeyMod.CtrlCmd, function openCommandPalette() {
		editor.trigger('anyString', 'editor.action.quickCommand');
	});
	editor.addCommand(monaco.KeyCode.Tab, function() {
		selectNextEl();
	}, 'hasJustTabbedIn');

	editor.webCodeState = {};
	editor.webCodeState.textHash = strHash(editor.getValue());
	editor.webCodeState.tab = tab;
	editor.webCodeState.hasJustTabbedIn = editor.createContextKey('hasJustTabbedIn', false);

	editor.webCodeState.functions = {
		checkForChanges: function checkForChanges() {
			editor.webCodeState.hasJustTabbedIn.set(false);
			let hasChanges = editor.webCodeState.textHash !== strHash(editor.getValue());
			editor.webCodeState.hasChanges = hasChanges;
			tab.el.classList.toggle('has-changes', editor.webCodeState.hasChanges);
		}
	};

	var writeToDB = index$6(function writeToDB() {
		if (tab.stats.constructor === BufferFile) {
			tab.stats.update(editor.getValue()).then(function () {
				editor.webCodeState.functions.checkForChanges();
			});
		}
	}, 500);

	editor.onDidChangeModelContent(function () {
		writeToDB();
		editor.webCodeState.functions.checkForChanges();
	});

	editor.onDidFocusEditorText(function () {
		editor.webCodeState.hasJustTabbedIn.set(true);
	});
	editor.onMouseDown(function () {
		editor.webCodeState.hasJustTabbedIn.set(false);
	});

	editor.addAction({
		id: 'web-code-save-tab',
		label: 'Save File',
		keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_S],
		keybindingContext: null,
		run: function () {
			editor.webCodeState.textHash = strHash(editor.getValue());
			saveTextFileFromEditor(tab.stats, editor);
		}
	});
}

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

/* NEEDS REFACTORING */

var highlightedEl;
var currentPath;
var resolver;
var rejecter;

function fileDialog(options) {

	return new Promise(function (resolve, reject) {
		
		var role;
		var path$$1 = options.path || process.env.HOME || '/';

		if (fileDialog.open === undefined) fileDialog.open = false;
		if (fileDialog.open === true) {
			throw Error('Dialog already open for another task.');
		}

		fileDialog.el.classList.remove('closed');

		if (typeof options !== 'object') {
			throw Error('Invalid options object')
		}

		if (!options.role) {
			throw Error('Role not defined');
		}

		if (options.role.toLowerCase() === 'open') {
			role = 'open';
			fileDialog.submitButton.textContent = 'Open';
			setTimeout(function () {
				fileDialog.filelistLeft.focus();
			}, 300);
		} else if (options.role.toLowerCase() === 'save as') {
			role = 'save-as';
			fileDialog.submitButton.textContent = 'Save';
			setTimeout(function () {
				fileDialog.filename.focus();
			}, 300);
		} else {
			throw Error('Unrecognised role, ' + options.role);
		}

		if (options.filename) {
			fileDialog.filename.value = options.filename;
		}

		fileDialog.el.dataset.role = role;

		currentPath = path$$1;
		resolver = resolve;
		rejecter = reject;

		fileDialog.currentPathEl.value = currentPath;

		populateFileList(fileDialog.filelistLeft, path$$1, {
			nested: false
		})
		.catch(function (e) {
			console.log(e);
			return populateFileList(fileDialog.filelistLeft, process.env.HOME || '/', {
				nested: false
			})
		});
	});
}

function highlight(e) {
	if (e.target.tagName === 'LI') {
		if (highlightedEl) {
			highlightedEl.classList.remove('has-highlight');
		}
		highlightedEl = e.target;
		highlightedEl.classList.add('has-highlight');

		currentPath = e.target.stats.data.path;


		if (e.target.stats && e.target.stats.isDirectory()) {
			fileDialog.currentPathEl.value = currentPath;
			if (e.currentTarget === fileDialog.filelistLeft) {
				if (e.target.stats.data.name === '..') {
					populateFileList(fileDialog.filelistLeft, e.target.stats.data.path, {
						nested: false
					});
					destroyFileList(fileDialog.filelistRight);
				} else {
					populateFileList(fileDialog.filelistRight, e.target.stats.data.path, {
						nested: false
					});
				}
			}
			if (e.currentTarget === fileDialog.filelistRight) {
				populateFileList(fileDialog.filelistLeft, e.target.stats.data.dirName, {
					nested: false
				})
				.then(function () {
					[].slice.call(fileDialog.filelistLeft.children).forEach(function (el) {
						if (el.stats.data.path === currentPath) {
							highlightedEl = e.target;
							highlightedEl.classList.add('has-highlight');
						}
					});
				});

				populateFileList(fileDialog.filelistRight, e.target.stats.data.path, {
					nested: false
				});
			}
		}

		if (e.target.stats && e.target.stats.isFile()) {
			if (fileDialog.el.dataset.role === 'open') {
				fileDialog.currentPathEl.value = currentPath;
			} else {
				fileDialog.currentPathEl.value = e.target.stats.data.dirName;
			}
			fileDialog.filename.value = e.target.stats.data.name;
		}
	}
}

function ondblclick(e) {
	highlight(e);
	if (e.target.stats && e.target.stats.isDirectory()) return;
	submit(e.target.stats);
}

function submit(stats) {
	if (fileDialog.el.dataset.role === 'open') {
		resolver(stats);
	}
	if (fileDialog.el.dataset.role === 'save-as') {
		resolver(join(stats.isDirectory() ? stats.data.path : stats.data.dirName, fileDialog.filename.value));
	}
	fileDialog.el.classList.add('closed');
	resolver = undefined;
	rejecter = undefined;
}

function cancel() {
	fileDialog.el.classList.add('closed');
	rejecter('User canceled');
	resolver = undefined;
	rejecter = undefined;
}

function onkeydown(e) {
	if (event.keyCode === 13) ondblclick(e);
	e.stopPropagation();
}

function setDialogPath(path$$1) {
	fileDialog.currentPathEl.value = path$$1;
	populateFileList(fileDialog.filelistLeft, path$$1, {
		nested: false
	});
	destroyFileList(fileDialog.filelistRight);
}

fileDialog.el = fileDialog.el || document.querySelector('#file-dialog-widget');
fileDialog.currentPathEl = fileDialog.currentPathEl || fileDialog.el.querySelector('input[name="current-path"]');
fileDialog.filelistLeft = fileDialog.filelistLeft || fileDialog.el.querySelector('.filelist:first-child');
fileDialog.filelistRight = fileDialog.filelistRight || fileDialog.el.querySelector('.filelist:not(:first-child)');
fileDialog.submitButton = fileDialog.submitButton || fileDialog.el.querySelector('#file-dialog-submit');
fileDialog.filename = fileDialog.filename || fileDialog.el.querySelector('#save-file-name');
fileDialog.cancelButton = fileDialog.cancelButton || fileDialog.el.querySelector('#file-dialog-cancel');
fileDialog.upDirButton = fileDialog.upDirButton || fileDialog.el.querySelector('button[data-action="up-dir"]');

fileDialog.el.addEventListener('keydown', function () {
	if (event.keyCode === 13) return Stats.fromPath(fileDialog.currentPathEl.value).then(submit);
});

fileDialog.filelistLeft.addEventListener('click', highlight);
fileDialog.filelistRight.addEventListener('click', highlight);

fileDialog.filelistLeft.addEventListener('keydown', onkeydown);
fileDialog.filelistRight.addEventListener('keydown', onkeydown);

fileDialog.filelistLeft.addEventListener('dblclick', ondblclick);
fileDialog.filelistRight.addEventListener('dblclick', ondblclick);
fileDialog.submitButton.addEventListener('click', function () {
	return Stats.fromPath(fileDialog.currentPathEl.value).then(submit);
});
fileDialog.cancelButton.addEventListener('click', function () {
	cancel();
});
fileDialog.upDirButton.addEventListener('click', function () {
	var path$$1 = resolve$1(join(fileDialog.currentPathEl.value, '/..'));
	setDialogPath(path$$1);
});

/* global Map, Set, Promise, monaco */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function populateFileList(el, path, options) {
	el.path = path;
	return Stats.fromPath(path)
		.then(function (stats) {
			if (stats.isFile()) {
				return Stats.fromPath(stats.data.dirName);
			}
			return stats;
		})
		.then(function (stats) {

			// Teardown old file list if one is present
			if (el.stats) {
				el.stats.destroyFileList(el);
			}

			// set up new one
			stats.renderFileList(el, options);

			// Update the filelist from the server
			return stats.updateChildren();
		});
}

function destroyFileList(el) {
	if (el.stats) {
		el.stats.destroyFileList(el);
	}
}

function openPath(stats) {
	if (stats.isDirectory()) {

		if (state.get('currentlyOpenedPath') !== stats.data.path) {
			tabController.closeAll();

			// Then open the saved tabs from last time
			db.get('OPEN_TABS_FOR_' + stats.data.path).then(function (tabs) {
				Promise.all(tabs.open_tabs.map(function (obj) {
					if (obj.__webStatDoc) {
						return Stats.fromPath(obj.path)
						.catch(function (e) {
							console.log(e.message);
							return null;
						});
					}
					if (obj.isBufferFileDoc) {
						return new BufferFile(obj);
					}
					return null;
				})).then(function (statsArray) {
					statsArray.filter(function (a) {
						return a !== null;
					}).forEach(function (stats) {
						openFile(stats);
					});
				});
			}).catch(function (e) {
				console.log(e);
			});
		}

		state.set('currentlyOpenedPath', stats.data.path);
		state.sync();

		var filelist = document.getElementById('directory');
		populateFileList(filelist, stats.data.path, {
			hideDotFiles: true
		})
		.catch(function (e) {
			throw e;
		});

		updateDBDoc('INIT_STATE', {
			previous_path: { path: stats.data.path }
		})
		.catch(function (err) {
			console.log(err);
		});

	}
	if (stats.isFile()) {
		openFile(stats);
	}
}

/**
 * returns a promise which resolves a Tab
 *
 * @param {Stats|FileBuffer} stats
 */
function openFile(stats) {

	if (tabController.hasTab(stats)) {
		tabController.focusTab(stats);
	} else {
		var newTab = tabController.newTab(stats);
		tabController.focusTab(newTab);

		if (stats.constructor === Stats) return monacoPromise
			.then(function () {
				if (stats.data.mime.match(/^image\//)) {
					var image = document.createElement('img');
					image.src = '/api/imageproxy?url=' + encodeURIComponent(stats.data.path);
					newTab.contentEl.appendChild(image);
					newTab.contentEl.classList.add('image-container');
					return newTab;
				} else if (stats.data.extension !== '.ts' && stats.data.mime.match(/^video\//)) {
					var video = document.createElement('video');
					video.src = '/api/imageproxy?url=' + encodeURIComponent(stats.data.path);
					newTab.contentEl.appendChild(video);
					video.controls = true;
					newTab.contentEl.classList.add('image-container');
					return newTab;
				} else {
					return fs$2.readFile(stats.data.path, 'utf8')
					.then(function (fileContents) {
						var language = getMonacoLanguageFromMimes(stats.data.mime) || getMonacoLanguageFromExtensions(stats.data.extension);
						newTab.editor = monaco.editor.create(newTab.contentEl, monacoSettings({
							value: fileContents,
							language: language
						}));
						addBindings(newTab.editor, newTab);
						return newTab;
					});
				}
			})
			.catch(function (e) {
				console.log(e.message);
			});

		if (stats.constructor === BufferFile) {
			return Promise.all([monacoPromise, stats.valuePromise]).then(function (arr) {
				return arr[1];
			})
			.then(function (value) {
				var language = getMonacoLanguageFromMimes(stats.data.mime) || getMonacoLanguageFromExtensions(stats.data.extension);
				newTab.editor = monaco.editor.create(newTab.contentEl, monacoSettings({
					value: value,
					language: language
				}));
				addBindings(newTab.editor, newTab);
				return newTab;
			});
		}
	}
}

function promptForOpen() {
	return fileDialog({
		path: state.get('currentlyOpenedPath') || process.env.HOME || '/',
		role: 'open'
	}).then(openPath);
}

// Saves file and updates versions for changes
function saveTextFileFromEditor(stats, editor) {
	if (stats.constructor === Stats) {
		var altId = editor.id;
		return fs$2.writeFile(stats.data.path, editor.getValue())
		.then(function () {
			editor.webCodeState.savedAlternativeVersionId = altId;
			editor.webCodeState.functions.checkForChanges();
		});
	} else if (stats.constructor === BufferFile) {
		return fileDialog({
			path: state.get('currentlyOpenedPath') || process.env.HOME || '/',
			role: 'save as',
			filename: stats.data.name
		}).then(function (path) {
			return fs$2.writeFile(path, editor.getValue())
			.then(function () {
				editor.webCodeState.savedAlternativeVersionId = altId;
				editor.webCodeState.functions.checkForChanges();
				return Stats.fromPath(path);
			})
			.then(function (newStats) {
				var tabs = tabController.getTabsAsArray();
				var oldTab = tabController.getTabFromKey(stats);
				var index = tabs.indexOf(oldTab);
				var newTab = tabs[index] = tabController.newTab(newStats);
				tabController.closeTab(stats);
				tabController.setOrder(tabs);
				return fs$2.readFile(newStats.data.path, 'utf8')
				.then(function (fileContents) {
					var language = getMonacoLanguageFromMimes(stats.data.mime) || getMonacoLanguageFromExtensions(stats.data.extension);
					newTab.editor = monaco.editor.create(newTab.contentEl, monacoSettings({
						value: fileContents,
						language: language
					}));
					addBindings(newTab.editor, newTab);
					tabController.focusTab(newTab);
					return newTab;
				});
			});
		});
	} else {
		throw Error('Not a FileStats or FileBuffer');
	}
}

/* global Map, Set, Promise, isServer */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

var promises = new Map();
function remoteCmd(cmd, data, ws) {
	var id = performance.now() + '_' + Math.random();
	return (ws ? Promise.resolve(ws) : wsPromise).then(function (ws) {
		ws.send(JSON.stringify([
			cmd,
			id,
			data
		]));

		if (process.env.DEBUG) {
			var err = new Error();
			var stack = err.stack;
		}

		return new Promise(function (resolve) {
			promises.set(id, resolve);
		}).then(function (data) {
			if (data.error) {
				if (process.env.DEBUG) {
					console.error(data.error, stack);
				}
				throw Error(data.error);
			}
			return data.result;
		});
	});
}

function updateEnv(name, ws) {
	return remoteCmd('GET_ENV', name, ws)
	.then(function (result) {
		if (result) process.env[name] = result;
		return result;
	});
}

var wsPromise = getNewWS();
var errorMsg;

// Connection opened
function getNewWS() {
	return new Promise(function (resolve) {

		if (isServer) resolve();

		var interval = -1;
		var isLocal = location.hostname === 'localhost' || location.hostname === '127.0.0.1';
		try {
			var ws = new WebSocket((isLocal ? 'ws://' : 'wss://') + location.host);
		} catch (e) {
			return terminate();
		}
		ws.binaryType = 'arraybuffer';

		var isAlive = true;

		ws.addEventListener('message', function m(e) {
			if (typeof e.data === 'string') {
				if (e.data === '__pong__') {
					isAlive = true;
					return;
				}
				var result = JSON.parse(e.data);
				var cmd = result[0];
				var promiseResolver = promises.get(result[1]);
				var data = result[2];
				if (promiseResolver) {
					promises.delete(result[1]);
					return promiseResolver(data);
				}
				if (cmd === 'HANDSHAKE') {
					Stats.fromPath(data.path).then(function (stats) {
						openPath(stats);
					});
					resolve(
						Promise.all([
							updateEnv('HOME', ws),
							updateEnv('DEBUG', ws),
						])
						.then(function () {
							return ws;
						})
					);
				}
				if (cmd === 'FS_CHANGE') {
					console.log('CHANGE', data);
				}
				if (cmd === 'FS_ADD') {
					Stats.fromPath(dirname(data.path)).then(function (stats) {
						stats.updateChildren();
					});
					console.log('ADD', data);
				}
				if (cmd === 'FS_UNLINK') {
					Stats.fromPath(dirname(data.path)).then(function (stats) {
						stats.updateChildren();
					});
					console.log('UNLINK', data);
				}
				if (cmd === 'OPEN_FILE') {
					Stats.fromPath(data.path).then(function (stats) {
						openFile(stats);
					});
				}
			}
		});

		ws.addEventListener('close', terminate);

		ws.addEventListener('open', function firstOpen() {

			if (errorMsg) {
				removeError(errorMsg);
				errorMsg = null;
			}

			interval = setInterval(function ping() {
				if (isAlive === false) {
					terminate();
				}
				isAlive = false;
				ws.send('__ping__');
			}, 3000);

			ws.removeEventListener('open', firstOpen);
		});

		function terminate() {
			clearInterval(interval);
			wsPromise = new Promise(function (resolve) {
				if (!errorMsg) errorMsg = displayError('Connection', 'Lost server connection.');
				setTimeout(function () {
					console.log('Trying to get new connection');
					getNewWS().then(function (newWs) {
						resolve(newWs);
					});
				}, 1000);
			}).then(function (newWs) {

				// don't return sync otherwise recusrion
				state.sync();
				return newWs;
			});
			return wsPromise;
		}
	});
}

/* global Map, Set, Promise, contextmenu */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function setUpSideBar() {

	function expandDir(el, stats) {
		var filelistEl = el.querySelector('.filelist');
		if (el.stats.expanded === true) {
			el.stats.expanded = false;
			destroyFileList(filelistEl);
		} else {
			el.stats.expanded = true;
			populateFileList(filelistEl, stats.data.path, {
				hideDotFiles: true
			});
		}
	}

	function refreshSideBar() {
		directoryEl.stats.updateChildren();
	}

	var directoryEl = document.querySelector('#directory');

	function onclick(e) {
		if (e.target.tagName === 'LI') {
			if (e.target.stats.isFile()) openFile(e.target.stats);
			if (e.target.stats.isDirectory()) expandDir(e.target, e.target.stats);
		}
	}

	function onkeydown(e) {
		if (event.keyCode === 13) onclick(e);
	}

	var menu = contextmenu([
		{
			label: 'New File',
			onclick: function () {
				lastContextEl = lastContextEl || directoryEl;
				if (lastContextEl.stats) {
					var newFile = prompt('New file name:', 'untitled.txt');
					if (newFile) {
						var newPath = join(lastContextEl.stats.isDirectory() ? lastContextEl.stats.data.path : lastContextEl.stats.data.dirName, newFile);
						fs$2.writeFile(newPath, '', {
							flag: 'wx'
						})
						.then(function () {
							return Stats.fromPath(newPath)
						})
						.then(function (stats) {
							openFile(stats);	
						})
						.catch(function (e) {
							displayError('FS Error', e.message, 3000);	
						})
						.then(refreshSideBar);
					}
				}
			}
		},
		{
			label: 'New Folder',
			onclick: function () {
				lastContextEl = lastContextEl || directoryEl;
				if (lastContextEl.stats) {
					var newFolder = prompt('New folder name:', 'New Folder');
					if (newFolder) {
						fs$2.mkdir(join(lastContextEl.stats.isDirectory() ? lastContextEl.stats.data.path : lastContextEl.stats.data.dirName, newFolder)).then(function () {
							console.log('success');
						})
						.catch(function (e) {
							displayError('FS Error', e.message, 3000);	
						})
						.then(refreshSideBar);
					}
				}
			}
		},
		{
			label: 'Rename',
			onclick: function () {
				lastContextEl = lastContextEl || directoryEl;
				if (lastContextEl.stats) {
					var newName = prompt('Rename file:', lastContextEl.stats.data.name);
					if (newName) {
						fs$2.rename(lastContextEl.stats.data.path, join(lastContextEl.stats.data.dirName, newName)).then(function () {
							console.log('success');
						})
						.catch(function (e) {
							displayError('FS Error', e.message, 3000);	
						})
						.then(refreshSideBar);
					}
				}
			}
		},
		{
			label: 'Delete File',
			onclick: function () {
				lastContextEl = lastContextEl || directoryEl;
				if (lastContextEl.stats) {
					var path$$1 = join(lastContextEl.stats.data.path);
					var confirmDel = confirm('Are you sure you want to delete this file?\n' + path$$1);
					if (confirmDel) {
						if (lastContextEl.stats.isFile()) {
							fs$2.unlink(path$$1).then(function () {
								console.log('success');
							})
							.catch(function (e) {
								displayError('FS Error', e.message, 3000);	
							})
							.then(refreshSideBar);
						}
						if (lastContextEl.stats.isDirectory()) {
							fs$2.rmdir(path$$1).then(function () {
								console.log('success');
							})
							.catch(function (e) {
								displayError('FS Error', e.message, 3000);	
							})
							.then(refreshSideBar);
						}
					}
				}
			}
		},
	]);

	var lastContextEl;

	function updateContextMenuEl(el) {
		el = el || {};
		if (el.stats) {
			lastContextEl = el;
			menuTitle.textContent = el.stats.data.name;
		} else {
			lastContextEl = null;
			menuTitle.textContent = '';
		}
	}

	directoryEl.addEventListener('contextmenu', function (e) {
		updateContextMenuEl(e.target);
		setTimeout(function () { menu.focus(); }, 0);
	});

	menu.tabIndex = 0;

	menu.addEventListener('keydown', function (e) {
		var children = Array.from(menu.children);
		var cur = menu.querySelector(':focus');
		var index = cur ? children.indexOf(cur) : -1;
		switch (e.keyCode) {
		case 38: // up
			index--;
			if (index < 0) index = children.length - 1;
			break;
		case 40: // down
			index++;
			if (index >= children.length) index = 0;
			break;
		case 13:
			if (cur) cur.click();
			break;
		}
		if (children[index]) children[index].focus();
	});

	Array.from(menu.querySelectorAll('menuitem')).forEach(function (el) {
		el.tabIndex=0;
	});

	contextmenu.attach(directoryEl, menu);

	var menuTitle = document.createElement('h2');
	menuTitle.textContent = 'Directory';
	menu.insertBefore(menuTitle, menu.firstChild);

	window.addEventListener('load', function () {
		var overlay = menu.parentNode;
		overlay.addEventListener('contextmenu', function (e) {
			var display = overlay.style.display;
			overlay.style.display = 'none';
			var node = document.elementFromPoint(e.clientX, e.clientY);
			if (node === directoryEl || directoryEl.contains(node)) {
				updateContextMenuEl(node);
			}
			overlay.style.display = display;
			setTimeout(function () { menu.focus(); }, 0);
		});
	});

	directoryEl.addEventListener('click', onclick);
	directoryEl.addEventListener('keydown', onkeydown);

}

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

function addScript (url) {
	var p = new Promise(function (resolve, reject) {
		var script = document.createElement('script');
		script.setAttribute('src', url);
		document.head.appendChild(script);
		script.onload = resolve;
		script.onerror = reject;
	});
	function promiseScript () {
		return p;
	}
	promiseScript.promise = p;
	return promiseScript;
}

/* global Map, Set, Promise, monaco */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

// Until they are saved new files are kept in a buffer
// Saved on changes to the db when saved to disk they are removed from the DB
function newFile() {
	var tab;

	var bf = new BufferFile ({
		name: 'New File',
		icon: 'buffer',
		id: Date.now() + '__' + 'New File'
	});
	
	bf.valuePromise
	.then(function () {
		tab = tabController.newTab(bf);
		return monacoPromise;
	})
	.then(function () {
		tab.editor = monaco.editor.create(tab.contentEl, monacoSettings());
		addBindings(tab.editor, tab);
		tabController.focusTab(tab);
	})
	.catch(function (e) {
		console.log(e.message);	
	});
}

/* global Map, Set, Promise */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

window.fs = fs$2;

wsPromise.then(function init() {
	
	console.log('Connected to the server...');

	if (process.env.DEBUG) {
		addScript('/axe/axe.min.js').promise.then(function () {
			window.axe.run(function (err, results) {
				if (err) throw err;
				console.log('a11y violations:', results.violations.length, results.violations);
			});
		});
	}

	// load old state
	return db.get('INIT_STATE')
		.then(function (doc) {
			if (doc.previous_path) {
				return Stats.fromPath(doc.previous_path.path).then(openPath);
			} else {
				return promptForOpen();
			}
		})
		.catch(function (err) {
			console.log(err);
		});
}, function (e) {
	console.log(e);	
});

(function setUpToolBar() {
	document.querySelector('button[data-action="open-file"]').addEventListener('click', promptForOpen);
	document.querySelector('button[data-action="save-file"]').addEventListener('click', saveOpenTab);
	document.querySelector('button[data-action="new-file"]').addEventListener('click', newFile);
}());

window.addEventListener('resize', function () {
	var tab = tabController.getOpenTab();
	if (tab && tab.editor) tab.editor.layout();
});

setUpSideBar();

}());
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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