'use strict';


	/* eslint-disable */
	var isServer = true;
	

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var path = require('path');
var mime = _interopDefault(require('mime'));
var renderFileList = _interopDefault(require('./render-file-list.js'));
var __ws_js = require('./ws.js');

/* global Map, Set, Promise, fs, isServer */
/* eslint no-var: 0, no-console: 0 */
/* eslint-env es6 */

// Map to prevent duplicate data objects for each file
var pathToDataMap = new Map();

var fsFromFn = ['isFile', 'isDirectory', 'isBlockDevice', 'isCharacterDevice', 'isSymbolicLink', 'isFIFO', 'isSocket'];
var fsStatic = [
	'dev',
	'mode',
	'nlink',
	'uid',
	'gid',
	'rdev',
	'blksize',
	'ino',
	'size',
	'blocks',
	'atime',
	'mtime',
	'ctime',
	'birthtime',
	'path'
];
var keys = fsStatic.concat(fsFromFn);


/**
 * Special type of singleton which returns the same object for each path.
 */
function Stats (data) {
	if (pathToDataMap.has(data.path)) {
		var existing = pathToDataMap.get(data.path);
		existing.update(data);
		return existing;
	}
	this.fileLists = new Set();
	this.data = {};
	this.update(data);
	pathToDataMap.set(data.path, this);
}

Stats.prototype.update = function update(data) {

	var self = this;

	this.data.name = path.basename(data.path);
	this.data.dirName = path.dirname(data.path);
	this.data.extension = path.extname(data.path).toLowerCase();
	this.data.mime = data.isFile ? mime.lookup(data.path) : 'directory';

	keys.forEach(function (key) {
		this.data[key] = data[key];
	}.bind(this));

	if (this.isDirectory() && !this.children) {
		this.children = [];
		this.childrenPopulated = false;
	}

    // Rerender file lists
	if (this.fileLists.size) {
		Array.from(this.fileLists).forEach(function (filelistEl) {
			filelistEl.innerHTML = '';
			self.renderFileList(filelistEl, filelistEl.filelistOptions);
		});
	}
};

Stats.prototype.toDoc = function toDoc() {
	var out = {
		__webStatDoc: true
	};
	keys.forEach(function (key) {
		out[key] = this.data[key];
	}.bind(this));
	return out;
};

Stats.prototype.updateChildren = function () {
	if(!this.isDirectory()) throw Error('Not a directory');

	var self = this;
	return fs.readdir(self.data.path)
	.then(function (arr) {
		return Promise.all(arr.map(function (child) {
			return Stats.fromPath(path.join(self.data.path, child));
		}));
	})
	.then(function (statsArray) {
		self.children.splice(0);
		self.children.push.apply(self.children, statsArray);

		// Let server know	
		if (!isServer) __ws_js.remoteCmd('CLIENT', {
			cmd: 'watchPath',
			arguments: [self.data.path]
		});

		self.update(self.data);

		return self;  
	});
};

Stats.prototype.destroyFileList = function (el) {
	el.stats = undefined;
	this.fileLists.delete(el);
	el.innerHTML = '';
};

Stats.prototype.renderFileList = function (el, options) {

	el.filelistOptions = options;

	el.stats = this;
	this.fileLists.add(el);
	el.dataset.mime = this.data.mime;
	el.dataset.name = this.data.name;
	el.dataset.size = this.data.size;

	renderFileList(el, this.children, options);
};

// add isFile isDirectory etc
fsFromFn.forEach(function (key) {
	Stats.prototype[key] = new Function('return this.data["' + key + '"];');
});

Stats.fromPath = function (path$$1) {
	return fs.stat(path$$1);
};

Stats.fromDoc = function (data) {
	return new Stats(data);
};

Stats.fromNodeStats = function (path$$1, nodeStat) {

	var out = {};

	fsFromFn.forEach(key => out[key] = nodeStat[key]());
	keys.forEach(key => {
		if (typeof nodeStat[key] !== 'function' && typeof nodeStat[key] !== 'object') {
			out[key] = nodeStat[key];
		}
	});

	out.path = path.resolve(path$$1);

	return new Stats(out);
};

module.exports = Stats;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
