![Postonent](https://user-images.githubusercontent.com/1507057/50406874-db91d080-07cc-11e9-9c39-8f7cb3b84170.png)

A simple UI library for light-weight, highly customizable Email components. Remove the pain of writing emails, by writing the templates in React, then SSR them and pass the generated HTML to the Backend to send it out.

[![npm version](https://badge.fury.io/js/postonents.svg)](https://badge.fury.io/js/postonents) [![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/Saifadin/postonents/issues) [![blazing](https://img.shields.io/badge/Status-Blazing%20%F0%9F%94%A5-brightgreen.svg)](https://github.com/Saifadin/postonents)

## Installation

To start with `postonents` install:

```
yarn add postonents
// or
npm install --save postonents
```

## Simple nodeJS setup

To add postonents to a nodeJS application also add install `react` and `react-dom`.

```
yarn add react react-dom
// or
npm install --save react react-dom
```

This will allow you to write something like this to generate an html string that can be provided to services like sendinblue or mandrill.

```jsx
import React from 'react';
import { renderHtml, Email, PostonentsProvider, Header } from 'postonents';

const Email = ({ email }) => (
  <PostonentsProvider>
    <Email title={`Verification email for ${email}`}>
      <Header logo="https://assets.airbnb.com/press/logos/NBC%20Logo.gif" logoHeight={50} style={{ marginBottom: 24 }} />
    </Email>
  </PostonentsProvider>
);

const getHtml = async () => {
  const html = await renderHtml(Email, { email: 'test@test.com' });

  return html;
};

// Now you can send the email with any email client library/service
```

## Components included

Included in this package are the following components:

- **`Template`**: The Wrapper component, that generates the `<html>`, `<head>` and `<body>` tags with many customization possibilities like adding scripts and global styles.
- **`Container`**: Component to generally wrap `Row`s. By default a max of 600px wide. (for the reason why see [here](http://templates.mailchimp.com/development/html/))
- **`Row`**: Each row has 12 possible `Column`s, that wrap, if they are too big.
- **`Column`**: A Column for content separation, can be customized for `small` (<600px) and `large` (>=600px).
- **`Text`**: Component to display and style text content.
- **`Link`**: Component to display and style links (`a` tag). Can have the look of a link, a primary button and a hollow button.
- **`Image`**: Component for images. Needs a src and either height or width definition.
- **`Header`**, **`Footer`**: Two Layout Components for Layouting
- **`FullWidth`**: Basically a `Container` and a `Row`. For layouting on the top level, if different backgroundColors are wanted.
- **`PostonentsProvider`**, **`PostonentsConsumer`** and **`PostonentContext`**: Multiple possible ways to access or change the internal Context for styling components.
- **`renderHtml`**: A function that server-side renders your template and returns it as a string.

## Component API

All components generally have a `children`, a `className` and a `style` prop and this will be applied to the element that has the styling for easy overrides and customization

### **`Template`**

| Prop            | type                               | required | description                                                                                                      |
| --------------- | ---------------------------------- | -------- | ---------------------------------------------------------------------------------------------------------------- |
| `lang`          | string                             | yes      | Will be added to the `html` tag                                                                                  |
| `title`         | string                             | yes      | The `title` of the email                                                                                         |
| `headAdditions` | array<{ type, children?, props? }> | no       | Needs to be an array, with a type (eg. `link`), props and maybe children, internally we do `React.createElement` |
| `headStyles`    | string                             | no       | Styles in the `head` tag, will automatically be wrapped in `<styles type="text/css>`                             |
| `bodyStyle`     | object                             | no       | will be added to the styles of the `body` tag                                                                    |

### **`Container`**

| Prop        | type             | required             | description                                                                    |
| ----------- | ---------------- | -------------------- | ------------------------------------------------------------------------------ |
| `alignment` | string           | no                   | Pass `center` here to make sure the Container is centered and not left-aligned |
| `maxWidth`  | number \| string | no (defaults to 600) | Will set the max-width of the whole container                                  |

### **`Column`**

| Prop        | type    | required                 | description                                           |
| ----------- | ------- | ------------------------ | ----------------------------------------------------- |
| `small`     | number  | no (defaults to 12)      | The column count from 1 to 12 for screens under 600px |
| `large`     | number  | no (defaults to `small)` | The column count from 1 to 12 for screens above 600px |
| `noPadding` | boolean | no                       | Will remove the padding of the column                 |

### **`Link`**

| Prop        | type    | required                | description                          |
| ----------- | ------- | ----------------------- | ------------------------------------ |
| `href`      | string  | yes                     | Target of the link                   |
| `type`      | enum    | no (defaults to 'link') | Can be 'link', 'primary' or 'hollow' |
| `fullWidth` | boolean | no                      | Makes the Link expand to the fullest |

### **`Image`**

| Prop     | type   | required | description             |
| -------- | ------ | -------- | ----------------------- |
| `src`    | string | yes      | The source of the image |
| `height` | number | no       | The height of the image |
| `width`  | number | no       | The width of the image  |

### **`Header`**

| Prop       | type   | required | description                                                                            |
| ---------- | ------ | -------- | -------------------------------------------------------------------------------------- |
| `logo`     | string | no       | src of log, if passed will render a logo horizontally centered at the top of the email |
| `title`    | string | no       | if passed, will render the title, right under the logo.                                |
| `children` | Node   | no       | For custom styling you can pass whatever you want                                      |

### **`renderHtml(Template, emailData, headStyles)`**

| Argument     | type   | required | description                                                               |
| ------------ | ------ | -------- | ------------------------------------------------------------------------- |
| `Template`   | Node   | yes      | The Template Component                                                    |
| `emailData`  | object | no       | emailData will be spread as props to the uppermost component in your tree |
| `headStyles` | string | no       | For global styling you can pass styles that go into the head here         |

## Theming

If you do not have special and custom styling purposes, the default theme will be more than enough. But if you would like some more control, this is the theme that can be overriden, by passing it as a `theme` prop to `PostonentsProvider`, that need to be the first element:

```jsx
<PostonentsProvider theme={{ ... }}>
  <Template>
    ...
  </Template>
</PostonentsProvider>
```

This is the current theme, it may be extended in the future.

```javascript
const DefaultTheme = {
  colors: {
    text: '#4c5b5c', // Txxt Color
    bodyBg: '#fafafa', // Background Color of `body`
    footerBg: '#4c5b5c', // Background Color of footer
    footerText: 'white', // Text Color of Footer
    primaryBg: '#6699cc', // Background Color of primary button
    primary: 'white', // text color of primary button
    hollow: '#4c5b5c', // text color and border color of hollow button
  },
  typo: {
    fontFamily: 'Helvetica, sans-serif', // Font family
    fontSize: '14px', // Font Size
    lineHeight: '24px', // line height
    light: 300, // definition for light font weight
    normal: 400, // definition for normal font weight
    bold: 600, // definition for bold font weight
  },
};
```

## Examples

Examples will be added regularly and will be visible on [Github Pages](https://saifadin.github.io/postonents/)

## FAQs

**My columns are not showing up after sending them out**

This happens a lot with Mandrill Users. Please refer to this [article in the HelpCenter](https://mandrill.zendesk.com/hc/en-us/articles/205582437-CSS-Inlining) and make sure automatic CSS inlining is deactivated.
