# 编码规范

HT框架的「命名规范」以及「代码审查制度」，由于版本或历史遗留问题，某些特例可能并未严格遵守这项规范。

## 术语定义

- **Pascal 大小写**

> 将标识符的首字母和后面连接的每个单词的首字母都大写。
例如：CodingStandard

- **Camel 大小写**

> 将标识符的首字母小写，而后面连接的每个单词的首字母都大写。
例如：codingStandard

## 命名规范

- **文件及文件夹**

> 1.文件/文件夹名遵从Pascal命名法，无特殊情况，扩展名小写。
> 2.C#类使用统一而又通用的文件扩展名： C# 类名 .cs，正常情况下，一个cs文件中不能含有两个及以上的类。

- **代码注释**

> public、protect等可被外界访问权限的类、方法、属性、变量等，都应使用C#的标准XML注释语法，例如：
```csharp
/// <summary>
/// 方法功能简述
/// </summary>
/// <param name="a">第一个参数 a</param>
/// <param name="b">第二个参数 b</param>
/// <returns>返回值简述</returns>
```
> 其他如私有变量、方法等可使用常规//单行注释或/**/多行注释。

- **命名空间**

> 命名空间的命名：Pascal，例如：`System.Drawing`

- **类、结构体**

> 类、结构体的命名：Pascal，例如：`AppDomain`

- **枚举类型**

> 枚举类型的命名：Pascal，例如：`ErrorLevel`。

- **枚举值**

> 枚举值的命名：Pascal，例如：`FatalError`。

- **接口**

> 接口的命名：I + Pascal，例如：`IDisposable`，（应当总是以 I 前缀开始）。

- **公开的/内部的/静态的属性、字段**

> 公开的/内部的属性、字段的命名：Pascal，例如：`BackColor`。

- **受保护的/私有的属性、字段**

> 受保护的/私有的属性、字段的命名：_ + Camel，例如：`_redValue`。

- **参数**

> 参数的命名：Camel，例如：`typeName`。

- **局部变量**

> 局部变量的命名：Camel，例如：`backColor`。

- **常量**

> 常量的命名：全大写，例如：`VALUE`。

- **方法**

> 方法的命名：Pascal，例如：`ToString`。

- **回调方法**

> 回调方法的命名：On + Pascal，例如：`OnInitialization`，（应当总是以 On 前缀开始）。

## 类成员排序规范

- **按作用域排序（从上至下）**

> 静态（只读、常量）成员 - 实例成员。

- **按类型排序（从上至下）**

> 字段 - 属性 - 方法。

- **按权限排序（从上至下）**

> 公有（内部）成员 - 保护成员 - 私有成员。

## 类成员分段规范

一个分段内的成员之间`不留间隔`，两个分段之间留`一个空白行作为间隔`。

- **按作用域分段**

> 静态（只读、常量）成员为一段，实例成员为一段。

- **按类型分段**

> 字段为一段，属性为一段，方法为一段。

- **按权限分段**

> 公有（内部）成员为一段，保护成员为一段，私有成员为一段。

- **按业务分段**

> 不同业务功能为一段。

## 代码审查制度

参考该文档：[Code Review Checklist and Guidelines for C# Developers](https://www.codeproject.com/Reference/593751/Code-Review-Checklist-and-Guidelines-for-Csharp-De)。

- **编译完成后，确保控制台没有任何警告。**

- **去掉所有没有用到的 usings，编码过程中去掉多余代码是个好习惯。**

- **在合理的地方检查对象是否为 null，避免运行的时候出现 Null Reference Exception。**

- **始终遵循命名规范。**

- **如果可以，尽量减小方法体的大小，减少代码的分支，保持成员名的简短。**

- **代码可重用性：如果一块代码已经被使用超过一次，或者你希望将来使用它，请提取成一个方法，将重复的工作做成通用的方法放在相关的类中，这样一旦你完成别人就可以使用了。**

- **代码一致性：比方说，Int32 写成 int，String 写成 string，应该在代码里保持统一形式，不能一会儿写成 int 一会儿写成 Int32。**

- **代码可读性：代码应该是可维护的，便于其他开发者理解。**

- **及时释放非托管资源，比如文件I/O，网络资源等，一旦使用结束就应该释放它们，如果你想一旦超出使用范围就自动释放对象，可以使用 using 将非托管代码括起来。**

- **合理实现异常处理(try/catch 和 finally 块)和异常记录。**

- **如果代码只会使用一次，请使用匿名类型。**

- **使用访问限定符(private, public, protected, internal, protected internal)限定每个方法、类或变量的访问范围，比方说如果一个类只会在程序集内使用，那么定义成 internal 就足够了。**

- **在需要保持解耦的地方使用接口，有些设计模式的出现也是由于接口的使用。**

- **按照用法和需要将类定义为 sealed、static 或 abstract。**

- **如果需要多次（大于3次）串联，请使用 Stringbuilder 代替 string，这可以节省堆内存。**

- **检查是否有不可能执行的代码，如果有，请修改。**

- **在每个方法前注释，说明它的用法、输入类型和返回值类型信息。**

- **尽量减少强制转换和类型转换的次数，因为会造成性能损失。**

- **确认代码是否有内存泄漏，如果有，请确保已修正。**

- **要透彻理解 OOP 概念，并尽可能在自己的代码里实现。**

- **了解整个项目的设计架构，可以从整体上理解程序的执行流程。**
