/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol.x;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.conf.ReadableProperty;
import com.mysql.cj.exceptions.AssertionFailedException;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.MessageListener;
import com.mysql.cj.protocol.MessageReader;
import com.mysql.cj.protocol.SocketConnection;
import com.mysql.cj.protocol.x.MessageConstants;
import com.mysql.cj.protocol.x.XMessage;
import com.mysql.cj.protocol.x.XMessageHeader;
import com.mysql.cj.protocol.x.XProtocolError;
import com.mysql.cj.x.protobuf.Mysqlx;
import com.mysql.cj.x.protobuf.MysqlxNotice;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AsyncMessageReader
implements CompletionHandler<Integer, Void>,
MessageReader<XMessageHeader, XMessage> {
    private XMessageHeader header;
    private ByteBuffer messageBuf;
    private PropertySet propertySet;
    private SocketConnection sc;
    private MessageListener<XMessage> currentMessageListener;
    private BlockingQueue<MessageListener<XMessage>> messageListenerQueue = new LinkedBlockingQueue<MessageListener<XMessage>>();
    private CompletableFuture<XMessageHeader> pendingMsgHeader;
    private Object pendingMsgMonitor = new Object();
    private boolean stopAfterNextMessage = false;
    private ReadingState state;

    public AsyncMessageReader(PropertySet propertySet, SocketConnection socketConnection) {
        this.propertySet = propertySet;
        this.sc = socketConnection;
    }

    public void start() {
        this.readMessageHeader();
    }

    public void stopAfterNextMessage() {
        this.stopAfterNextMessage = true;
    }

    public void pushMessageListener(MessageListener<XMessage> l) {
        if (!this.sc.getAsynchronousSocketChannel().isOpen()) {
            throw new CJCommunicationsException("async closed");
        }
        this.messageListenerQueue.add(l);
    }

    private MessageListener<XMessage> getMessageListener(boolean block) {
        if (this.currentMessageListener == null) {
            if (block) {
                try {
                    this.currentMessageListener = this.messageListenerQueue.take();
                }
                catch (InterruptedException ex) {
                    throw new CJCommunicationsException(ex);
                }
            } else {
                this.currentMessageListener = (MessageListener)this.messageListenerQueue.poll();
            }
        }
        return this.currentMessageListener;
    }

    private void readMessageHeader() {
        this.state = ReadingState.READING_HEADER;
        if (this.header == null) {
            this.header = new XMessageHeader();
        }
        if (this.header.getBuffer().position() < 5) {
            this.sc.getAsynchronousSocketChannel().read(this.header.getBuffer(), null, this);
            return;
        }
        this.state = ReadingState.READING_MESSAGE;
        this.messageBuf = ByteBuffer.allocate(this.header.getMessageSize());
        this.readMessage();
    }

    private void readMessage() {
        if (this.messageBuf.position() < this.header.getMessageSize()) {
            this.sc.getAsynchronousSocketChannel().read(this.messageBuf, null, this);
            return;
        }
        ByteBuffer buf = this.messageBuf;
        this.messageBuf = null;
        Class<? extends GeneratedMessage> messageClass = MessageConstants.getMessageClassForType(this.header.getMessageType());
        boolean localStopAfterNextMessage = this.stopAfterNextMessage;
        buf.flip();
        this.dispatchMessage(this.header, this.parseMessage(messageClass, buf));
        if (localStopAfterNextMessage && messageClass != MysqlxNotice.Frame.class) {
            this.stopAfterNextMessage = false;
            this.header = null;
            return;
        }
        this.header = null;
        this.readMessageHeader();
    }

    private GeneratedMessage parseMessage(Class<? extends GeneratedMessage> messageClass, ByteBuffer buf) {
        try {
            Parser<? extends GeneratedMessage> parser = MessageConstants.MESSAGE_CLASS_TO_PARSER.get(messageClass);
            return (GeneratedMessage)parser.parseFrom(CodedInputStream.newInstance((ByteBuffer)buf));
        }
        catch (InvalidProtocolBufferException ex) {
            throw AssertionFailedException.shouldNotHappen((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(XMessageHeader hdr, GeneratedMessage message) {
        Object object;
        if (message.getClass() == MysqlxNotice.Frame.class && ((MysqlxNotice.Frame)message).getScope() == MysqlxNotice.Frame.Scope.GLOBAL) {
            throw new RuntimeException("TODO: implement me");
        }
        if (this.getMessageListener(false) == null) {
            object = this.pendingMsgMonitor;
            synchronized (object) {
                this.pendingMsgHeader = CompletableFuture.completedFuture(hdr);
                this.pendingMsgMonitor.notify();
            }
        }
        this.getMessageListener(true);
        object = this.pendingMsgMonitor;
        synchronized (object) {
            boolean currentListenerDone = (Boolean)this.currentMessageListener.createFromMessage(new XMessage((Message)message));
            if (currentListenerDone) {
                this.currentMessageListener = null;
            }
            this.pendingMsgHeader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Integer bytesRead, Void v) {
        if (bytesRead < 0) {
            try {
                this.sc.getAsynchronousSocketChannel().close();
            }
            catch (IOException ex) {
                throw AssertionFailedException.shouldNotHappen(ex);
            }
            finally {
                if (this.currentMessageListener == null) {
                    this.currentMessageListener = (MessageListener)this.messageListenerQueue.poll();
                }
                if (this.currentMessageListener != null) {
                    this.currentMessageListener.closed();
                }
                this.currentMessageListener = null;
                Object object = this.pendingMsgMonitor;
                synchronized (object) {
                    this.pendingMsgHeader = new CompletableFuture();
                    this.pendingMsgHeader.completeExceptionally(new CJCommunicationsException("Socket closed"));
                    this.pendingMsgMonitor.notify();
                }
            }
            return;
        }
        try {
            if (this.state == ReadingState.READING_HEADER) {
                this.readMessageHeader();
            } else {
                this.readMessage();
            }
        }
        catch (Throwable t) {
            try {
                this.sc.getAsynchronousSocketChannel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentMessageListener != null) {
                try {
                    this.currentMessageListener.error(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.messageListenerQueue.forEach(l -> {
                try {
                    l.error(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Object object = this.pendingMsgMonitor;
            synchronized (object) {
                this.pendingMsgHeader = new CompletableFuture();
                this.pendingMsgHeader.completeExceptionally(t);
                this.pendingMsgMonitor.notify();
            }
            this.messageListenerQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable exc, Void v) {
        if (this.getMessageListener(false) != null) {
            Object object = this.pendingMsgMonitor;
            synchronized (object) {
                this.pendingMsgMonitor.notify();
            }
            if (AsynchronousCloseException.class.equals(exc.getClass())) {
                this.currentMessageListener.closed();
            } else {
                this.currentMessageListener.error(exc);
            }
        }
        this.currentMessageListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMessageHeader readHeader() throws IOException {
        XMessageHeader mh;
        Object object = this.pendingMsgMonitor;
        synchronized (object) {
            if (!this.sc.getAsynchronousSocketChannel().isOpen()) {
                throw new CJCommunicationsException("async closed");
            }
            while (this.pendingMsgHeader == null) {
                try {
                    this.pendingMsgMonitor.wait();
                }
                catch (InterruptedException ex) {
                    throw new CJCommunicationsException(ex);
                }
            }
            try {
                mh = this.pendingMsgHeader.get();
            }
            catch (ExecutionException ex) {
                throw new CJCommunicationsException("Failed to peek pending message", ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new CJCommunicationsException(ex);
            }
        }
        if (mh.getMessageType() == 1) {
            this.readMessage((Optional<XMessage>)null, mh);
        }
        return mh;
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, XMessageHeader hdr) throws IOException {
        Class<? extends GeneratedMessage> msgClass = MessageConstants.getMessageClassForType(hdr.getMessageType());
        return this.readSync(msgClass);
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, int expectedType) throws IOException {
        Class<? extends GeneratedMessage> msgClass = MessageConstants.getMessageClassForType(expectedType);
        return this.readSync(msgClass);
    }

    private <T extends GeneratedMessage> XMessage readSync(Class<T> expectedClass) {
        SyncReader<T> r = new SyncReader<T>(this.propertySet, this, expectedClass);
        return new XMessage((Message)r.read());
    }

    private static final class SyncReader<T>
    implements MessageListener<XMessage> {
        private CompletableFuture<Function<BiFunction<Class<? extends GeneratedMessage>, GeneratedMessage, T>, T>> future = new CompletableFuture();
        private Class<T> expectedClass;
        private ReadableProperty<Integer> asyncTimeout;

        public SyncReader(PropertySet propertySet, AsyncMessageReader rdr, Class<T> expectedClass) {
            this.asyncTimeout = propertySet.getIntegerReadableProperty("xdevapi.asyncResponseTimeout");
            this.expectedClass = expectedClass;
            rdr.pushMessageListener(this);
        }

        @Override
        public Boolean createFromMessage(XMessage msg) {
            return this.future.complete(c -> c.apply(msg.getMessage().getClass(), (GeneratedMessage)msg.getMessage()));
        }

        @Override
        public void error(Throwable ex) {
            this.future.completeExceptionally(ex);
        }

        @Override
        public void closed() {
            this.future.completeExceptionally(new CJCommunicationsException("Socket closed"));
        }

        public T read() {
            try {
                return ((CompletableFuture)this.future.thenApply(f -> f.apply((msgClass, msg) -> {
                    if (Mysqlx.Error.class.equals(msgClass)) {
                        throw new XProtocolError((Mysqlx.Error)Mysqlx.Error.class.cast(msg));
                    }
                    if (!msgClass.equals(this.expectedClass)) {
                        throw new WrongArgumentException("Unexpected message class. Expected '" + this.expectedClass.getSimpleName() + "' but actually received '" + msgClass.getSimpleName() + "'");
                    }
                    return this.expectedClass.cast(msg);
                }))).get(this.asyncTimeout.getValue().intValue(), TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                if (XProtocolError.class.equals(ex.getCause().getClass())) {
                    throw new XProtocolError((XProtocolError)ex.getCause());
                }
                throw new CJCommunicationsException(ex.getCause().getMessage(), ex.getCause());
            }
            catch (InterruptedException | TimeoutException ex) {
                throw new CJCommunicationsException(ex);
            }
        }
    }

    private static enum ReadingState {
        READING_HEADER,
        READING_MESSAGE;

    }
}

