type Brand = {
	id: number;
	name: string;
	link: string;
	image: JSX.Element;
};

const i = 1;

const brandData: Brand[] = [
	{
		id: 1 + i,
		name: "NextJSTemplates",
		link: "https://nextjstemplates.com",
		image: (
			<svg
				width='101'
				height='28'
				viewBox='0 0 101 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<path
					d='M87.327 15.8857C87.327 15.4867 87.674 15.1571 88.073 15.1571C88.472 15.1571 88.8016 15.4867 88.8016 15.8857C88.8016 16.2847 88.4547 16.6143 88.073 16.6143C87.6913 16.6143 87.327 16.2847 87.327 15.8857Z'
					fill='currentColor'
				/>
				<path
					d='M89.8252 14.0294H90.814V14.3937C90.814 15.1224 91.213 15.6602 92.0457 15.6602C92.8784 15.6602 93.2601 15.1397 93.2601 14.359V8.98109H94.2663V14.3937C94.2663 15.7469 93.3642 16.5796 92.0284 16.5796C90.6058 16.5796 89.8078 15.6775 89.8078 14.3764V14.0121L89.8252 14.0294Z'
					fill='currentColor'
				/>
				<path
					d='M98.1003 8.87701C99.5228 8.87701 100.442 9.67502 100.529 10.9761H99.5055C99.4534 10.2302 98.933 9.79646 98.0829 9.79646C97.1461 9.79646 96.5389 10.2649 96.5389 11.0108C96.5389 11.618 96.8859 11.965 97.5798 12.1385L98.8115 12.4334C100.026 12.711 100.65 13.3702 100.65 14.4284C100.65 15.7816 99.6096 16.6317 98.0135 16.6317C96.4175 16.6317 95.4807 15.8336 95.4113 14.5499H96.4522C96.4695 15.2611 97.0767 15.7122 98.0135 15.7122C99.0024 15.7122 99.6443 15.2438 99.6443 14.4978C99.6443 13.908 99.332 13.5437 98.6034 13.3702L97.3716 13.0926C96.1573 12.815 95.5154 12.1038 95.5154 11.0282C95.5154 9.74442 96.5563 8.87701 98.1003 8.87701Z'
					fill='currentColor'
				/>
				<path
					d='M47.5839 1.39989V12.1731L40.4538 1.39989H37.8168V16.6143H40.4364V5.82368L47.5839 16.6143H50.2034V1.39989H47.5839Z'
					fill='currentColor'
				/>
				<path
					d='M61.6186 1.39989V3.84598H54.8354V7.76668H60.9073V10.1087H54.8354V14.1508H61.6186V16.6143H52.1638V1.39989H61.6186Z'
					fill='currentColor'
				/>
				<path
					d='M78.6545 1.39989L76.9891 3.84598H81.8119V16.6143H84.4835V3.84598H87.8837L89.5318 1.39989H78.6545Z'
					fill='currentColor'
				/>
				<path
					d='M67.3261 10.6117L68.9568 13.0058L66.4934 16.6142H63.2493L67.3261 10.6117Z'
					fill='currentColor'
				/>
				<path
					d='M76.885 16.6142H73.6235L70.0671 11.3751L68.4364 8.98101L63.284 1.39985H66.5281L70.0671 6.58696L73.5888 1.39985H76.8329L73.398 6.44818L71.6805 8.98101L76.885 16.6142Z'
					fill='currentColor'
				/>
				<path
					d='M37.8168 18.6348H42.3621V19.2246H40.4017V24.9669H39.7598V19.2246H37.8168V18.6348Z'
					fill='currentColor'
				/>
				<path
					d='M42.1539 22.8157C42.1539 21.4799 42.9866 20.5604 44.2183 20.5604C45.45 20.5604 46.1613 21.3758 46.1613 22.5902V22.8851H42.7437C42.7958 23.926 43.3336 24.5332 44.253 24.5332C44.9469 24.5332 45.398 24.2382 45.5715 23.6657H46.1613C45.9358 24.5679 45.2592 25.0536 44.253 25.0536C42.9866 25.0536 42.1539 24.1515 42.1539 22.8157ZM42.7611 22.4514H45.5541C45.5541 21.636 45.0163 21.0809 44.2183 21.0809C43.4203 21.0809 42.8825 21.6187 42.7784 22.4514H42.7611Z'
					fill='currentColor'
				/>
				<path
					d='M47.1328 24.9669V20.6819H47.6706L47.74 21.289C47.9482 20.838 48.4339 20.5604 49.0411 20.5604C49.7177 20.5604 50.2208 20.9074 50.429 21.4799C50.6198 20.9247 51.1402 20.5604 51.8342 20.5604C52.771 20.5604 53.3782 21.1676 53.3782 22.1564V24.9669H52.7883V22.2952C52.7883 21.5666 52.372 21.1329 51.7301 21.1329C51.0188 21.1329 50.5851 21.6707 50.5851 22.3299V24.9669H49.9779V22.2779C49.9779 21.5493 49.5616 21.1329 48.9197 21.1329C48.2084 21.1329 47.7747 21.6707 47.7747 22.3126V24.9669H47.1328Z'
					fill='currentColor'
				/>
				<path
					d='M54.5925 20.6819H55.1303L55.1997 21.5493C55.4946 20.89 56.1018 20.5604 56.8304 20.5604C58.0795 20.5604 58.8081 21.5146 58.8081 22.7983C58.8081 24.0821 58.0969 25.0536 56.8304 25.0536C56.1018 25.0536 55.5293 24.7413 55.2344 24.1168V26.8058H54.6272V20.6645L54.5925 20.6819ZM56.709 24.5158C57.6458 24.5158 58.1836 23.8045 58.1836 22.8157C58.1836 21.8268 57.6458 21.1156 56.709 21.1156C55.7722 21.1156 55.2171 21.8268 55.2171 22.8157C55.2171 23.8045 55.7722 24.5158 56.709 24.5158Z'
					fill='currentColor'
				/>
				<path
					d='M59.797 24.9669V18.947L60.4042 18.5133V24.9495H59.797V24.9669Z'
					fill='currentColor'
				/>
				<path
					d='M61.4798 23.8045C61.4798 23.0239 62.087 22.5208 63.0932 22.4514L64.5157 22.3299V22.1911C64.5157 21.3584 64.0126 21.0809 63.3881 21.0809C62.6421 21.0809 62.2084 21.4105 62.2084 22.0003H61.6533C61.6533 21.1329 62.3645 20.5778 63.4228 20.5778C64.4116 20.5778 65.1402 21.0809 65.1402 22.2085V24.9669H64.6198L64.5331 24.2209C64.2728 24.7587 63.683 25.0883 62.9544 25.0883C62.0349 25.0883 61.4971 24.5678 61.4971 23.8219L61.4798 23.8045ZM64.4984 23.0239V22.7983L63.2319 22.9024C62.4166 22.9718 62.1043 23.3188 62.1043 23.8045C62.1043 24.325 62.486 24.5852 63.0758 24.5852C63.9779 24.5852 64.4984 23.9607 64.4984 23.0239Z'
					fill='currentColor'
				/>
				<path
					d='M66.6322 24.9669V21.2023H65.7648V20.6819H66.6322V19.745L67.2394 19.3287V20.6819H68.1068V21.2023H67.2394V24.9669H66.6322Z'
					fill='currentColor'
				/>
				<path
					d='M68.5405 22.8157C68.5405 21.4799 69.3732 20.5604 70.6049 20.5604C71.8366 20.5604 72.5479 21.3758 72.5479 22.5902V22.8851H69.1303C69.1824 23.926 69.7202 24.5332 70.6396 24.5332C71.3335 24.5332 71.7846 24.2382 71.9581 23.6657H72.5479C72.3224 24.5679 71.6458 25.0536 70.6396 25.0536C69.3732 25.0536 68.5405 24.1515 68.5405 22.8157ZM69.1477 22.4514H71.9407C71.9407 21.636 71.4029 21.0809 70.6049 21.0809C69.8069 21.0809 69.2691 21.6187 69.165 22.4514H69.1477Z'
					fill='currentColor'
				/>
				<path
					d='M73.745 23.7525C73.745 24.2556 74.1093 24.5505 74.7165 24.5505C75.3757 24.5505 75.7747 24.2729 75.7747 23.8045C75.7747 23.4576 75.6012 23.2494 75.0981 23.128L74.3695 22.9371C73.6235 22.7463 73.2592 22.3646 73.2592 21.7748C73.2592 21.0288 73.8837 20.5431 74.8032 20.5431C75.7227 20.5431 76.2951 21.0462 76.3125 21.8268H75.7226C75.7226 21.3237 75.3583 21.0462 74.7858 21.0462C74.2134 21.0462 73.849 21.3064 73.849 21.7574C73.849 22.0871 74.0746 22.3126 74.543 22.434L75.2716 22.6249C76.0176 22.8157 76.3472 23.1626 76.3472 23.7698C76.3472 24.5332 75.6879 25.0363 74.7165 25.0363C73.745 25.0363 73.1551 24.5158 73.1551 23.7351H73.745V23.7525Z'
					fill='currentColor'
				/>
				<path
					d='M99.9079 22.9154H79.4023L80.183 22.0133H100.671L99.9079 22.9154Z'
					fill='currentColor'
				/>
				<path
					d='M28.0173 13.9827C28.0173 15.9083 27.6357 17.7472 26.9417 19.3953C24.8253 24.461 19.8463 28 14.0173 28C6.28005 28 0 21.7373 0 14C0 6.2627 6.28005 0 14.0173 0C18.5105 0 22.518 2.11648 25.0855 5.41264H13.7571L15.7348 8.37918H18.2676V17.5737L15.4399 13.2887L10.2181 5.41264H7.2342V22.4H10.2007V10.4089L18.2676 22.5874H21.2168V8.37918H26.855C27.601 10.0967 28.0173 11.9876 28.0173 13.9827Z'
					fill='currentColor'
				/>
			</svg>
		),
	},
	{
		id: 1 + i,
		name: "FormBold",
		link: "https://formbold.com",
		image: (
			<svg
				width='153'
				height='28'
				viewBox='0 0 153 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<path
					d='M28 0V28H10.8031V22.3096H22.6864V16.7699H10.8031V11.3055H22.6864V5.84118H5.38896V28H0V0H28Z'
					fill='currentColor'
				/>
				<path
					d='M51.4835 15.6629V12.6489H44.3547V7.43334H52.8463V4.34071H41V23.4993H44.3547V15.6629H51.4835Z'
					fill='currentColor'
				/>
				<path
					d='M53.2473 16.9995C53.2473 21.0357 56.1564 23.8138 60.1664 23.8138C64.1763 23.8138 67.0855 21.0357 67.0855 16.9995C67.0855 12.9634 64.1763 10.1853 60.1664 10.1853C56.1564 10.1853 53.2473 12.9634 53.2473 16.9995ZM56.4447 16.9995C56.4447 14.6407 57.9648 13.042 60.1664 13.042C62.3679 13.042 63.888 14.6407 63.888 16.9995C63.888 19.3583 62.3679 20.957 60.1664 20.957C57.9648 20.957 56.4447 19.3583 56.4447 16.9995Z'
					fill='currentColor'
				/>
				<path
					d='M77.3515 10.4998C76.8273 10.3687 76.3818 10.3163 75.9362 10.3163C74.2064 10.3163 72.9746 11.1812 72.4243 12.4654L72.2408 10.5784H69.2268V23.4993H72.4243V17.2092C72.4243 14.6932 73.8657 13.4613 76.1721 13.4613H77.3515V10.4998Z'
					fill='currentColor'
				/>
				<path
					d='M82.3201 23.4993V16.1608C82.3201 14.0641 83.5519 13.0682 85.072 13.0682C86.5921 13.0682 87.5618 14.0379 87.5618 15.8463V23.4993H90.7593V16.1608C90.7593 14.0379 91.9387 13.042 93.485 13.042C95.0051 13.042 96.001 14.0117 96.001 15.8725V23.4993H99.1723V15.0339C99.1723 12.0461 97.4425 10.159 94.2975 10.159C92.3318 10.159 90.8117 11.1288 90.1565 12.6227C89.4751 11.1288 88.1122 10.159 86.1466 10.159C84.2857 10.159 82.9753 10.9977 82.3201 12.0723L82.058 10.5522H79.1226V23.4993H82.3201Z'
					fill='currentColor'
				/>
				<path
					d='M102.39 23.4993H110.148C114.105 23.4993 116.385 21.5861 116.385 18.31C116.385 16.0822 115.363 14.5621 113.345 13.9069C115.153 13.1468 116.097 11.6267 116.097 9.50383C116.097 6.30637 113.791 4.34071 110.017 4.34071H102.39V23.4993ZM109.728 7.3023C111.615 7.3023 112.664 8.19339 112.664 9.84454C112.664 11.5481 111.642 12.5178 109.807 12.5178H105.745V7.3023H109.728ZM110.017 15.3484C111.877 15.3484 112.952 16.2657 112.952 17.8906C112.952 19.6204 111.904 20.5377 110.017 20.5377H105.745V15.3484H110.017Z'
					fill='currentColor'
				/>
				<path
					d='M117.836 16.9995C117.836 21.0357 120.746 23.8138 124.755 23.8138C128.765 23.8138 131.675 21.0357 131.675 16.9995C131.675 12.9634 128.765 10.1853 124.755 10.1853C120.746 10.1853 117.836 12.9634 117.836 16.9995ZM121.034 16.9995C121.034 14.6407 122.554 13.042 124.755 13.042C126.957 13.042 128.477 14.6407 128.477 16.9995C128.477 19.3583 126.957 20.957 124.755 20.957C122.554 20.957 121.034 19.3583 121.034 16.9995Z'
					fill='currentColor'
				/>
				<path
					d='M137.04 23.4993V4H133.868V23.4993H137.04Z'
					fill='currentColor'
				/>
				<path
					d='M145.321 23.84C147.287 23.84 148.964 22.9751 149.75 21.4812L149.96 23.4993H152.895V4H149.724V12.2033C148.912 10.9191 147.313 10.159 145.504 10.159C141.599 10.159 139.241 13.042 139.241 17.0782C139.241 21.0881 141.573 23.84 145.321 23.84ZM146.029 20.9046C143.801 20.9046 142.438 19.2797 142.438 16.9733C142.438 14.6669 143.801 13.0158 146.029 13.0158C148.256 13.0158 149.698 14.6407 149.698 16.9733C149.698 19.3059 148.256 20.9046 146.029 20.9046Z'
					fill='currentColor'
				/>
			</svg>
		),
	},
	{
		id: 1 + i,
		name: "Lineicons",
		link: "https://lineicons.com",
		image: (
			<svg
				width='173'
				height='28'
				viewBox='0 0 173 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<g clipPath='url(#clip0_2911_30)'>
					<path
						d='M41.0808 2.1517H37.0198V25.3354H50.7918V21.595H41.0808V2.1517Z'
						fill='currentColor'
					/>
					<path
						d='M55.4514 6.52626C56.7196 6.52626 57.7669 5.47893 57.7669 4.17511C57.7669 2.87129 56.7196 1.86671 55.4514 1.86671C54.1191 1.86671 53.0718 2.88554 53.0718 4.18224C53.0718 5.47893 54.1262 6.52626 55.4514 6.52626ZM53.5278 25.3354H57.3965V9.66112H53.5278V25.3354Z'
						fill='currentColor'
					/>
					<path
						d='M65.262 25.3354V16.8998C65.262 14.3634 66.7154 12.7105 69.1022 12.7105C71.1043 12.7105 72.4009 13.9787 72.4009 16.6148V25.3425H76.2697V15.6886C76.2697 11.6275 74.2391 9.19089 70.3063 9.19089C68.1831 9.19089 66.2808 10.11 65.2976 11.6988L64.977 9.66824H61.3933V25.3425H65.262V25.3354Z'
						fill='currentColor'
					/>
					<path
						d='M87.0848 25.7486C91.1744 25.7486 94.0314 23.6896 94.694 20.2555H91.1103C90.6614 21.7446 89.2721 22.571 87.1418 22.571C84.5698 22.571 83.1164 21.1746 82.8314 18.4173L94.6299 18.3817V17.2133C94.6299 12.3257 91.6446 9.18376 86.9495 9.18376C82.3541 9.18376 79.1479 12.5751 79.1479 17.4983C79.1479 22.3502 82.4182 25.7486 87.0848 25.7486ZM86.9851 12.3614C89.3006 12.3614 90.7897 13.7863 90.7897 15.9451H82.924C83.3016 13.6011 84.6981 12.3614 86.9851 12.3614Z'
						fill='currentColor'
					/>
					<path
						d='M99.6599 6.52626C100.928 6.52626 101.975 5.47893 101.975 4.17511C101.975 2.87129 100.928 1.86671 99.6599 1.86671C98.3276 1.86671 97.2874 2.88554 97.2874 4.18224C97.2874 5.47893 98.3204 6.52626 99.6599 6.52626ZM97.722 25.3354H101.591V9.66112H97.722V25.3354Z'
						fill='currentColor'
					/>
					<path
						d='M104.676 17.4698C104.676 22.4499 107.782 25.7486 112.541 25.7486C116.631 25.7486 119.68 23.2408 120.151 19.5929H116.246C115.833 21.31 114.472 22.2576 112.534 22.2576C110.062 22.2576 108.537 20.4194 108.537 17.4698C108.537 14.5201 110.19 12.6464 112.663 12.6464C114.501 12.6464 115.805 13.5654 116.246 15.3466H120.115C119.702 11.5705 116.781 9.19089 112.506 9.19089C107.882 9.19089 104.676 12.6179 104.676 17.4698Z'
						fill='currentColor'
					/>
					<path
						d='M122.11 17.4698C122.11 22.3573 125.629 25.7202 130.488 25.7202C135.34 25.7202 138.867 22.3644 138.867 17.4698C138.867 12.5822 135.348 9.21939 130.488 9.21939C125.637 9.22652 122.11 12.5822 122.11 17.4698ZM125.986 17.4698C125.986 14.6128 127.824 12.682 130.488 12.682C133.153 12.682 134.991 14.6199 134.991 17.4698C134.991 20.3196 133.153 22.2576 130.488 22.2576C127.824 22.2647 125.986 20.3268 125.986 17.4698Z'
						fill='currentColor'
					/>
					<path
						d='M145.792 25.3354V16.8998C145.792 14.3634 147.246 12.7105 149.632 12.7105C151.635 12.7105 152.931 13.9787 152.931 16.6148V25.3425H156.8V15.6886C156.8 11.6275 154.769 9.19089 150.837 9.19089C148.713 9.19089 146.811 10.11 145.828 11.6988L145.507 9.66824H141.924V25.3425H145.792V25.3354Z'
						fill='currentColor'
					/>
					<path
						d='M172.154 20.6118C172.154 23.7822 169.46 25.7558 165.592 25.7558C161.687 25.7558 159.222 23.654 159.215 20.5904H162.884C162.913 21.9512 163.932 22.8133 165.706 22.8133C167.508 22.8133 168.499 22.0794 168.499 20.9395C168.499 20.1415 168.092 19.5787 166.696 19.2581L163.868 18.5883C161.046 17.9542 159.685 16.6219 159.685 14.114C159.685 11.0362 162.279 9.19089 165.898 9.19089C169.418 9.19089 171.79 11.2285 171.826 14.2708H168.149C168.128 12.9385 167.23 12.0835 165.741 12.0835C164.224 12.0835 163.333 12.7817 163.333 13.9502C163.333 14.8408 164.038 15.4036 165.364 15.7242L168.192 16.3939C170.622 16.9425 171.954 18.0255 172.132 20.0845L172.154 20.6118Z'
						fill='currentColor'
					/>
					<path
						d='M22.1363 24.6889C23.1551 23.6701 23.1551 22.0243 22.1363 21.0055L4.44568 3.31489C3.42685 2.29606 1.78105 2.29606 0.762218 3.31489C-0.256611 4.33372 -0.256611 5.97952 0.762218 6.99835L18.4528 24.6889C19.4716 25.7078 21.1174 25.7078 22.1363 24.6889Z'
						fill='currentColor'
					/>
					<path
						d='M21.6661 11.6293C22.6849 10.6105 22.6849 8.96471 21.6661 7.94588L14.4844 0.764199C13.4655 -0.254631 11.8197 -0.254631 10.8009 0.764199C9.78208 1.78303 9.78208 3.42883 10.8009 4.44766L17.9826 11.6293C19.0014 12.641 20.6472 12.641 21.6661 11.6293Z'
						fill='currentColor'
					/>
					<path
						d='M12.0977 27.2396C13.1165 26.2208 13.1165 24.575 12.0977 23.5562L4.91601 16.3745C3.89718 15.3557 2.25138 15.3557 1.23255 16.3745C0.213723 17.3933 0.213723 19.0391 1.23255 20.058L8.41423 27.2396C9.43306 28.2585 11.0789 28.2585 12.0977 27.2396Z'
						fill='currentColor'
					/>
				</g>
				<defs>
					<clipPath id='clip0_2911_30'>
						<rect width='172.154' height='28' fill='currentColor' />
					</clipPath>
				</defs>
			</svg>
		),
	},
	{
		id: 1 + i,
		name: "Uideck",
		link: "https://uideck.com",
		image: (
			<svg
				width='119'
				height='28'
				viewBox='0 0 119 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<path
					d='M23.9159 10.3141V19.1146C23.9159 20.9027 22.997 22.5641 21.485 23.5148L14.4093 27.9648C14.2599 28.0598 14.0607 27.9512 14.0607 27.7746V24.6601C14.0607 24.1485 14.3143 23.6732 14.7398 23.388L19.2532 20.3776C19.8824 19.9566 20.2627 19.2504 20.2627 18.4944V12.4282C20.2627 11.9438 20.5207 11.4957 20.9417 11.2512L23.2369 9.92935C23.5402 9.75732 23.9159 9.97462 23.9159 10.3232V10.3141Z'
					fill='currentColor'
				/>
				<path
					d='M23.3682 7.67999L13.3726 13.4519C12.671 13.8548 12.2409 14.6017 12.2409 15.412V27.5715C12.2409 27.748 12.0508 27.8567 11.9014 27.7661L2.63922 22.379C1.00499 21.4284 0 19.6855 0 17.7932V10.4324C0 8.21418 1.18154 6.16346 3.1055 5.05436L11.5347 0.183342C11.9557 -0.061114 12.4718 -0.061114 12.8928 0.183342L15.0024 1.4011C15.4551 1.66366 15.4551 2.31554 15.0024 2.57811L4.93892 8.3862C4.23724 8.7891 3.80718 9.53605 3.80718 10.3464V17.3451C3.80718 18.1554 4.23724 18.9023 4.93892 19.3052L8.27529 21.2292C8.34772 21.2699 8.43373 21.2201 8.43373 21.1387V14.1852C8.43373 12.7728 9.18521 11.4736 10.4075 10.7674L20.0771 5.18564C20.5298 4.92307 21.0911 4.94571 21.5212 5.23996L23.4089 6.53015C23.8209 6.81082 23.7982 7.42648 23.3637 7.67999H23.3682Z'
					fill='currentColor'
				/>
				<path
					d='M34.8027 6.42281H38.0308V15.1906C38.0308 15.9102 38.1293 16.5518 38.3261 17.1152C38.523 17.6719 38.8149 18.1438 39.2019 18.5307C39.5957 18.9177 40.0811 19.213 40.6581 19.4167C41.2352 19.6135 41.9073 19.712 42.6744 19.712C43.4348 19.712 44.1035 19.6135 44.6805 19.4167C45.2643 19.213 45.7498 18.9177 46.1367 18.5307C46.5305 18.1438 46.8258 17.6719 47.0227 17.1152C47.2195 16.5518 47.318 15.9102 47.318 15.1906V6.42281H50.5461V15.5776C50.5461 16.6231 50.3696 17.5735 50.0165 18.4289C49.6635 19.2843 49.151 20.0175 48.4789 20.6285C47.8068 21.2395 46.9819 21.7113 46.0043 22.0439C45.0335 22.3766 43.9236 22.5429 42.6744 22.5429C41.4253 22.5429 40.3119 22.3766 39.3343 22.0439C38.3635 21.7113 37.542 21.2395 36.8699 20.6285C36.1978 20.0175 35.6853 19.2843 35.3323 18.4289C34.9792 17.5735 34.8027 16.6231 34.8027 15.5776V6.42281Z'
					fill='currentColor'
				/>
				<path
					d='M52.7762 6.42281H56.0247V22.3393H52.7762V6.42281Z'
					fill='currentColor'
				/>
				<path
					d='M57.542 16.3821C57.542 15.4248 57.7219 14.5626 58.0817 13.7955C58.4415 13.0216 58.9371 12.3631 59.5684 11.8199C60.2066 11.2701 60.9602 10.8491 61.8291 10.5572C62.7049 10.2585 63.6519 10.1092 64.6703 10.1092C65.1048 10.1092 65.5325 10.1363 65.9534 10.1906C66.3811 10.2449 66.7884 10.3196 67.1754 10.4147C67.5691 10.5097 67.9357 10.6251 68.2751 10.7609C68.6214 10.8899 68.9269 11.0324 69.1916 11.1886V5.44522H72.2059V22.3393H69.1916V21.2089C68.9269 21.3922 68.6146 21.5653 68.2548 21.7283C67.895 21.8912 67.508 22.0338 67.0939 22.156C66.6798 22.2782 66.2487 22.3732 65.8006 22.4411C65.3593 22.5158 64.9215 22.5531 64.487 22.5531C63.4686 22.5531 62.5318 22.4038 61.6764 22.105C60.8278 21.8063 60.098 21.3854 59.487 20.8423C58.876 20.2992 58.3974 19.6509 58.0511 18.8973C57.7117 18.137 57.542 17.2985 57.542 16.3821ZM60.709 16.3821C60.709 16.8641 60.804 17.3189 60.9941 17.7466C61.191 18.1743 61.4693 18.5511 61.8291 18.877C62.1957 19.196 62.6336 19.4506 63.1428 19.6407C63.6587 19.824 64.2358 19.9156 64.8739 19.9156C65.2813 19.9156 65.6886 19.8783 66.0959 19.8036C66.5033 19.7222 66.8936 19.6101 67.267 19.4676C67.6472 19.325 68.0002 19.1519 68.3261 18.9482C68.6587 18.7446 68.9472 18.5171 69.1916 18.266V14.101C68.8861 13.8566 68.5637 13.6495 68.2242 13.4798C67.8848 13.3101 67.5386 13.1709 67.1855 13.0623C66.8325 12.9537 66.4761 12.8756 66.1163 12.8281C65.7565 12.7738 65.4069 12.7466 65.0674 12.7466C64.375 12.7466 63.7572 12.8417 63.2141 13.0318C62.6777 13.2151 62.2229 13.4696 61.8495 13.7955C61.4829 14.1214 61.2012 14.5049 61.0043 14.9462C60.8074 15.3875 60.709 15.8661 60.709 16.3821Z'
					fill='currentColor'
				/>
				<path
					d='M74.0287 16.2904C74.0287 15.4757 74.195 14.6984 74.5277 13.9584C74.8603 13.2117 75.3389 12.5531 75.9635 11.9829C76.5881 11.4126 77.3518 10.9578 78.2548 10.6183C79.1645 10.2789 80.1964 10.1092 81.3505 10.1092C82.4978 10.1092 83.5297 10.2823 84.4462 10.6285C85.3695 10.9679 86.1502 11.4364 86.7883 12.0338C87.4333 12.6312 87.9255 13.3339 88.2649 14.1417C88.6111 14.9496 88.7843 15.8152 88.7843 16.7385C88.7843 16.8539 88.7809 16.9795 88.7741 17.1152C88.7741 17.2442 88.7673 17.363 88.7537 17.4717H77.3892C77.5182 17.8315 77.7252 18.1607 78.0104 18.4594C78.3023 18.7581 78.6655 19.0161 79.1 19.2334C79.5344 19.4506 80.0368 19.6203 80.6071 19.7425C81.1773 19.8579 81.8087 19.9156 82.5012 19.9156C83.1936 19.9156 83.8827 19.8444 84.5684 19.7018C85.2541 19.5524 85.9092 19.3658 86.5337 19.1417L87.5521 21.4431C87.1583 21.6264 86.7578 21.7894 86.3504 21.9319C85.9499 22.0677 85.529 22.1831 85.0877 22.2782C84.6532 22.3664 84.195 22.4343 83.713 22.4818C83.2378 22.5294 82.7354 22.5531 82.2059 22.5531C80.8549 22.5531 79.6702 22.3902 78.6519 22.0643C77.6336 21.7385 76.7816 21.2938 76.0959 20.7303C75.4102 20.1668 74.8943 19.5049 74.548 18.7446C74.2018 17.9842 74.0287 17.1662 74.0287 16.2904ZM85.5867 15.1193C85.4781 14.7867 85.3084 14.4778 85.0775 14.1926C84.8535 13.9007 84.5718 13.6495 84.2323 13.4391C83.8929 13.2218 83.4991 13.0521 83.0511 12.9299C82.603 12.8077 82.1108 12.7466 81.5745 12.7466C81.0042 12.7466 80.4849 12.8111 80.0165 12.9401C79.548 13.0691 79.1373 13.2422 78.7843 13.4595C78.4313 13.6767 78.1359 13.9279 77.8983 14.213C77.6675 14.4981 77.4978 14.8003 77.3892 15.1193H85.5867Z'
					fill='currentColor'
				/>
				<path
					d='M90.0062 16.3617C90.0062 15.4791 90.1658 14.6577 90.4849 13.8973C90.8107 13.1302 91.2825 12.4683 91.9003 11.9116C92.5249 11.3481 93.2853 10.9068 94.1814 10.5878C95.0843 10.2687 96.1128 10.1092 97.2669 10.1092C97.7693 10.1092 98.2751 10.1397 98.7842 10.2008C99.2934 10.2619 99.7822 10.3502 100.251 10.4656C100.726 10.5742 101.171 10.7066 101.585 10.8627C101.999 11.0121 102.359 11.1784 102.664 11.3617L101.269 13.6326C100.61 13.3271 99.9859 13.103 99.3952 12.9605C98.8114 12.8179 98.2174 12.7466 97.6131 12.7466C96.9207 12.7466 96.2995 12.8383 95.7496 13.0216C95.1997 13.1981 94.7313 13.4493 94.3443 13.7751C93.9641 14.0942 93.6722 14.4744 93.4686 14.9157C93.2717 15.3501 93.1732 15.8254 93.1732 16.3413C93.1732 16.8573 93.2785 17.3359 93.4889 17.7772C93.7062 18.2116 94.0083 18.5884 94.3952 18.9075C94.789 19.2198 95.2608 19.4676 95.8107 19.6509C96.3674 19.8274 96.9852 19.9156 97.6641 19.9156C98.4108 19.9156 99.1135 19.8104 99.772 19.6C100.437 19.3895 101.055 19.1078 101.625 18.7548L103.02 21.0256C102.661 21.2429 102.27 21.4465 101.849 21.6366C101.428 21.8199 100.977 21.9795 100.495 22.1152C100.02 22.251 99.5174 22.3562 98.9879 22.4309C98.4651 22.5124 97.922 22.5531 97.3586 22.5531C96.2113 22.5531 95.1827 22.397 94.273 22.0847C93.3633 21.7724 92.5928 21.3413 91.9614 20.7914C91.3301 20.2347 90.8447 19.5796 90.5052 18.826C90.1726 18.0725 90.0062 17.251 90.0062 16.3617Z'
					fill='currentColor'
				/>
				<path
					d='M104.976 5.44522H107.99V15.4248L113.611 10.323H118.224L111.941 15.9442L118.621 22.3393H114.1L109.629 18.0114L107.99 19.4778V22.3393H104.976V5.44522Z'
					fill='currentColor'
				/>
			</svg>
		),
	},
	{
		id: 1 + i,
		name: "Graygrids",
		link: "https://graygrids.com",
		image: (
			<svg
				width='134'
				height='28'
				viewBox='0 0 134 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<g clipPath='url(#clip0_2978_61)'>
					<path
						opacity='0.1'
						d='M28 14C28 6.26801 21.732 0 14 0C6.26801 0 0 6.26801 0 14C0 21.732 6.26801 28 14 28C21.732 28 28 21.732 28 14Z'
						fill='url(#paint0_linear_2978_61)'
					/>
					<path
						opacity='0.1'
						d='M28 14C28 6.26801 21.732 0 14 0C6.26801 0 0 6.26801 0 14C0 21.732 6.26801 28 14 28C21.732 28 28 21.732 28 14Z'
						fill='url(#paint1_linear_2978_61)'
						fillOpacity='0.56'
					/>
					<path
						d='M14.2228 5.25C16.4398 5.25 18.5327 6.06909 20.1522 7.56238C20.242 7.64519 20.2429 7.78579 20.1566 7.87212L16.7285 11.3002C16.6455 11.3832 16.5121 11.3853 16.4213 11.3108C15.8022 10.804 15.034 10.5287 14.2242 10.5287C12.3074 10.5274 10.7488 12.086 10.7488 14H5.46875C5.46875 9.17521 9.39665 5.25 14.2228 5.25Z'
						fill='currentColor'
					/>
					<path
						d='M10.7488 14C10.7488 15.7964 12.1214 17.2792 13.8736 17.4552C13.9904 17.4669 14.0834 17.5627 14.0834 17.6801V22.5278C14.0834 22.6499 13.9827 22.7487 13.8606 22.7437C9.20065 22.5528 5.46875 18.7036 5.46875 14H10.7488Z'
						fill='currentColor'
					/>
					<path
						opacity='0.56'
						d='M19.425 14.6945H17.3605C17.2396 14.6945 17.1417 14.7925 17.1417 14.9133V16.9763C17.1417 17.0972 17.2396 17.1951 17.3605 17.1951H19.425C19.5458 17.1951 19.6437 17.0972 19.6437 16.9763V14.9133C19.6437 14.7925 19.5458 14.6945 19.425 14.6945Z'
						fill='currentColor'
					/>
					<path
						opacity='0.4'
						d='M22.2028 14.6945H20.1384C20.0176 14.6945 19.9197 14.7925 19.9197 14.9133V16.9763C19.9197 17.0972 20.0176 17.1951 20.1384 17.1951H22.2028C22.3236 17.1951 22.4216 17.0972 22.4216 16.9763V14.9133C22.4216 14.7925 22.3236 14.6945 22.2028 14.6945Z'
						fill='currentColor'
					/>
					<path
						opacity='0.72'
						d='M19.425 17.4728H17.3605C17.2396 17.4728 17.1417 17.5707 17.1417 17.6915V19.7546C17.1417 19.8754 17.2396 19.9733 17.3605 19.9733H19.425C19.5458 19.9733 19.6437 19.8754 19.6437 19.7546V17.6915C19.6437 17.5707 19.5458 17.4728 19.425 17.4728Z'
						fill='currentColor'
					/>
					<path
						opacity='0.88'
						d='M16.6457 17.4728H14.5813C14.4605 17.4728 14.3625 17.5707 14.3625 17.6915V19.7546C14.3625 19.8754 14.4605 19.9733 14.5813 19.9733H16.6457C16.7666 19.9733 16.8645 19.8754 16.8645 19.7546V17.6915C16.8645 17.5707 16.7666 17.4728 16.6457 17.4728Z'
						fill='currentColor'
					/>
					<path
						opacity='0.56'
						d='M22.2028 17.4728H20.1384C20.0176 17.4728 19.9197 17.5707 19.9197 17.6915V19.7546C19.9197 19.8754 20.0176 19.9733 20.1384 19.9733H22.2028C22.3236 19.9733 22.4216 19.8754 22.4216 19.7546V17.6915C22.4216 17.5707 22.3236 17.4728 22.2028 17.4728Z'
						fill='currentColor'
					/>
					<path
						opacity='0.88'
						d='M19.425 20.2493H17.3605C17.2396 20.2493 17.1417 20.3472 17.1417 20.468V22.5311C17.1417 22.6519 17.2396 22.7498 17.3605 22.7498H19.425C19.5458 22.7498 19.6437 22.6519 19.6437 22.5311V20.468C19.6437 20.3472 19.5458 20.2493 19.425 20.2493Z'
						fill='currentColor'
					/>
					<path
						opacity='0.96'
						d='M16.6457 20.2493H14.5813C14.4605 20.2493 14.3625 20.3472 14.3625 20.468V22.5311C14.3625 22.6519 14.4605 22.7498 14.5813 22.7498H16.6457C16.7666 22.7498 16.8645 22.6519 16.8645 22.5311V20.468C16.8645 20.3472 16.7666 20.2493 16.6457 20.2493Z'
						fill='currentColor'
					/>
					<path
						opacity='0.72'
						d='M22.2028 20.2493H20.1384C20.0176 20.2493 19.9197 20.3472 19.9197 20.468V22.5311C19.9197 22.6519 20.0176 22.7498 20.1384 22.7498H22.2028C22.3236 22.7498 22.4216 22.6519 22.4216 22.5311V20.468C22.4216 20.3472 22.3236 20.2493 22.2028 20.2493Z'
						fill='currentColor'
					/>
					<path
						d='M44.2881 7.875H46.4931V20.517C46.4931 21.3255 46.305 22.0768 45.9287 22.771C45.5612 23.4733 45.0625 24.0817 44.4325 24.5963C43.8025 25.1189 43.085 25.5232 42.28 25.809C41.475 26.103 40.635 26.25 39.76 26.25C38.85 26.25 37.9706 26.0581 37.1219 25.6743C36.2731 25.2986 35.5294 24.7922 34.8906 24.1552C34.2606 23.5264 33.8056 22.82 33.5256 22.036L35.5469 21.1785C35.7131 21.742 36.0106 22.2483 36.4394 22.6975C36.8769 23.1548 37.3844 23.5142 37.9619 23.7755C38.5481 24.045 39.1475 24.1797 39.76 24.1797C40.3375 24.1797 40.8931 24.0858 41.4269 23.898C41.9694 23.7102 42.455 23.4488 42.8837 23.114C43.3212 22.7873 43.6625 22.3995 43.9075 21.9503C44.1612 21.5093 44.2881 21.0315 44.2881 20.517V18.0792C43.8419 18.7815 43.2512 19.3532 42.5162 19.7942C41.79 20.2271 40.9412 20.4435 39.97 20.4435C39.0425 20.4435 38.1719 20.2761 37.3581 19.9413C36.5444 19.6065 35.8312 19.145 35.2187 18.557C34.6062 17.9608 34.125 17.2748 33.775 16.499C33.425 15.7232 33.25 14.8902 33.25 14C33.25 13.1098 33.425 12.2768 33.775 11.501C34.125 10.717 34.6062 10.031 35.2187 9.443C35.8312 8.84683 36.5444 8.38133 37.3581 8.0465C38.1719 7.71167 39.0425 7.54425 39.97 7.54425C40.9412 7.54425 41.79 7.76067 42.5162 8.1935C43.2512 8.62633 43.8419 9.198 44.2881 9.9085V7.875ZM39.9831 18.4468C40.8319 18.4468 41.5669 18.2426 42.1881 17.8343C42.8181 17.426 43.3037 16.8828 43.645 16.205C43.9862 15.5272 44.1569 14.7922 44.1569 14C44.1569 13.1833 43.9819 12.4402 43.6319 11.7705C43.2906 11.0927 42.805 10.5537 42.175 10.1535C41.5537 9.74517 40.8231 9.541 39.9831 9.541C39.1606 9.541 38.4081 9.74112 37.7256 10.1413C37.0431 10.5415 36.5006 11.0805 36.0981 11.7583C35.7044 12.428 35.5075 13.1752 35.5075 14C35.5075 14.8248 35.7087 15.5762 36.1113 16.254C36.5225 16.9237 37.065 17.4586 37.7387 17.8588C38.4212 18.2508 39.1694 18.4468 39.9831 18.4468Z'
						fill='currentColor'
					/>
					<path
						d='M48.5991 20.125V7.875H50.8041V9.40629C51.2679 8.83462 51.8541 8.38133 52.5629 8.0465C53.2716 7.7035 54.0416 7.532 54.8729 7.532C55.3804 7.532 55.8704 7.59325 56.3429 7.71575L55.4504 9.77379C55.0916 9.66762 54.7416 9.6145 54.4004 9.6145C53.7441 9.6145 53.1404 9.76562 52.5891 10.0678C52.0466 10.3618 51.6135 10.762 51.2898 11.2683C50.966 11.7746 50.8041 12.3381 50.8041 12.9588V20.125H48.5991Z'
						fill='currentColor'
					/>
					<path
						d='M66.7918 7.875H68.9968V20.125H66.7918L66.6999 18.0548C66.2886 18.7653 65.7199 19.341 64.9936 19.782C64.2761 20.223 63.4186 20.4435 62.4211 20.4435C61.4586 20.4435 60.5574 20.2761 59.7174 19.9413C58.8774 19.5983 58.1336 19.1287 57.4861 18.5325C56.8474 17.9282 56.3486 17.234 55.9899 16.45C55.6311 15.666 55.4518 14.8208 55.4518 13.9143C55.4518 13.0405 55.6268 12.2156 55.9768 11.4398C56.3268 10.664 56.8124 9.98612 57.4336 9.40629C58.0636 8.81829 58.7899 8.36095 59.6124 8.03429C60.4349 7.69941 61.3186 7.532 62.2636 7.532C63.2961 7.532 64.2018 7.76066 64.9806 8.218C65.7593 8.66716 66.3893 9.25112 66.8706 9.96979L66.7918 7.875ZM62.3818 18.4468C63.2481 18.4468 63.9961 18.2508 64.6261 17.8588C65.2649 17.4586 65.7549 16.9196 66.0961 16.2418C66.4461 15.564 66.6211 14.8167 66.6211 14C66.6211 13.167 66.4461 12.4157 66.0961 11.746C65.7461 11.0682 65.2518 10.5333 64.6131 10.1413C63.9831 9.74112 63.2393 9.541 62.3818 9.541C61.5156 9.541 60.7281 9.74112 60.0193 10.1413C59.3106 10.5415 58.7461 11.0805 58.3261 11.7583C57.9149 12.428 57.7093 13.1752 57.7093 14C57.7093 14.8248 57.9236 15.5762 58.3524 16.254C58.7811 16.9237 59.3499 17.4586 60.0586 17.8588C60.7674 18.2508 61.5418 18.4468 62.3818 18.4468Z'
						fill='currentColor'
					/>
					<path
						d='M79.1506 7.875H81.487L74.3075 26.25H71.9712L74.3469 20.125L69.635 7.875H72.05L75.4494 17.2952L79.1506 7.875Z'
						fill='currentColor'
					/>
					<path
						d='M92.6395 7.875H94.8445V20.517C94.8445 21.3255 94.6563 22.0768 94.2799 22.771C93.9128 23.4733 93.4134 24.0817 92.7834 24.5963C92.1534 25.1189 91.4363 25.5232 90.6313 25.809C89.8263 26.103 88.9863 26.25 88.1113 26.25C87.2013 26.25 86.3216 26.0581 85.4731 25.6743C84.6245 25.2986 83.881 24.7922 83.2417 24.1552C82.6117 23.5264 82.1566 22.82 81.8766 22.036L83.8981 21.1785C84.0645 21.742 84.3617 22.2483 84.791 22.6975C85.2281 23.1548 85.736 23.5142 86.3131 23.7755C86.8995 24.045 87.4984 24.1797 88.1113 24.1797C88.6884 24.1797 89.2445 24.0858 89.7781 23.898C90.321 23.7102 90.8063 23.4488 91.2349 23.114C91.6728 22.7873 92.0134 22.3995 92.2584 21.9503C92.5128 21.5093 92.6395 21.0315 92.6395 20.517V18.0792C92.1931 18.7815 91.6028 19.3532 90.8678 19.7942C90.1413 20.2271 89.2928 20.4435 88.3213 20.4435C87.3934 20.4435 86.5231 20.2761 85.7095 19.9413C84.896 19.6065 84.1828 19.145 83.5699 18.557C82.9578 17.9608 82.4763 17.2748 82.1263 16.499C81.7763 15.7232 81.6013 14.8902 81.6013 14C81.6013 13.1098 81.7763 12.2768 82.1263 11.501C82.4763 10.717 82.9578 10.031 83.5699 9.443C84.1828 8.84683 84.896 8.38133 85.7095 8.0465C86.5231 7.71167 87.3934 7.54425 88.3213 7.54425C89.2928 7.54425 90.1413 7.76067 90.8678 8.1935C91.6028 8.62633 92.1931 9.198 92.6395 9.9085V7.875ZM88.3345 18.4468C89.1831 18.4468 89.9181 18.2426 90.5395 17.8343C91.1695 17.426 91.6549 16.8828 91.9963 16.205C92.3378 15.5272 92.5081 14.7922 92.5081 14C92.5081 13.1833 92.3331 12.4402 91.9831 11.7705C91.6417 11.0927 91.1563 10.5537 90.5263 10.1535C89.9049 9.74517 89.1745 9.541 88.3345 9.541C87.5117 9.541 86.7595 9.74112 86.0767 10.1413C85.3945 10.5415 84.8517 11.0805 84.4495 11.7583C84.056 12.428 83.8584 13.1752 83.8584 14C83.8584 14.8248 84.0599 15.5762 84.4628 16.254C84.8734 16.9237 85.4163 17.4586 86.0899 17.8588C86.7728 18.2508 87.521 18.4468 88.3345 18.4468Z'
						fill='currentColor'
					/>
					<path
						d='M96.95 20.125V7.875H99.155V9.40629C99.6193 8.83462 100.205 8.38133 100.914 8.0465C101.623 7.7035 102.393 7.532 103.224 7.532C103.731 7.532 104.221 7.59325 104.694 7.71575L103.801 9.77379C103.443 9.66762 103.093 9.6145 102.751 9.6145C102.095 9.6145 101.491 9.76562 100.94 10.0678C100.398 10.3618 99.9646 10.762 99.6411 11.2683C99.3175 11.7746 99.155 12.3381 99.155 12.9588V20.125H96.95Z'
						fill='currentColor'
					/>
					<path
						d='M105.257 7.875H107.462V20.125H105.257V7.875ZM106.386 5.87825C106.036 5.87825 105.743 5.77208 105.506 5.55975C105.27 5.34742 105.152 5.082 105.152 4.7635C105.152 4.445 105.27 4.17958 105.506 3.96725C105.743 3.75492 106.031 3.64875 106.373 3.64875C106.714 3.64875 107.003 3.75492 107.239 3.96725C107.475 4.17958 107.593 4.445 107.593 4.7635C107.593 5.082 107.475 5.34742 107.239 5.55975C107.011 5.77208 106.727 5.87825 106.386 5.87825Z'
						fill='currentColor'
					/>
					<path
						d='M119.951 1.75H122.156V20.125H119.951V18.0425C119.505 18.7612 118.905 19.341 118.153 19.782C117.4 20.223 116.517 20.4435 115.502 20.4435C114.548 20.4435 113.655 20.2761 112.824 19.9413C111.993 19.6065 111.258 19.145 110.619 18.557C109.989 17.9608 109.495 17.2748 109.136 16.499C108.777 15.7232 108.598 14.8902 108.598 14C108.598 13.1098 108.777 12.2768 109.136 11.501C109.495 10.717 109.989 10.031 110.619 9.443C111.258 8.84683 111.993 8.38133 112.824 8.0465C113.655 7.71167 114.548 7.54425 115.502 7.54425C116.517 7.54425 117.4 7.76475 118.153 8.20579C118.905 8.64679 119.505 9.22662 119.951 9.94529V1.75ZM115.528 18.4468C116.394 18.4468 117.142 18.2508 117.772 17.8588C118.411 17.4586 118.901 16.9196 119.242 16.2418C119.592 15.564 119.767 14.8167 119.767 14C119.767 13.167 119.592 12.4157 119.242 11.746C118.892 11.0682 118.398 10.5333 117.759 10.1413C117.129 9.74112 116.385 9.541 115.528 9.541C114.662 9.541 113.874 9.74112 113.165 10.1413C112.465 10.5415 111.905 11.0805 111.485 11.7583C111.065 12.428 110.855 13.1752 110.855 14C110.855 14.8248 111.07 15.5762 111.498 16.254C111.927 16.9237 112.496 17.4586 113.205 17.8588C113.913 18.2508 114.688 18.4468 115.528 18.4468Z'
						fill='currentColor'
					/>
					<path
						d='M128.258 20.3577C127.549 20.3332 126.858 20.2108 126.184 19.9902C125.519 19.7616 124.933 19.4553 124.425 19.0715C123.926 18.6795 123.563 18.2303 123.335 17.724L125.225 16.9645C125.357 17.2422 125.593 17.5035 125.935 17.7485C126.275 17.9935 126.67 18.1895 127.115 18.3365C127.562 18.4835 128.013 18.557 128.468 18.557C128.949 18.557 129.4 18.4876 129.82 18.3488C130.24 18.21 130.58 18.0058 130.843 17.7363C131.115 17.4586 131.25 17.1278 131.25 16.744C131.25 16.3357 131.101 16.0172 130.804 15.7885C130.515 15.5517 130.148 15.3679 129.701 15.2372C129.264 15.0985 128.818 14.9677 128.363 14.8453C127.461 14.6329 126.656 14.3798 125.948 14.0858C125.239 13.7836 124.679 13.4038 124.268 12.9465C123.865 12.481 123.664 11.889 123.664 11.1703C123.664 10.4108 123.887 9.75334 124.333 9.198C124.788 8.64267 125.383 8.21396 126.118 7.91179C126.853 7.60959 127.64 7.4585 128.48 7.4585C129.54 7.4585 130.506 7.67084 131.381 8.0955C132.256 8.52017 132.908 9.09596 133.337 9.82279L131.565 10.7905C131.416 10.4965 131.189 10.2393 130.883 10.0188C130.576 9.79013 130.226 9.61046 129.833 9.47979C129.439 9.34913 129.036 9.27967 128.625 9.2715C128.118 9.25517 127.64 9.31646 127.195 9.45529C126.757 9.59413 126.403 9.80646 126.131 10.0922C125.869 10.37 125.738 10.717 125.738 11.1335C125.738 11.5418 125.878 11.8522 126.158 12.0645C126.446 12.2768 126.818 12.4483 127.273 12.579C127.737 12.7015 128.24 12.8445 128.783 13.0078C129.579 13.2446 130.323 13.5182 131.014 13.8285C131.705 14.1388 132.26 14.5268 132.68 14.9923C133.11 15.4578 133.32 16.0335 133.31 16.7195C133.31 17.4708 133.07 18.1283 132.589 18.6918C132.108 19.2471 131.482 19.6717 130.712 19.9657C129.95 20.2598 129.133 20.3904 128.258 20.3577Z'
						fill='currentColor'
					/>
				</g>
				<defs>
					<linearGradient
						id='paint0_linear_2978_61'
						x1='14'
						y1='0'
						x2='14'
						y2='28'
						gradientUnits='userSpaceOnUse'
					>
						<stop stopColor='currentColor' />
						<stop offset='1' stopColor='currentColor' />
					</linearGradient>
					<linearGradient
						id='paint1_linear_2978_61'
						x1='17.725'
						y1='4.06733'
						x2='5.39227'
						y2='40.8138'
						gradientUnits='userSpaceOnUse'
					>
						<stop offset='0.215628' stopColor='currentColor' stopOpacity='0' />
						<stop
							offset='0.447191'
							stopColor='currentColor'
							stopOpacity='0.19'
						/>
						<stop offset='0.619792' stopColor='currentColor' />
					</linearGradient>
					<clipPath id='clip0_2978_61'>
						<rect width='133.778' height='28' fill='currentColor' />
					</clipPath>
				</defs>
			</svg>
		),
	},
	{
		id: 1 + i,
		name: "SaaSBold",
		link: "https://SaaSBold.com",
		image: (
			<svg
				width='154'
				height='28'
				viewBox='0 0 154 28'
				fill='none'
				xmlns='http://www.w3.org/2000/svg'
			>
				<g clipPath='url(#clip0_2911_56)'>
					<path
						d='M38.5 8.02892H43.9926V23.7625H47.278V8.02892H52.7706V5.00026H38.5V8.02892Z'
						fill='currentColor'
					/>
					<path
						d='M56.4373 24.0963C58.4136 24.0963 60.1333 23.1979 60.6723 21.8889L60.9033 23.7625H63.6496V16.0625C63.6496 12.5463 61.545 10.6983 58.1313 10.6983C54.692 10.6983 52.4333 12.4949 52.4333 15.2413H55.1026C55.1026 13.9066 56.1293 13.1366 57.9773 13.1366C59.5686 13.1366 60.5953 13.8296 60.5953 15.5493V15.8315L56.7966 16.1139C53.7936 16.3449 52.0996 17.8079 52.0996 20.1436C52.0996 22.5305 53.7423 24.0963 56.4373 24.0963ZM57.464 21.7349C56.0523 21.7349 55.2823 21.1703 55.2823 20.0153C55.2823 18.9885 56.0266 18.3469 57.9773 18.1673L60.621 17.9619V18.6293C60.621 20.5799 59.389 21.7349 57.464 21.7349Z'
						fill='currentColor'
					/>
					<path
						d='M68.2915 8.54226C69.3182 8.54226 70.1652 7.69526 70.1652 6.64294C70.1652 5.5906 69.3182 4.76927 68.2915 4.76927C67.2135 4.76927 66.3665 5.5906 66.3665 6.64294C66.3665 7.69526 67.2135 8.54226 68.2915 8.54226ZM66.7258 23.7626H69.8572V11.0833H66.7258V23.7626Z'
						fill='currentColor'
					/>
					<path
						d='M76.2494 23.7626V4.6666H73.1438V23.7626H76.2494Z'
						fill='currentColor'
					/>
					<path
						d='M81.6131 23.7625L83.1275 19.4249H90.1345L91.6492 23.7625H95.1142L88.3382 5.00026H84.9755L78.1995 23.7625H81.6131ZM86.2331 10.5956C86.4128 10.0823 86.5667 9.51763 86.6437 9.15827C86.6951 9.54327 86.8747 10.1079 87.0287 10.5956L89.1852 16.6529H84.1027L86.2331 10.5956Z'
						fill='currentColor'
					/>
					<path
						d='M101.638 24.0963C103.563 24.0963 105.206 23.2493 105.976 21.7863L106.181 23.7626H109.056V4.6666H105.95V12.7003C105.155 11.4426 103.589 10.6983 101.818 10.6983C97.9938 10.6983 95.6838 13.5216 95.6838 17.4743C95.6838 21.4013 97.9685 24.0963 101.638 24.0963ZM102.331 21.2216C100.15 21.2216 98.8155 19.6303 98.8155 17.3716C98.8155 15.1129 100.15 13.4959 102.331 13.4959C104.513 13.4959 105.925 15.0873 105.925 17.3716C105.925 19.6559 104.513 21.2216 102.331 21.2216Z'
						fill='currentColor'
					/>
					<path
						d='M115.451 23.7625V16.5759C115.451 14.5226 116.657 13.5473 118.146 13.5473C119.634 13.5473 120.584 14.4969 120.584 16.2679V23.7625H123.715V16.5759C123.715 14.4969 124.87 13.5216 126.385 13.5216C127.873 13.5216 128.849 14.4713 128.849 16.2936V23.7625H131.954V15.4723C131.954 12.5463 130.26 10.6983 127.18 10.6983C125.255 10.6983 123.767 11.6479 123.125 13.1109C122.458 11.6479 121.123 10.6983 119.198 10.6983C117.376 10.6983 116.092 11.5196 115.451 12.5719L115.194 11.0833H112.319V23.7625H115.451Z'
						fill='currentColor'
					/>
					<path
						d='M136.594 8.54226C137.621 8.54226 138.468 7.69526 138.468 6.64294C138.468 5.5906 137.621 4.76927 136.594 4.76927C135.516 4.76927 134.669 5.5906 134.669 6.64294C134.669 7.69526 135.516 8.54226 136.594 8.54226ZM135.028 23.7626H138.16V11.0833H135.028V23.7626Z'
						fill='currentColor'
					/>
					<path
						d='M144.526 23.7625V16.9353C144.526 14.8819 145.707 13.5473 147.632 13.5473C149.249 13.5473 150.301 14.5739 150.301 16.7043V23.7625H153.432V15.9599C153.432 12.6746 151.79 10.6983 148.607 10.6983C146.887 10.6983 145.347 11.4426 144.552 12.7259L144.295 11.0833H141.395V23.7625H144.526Z'
						fill='currentColor'
					/>
					<path
						d='M0 7.36842C0 3.29895 3.29895 0 7.36842 0H20.6315C24.7011 0 28 3.29895 28 7.36842V20.6315C28 24.7011 24.7011 28 20.6315 28H7.36842C3.29895 28 0 24.7011 0 20.6315V7.36842Z'
						fill='currentColor'
						opacity='.05'
					/>
					<g filter='url(#filter0_d_2911_56)'>
						<path
							d='M7.36865 7.36861C7.36865 6.55472 8.02844 5.89493 8.84234 5.89493C9.65626 5.89493 10.316 6.55472 10.316 7.36861V20.6318C10.316 21.4456 9.65626 22.1055 8.84234 22.1055C8.02844 22.1055 7.36865 21.4456 7.36865 20.6318V7.36861Z'
							fill='currentColor'
						/>
					</g>
					<g opacity='0.9' filter='url(#filter1_d_2911_56)'>
						<path
							d='M12.8948 13.2629C12.8948 12.449 13.5546 11.7892 14.3684 11.7892C15.1824 11.7892 15.8421 12.449 15.8421 13.2629V20.6313C15.8421 21.4452 15.1824 22.105 14.3684 22.105C13.5546 22.105 12.8948 21.4452 12.8948 20.6313V13.2629Z'
							fill='currentColor'
						/>
					</g>
					<g opacity='0.7' filter='url(#filter2_d_2911_56)'>
						<path
							d='M18.4207 9.57853C18.4207 8.76461 19.0805 8.10486 19.8944 8.10486C20.7083 8.10486 21.3681 8.76461 21.3681 9.57853V20.6312C21.3681 21.445 20.7083 22.1049 19.8944 22.1049C19.0805 22.1049 18.4207 21.445 18.4207 20.6312V9.57853Z'
							fill='currentColor'
						/>
					</g>
				</g>
				<defs>
					<filter
						id='filter0_d_2911_56'
						x='6.36865'
						y='5.39493'
						width='4.94727'
						height='18.2105'
						filterUnits='userSpaceOnUse'
						colorInterpolationFilters='sRGB'
					>
						<feFlood floodOpacity='0' result='BackgroundImageFix' />
						<feColorMatrix
							in='SourceAlpha'
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0'
							result='hardAlpha'
						/>
						<feOffset dy='0.5' />
						<feGaussianBlur stdDeviation='0.5' />
						<feComposite in2='hardAlpha' operator='out' />
						<feColorMatrix
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.12 0'
						/>
						<feBlend
							mode='normal'
							in2='BackgroundImageFix'
							result='effect1_dropShadow_2911_56'
						/>
						<feBlend
							mode='normal'
							in='SourceGraphic'
							in2='effect1_dropShadow_2911_56'
							result='shape'
						/>
					</filter>
					<filter
						id='filter1_d_2911_56'
						x='11.8948'
						y='11.2892'
						width='4.94727'
						height='12.3158'
						filterUnits='userSpaceOnUse'
						colorInterpolationFilters='sRGB'
					>
						<feFlood floodOpacity='0' result='BackgroundImageFix' />
						<feColorMatrix
							in='SourceAlpha'
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0'
							result='hardAlpha'
						/>
						<feOffset dy='0.5' />
						<feGaussianBlur stdDeviation='0.5' />
						<feComposite in2='hardAlpha' operator='out' />
						<feColorMatrix
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.12 0'
						/>
						<feBlend
							mode='normal'
							in2='BackgroundImageFix'
							result='effect1_dropShadow_2911_56'
						/>
						<feBlend
							mode='normal'
							in='SourceGraphic'
							in2='effect1_dropShadow_2911_56'
							result='shape'
						/>
					</filter>
					<filter
						id='filter2_d_2911_56'
						x='17.4207'
						y='7.60486'
						width='4.94751'
						height='16'
						filterUnits='userSpaceOnUse'
						colorInterpolationFilters='sRGB'
					>
						<feFlood floodOpacity='0' result='BackgroundImageFix' />
						<feColorMatrix
							in='SourceAlpha'
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0'
							result='hardAlpha'
						/>
						<feOffset dy='0.5' />
						<feGaussianBlur stdDeviation='0.5' />
						<feComposite in2='hardAlpha' operator='out' />
						<feColorMatrix
							type='matrix'
							values='0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.12 0'
						/>
						<feBlend
							mode='normal'
							in2='BackgroundImageFix'
							result='effect1_dropShadow_2911_56'
						/>
						<feBlend
							mode='normal'
							in='SourceGraphic'
							in2='effect1_dropShadow_2911_56'
							result='shape'
						/>
					</filter>
					<clipPath id='clip0_2911_56'>
						<rect width='154' height='28' fill='currentColor' />
					</clipPath>
				</defs>
			</svg>
		),
	},
];

export default brandData;
