/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.ArrayList;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import java_cup.runtime.TableDecoder;
import java_cup.runtime.virtual_parse_stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LRParser {
    public SymbolFactory symbolFactory;
    private static final int ERROR = 0;
    private static final int EOF = 1;
    private boolean _done_parsing = false;
    protected Symbol cur_token;
    protected ArrayList<Symbol> stack = new ArrayList();
    private int[] base_table;
    private short[] action_table;
    private short[] reduce_table;
    private short[] production_table;
    private Scanner _scanner;

    public LRParser() {
        this(null);
    }

    public LRParser(Scanner s) {
        this(s, new DefaultSymbolFactory());
    }

    public LRParser(Scanner s, SymbolFactory symfac) {
        this.symbolFactory = symfac;
        this.setScanner(s);
    }

    public SymbolFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    protected int error_sync_size() {
        return 3;
    }

    public void done_parsing() {
        this._done_parsing = true;
    }

    public void setScanner(Scanner s) {
        this._scanner = s;
    }

    public Scanner getScanner() {
        return this._scanner;
    }

    public abstract Symbol do_action(int var1, ArrayList<Symbol> var2) throws Exception;

    protected abstract String[] action_table();

    public void user_init() throws Exception {
    }

    protected abstract void init_actions() throws Exception;

    public Symbol scan() throws Exception {
        Symbol sym2 = this.getScanner().next_token();
        return sym2 != null ? sym2 : this.getSymbolFactory().newSymbol("END_OF_FILE", 0);
    }

    public void report_fatal_error(String message, Object info) throws Exception {
        this.done_parsing();
        this.report_error(message, info);
        throw new Exception("Can't recover from previous error(s)");
    }

    public void report_error(String message, Object info) {
        System.err.print(message);
        System.err.flush();
        if (info instanceof Symbol) {
            if (((Symbol)info).left != -1) {
                System.err.println(" at character " + ((Symbol)info).left + " of input");
            } else {
                System.err.println("");
            }
        } else {
            System.err.println("");
        }
    }

    public void syntax_error(Symbol cur_token) {
        this.report_error("Syntax error", cur_token);
    }

    public void unrecovered_syntax_error(Symbol cur_token) throws Exception {
        this.report_fatal_error("Couldn't repair and continue parse", cur_token);
    }

    private final short get_action(int state, int sym2) {
        int base = this.base_table[state] + 2 * sym2;
        if (this.action_table[base] == state) {
            return this.action_table[base + 1];
        }
        return this.action_table[state];
    }

    private final short get_reduce(int state, int sym2) {
        return this.reduce_table[this.reduce_table[state] + sym2];
    }

    public Symbol parse() throws Exception {
        this.init_actions();
        this.user_init();
        this.unpackStrings(this.action_table());
        this.cur_token = this.scan();
        this.stack.clear();
        this.stack.add(this.getSymbolFactory().startSymbol("START", 0, 0));
        int parse_state = 0;
        this._done_parsing = false;
        while (!this._done_parsing) {
            int act = this.get_action(parse_state, this.cur_token.sym);
            if ((act & 1) != 0) {
                this.cur_token.parse_state = parse_state = act >> 1;
                this.stack.add(this.cur_token);
                this.cur_token = this.scan();
                continue;
            }
            if (act != 0) {
                act = (act >> 1) - 1;
                Symbol lhs_sym = this.do_action(act, this.stack);
                int handle_size = this.production_table[2 * act + 1];
                while (handle_size-- > 0) {
                    this.stack.remove(this.stack.size() - 1);
                }
                lhs_sym.parse_state = parse_state = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, lhs_sym.sym);
                this.stack.add(lhs_sym);
                continue;
            }
            this.error_recovery(false);
            if (this.stack.isEmpty()) continue;
            parse_state = this.stack.get((int)(this.stack.size() - 1)).parse_state;
        }
        this.production_table = null;
        this.action_table = null;
        this.reduce_table = null;
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public void debug_message(String mess) {
        System.err.println(mess);
    }

    public void dump_stack() {
        if (this.stack == null) {
            this.debug_message("# Stack dump requested, but stack is null");
            return;
        }
        this.debug_message("============ Parse Stack Dump ============");
        for (int i = 0; i < this.stack.size(); ++i) {
            this.debug_message("Symbol: " + this.stack.get((int)i).sym + " State: " + this.stack.get((int)i).parse_state);
        }
        this.debug_message("==========================================");
    }

    public void debug_reduce(int prod_num, Symbol nt, int rhs_size) {
        this.debug_message("# Reduce with prod #" + prod_num + " [NT=" + nt + ", " + "SZ=" + rhs_size + "]");
    }

    public void debug_shift(Symbol shift_tkn) {
        this.debug_message("# Shift under term " + shift_tkn + " to state #" + shift_tkn.parse_state);
    }

    public void debug_stack() {
        StringBuffer sb = new StringBuffer("## STACK:");
        for (int i = 0; i < this.stack.size(); ++i) {
            Symbol s = this.stack.get(i);
            sb.append(" <state " + s.parse_state + ", sym " + s.sym + ">");
            if (i % 3 != 2 && i != this.stack.size() - 1) continue;
            this.debug_message(sb.toString());
            sb = new StringBuffer("         ");
        }
    }

    public Symbol debug_parse() throws Exception {
        this.debug_message("# Initializing parser");
        this.init_actions();
        this.user_init();
        this.unpackStrings(this.action_table());
        this.cur_token = this.scan();
        this.debug_message("# Current Symbol is #" + this.cur_token.sym);
        this.stack.clear();
        this.stack.add(this.getSymbolFactory().startSymbol("START", 0, 0));
        int parse_state = 0;
        this._done_parsing = false;
        while (!this._done_parsing) {
            if (this.cur_token.used_by_parser) {
                throw new Error("Symbol recycling detected (fix your scanner).");
            }
            int act = this.get_action(parse_state, this.cur_token.sym);
            if ((act & 1) != 0) {
                this.cur_token.parse_state = parse_state = act >> 1;
                this.cur_token.used_by_parser = true;
                this.debug_shift(this.cur_token);
                this.stack.add(this.cur_token);
                this.cur_token = this.scan();
                this.debug_message("# Current token is " + this.cur_token);
                continue;
            }
            if (act != 0) {
                act = (act >> 1) - 1;
                Symbol lhs_sym = this.do_action(act, this.stack);
                int handle_size = this.production_table[2 * act + 1];
                this.debug_reduce(act, lhs_sym, handle_size);
                while (handle_size-- > 0) {
                    this.stack.remove(this.stack.size() - 1);
                }
                act = this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, lhs_sym.sym);
                this.debug_message("# Reduce rule: top state " + this.stack.get((int)(this.stack.size() - 1)).parse_state + ", lhs sym " + lhs_sym.sym + " -> state " + act);
                lhs_sym.parse_state = parse_state = act;
                lhs_sym.used_by_parser = true;
                this.stack.add(lhs_sym);
                this.debug_message("# Goto state #" + act);
                continue;
            }
            this.error_recovery(true);
            if (this.stack.isEmpty()) continue;
            parse_state = this.stack.get((int)(this.stack.size() - 1)).parse_state;
        }
        this.production_table = null;
        this.action_table = null;
        this.reduce_table = null;
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    private void error_recovery(boolean debug) throws Exception {
        int i;
        this.syntax_error(this.cur_token);
        if (debug) {
            this.debug_message("# Attempting error recovery");
        }
        if (!this.find_recovery_config(debug)) {
            if (debug) {
                this.debug_message("# Error recovery fails");
            }
            this.unrecovered_syntax_error(this.cur_token);
            this.done_parsing();
            return;
        }
        Symbol[] lookaheads2 = new Symbol[this.error_sync_size()];
        lookaheads2[0] = this.cur_token;
        for (i = 1; i < lookaheads2.length; ++i) {
            lookaheads2[i] = this.scan();
        }
        while (true) {
            if (debug) {
                this.debug_message("# Trying to parse ahead");
            }
            if (this.try_parse_ahead(debug, lookaheads2)) break;
            if (lookaheads2[0].sym == 1) {
                if (debug) {
                    this.debug_message("# Error recovery fails at EOF");
                }
                this.unrecovered_syntax_error(this.cur_token);
                this.done_parsing();
                return;
            }
            if (debug) {
                this.debug_message("# Consuming Symbol #" + lookaheads2[0].sym);
            }
            for (i = 1; i < lookaheads2.length; ++i) {
                lookaheads2[i - 1] = lookaheads2[i];
            }
            lookaheads2[lookaheads2.length - 1] = this.scan();
        }
        if (debug) {
            this.debug_message("# Parse-ahead ok, going back to normal parse");
        }
        this.parse_lookahead(debug, lookaheads2);
    }

    private boolean find_recovery_config(boolean debug) throws Exception {
        int act;
        if (debug) {
            this.debug_message("# Finding recovery state on stack");
        }
        Symbol right = this.stack.get(this.stack.size() - 1);
        Symbol left = this.cur_token;
        while (((act = this.get_action(this.stack.get((int)(this.stack.size() - 1)).parse_state, 0)) & 1) == 0) {
            if (act == 0) {
                if (debug) {
                    this.debug_message("# Pop stack by one, state was # " + this.stack.get((int)(this.stack.size() - 1)).parse_state);
                }
                left = this.stack.remove(this.stack.size() - 1);
                if (!this.stack.isEmpty()) continue;
                if (debug) {
                    this.debug_message("# No recovery state found on stack");
                }
                return false;
            }
            act = (act >> 1) - 1;
            Symbol lhs_sym = this.do_action(act, this.stack);
            int handle_size = this.production_table[2 * act + 1];
            if (debug) {
                this.debug_reduce(act, lhs_sym, handle_size);
            }
            while (handle_size-- > 0) {
                this.stack.remove(this.stack.size() - 1);
            }
            lhs_sym.parse_state = act = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, lhs_sym.sym);
            lhs_sym.used_by_parser = true;
            this.stack.add(lhs_sym);
            if (!debug) continue;
            this.debug_message("# Goto state #" + act);
        }
        if (debug) {
            this.debug_message("# Recover state found (#" + this.stack.get((int)(this.stack.size() - 1)).parse_state + ")");
            this.debug_message("# Shifting on error to state #" + (act - 1));
        }
        Symbol error_token = this.getSymbolFactory().newSymbol("ERROR", 1, left, right);
        error_token.parse_state = act >> 1;
        error_token.used_by_parser = true;
        this.stack.add(error_token);
        return true;
    }

    private boolean try_parse_ahead(boolean debug, Symbol[] lookaheads2) throws Exception {
        virtual_parse_stack vstack = new virtual_parse_stack(this.stack);
        int parse_state = vstack.top();
        int lookahead_pos = 0;
        this.cur_token = lookaheads2[lookahead_pos++];
        while (true) {
            int act;
            if (((act = this.get_action(parse_state, this.cur_token.sym)) & 1) != 0) {
                parse_state = act >> 1;
                vstack.push(parse_state);
                if (debug) {
                    this.debug_message("# Parse-ahead shifts Symbol #" + this.cur_token.sym + " into state #" + parse_state);
                }
                if (lookahead_pos == lookaheads2.length) {
                    return true;
                }
                this.cur_token = lookaheads2[lookahead_pos++];
                continue;
            }
            if (act <= 0) break;
            if ((act = (act >> 1) - 1) == 0) {
                if (debug) {
                    this.debug_message("# Parse-ahead accepts");
                }
                return true;
            }
            short lhs = this.production_table[2 * act];
            short rhs_size = this.production_table[2 * act + 1];
            vstack.pop(rhs_size);
            if (debug) {
                this.debug_message("# Parse-ahead reduces: handle size = " + rhs_size + " lhs = #" + lhs + " from state #" + vstack.top());
            }
            parse_state = this.get_reduce(vstack.top(), lhs);
            vstack.push(parse_state);
            if (!debug) continue;
            this.debug_message("# Goto state #" + vstack.top());
        }
        return false;
    }

    private void parse_lookahead(boolean debug, Symbol[] lookaheads2) throws Exception {
        Symbol lhs_sym = null;
        int lookahead_pos = 0;
        this.cur_token = lookaheads2[lookahead_pos++];
        if (debug) {
            this.debug_message("# Reparsing saved input with actions");
            this.debug_message("# Current Symbol is #" + this.cur_token.sym);
            this.debug_message("# Current state is #" + this.stack.get((int)(this.stack.size() - 1)).parse_state);
        }
        while (!this._done_parsing && lookahead_pos < lookaheads2.length) {
            int act = this.get_action(this.stack.get((int)(this.stack.size() - 1)).parse_state, this.cur_token.sym);
            if ((act & 1) != 0) {
                this.cur_token.parse_state = act >> 1;
                this.cur_token.used_by_parser = true;
                if (debug) {
                    this.debug_shift(this.cur_token);
                }
                this.stack.add(this.cur_token);
                this.cur_token = lookaheads2[lookahead_pos++];
                if (!debug) continue;
                this.debug_message("# Current Symbol is #" + this.cur_token.sym);
                continue;
            }
            act = (act >> 1) - 1;
            lhs_sym = this.do_action(act, this.stack);
            int handle_size = this.production_table[2 * act + 1];
            if (debug) {
                this.debug_reduce(act, lhs_sym, handle_size);
            }
            while (handle_size-- > 0) {
                this.stack.remove(this.stack.size() - 1);
            }
            lhs_sym.parse_state = act = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, lhs_sym.sym);
            lhs_sym.used_by_parser = true;
            this.stack.add(lhs_sym);
            if (!debug) continue;
            this.debug_message("# Goto state #" + act);
        }
        if (debug) {
            this.debug_message("# Completed reparse");
        }
    }

    private void unpackStrings(String[] sa) {
        TableDecoder decoder = new TableDecoder(sa);
        this.production_table = decoder.decodeShortArray();
        this.base_table = decoder.decodeIntArray();
        this.action_table = decoder.decodeShortArray();
        this.reduce_table = decoder.decodeShortArray();
    }
}

