/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.BitSet;
import java.util.TreeSet;
import java_cup.CombRow;
import java_cup.Grammar;
import java_cup.lalr_state;

public class parse_reduce_table {
    public lalr_state[][] table;
    protected int _num_states;
    private int _num_nonterm;

    public parse_reduce_table(Grammar grammar) {
        this._num_states = grammar.lalr_states().size();
        this._num_nonterm = grammar.num_non_terminals();
        this.table = new lalr_state[this._num_states][this._num_nonterm];
    }

    public int num_states() {
        return this._num_states;
    }

    public short[] compress() {
        BitSet used = new BitSet();
        TreeSet<CombRow> rows = new TreeSet<CombRow>();
        for (int i = 0; i < this._num_states; ++i) {
            int len = 0;
            for (int j = 0; j < this._num_nonterm; ++j) {
                if (this.table[i][j] == null) continue;
                ++len;
            }
            if (len == 0) continue;
            used.set(i);
            int[] rowidx = new int[len];
            len = 0;
            for (int j = 0; j < this._num_nonterm; ++j) {
                if (this.table[i][j] == null) continue;
                rowidx[len++] = j;
            }
            CombRow row = new CombRow(i, rowidx);
            rows.add(row);
        }
        for (CombRow row : rows) {
            row.fitInComb(used);
        }
        int maxbase = used.size();
        while (!used.get(maxbase - 1)) {
            --maxbase;
        }
        short[] compressed = new short[maxbase];
        for (int i = 0; i < maxbase; ++i) {
            compressed[i] = 1;
        }
        for (CombRow row : rows) {
            int base = row.base;
            compressed[row.index] = (short)base;
            for (int j = 0; j < row.comb.length; ++j) {
                compressed[base + row.comb[j]] = (short)this.table[row.index][row.comb[j]].index();
            }
        }
        return compressed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("-------- REDUCE_TABLE --------\n");
        for (int row = 0; row < this.num_states(); ++row) {
            result.append("From state #").append(row).append("\n");
            int cnt = 0;
            for (int col = 0; col < this._num_nonterm; ++col) {
                lalr_state goto_st = this.table[row][col];
                if (goto_st == null) continue;
                result.append(" [non term ").append(col).append("->");
                result.append("state ").append(goto_st.index()).append("]");
                if (++cnt != 3) continue;
                result.append("\n");
                cnt = 0;
            }
            if (cnt == 0) continue;
            result.append("\n");
        }
        result.append("-----------------------------");
        return result.toString();
    }
}

