/*
 * Decompiled with CFR 0.152.
 */
package ap;

import ap.AbstractFileProver;
import ap.CmdlMain$NullStream$;
import ap.IntelliFileProver;
import ap.ParallelFileProver;
import ap.Prover;
import ap.Prover$NoCounterModel$;
import ap.Prover$NoModel$;
import ap.Prover$TimeoutCounterModel$;
import ap.Prover$TimeoutModel$;
import ap.SimpleAPI;
import ap.SimpleAPI$;
import ap.parameters.GlobalSettings;
import ap.parameters.GlobalSettings$;
import ap.parameters.Param$ASSERTIONS$;
import ap.parameters.Param$GENERATE_TOTALITY_AXIOMS$;
import ap.parameters.Param$INCREMENTAL$;
import ap.parameters.Param$INPUT_FORMAT$;
import ap.parameters.Param$InputFormat$;
import ap.parameters.Param$LOGO$;
import ap.parameters.Param$MOST_GENERAL_CONSTRAINT$;
import ap.parameters.Param$MULTI_STRATEGY$;
import ap.parameters.Param$PRINT_DOT_CERTIFICATE_FILE$;
import ap.parameters.Param$PRINT_SMT_FILE$;
import ap.parameters.Param$PRINT_TPTP_FILE$;
import ap.parameters.Param$PRINT_TREE$;
import ap.parameters.Param$QUIET$;
import ap.parameters.Param$REVERSE_FUNCTIONALITY_PROPAGATION$;
import ap.parameters.Param$STDIN$;
import ap.parameters.Param$TIGHT_FUNCTION_SCOPES$;
import ap.parameters.Param$TIMEOUT$;
import ap.parameters.Param$TIMEOUT_PER$;
import ap.parameters.Param$TRIGGER_STRATEGY$;
import ap.parameters.Param$TriggerStrategyOptions$;
import ap.parameters.Param$VERSION$;
import ap.parser.IBoolLit;
import ap.parser.IExpression$;
import ap.parser.IFormula;
import ap.parser.IInterpolantSpec;
import ap.parser.INamedPart;
import ap.parser.Internal2InputAbsy$;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.parser.PrincessLineariser$;
import ap.parser.SMTLineariser$;
import ap.parser.SMTParser2InputAbsy;
import ap.parser.SMTParser2InputAbsy$;
import ap.parser.Simplifier;
import ap.parser.TPTPLineariser$;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.DotLineariser$;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.util.Debug$;
import ap.util.Timeout$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class CmdlMain$ {
    public static final CmdlMain$ MODULE$;
    private final String version;

    static {
        new CmdlMain$();
    }

    public String version() {
        return this.version;
    }

    public void printGreeting() {
        Predef$.MODULE$.println((Object)"________       _____");
        Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
        Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
        Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
        Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"A Theorem Prover for First-Order Logic modulo Linear Integer Arithmetic");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"(").append((Object)this.version()).append((Object)")").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"(c) Philipp R\u00fcmmer, 2009-2015");
        Predef$.MODULE$.println((Object)"(contributions by Angelo Brillout, Peter Backeman, Peter Baumgartner)");
        Predef$.MODULE$.println((Object)"Free software under GNU Lesser General Public License (LGPL).");
        Predef$.MODULE$.println((Object)"Bug reports to ph_r@gmx.net");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"For more information, visit http://www.philipp.ruemmer.org/princess.shtml");
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)"Usage: princess <option>* <inputfile>*");
        Predef$.MODULE$.println();
        this.printOptions();
    }

    public void printOptions() {
        Predef$.MODULE$.println((Object)"Options:");
        Predef$.MODULE$.println((Object)" [+-]logo                  Print logo and elapsed time              (default: +)");
        Predef$.MODULE$.println((Object)" [+-]version               Print version and exit                   (default: -)");
        Predef$.MODULE$.println((Object)" [+-]quiet                 Suppress all output to stderr            (default: -)");
        Predef$.MODULE$.println((Object)" [+-]printTree             Output the constructed proof tree        (default: -)");
        Predef$.MODULE$.println((Object)" -inputFormat=val          Specify format of problem file:       (default: auto)");
        Predef$.MODULE$.println((Object)"                             auto, pri, smtlib, tptp");
        Predef$.MODULE$.println((Object)" [+-]stdin                 Read SMT-LIB 2 problems from stdin       (default: -)");
        Predef$.MODULE$.println((Object)" [+-]incremental           Incremental SMT-LIB 2 interpreter        (default: -)");
        Predef$.MODULE$.println((Object)"                             (+incremental implies -genTotalityAxioms)");
        Predef$.MODULE$.println((Object)" -printSMT=filename        Output the problem in SMT-LIB format    (default: \"\")");
        Predef$.MODULE$.println((Object)" -printTPTP=filename       Output the problem in TPTP format       (default: \"\")");
        Predef$.MODULE$.println((Object)" -printDOT=filename        Output the proof in GraphViz format     (default: \"\")");
        Predef$.MODULE$.println((Object)" [+-]assert                Enable runtime assertions                (default: -)");
        Predef$.MODULE$.println((Object)" -timeout=val              Set a timeout in milliseconds        (default: infty)");
        Predef$.MODULE$.println((Object)" -timeoutPer=val           Set a timeout per SMT-LIB query (ms) (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]multiStrategy         Use a portfolio of different strategies  (default: -)");
        Predef$.MODULE$.println((Object)" -simplifyConstraints=val  How to simplify constraints:");
        Predef$.MODULE$.println((Object)"                             none:   not at all");
        Predef$.MODULE$.println((Object)"                             fair:   fair construction of a proof");
        Predef$.MODULE$.println((Object)"                             lemmas: proof construction with lemmas (default)");
        Predef$.MODULE$.println((Object)" [+-]traceConstraintSimplifier  Show constraint simplifications     (default: -)");
        Predef$.MODULE$.println((Object)" [+-]mostGeneralConstraint Derive the most general constraint for this problem");
        Predef$.MODULE$.println((Object)"                           (quantifier elimination for PA formulae) (default: -)");
        Predef$.MODULE$.println((Object)" [+-]dnfConstraints        Turn ground constraints into DNF         (default: +)");
        Predef$.MODULE$.println((Object)" -clausifier=val           Choose the clausifier (none, simple)  (default: none)");
        Predef$.MODULE$.println((Object)" [+-]posUnitResolution     Resolution of clauses with literals in   (default: +)");
        Predef$.MODULE$.println((Object)"                           the antecedent");
        Predef$.MODULE$.println((Object)" -generateTriggers=val     Automatically choose triggers for quant. formulae");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" -functionGC=val           Garbage-collect function terms");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" [+-]tightFunctionScopes   Keep function application defs. local    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]genTotalityAxioms     Generate totality axioms for functions   (default: +)");
        Predef$.MODULE$.println((Object)" [+-]boolFunsAsPreds       In smtlib and tptp, encode               (default: -)");
        Predef$.MODULE$.println((Object)"                           boolean functions as predicates");
        Predef$.MODULE$.println((Object)" -mulProcedure=val         Handling of nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             bitShift: shift-and-add axiom");
        Predef$.MODULE$.println((Object)"                             native:   built-in theory solver       (default)");
        Predef$.MODULE$.println((Object)" -constructProofs=val      Extract proofs");
        Predef$.MODULE$.println((Object)"                             never");
        Predef$.MODULE$.println((Object)"                             ifInterpolating: if \\interpolant occurs (default)");
        Predef$.MODULE$.println((Object)"                             always");
        Predef$.MODULE$.println((Object)" [+-]simplifyProofs        Simplify extracted proofs                (default: +)");
        Predef$.MODULE$.println((Object)" [+-]elimInterpolantQuants Eliminate quantifiers from interpolants  (default: +)");
    }

    private void printSMT(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
        if (object == null || !object.equals("")) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
            if (object2 != null && object2.equals("-")) {
                this.ap$CmdlMain$$linearise$1(prover, filename);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving in SMT format to ").append(Param$PRINT_SMT_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_SMT_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(prover, filename){
                    public static final long serialVersionUID = 0L;
                    public final AbstractFileProver prover$1;
                    public final String filename$1;

                    public final void apply() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$1(this.prover$1, this.filename$1);
                    }

                    public void apply$mcV$sp() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$1(this.prover$1, this.filename$1);
                    }
                    {
                        this.prover$1 = prover$1;
                        this.filename$1 = filename$1;
                    }
                });
                out.close();
            }
        }
    }

    private void printTPTP(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
        if (object == null || !object.equals("")) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
            if (object2 != null && object2.equals("-")) {
                this.ap$CmdlMain$$linearise$2(prover, filename);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving in TPTP format to ").append(Param$PRINT_TPTP_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_TPTP_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(prover, filename){
                    public static final long serialVersionUID = 0L;
                    public final AbstractFileProver prover$2;
                    public final String filename$2;

                    public final void apply() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$2(this.prover$2, this.filename$2);
                    }

                    public void apply$mcV$sp() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$2(this.prover$2, this.filename$2);
                    }
                    {
                        this.prover$2 = prover$2;
                        this.filename$2 = filename$2;
                    }
                });
                out.close();
            }
        }
    }

    private void printDOTCertificate(Certificate cert, GlobalSettings settings) {
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        if (object == null || !object.equals("")) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
            if (object2 != null && object2.equals("-")) {
                DotLineariser$.MODULE$.apply(cert);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving certificate in GraphViz format to ").append(Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(cert){
                    public static final long serialVersionUID = 0L;
                    public final Certificate cert$1;

                    public final void apply() {
                        DotLineariser$.MODULE$.apply(this.cert$1);
                    }

                    public void apply$mcV$sp() {
                        DotLineariser$.MODULE$.apply(this.cert$1);
                    }
                    {
                        this.cert$1 = cert$1;
                    }
                });
                out.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration.Value ap$CmdlMain$$determineInputFormat(String filename, GlobalSettings settings) {
        Enumeration.Value value;
        Enumeration.Value value2 = (Enumeration.Value)Param$INPUT_FORMAT$.MODULE$.apply(settings);
        Enumeration.Value value3 = Param$InputFormat$.MODULE$.Auto();
        if (value3 == null) {
            if (value2 != null) {
                return value2;
            }
        } else if (!value3.equals(value2)) return value2;
        if (filename.endsWith(".pri")) {
            value = Param$InputFormat$.MODULE$.Princess();
            return value;
        } else if (filename.endsWith(".smt2")) {
            value = Param$InputFormat$.MODULE$.SMTLIB();
            return value;
        } else {
            if (!filename.endsWith(".p")) throw new Exception("could not figure out the input format (recognised types: .pri, .smt2, .p)");
            value = Param$InputFormat$.MODULE$.TPTP();
        }
        return value;
    }

    public void ap$CmdlMain$$printFormula(IFormula f, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            SMTLineariser$.MODULE$.apply(f);
            Predef$.MODULE$.println();
        } else {
            PrincessLineariser$.MODULE$.printExpression(f);
            Predef$.MODULE$.println();
        }
    }

    public void ap$CmdlMain$$printFormula(Conjunction c, Enumeration.Value format) {
        this.ap$CmdlMain$$printFormula(new Simplifier().apply(Internal2InputAbsy$.MODULE$.apply(c)), format);
    }

    public int ap$CmdlMain$$existentialConstantNum(ProofTree p) {
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option = QuantifiedTree$.MODULE$.unapply(p);
        int n = !option.isEmpty() && Quantifier$EX$.MODULE$.equals(((Tuple3)option.get())._1()) ? this.ap$CmdlMain$$existentialConstantNum((ProofTree)((Tuple3)option.get())._3()) + ((SeqLike)((Tuple3)option.get())._2()).size() : BoxesRunTime.unboxToInt((Object)p.subtrees().iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ProofTree st) {
                return CmdlMain$.MODULE$.ap$CmdlMain$$existentialConstantNum(st);
            }
        }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Prover.Result> proveProblem(GlobalSettings settings, String name, Function0<Reader> reader, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        None$ none$;
        Debug$.MODULE$.enableAllAssertions(BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings)));
        try {
            Prover prover;
            long timeBefore = System.currentTimeMillis();
            GlobalSettings baseSettings = Param$INPUT_FORMAT$.MODULE$.set(settings, format);
            if (BoxesRunTime.unboxToBoolean((Object)Param$MULTI_STRATEGY$.MODULE$.apply(settings))) {
                void var9_11;
                void var8_10;
                void var7_9;
                void var6_8;
                GlobalSettings s = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(baseSettings, BoxesRunTime.boxToBoolean((boolean)false));
                s = Param$TRIGGER_STRATEGY$.MODULE$.set(s, Param$TriggerStrategyOptions$.MODULE$.Maximal());
                s = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s, BoxesRunTime.boxToBoolean((boolean)false));
                s = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings s2 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(baseSettings, BoxesRunTime.boxToBoolean((boolean)true));
                s2 = Param$TRIGGER_STRATEGY$.MODULE$.set(s2, Param$TriggerStrategyOptions$.MODULE$.AllMaximal());
                s2 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s2, BoxesRunTime.boxToBoolean((boolean)true));
                s2 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s2, BoxesRunTime.boxToBoolean((boolean)true));
                GlobalSettings s3 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(baseSettings, BoxesRunTime.boxToBoolean((boolean)true));
                s3 = Param$TRIGGER_STRATEGY$.MODULE$.set(s3, Param$TriggerStrategyOptions$.MODULE$.AllMaximal());
                s3 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s3, BoxesRunTime.boxToBoolean((boolean)false));
                s3 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s3, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings s4 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(baseSettings, BoxesRunTime.boxToBoolean((boolean)false));
                s4 = Param$TRIGGER_STRATEGY$.MODULE$.set(s4, Param$TriggerStrategyOptions$.MODULE$.Maximal());
                s4 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s4, BoxesRunTime.boxToBoolean((boolean)true));
                s4 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s4, BoxesRunTime.boxToBoolean((boolean)false));
                List strategies = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParallelFileProver.Configuration[]{new ParallelFileProver.Configuration((GlobalSettings)var6_8, false, "-genTotalityAxioms -tightFunctionScopes", Long.MAX_VALUE), new ParallelFileProver.Configuration((GlobalSettings)var7_9, true, "-triggerStrategy=allMaximal +reverseFunctionalityPropagation", Long.MAX_VALUE), new ParallelFileProver.Configuration((GlobalSettings)var8_10, true, "-triggerStrategy=allMaximal -tightFunctionScopes", Long.MAX_VALUE), new ParallelFileProver.Configuration((GlobalSettings)var9_11, false, "-genTotalityAxioms +reverseFunctionalityPropagation -tightFunctionScopes", Long.MAX_VALUE)}));
                prover = new ParallelFileProver(reader, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, (Seq<ParallelFileProver.Configuration>)strategies, 2);
            } else {
                prover = new IntelliFileProver((Reader)reader.apply(), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, baseSettings);
            }
            IntelliFileProver prover2 = prover;
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    Predef$.MODULE$.println();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.println();
                }
            });
            this.printResult(prover2.result(), settings, format);
            long timeAfter = System.currentTimeMillis();
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(settings, timeBefore, timeAfter){
                public static final long serialVersionUID = 0L;
                private final GlobalSettings settings$1;
                private final long timeBefore$1;
                private final long timeAfter$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.println();
                    if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(this.settings$1))) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToLong((long)(this.timeAfter$1 - this.timeBefore$1))).append((Object)"ms").toString());
                    }
                }
                {
                    this.settings$1 = settings$1;
                    this.timeBefore$1 = timeBefore$1;
                    this.timeAfter$1 = timeAfter$1;
                }
            });
            if (prover2 instanceof AbstractFileProver) {
                AbstractFileProver abstractFileProver = prover2;
                this.printSMT(abstractFileProver, name, settings);
                this.printTPTP(abstractFileProver, name, settings);
            }
            none$ = new Some((Object)prover2.result());
        }
        catch (Throwable throwable) {
            Enumeration.Value value = format;
            Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                Predef$.MODULE$.println((Object)"error");
                Console$.MODULE$.err().println(throwable.getMessage());
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"ERROR: ").append((Object)throwable.getMessage()).toString());
            }
            none$ = None$.MODULE$;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Enumeration.Value value = format;
            Enumeration.Value value3 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            none$ = None$.MODULE$;
        }
        catch (StackOverflowError stackOverflowError) {
            Enumeration.Value value = format;
            Enumeration.Value value4 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value4) : value4 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Stack overflow, giving up");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void proveMultiSMT(GlobalSettings settings, BufferedReader input, Function0<Object> userDefStoppingCond) {
        try {
            boolean assertions = BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings));
            Debug$.MODULE$.enableAllAssertions(assertions);
            boolean x$4 = BoxesRunTime.unboxToBoolean((Object)Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.apply(settings));
            boolean x$5 = SimpleAPI$.MODULE$.withProver$default$3();
            String x$6 = SimpleAPI$.MODULE$.withProver$default$4();
            boolean x$7 = SimpleAPI$.MODULE$.withProver$default$5();
            String x$8 = SimpleAPI$.MODULE$.withProver$default$6();
            File x$9 = SimpleAPI$.MODULE$.withProver$default$7();
            boolean x$10 = SimpleAPI$.MODULE$.withProver$default$8();
            Serializable x$11 = new Serializable(settings, input, userDefStoppingCond){
                public static final long serialVersionUID = 0L;
                private final GlobalSettings settings$2;
                private final BufferedReader input$1;
                private final Function0 userDefStoppingCond$1;

                public final void apply(SimpleAPI p) {
                    SMTParser2InputAbsy parser2 = SMTParser2InputAbsy$.MODULE$.apply(this.settings$2.toParserSettings(), p);
                    parser2.processIncrementally(this.input$1, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(this.settings$2)), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT_PER$.MODULE$.apply(this.settings$2)), (Function0<Object>)this.userDefStoppingCond$1);
                }
                {
                    this.settings$2 = settings$2;
                    this.input$1 = input$1;
                    this.userDefStoppingCond$1 = userDefStoppingCond$1;
                }
            };
            SimpleAPI$.MODULE$.withProver(assertions, false, x$5, x$6, x$7, x$8, x$9, x$10, x$4, x$11);
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"error");
            Console$.MODULE$.err().println(throwable.getMessage());
            throwable.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
        }
        catch (StackOverflowError stackOverflowError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Stack overflow, giving up");
        }
    }

    public Object proveProblems(GlobalSettings settings, String name, Function0<BufferedReader> input, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        BoxedUnit boxedUnit;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Loading ").append((Object)name).append((Object)" ...").toString());
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null) && BoxesRunTime.unboxToBoolean((Object)Param$INCREMENTAL$.MODULE$.apply(settings))) {
            this.proveMultiSMT(settings, (BufferedReader)input.apply(), userDefStoppingCond);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = this.proveProblem(settings, name, input, userDefStoppingCond, format);
        }
        return boxedUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printResult(Prover.Result res, GlobalSettings settings, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            if (res instanceof Prover.Proof) {
                Prover.Proof proof = (Prover.Proof)res;
                Predef$.MODULE$.println((Object)"unsat");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(proof){
                    public static final long serialVersionUID = 0L;
                    private final Prover.Proof x2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Proof tree:");
                        Predef$.MODULE$.println((Object)this.x2$1.tree());
                    }
                    {
                        this.x2$1 = x2$1;
                    }
                });
                return;
            }
            if (res instanceof Prover.ProofWithModel) {
                Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)res;
                Predef$.MODULE$.println((Object)"unsat");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(proofWithModel){
                    public static final long serialVersionUID = 0L;
                    private final Prover.ProofWithModel x3$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Proof tree:");
                        Predef$.MODULE$.println((Object)this.x3$1.tree());
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                return;
            }
            if (res instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)"unknown");
                return;
            }
            if (res instanceof Prover.Invalid) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (res instanceof Prover.CounterModel) {
                Prover.CounterModel counterModel = (Prover.CounterModel)res;
                Predef$.MODULE$.println((Object)"sat");
                BoxedUnit cfr_ignored_2 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(format, counterModel){
                    public static final long serialVersionUID = 0L;
                    private final Enumeration.Value format$1;
                    private final Prover.CounterModel x8$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Model:");
                        CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.x8$1.counterModel(), this.format$1);
                    }
                    {
                        this.format$1 = format$1;
                        this.x8$1 = x8$1;
                    }
                });
                return;
            }
            if (res instanceof Prover.MaybeCounterModel) {
                Prover.MaybeCounterModel maybeCounterModel = (Prover.MaybeCounterModel)res;
                Predef$.MODULE$.println((Object)"unknown");
                BoxedUnit cfr_ignored_3 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(format, maybeCounterModel){
                    public static final long serialVersionUID = 0L;
                    private final Enumeration.Value format$1;
                    private final Prover.MaybeCounterModel x9$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Possible model:");
                        CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.x9$1.counterModel(), this.format$1);
                    }
                    {
                        this.format$1 = format$1;
                        this.x9$1 = x9$1;
                    }
                });
                return;
            }
            if (Prover$NoCounterModel$.MODULE$.equals(res)) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (res instanceof Prover.NoCounterModelCert) {
                Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)res;
                Predef$.MODULE$.println((Object)"unsat");
                this.printDOTCertificate(noCounterModelCert.certificate(), settings);
                return;
            }
            if (res instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)res;
                Predef$.MODULE$.println((Object)"unsat");
                this.printDOTCertificate(noCounterModelCertInter.certificate(), settings);
                Console$.MODULE$.err().println();
                Console$.MODULE$.err().println("Interpolants:");
                noCounterModelCertInter.interpolants().foreach((Function1)new Serializable(format){
                    public static final long serialVersionUID = 0L;
                    private final Enumeration.Value format$1;

                    public final void apply(IFormula i) {
                        CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(i, this.format$1);
                    }
                    {
                        this.format$1 = format$1;
                    }
                });
                return;
            }
            if (res instanceof Prover.Model) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (Prover$NoModel$.MODULE$.equals(res)) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (res instanceof Prover.TimeoutProof) {
                Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)res;
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_4 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(timeoutProof){
                    public static final long serialVersionUID = 0L;
                    private final Prover.TimeoutProof x13$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Proof tree:");
                        Predef$.MODULE$.println((Object)this.x13$1.unfinishedTree());
                    }
                    {
                        this.x13$1 = x13$1;
                    }
                });
                return;
            }
            boolean bl = Prover$TimeoutModel$.MODULE$.equals(res) ? true : Prover$TimeoutCounterModel$.MODULE$.equals(res);
            if (!bl) throw new MatchError((Object)res);
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Cancelled or timeout");
            return;
        }
        if (res instanceof Prover.Proof) {
            Prover.Proof proof = (Prover.Proof)res;
            Predef$.MODULE$.println((Object)"VALID");
            if (!proof.tree().closingConstraint().isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append((Object)"constraint:").toString());
                this.ap$CmdlMain$$printFormula(proof.tree().closingConstraint(), format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)proof.tree());
            return;
        }
        if (res instanceof Prover.ProofWithModel) {
            IBoolLit iBoolLit;
            IFormula iFormula;
            Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)res;
            Predef$.MODULE$.println((Object)"VALID");
            if (!proofWithModel.tree().closingConstraint().isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append((Object)"constraint:").toString());
                this.ap$CmdlMain$$printFormula(proofWithModel.tree().closingConstraint(), format);
            }
            if ((iFormula = proofWithModel.model()) instanceof IBoolLit && (iBoolLit = (IBoolLit)iFormula).value()) {
            } else {
                Conjunction c = proofWithModel.tree().closingConstraint();
                if (c.arithConj().positiveEqs().size() == c.size()) {
                } else {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Concrete witness:");
                    this.ap$CmdlMain$$printFormula(proofWithModel.model(), format);
                }
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)proofWithModel.tree());
            return;
        }
        if (res instanceof Prover.NoProof) {
            Predef$.MODULE$.println((Object)"UNKNOWN");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (res instanceof Prover.Invalid) {
            Predef$.MODULE$.println((Object)"INVALID");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (res instanceof Prover.CounterModel) {
            IBoolLit iBoolLit;
            Prover.CounterModel counterModel = (Prover.CounterModel)res;
            Predef$.MODULE$.println((Object)"INVALID");
            IFormula iFormula = counterModel.counterModel();
            if (iFormula instanceof IBoolLit && (iBoolLit = (IBoolLit)iFormula).value()) {
            } else {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Countermodel:");
                this.ap$CmdlMain$$printFormula(counterModel.counterModel(), format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (res instanceof Prover.MaybeCounterModel) {
            IBoolLit iBoolLit;
            Prover.MaybeCounterModel maybeCounterModel = (Prover.MaybeCounterModel)res;
            Predef$.MODULE$.println((Object)"UNKNOWN");
            IFormula iFormula = maybeCounterModel.counterModel();
            if (iFormula instanceof IBoolLit && (iBoolLit = (IBoolLit)iFormula).value()) {
            } else {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Possible countermodel:");
                this.ap$CmdlMain$$printFormula(maybeCounterModel.counterModel(), format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (Prover$NoCounterModel$.MODULE$.equals(res)) {
            Predef$.MODULE$.println((Object)"VALID");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"true");
            return;
        }
        if (res instanceof Prover.NoCounterModelCert) {
            Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)res;
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Most-general constraint:");
                Predef$.MODULE$.println((Object)"true");
            }
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Certificate: ").append((Object)noCounterModelCert.certificate()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Assumed formulae: ").append(noCounterModelCert.certificate().assumedFormulas()).toString());
            Predef$.MODULE$.print((Object)"Constraint: ");
            this.ap$CmdlMain$$printFormula(noCounterModelCert.certificate().closingConstraint(), format);
            this.printDOTCertificate(noCounterModelCert.certificate(), settings);
            return;
        }
        if (res instanceof Prover.NoCounterModelCertInter) {
            Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)res;
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Most-general constraint:");
                Predef$.MODULE$.println((Object)"true");
            }
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Interpolants:");
            noCounterModelCertInter.interpolants().foreach((Function1)new Serializable(format){
                public static final long serialVersionUID = 0L;
                private final Enumeration.Value format$1;

                public final void apply(IFormula i) {
                    CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(i, this.format$1);
                }
                {
                    this.format$1 = format$1;
                }
            });
            this.printDOTCertificate(noCounterModelCertInter.certificate(), settings);
            return;
        }
        if (res instanceof Prover.Model) {
            Prover.Model model = (Prover.Model)res;
            Predef$.MODULE$.println((Object)"VALID");
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Under the assignment:");
            this.ap$CmdlMain$$printFormula(model.model(), format);
            return;
        }
        if (Prover$NoModel$.MODULE$.equals(res)) {
            Predef$.MODULE$.println((Object)"INVALID");
            return;
        }
        if (res instanceof Prover.TimeoutProof) {
            Object object;
            Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)res;
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Current constraint:");
                object = Timeout$.MODULE$.withTimeoutMillis(1000L, new Serializable(format, timeoutProof){
                    public static final long serialVersionUID = 0L;
                    public final Enumeration.Value format$1;
                    public final Prover.TimeoutProof x11$1;

                    public final void apply() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.x11$1.unfinishedTree().closingConstraint(), this.format$1);
                    }

                    public void apply$mcV$sp() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.x11$1.unfinishedTree().closingConstraint(), this.format$1);
                    }
                    {
                        this.format$1 = format$1;
                        this.x11$1 = x11$1;
                    }
                }, new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        Predef$.MODULE$.println((Object)"(timeout)");
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println((Object)"(timeout)");
                    }
                });
            } else {
                object = BoxedUnit.UNIT;
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)timeoutProof.unfinishedTree());
            return;
        }
        boolean bl = Prover$TimeoutModel$.MODULE$.equals(res) ? true : Prover$TimeoutCounterModel$.MODULE$.equals(res);
        if (!bl) throw new MatchError((Object)res);
        Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
        if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Current constraint:");
        Predef$.MODULE$.println((Object)"false");
    }

    public void main(String[] args) {
        this.doMain(args, (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return false;
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        });
    }

    public void doMain(String[] args, Function0<Object> userDefStoppingCond) {
        NonLocalReturnControl nonLocalReturnControl;
        block8: {
            block7: {
                Object object = new Object();
                try {
                    Tuple2 tuple2 = this.liftedTree1$1(args, object);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                        GlobalSettings settings = (GlobalSettings)tuple22._1();
                        Seq inputs = (Seq)tuple22._2();
                        if (BoxesRunTime.unboxToBoolean((Object)Param$VERSION$.MODULE$.apply(settings))) {
                            Predef$.MODULE$.println((Object)this.version());
                            return;
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)Param$QUIET$.MODULE$.apply(settings))) {
                            Console$.MODULE$.setErr((OutputStream)CmdlMain$NullStream$.MODULE$);
                        }
                        Object object2 = BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings)) ? Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                CmdlMain$.MODULE$.printGreeting();
                                Predef$.MODULE$.println();
                            }

                            public void apply$mcV$sp() {
                                CmdlMain$.MODULE$.printGreeting();
                                Predef$.MODULE$.println();
                            }
                        }) : BoxedUnit.UNIT;
                        if (inputs.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings))) {
                            Console$.MODULE$.err().println("No inputs given, exiting");
                            return;
                        }
                        inputs.foreach((Function1)new Serializable(userDefStoppingCond, settings){
                            public static final long serialVersionUID = 0L;
                            private final Function0 userDefStoppingCond$2;
                            private final GlobalSettings settings$3;

                            public final Object apply(String filename) {
                                Object object;
                                try {
                                    Enumeration.Value format = CmdlMain$.MODULE$.ap$CmdlMain$$determineInputFormat(filename, this.settings$3);
                                    object = CmdlMain$.MODULE$.proveProblems(this.settings$3, filename, (Function0<BufferedReader>)new Serializable(this, filename){
                                        public static final long serialVersionUID = 0L;
                                        private final String filename$3;

                                        public final BufferedReader apply() {
                                            return new BufferedReader(new FileReader(new File(this.filename$3)));
                                        }
                                        {
                                            this.filename$3 = filename$3;
                                        }
                                    }, (Function0<Object>)this.userDefStoppingCond$2, format);
                                }
                                catch (Throwable throwable) {
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"ERROR: ").append((Object)throwable.getMessage()).toString());
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            {
                                this.userDefStoppingCond$2 = userDefStoppingCond$2;
                                this.settings$3 = settings$3;
                            }
                        });
                        if (BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings))) {
                            Console$.MODULE$.err().println("Reading SMT-LIB 2 input from stdin ...");
                            this.proveMultiSMT(settings, Console$.MODULE$.in(), userDefStoppingCond);
                        }
                        break block7;
                    }
                    throw new MatchError((Object)tuple2);
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    nonLocalReturnControl = nonLocalReturnControl2;
                    if (nonLocalReturnControl2.key() != object) break block8;
                    nonLocalReturnControl.value$mcV$sp();
                }
            }
            return;
        }
        throw nonLocalReturnControl;
    }

    public final IFormula ap$CmdlMain$$formula$1(PartName name, AbstractFileProver prover$1) {
        Object object;
        Option option = prover$1.inputFormulas().find((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final PartName name$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(INamedPart x0$1) {
                if (x0$1 == null) return false;
                PartName partName = this.name$1;
                PartName partName2 = x0$1.name();
                if (partName != null) {
                    if (!partName.equals(partName2)) return false;
                    return true;
                }
                if (partName2 == null) return true;
                return false;
            }
            {
                this.name$1 = name$1;
            }
        });
        if (!option.isEmpty()) {
            object = option.get();
        } else {
            IExpression$ iExpression$ = IExpression$.MODULE$;
            object = new IBoolLit(false);
        }
        return IExpression$.MODULE$.removePartName((IFormula)object);
    }

    public final void ap$CmdlMain$$linearise$1(AbstractFileProver prover$1, String filename$1) {
        List<IInterpolantSpec> list;
        block4: {
            List list2;
            block3: {
                .colon.colon colon2;
                block2: {
                    list = prover$1.interpolantSpecs();
                    Some some = List$.MODULE$.unapplySeq(list);
                    if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(0) != 0) break block2;
                    list2 = (List)prover$1.inputFormulas().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final IFormula apply(INamedPart f) {
                            return IExpression$.MODULE$.removePartName(f);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!(list instanceof .colon.colon) || (colon2 = (.colon.colon)list).head() == null) break block4;
                IFormula common = this.ap$CmdlMain$$formula$1(PartName$.MODULE$.NO_NAME(), prover$1);
                list2 = (List)((List)((IInterpolantSpec)colon2.head()).left().$plus$plus(((IInterpolantSpec)colon2.head()).right(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(prover$1, common){
                    public static final long serialVersionUID = 0L;
                    private final AbstractFileProver prover$1;
                    private final IFormula common$1;

                    public final IFormula apply(PartName part) {
                        return this.common$1.$bar$bar$bar(CmdlMain$.MODULE$.ap$CmdlMain$$formula$1(part, this.prover$1));
                    }
                    {
                        this.prover$1 = prover$1;
                        this.common$1 = common$1;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            SMTLineariser$.MODULE$.apply((Seq<IFormula>)list2, prover$1.signature(), filename$1);
            return;
        }
        throw new MatchError(list);
    }

    public final void ap$CmdlMain$$linearise$2(AbstractFileProver prover$2, String filename$2) {
        TPTPLineariser$.MODULE$.apply(prover$2.originalInputFormula(), filename$2);
    }

    private final Tuple2 liftedTree1$1(String[] args$1, Object nonLocalReturnKey1$1) {
        try {
            return GlobalSettings$.MODULE$.fromArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args$1), GlobalSettings$.MODULE$.DEFAULT());
        }
        catch (Throwable throwable) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    CmdlMain$.MODULE$.printGreeting();
                    Predef$.MODULE$.println();
                }

                public void apply$mcV$sp() {
                    CmdlMain$.MODULE$.printGreeting();
                    Predef$.MODULE$.println();
                }
            });
            Predef$.MODULE$.println((Object)throwable.getMessage());
            Predef$.MODULE$.println();
            this.printUsage();
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    private CmdlMain$() {
        MODULE$ = this;
        this.version = "build 2015-07-06";
    }
}

