import BaseSchema from '@ioc:Adonis/Lucid/Schema'

// eslint-disable-next-line import/no-anonymous-default-export
export default class extends BaseSchema {
  protected tableName = 'server'

  public async up() {
    this.schema.createTable(this.tableName, (table) => {
      table.increments('id')

      table.string('name', 64).notNullable().unique()
      table.string('description').nullable()

      /**
       * Uses timestamptz for PostgreSQL and DATETIME2 for MSSQL
       */
      table.timestamp('created_at', { useTz: true })
      table.timestamp('updated_at', { useTz: true })
    })
  }

  public async down() {
    this.schema.dropTable(this.tableName)
  }
}
