# Python Codes in Data Science

Codes in NLP, Deep Learning, Reinforcement Learning and Artificial Intelligence

<b> Welcome to my GitHub repo. </b>

I am a Data Scientist and I code in R, Python and Wolfram Mathematica. Here you will find some Machine Learning, Deep Learning, Natural Language Processing and Artificial Intelligence models I developed.

---------------
Keras version used in models: keras==1.1.0

<b> Autoencoder for Audio  </b> is a model where I compressed an audio file and used Autoencoder to reconstruct the audio file, for use in phoneme classification.

<b> Collaborative Filtering  </b> is a Recommender System where the algorithm predicts a movie review based on genre of movie and similarity among people who watched the same movie.

<b> Convolutional NN Lasagne  </b> is a Convolutional Neural Network model in Lasagne to solve the MNIST task.

<b> Ensembled Machine Learning </b> is a .py file where 7 Machine Learning algorithms are used in a classification task with 3 classes and all possible hyperparameters of each algorithm are adjusted. Iris dataset of scikit-learn.

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/raw/master/Pictures%20-%20Formulas/Ensembled.MachineLearning.png?raw=true>
</p>

<b> GAN Generative Adversarial  </b> are models of Generative Adversarial Neural Networks.

<b> Hyperparameter Tuning RL  </b> is a model where hyperparameters of Neural Networks are adjusted via Reinforcement Learning. According to a reward, hyperparameter tuning (environment) is changed through a policy (mechanization of knowledge) using the Boston Dataset. Hyperparameters tuned are: learning rate, epochs, decay, momentum, number of hidden layers and nodes and initial weights.

<b> Keras Regularization L2  </b> is a Neural Network model for regression made with Keras where a L2 regularization was applied to prevent overfitting.

<b> Lasagne Neural Nets Regression  </b> is a Neural Network model based in Theano and Lasagne, that makes a linear regression with a continuous target variable and reaches 99.4% accuracy. It uses the DadosTeseLogit.csv sample file.

<b> Lasagne Neural Nets + Weights  </b> is a Neural Network model based in Theano and Lasagne, where is possible to visualize weights between X1 and X2 to hidden layer. Can also be adapted to visualize weights between hidden layer and output. It uses the DadosTeseLogit.csv sample file.

<b> Multinomial Regression  </b> is a regression model where target variable has 3 classes.

<b> Neural Networks for Regression  </b> shows multiple solutions for a regression problem, solved with sklearn, Keras, Theano and Lasagne. It uses the Boston dataset sample file from sklearn and reaches more than 98% accuracy.

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/raw/master/Pictures%20-%20Formulas/HiddenLayers.jpg?raw=true>
</p>

<b> NLP + Naive Bayes Classifier  </b> is a model where movie reviews were labeled as positive and negative and the algorithm then classifies a totally new set of reviews using Logistic Regression, Decision Trees and Naive Bayes, reaching an accuracy of 92%.

<b> NLP Anger Analysis  </b> is a Doc2Vec model associated with Word2Vec model to analyze level of anger using synonyms in consumer complaints of a U.S. retailer in Facebook posts.

<b> NLP Consumer Complaint  </b> is a model where Facebook posts of a U.S. computer retailer were scraped, tokenized, lemmatized and applied Word2Vec. After that, t-SNE and Latent Dirichlet Allocation were developed in order to classify the arguments and weights of each keyword used by a consumer in his complaint. The code also analyzes frequency of words in 100 posts.

<b> NLP Convolutional Neural Network </b> is a Convolutional Neural Network for Text in order to classify movie reviews.

<b> NLP Doc2Vec  </b> is a Natural Language Procesing file where cosine similarity among phrases is measured through Doc2Vec.

<b> NLP Document Classification  </b> is a code for Document Classification according to Latent Dirichlet Allocation.

<b> NLP Facebook Analysis  </b> analyzes Facebook posts regarding Word Frequency and Topic Modelling using LDA.

<b> NLP Facebook Scrap  </b> is a Python code for scraping data from Facebook.

<b> NLP - Latent Dirichlet Allocation  </b> is a Natural Language Processing model where a Wikipedia page on Statistical Inference is classified regarding topics, using Latent Dirichlet Allocation with Gensim, NLTK, t-SNE and K-Means.

<b> NLP Probabilistic ANN  </b> is a Natural Language Processing model where sentences are vectorized by Gensim and a probabilistic Neural Network model is deveoped using Gensim, for sentiment analysis.

<b> NLP Semantic Doc2Vec + Neural Network  </b> is a model where positive and negative movie reviews were extracted and semantically classified with NLTK and BeautifulSoup, then labeled as positive or negative. Text was then used as an input for the Neural Network model training. After training, new sentences are entered in the Keras Neural Network model and then classified. It uses the zip file.

<b> NLP Sentiment Positive  </b> is a model that identifies website content as positive, neutral or negative using BeautifulSoup and NLTK libraries, plotting the results.

<b> NLP Twitter Analysis ID #  </b> is a model that extracts posts from Twitter based in ID of user or Hashtag.

<b> NLP Twitter Scrap  </b> is a model that scraps Twitter data and shows the cleaned text as output.

<b> NLP Twitter Streaming  </b> is a model of analysis of real-time data from Twitter (under development).

<b> NLP Twitter Streaming Mood  </b> is a model where the evolution of mood Twitter posts is measured during a period of time.

<b> NLP Wikipedia Summarization  </b> is a Python code that summarizes any given page in a few sentences.

<b> NLP Word Frequency  </b> is a model that calculates the frequency of nouns, verbs, words in Facebook posts.

<b> Probabilistic Neural Network  </b> is a Probabilistic Neural Network for Time Series Prediction.

<b> REAL-TIME Twitter Analysis  </b> is a model where Twitter streaming is extracted, words and sentences tokenized, word embeddings were created, topic modeling was made and classified using K-Means. Then, NLTK SentimentAnalyzer was used to classify each sentence of the streaming into positive, neutral or negative. Accumulated sum was used to generate the plot and the code loops each 1 second, collecting new tweets.

<b> RESNET-2  </b> is a Deep Residual Neural Network.

<b> ROC Curve Multiclass  </b> is a .py file where Naive Bayes was used to solve the IRIS Dataset task and ROC curve of different classes are plotted.

<b> SQUEEZENET  </b> is a simplified version of the AlexNet.

<b> Stacked Machine Learning  </b> is a .py notebook where t-SNE, Principal Components Analysis and Factor Analysis were applied to reduce dimensionality of data. Classification performances were measured after applying K-Means.

<b> Support Vector Regression  </b> is a SVM model for non linear regression in an artificial dataset.

<b> Text-to-Speech  </b> is a .py file where Python speaks any given text and saves it as an audio .wav file.

<b> Time Series ARIMA </b>  is a ARIMA model to forecast time series, with an error margin of 0.2%.

<b> Time Series Prediction with Neural Networks - Keras </b>  is a Neural Network model to forecast time series, using Keras with an adaptive learning rate depending upon derivative of loss.

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/blob/master/Pictures%20-%20Formulas/ARIMA.10Period.png?raw=true> 
</p>

<b> Variational Autoencoder  </b> is a VAE made with Keras.

<b> Web Crawler  </b> is a code that scraps data from different URLs of a hotel website.

<b> t-SNE Dimensionality Reduction  </b> is a t-SNE model for dimensionality reduction which is compared to Principal Components Analysis regarding its discriminatory power.

<b> t-SNE PCA + Neural Networks  </b> is a model that compares performance or Neural Networks made after t-SNE, PCA and K-Means.

<b> t-SNE PCA LDA embeddings </b> is a model where t-SNE, Principal Components Analysis, Linear Discriminant Analysis and Random Forest embeddings are compared in a task to classify clusters of similar digits.

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/raw/master/Pictures%20-%20Formulas/Doc2Vec.png?raw=true>
</p>

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/raw/master/Pictures%20-%20Formulas/t_SNE_Lk.png?raw=true>
</p>

<p align="center">
<img src=https://github.com/RubensZimbres/Repo-2017/blob/master/Pictures%20-%20Formulas/RESNET_Me.jpg?raw=true>
</p>

