# Roseau Load Flow Tutorials

## Overview

Welcome to _Roseau Load Flow_ tutorials. This series of tutorials provides a comprehensive overview
of the steps needed to model, solve and analyze electrical networks using the Roseau Load Flow
solver. The tutorials are designed for power engineering students or professionals, researchers,
consultants, etc. and requires an intermediate level of Python skills. Whatever your background,
this tutorial will be valuable for understanding the intricacies of the _Roseau Load Flow_ solver.

## Pre-Requisites

Make sure you have installed all the packages as described in the _pyproject.toml_ file of the
tutorial series you are following to ensure a smooth journey through the tutorial. The easiest way
to do this is as follows:

1. [Clone](https://docs.github.com/en/repositories/creating-and-managing-repositories/cloning-a-repository)
   this repository. Alternatively, download it as a zip archive using the green "Code" button and
   unzip it on your device.
2. Using the terminal, install the `poetry` package manager if you don't have it already. Follow the
   [installation instructions](https://python-poetry.org/docs/#installation) on the Poetry website.
3. Navigate to your download location in the terminal and run the: `poetry install`

Using this method will automatically install all required packages and their dependencies with the
correct versions.

## What's Next?

See the README file for each tutorial to get started.

## Contributing

We welcome contributions form the community. If you have an idea for a new tutorial, bug fixes or improvements to existing tutorials, please feel free to submit a pull request.

## Support

If you encounter any issues or have questions, please open an issue on Github. We are here to help and ensure that you have a smooth learning experience.
