# Roseau Load Flow Tutorials

This series of tutorials provides a step-by-step guide to modelling, solving, and analyzing
electrical networks using the Roseau Load Flow solver by following the
[OpenDSS tutorials by prof. Nando Ochoa](https://github.com/Team-Nando).

## Pre-Requisites

Please follow the instructions in the [main README](../README.md) file to install the required packages.

## Tutorial 1

This tutorial involves modelling a simple LV network and is designed to familiarize the user with
the basic workflow of Roseau Load Flow (RLF). You will learn the following:

1. How to model common network components such as buses, lines, transformers, etc. in RLF as well
   as RLF-specific components.
2. How to build a network and run power flow simulations in RLF.
3. How to access different types of results for various network elements

## Tutorial 2

This tutorial focuses on the modelling flexibility of RLF as well as benchmarking RLF. It also
demonstrates the interoperability of RLF with OpenDSS. In this tutorial, you will learn the
following:

1. How to convert OpenDSS parameters into RLF parameters
2. How to model networks with a single-wire, earth-return systems in RLF
