"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Bulk Messaging and Broadcast
 * Bulk Sending is a public Twilio REST API for 1:Many Message creation up to 100 recipients. Broadcast is a public Twilio REST API for 1:Many Message creation up to 10,000 recipients via file upload.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageInstance = exports.MessageListInstance = exports.MessagingV1MessageReceipt = exports.MessagingV1Message = exports.MessagingV1FailedMessageReceipt = exports.CreateMessagesRequest = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
class CreateMessagesRequest {
}
exports.CreateMessagesRequest = CreateMessagesRequest;
class MessagingV1FailedMessageReceipt {
}
exports.MessagingV1FailedMessageReceipt = MessagingV1FailedMessageReceipt;
class MessagingV1Message {
}
exports.MessagingV1Message = MessagingV1Message;
class MessagingV1MessageReceipt {
}
exports.MessagingV1MessageReceipt = MessagingV1MessageReceipt;
function MessageListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Messages`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        const headers = {};
        headers["Content-Type"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new MessageInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.MessageListInstance = MessageListInstance;
class MessageInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.totalMessageCount = deserialize.integer(payload.total_message_count);
        this.successCount = deserialize.integer(payload.success_count);
        this.errorCount = deserialize.integer(payload.error_count);
        this.messageReceipts = payload.message_receipts;
        this.failedMessageReceipts = payload.failed_message_receipts;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            totalMessageCount: this.totalMessageCount,
            successCount: this.successCount,
            errorCount: this.errorCount,
            messageReceipts: this.messageReceipts,
            failedMessageReceipts: this.failedMessageReceipts,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.MessageInstance = MessageInstance;
