"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Bulk Messaging and Broadcast
 * Bulk Sending is a public Twilio REST API for 1:Many Message creation up to 100 recipients. Broadcast is a public Twilio REST API for 1:Many Message creation up to 10,000 recipients via file upload.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BroadcastInstance = exports.BroadcastListInstance = exports.MessagingV1BroadcastExecutionDetails = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
/**
 * Details on the statuses of messages sent to recipients
 */
class MessagingV1BroadcastExecutionDetails {
}
exports.MessagingV1BroadcastExecutionDetails = MessagingV1BroadcastExecutionDetails;
function BroadcastListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Broadcasts`;
    instance.create = function create(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        const headers = {};
        if (params["xTwilioRequestKey"] !== undefined)
            headers["X-Twilio-Request-Key"] = params["xTwilioRequestKey"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new BroadcastInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.BroadcastListInstance = BroadcastListInstance;
/**
 * Details of a Broadcast
 */
class BroadcastInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.broadcastSid = payload.broadcast_sid;
        this.createdDate = deserialize.iso8601DateTime(payload.created_date);
        this.updatedDate = deserialize.iso8601DateTime(payload.updated_date);
        this.broadcastStatus = payload.broadcast_status;
        this.executionDetails = payload.execution_details;
        this.resultsFile = payload.results_file;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            broadcastSid: this.broadcastSid,
            createdDate: this.createdDate,
            updatedDate: this.updatedDate,
            broadcastStatus: this.broadcastStatus,
            executionDetails: this.executionDetails,
            resultsFile: this.resultsFile,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.BroadcastInstance = BroadcastInstance;
