/// <reference types="node" />
import { inspect, InspectOptions } from "util";
import V1 from "../V1";
/**
 * Details on the statuses of messages sent to recipients
 */
export declare class MessagingV1BroadcastExecutionDetails {
    /**
     * Number of recipients in the Broadcast request
     */
    "totalRecords"?: number;
    /**
     * Number of recipients with messages successfully sent to them
     */
    "totalCompleted"?: number;
    /**
     * Number of recipients with messages unsuccessfully sent to them, producing an error
     */
    "totalErrors"?: number;
}
/**
 * Options to pass to create a BroadcastInstance
 */
export interface BroadcastListInstanceCreateOptions {
    /** Idempotency key provided by the client */
    xTwilioRequestKey?: string;
}
export interface BroadcastSolution {
}
export interface BroadcastListInstance {
    _version: V1;
    _solution: BroadcastSolution;
    _uri: string;
    /**
     * Create a BroadcastInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed BroadcastInstance
     */
    create(callback?: (error: Error | null, item?: BroadcastInstance) => any): Promise<BroadcastInstance>;
    /**
     * Create a BroadcastInstance
     *
     * @param params - Parameter for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed BroadcastInstance
     */
    create(params: BroadcastListInstanceCreateOptions, callback?: (error: Error | null, item?: BroadcastInstance) => any): Promise<BroadcastInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function BroadcastListInstance(version: V1): BroadcastListInstance;
interface BroadcastResource {
    broadcast_sid: string;
    created_date: Date;
    updated_date: Date;
    broadcast_status: string;
    execution_details: MessagingV1BroadcastExecutionDetails;
    results_file: string;
}
/**
 * Details of a Broadcast
 */
export declare class BroadcastInstance {
    protected _version: V1;
    constructor(_version: V1, payload: BroadcastResource);
    /**
     * Numeric ID indentifying individual Broadcast requests
     */
    broadcastSid: string;
    /**
     * Timestamp of when the Broadcast was created
     */
    createdDate: Date;
    /**
     * Timestamp of when the Broadcast was last updated
     */
    updatedDate: Date;
    /**
     * Status of the Broadcast request. Valid values are None, Pending-Upload, Uploaded, Queued, Executing, Execution-Failure, Execution-Completed, Cancelation-Requested, and Canceled
     */
    broadcastStatus: string;
    executionDetails: MessagingV1BroadcastExecutionDetails;
    /**
     * Path to a file detailing successful requests and errors from Broadcast execution
     */
    resultsFile: string;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        broadcastSid: string;
        createdDate: Date;
        updatedDate: Date;
        broadcastStatus: string;
        executionDetails: MessagingV1BroadcastExecutionDetails;
        resultsFile: string;
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export {};
