import NumbersBase from "../NumbersBase";
import Version from "../../base/Version";
import { BulkEligibilityListInstance } from "./v1/bulkEligibility";
import { EligibilityListInstance } from "./v1/eligibility";
import { PortingBulkPortabilityListInstance } from "./v1/portingBulkPortability";
import { PortingPortInListInstance } from "./v1/portingPortIn";
import { PortingPortInFetchListInstance } from "./v1/portingPortInFetch";
import { PortingPortInPhoneNumberListInstance } from "./v1/portingPortInPhoneNumber";
import { PortingPortabilityListInstance } from "./v1/portingPortability";
export default class V1 extends Version {
    /**
     * Initialize the V1 version of Numbers
     *
     * @param domain - The Twilio (Twilio.Numbers) domain
     */
    constructor(domain: NumbersBase);
    /** bulkEligibilities - { Twilio.Numbers.V1.BulkEligibilityListInstance } resource */
    protected _bulkEligibilities?: BulkEligibilityListInstance;
    /** eligibilities - { Twilio.Numbers.V1.EligibilityListInstance } resource */
    protected _eligibilities?: EligibilityListInstance;
    /** portingBulkPortabilities - { Twilio.Numbers.V1.PortingBulkPortabilityListInstance } resource */
    protected _portingBulkPortabilities?: PortingBulkPortabilityListInstance;
    /** portingPortIns - { Twilio.Numbers.V1.PortingPortInListInstance } resource */
    protected _portingPortIns?: PortingPortInListInstance;
    /** portingPortInsFetch - { Twilio.Numbers.V1.PortingPortInFetchListInstance } resource */
    protected _portingPortInsFetch?: PortingPortInFetchListInstance;
    /** portingPortInPhoneNumber - { Twilio.Numbers.V1.PortingPortInPhoneNumberListInstance } resource */
    protected _portingPortInPhoneNumber?: PortingPortInPhoneNumberListInstance;
    /** portingPortabilities - { Twilio.Numbers.V1.PortingPortabilityListInstance } resource */
    protected _portingPortabilities?: PortingPortabilityListInstance;
    /** Getter for bulkEligibilities resource */
    get bulkEligibilities(): BulkEligibilityListInstance;
    /** Getter for eligibilities resource */
    get eligibilities(): EligibilityListInstance;
    /** Getter for portingBulkPortabilities resource */
    get portingBulkPortabilities(): PortingBulkPortabilityListInstance;
    /** Getter for portingPortIns resource */
    get portingPortIns(): PortingPortInListInstance;
    /** Getter for portingPortInsFetch resource */
    get portingPortInsFetch(): PortingPortInFetchListInstance;
    /** Getter for portingPortInPhoneNumber resource */
    get portingPortInPhoneNumber(): PortingPortInPhoneNumberListInstance;
    /** Getter for portingPortabilities resource */
    get portingPortabilities(): PortingPortabilityListInstance;
}
