---
title: Nextjs Starter Blog
github: https://github.com/ixartz/Next-js-Blog-Boilerplate
demo: https://creativedesignsguru.com/demo/Nextjs-Blog-Boilerplate/
author: Ixartz
ssg:
  - Next
cms:
  - No Cms
css:
  - Tailwind
date: 2020-08-16T12:37:50.000Z
description: >-
  🚀 The perfect Nextjs starter code: production-ready with SEO-friendly for
  quickly start a blog.
stale: false
---

# Nextjs Starter

🚀 Nextjs Starter is boilerplate code for your blog based on Next.js framework. ⚡️ Made with Next.js, TypeScript, ESLint, Prettier, PostCSS, Tailwind CSS.

You can also check our [Nextjs Themes](https://creativedesignsguru.com/category/nextjs/) or if you want to see all our [React Themes](https://creativedesignsguru.com/category/react/). You can see all our other [premium themes](https://creativedesignsguru.com) using other static static generator like Eleventyjs.

## Features

Blog feature:

- 🎈 Syntax Highlighting with Prism.js
- 🤖 SEO metadata and Open Graph tags
- ⚙️ JSON-LD for richer indexing
- 📖 Pagination
- ⬇️ Markdown
- 💯 Maximize lighthouse score

Developer experience first:

- 🔥 Next.js for Static Site Generator
- 🎨 Integrate with Tailwind CSS
- 💅 PostCSS for processing Tailwind CSS
- 🎉 Type checking TypeScript
- ✏️ Linter with ESLint
- 🛠 Code Formatter with Prettier
- 🦊 SEO metadata, JSON-LD and Open Graph tags with Next SEO

Built-in feature from Next.js:

- ☕ Minify HTML & CSS with HTMLMinifier
- 💨 Live reload
- ✅ Cache busting

## Philosophy

- Minimal code
- SEO-friendly
- Production-ready
