---
title: Purelog
github: https://github.com/brennanbrown/purelog
demo: https://purelog.netlify.app
author: brennanbrown
date: 2021-05-04T00:00:00.000Z
ssg:
  - Jekyll
cms:
  - No CMS
archetype:
  - Blog
description: >-
  A responsive sidebar Jekyll theme using the Pure.css framework, designed for
  writers and bloggers of all kinds.
stale: false
---

# Purelog Theme for Jekyll

**Purelog** is a responsive, sidebar theme for the popular JAMstack generator Jekyll that only uses the minimal [**Pure.css** framework](https://github.com/pure-css/pure) (hence the name!), while still following the best practices possible for accessibility and search-engine optimization.

I created this after finishing [Watery](https://github.com/brennanbrown/watery) (which this theme is built off of), as a way to add more functionality and design while still remaining as lightweight as possible.

This project is aimed towards those looking for an interesting theme for Jekyll that has features that aren't found commonly elsewhere, specifically having separate sections dedicated towards: blogging, note-taking, and daily journal entries.

## Features

Here are a few interesting features of this Jekyll theme:

- A fully customizable and empty `_BLANK_config.yml` to make getting up-and-running easy.
- A speedy, on-site search function using [Simply Jekyll Search](https://github.com/christian-fei/Simple-Jekyll-Search).
- Custom collections for different types of material (note-taking, journal writing, etc.)
- An auto-generating archive page that displays all entries from _all_ collections.
- Auto-generating tags and categories pages.
- Having a `_pages` collection for easier organization.
- An author bio at the end of each post. (Located in `_inclues/author.html`)
- Full Rouge support for syntax highlighting. (Currently using `base16.solarized.light`)
- Auto-generated RSS feed, sitemap, accessibility features, and search-engine optimization.
