---
title: Enjoyment Work
github: https://github.com/brennanbrown/enjoyment-work
demo: https://enjoyment-work.netlify.app
author: brennanbrown
date: 2021-05-04T00:00:00.000Z
ssg:
  - Jekyll
css:
  - Bootstrap
cms:
  - No CMS
archetype:
  - Blog
description: >-
  A Digital Garden: Capturing my daily thoughts and progress, as well as curated
  ideas with unique synthesis—a personal zettelkasten. Built on Simply Jekyll by
  Raghuveer S.
stale: false
---

## Enjoyment Work theme for Jekyll

**Enjoyment Work** is an academic / research-focused theme that provides extensive features for note-taking and personal growth. It is based off of the [Digital Garden](https://github.com/MaggieAppleton/digital-gardeners) philosophy, which you can read more about on the [**demo site**](https://enjoyment-work.netlify.app)

The next step for Enjoyment Work is to properly configure the syntax required to work with [**Obsidian**](https://obsidian.md/), a powerful knowledge base that works on top of a local folder of plain text Markdown files. Which would ultimately allow somebody to turn their Obsidian notes into an online blog by simply using the `_notes` directory.

## Features
Here are a few interesting features of this Jekyll theme:

- A fully customizable and empty `_BLANK_config.yml` to make getting up-and-running easy.
- A speedy, on-site search function using [Simply Jekyll Search](https://github.com/christian-fei/Simple-Jekyll-Search).
- Custom collections for different types of material (note-taking, journal writing, etc.)
- An auto-generating `/archive` page that displays all entries from _all_ collections.
- Auto-generating `/tags` and `/categories` pages.
- Breadcrumbs for improved navigation and SEO.
- Having a `_pages` collection for easier organization.
- An author bio at the end of each post. (Located in `_inclues/author.html`)
- Full Rouge support for [syntax highlighting](https://spsarolkar.github.io/rouge-theme-preview/). (Currently using `base16.dark`)
- Auto-generated RSS feed, sitemap, accessibility features, and search-engine optimization.
- Creates backlinks to other notes automatically
- Context menu on feed to instantly see related posts and backlinks
- Supports Roam-style double bracket link syntax to other notes
- On hover page previews
- Features a simple and responsive design
- Supports Markdown or HTML notes

