---
title: Doit
github: https://github.com/HEIGE-PCloud/DoIt
demo: https://hugodoit.pages.dev/
author: PCloud
author_link: https://planet-cloud.fun/
date: 2022-02-07T18:25:23.000Z
weight: 4
ssg:
  - Hugo
cms:
  - No CMS
archetype:
  - Blog
  - Gallery
  - Landing Page
  - Multi Purpose
  - Portfolio
  - Resume
features:
  - Dark mode
  - Search
  - Animate.css
  - Font awesome
  - Katex
  - Diagrams with Mermaid
  - Mapbox
  - Multiple authors
  - Table of content
  - PWA
  - Disqus
  - Gitalk
  - Utterances
  - Giscus
  - Twemoji
  - Images Gallery
  - Internationalization
description: >-
  The goal of DoIt theme is to create a powerful and easy-to-use Hugo theme, so
  you can go straight into your blog content creation and just do it without
  worrying about the complex technical details.
stale: false
---

## Why choose DoIt

* Custom **Header**
* Custom **CSS Style**
* A new **home page**, compatible with the latest version of Hugo
* A lot of **style detail adjustments,** including color, font size, margins, code priew style
* More readable **dark mode**
* Some beautiful **CSS animations** with Animate.css
* Easy-to-use and self-expanding **table of contents**
* More **social links**, **share sites** and **comment system**
* **Search** supported by [Lunr.js](https://lunrjs.com/) or [algolia](https://www.algolia.com/) or [Fuse.js](https://fusejs.io/)
* **Copy code** to clipboard with one click
* Extended Markdown syntax for **[Font Awesome](https://fontawesome.com/) icons**
* Extended Markdown syntax for **ruby annotation**
* Extended Markdown syntax for **fraction**
* **Mathematical formula** supported by [KaTeX](https://katex.org/)
* **Diagram syntax** shortcode supported by [mermaid](https://github.com/knsv/mermaid)
* **Interactive data visualization** shortcode supported by [ECharts](https://echarts.aphe.org/)
* **Mapbox** shortcode supported by [Mapbox GL JS](https://docs.mapbox.com/maox-gl-js)
* Embedded **music player** supported by [APlayer](https://github.com/MoePlayer/APyer) and [MetingJS](https://github.com/metowolf/MetingJS)
* **Bilibili** player supported
* Kinds of **admonitions** shortcode supported
* Custom style shortcodes supported
* **CDN** for all third-party libraries supported
* **Mulitple Authors** supported
* **PJAX** supported
* ...

### Performance and SEO

* Optimized for **performance**: 99/100 on mobile and 100/100 on desktop in [Google PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights)
* Optimized SEO performance with a correct **SEO SCHEMA** based on JSON-LD
* **[Google Analytics](https://analytics.google.com/analytics)** supported
* **[Fathom Analytics](https://usefathom.com/)** supported
* **[Baidu Analytics](https://tongji.baidu.com/)** supported
* **[Umami Analytics](https://umami.is/)** supported
* **[Plausible Analytics](https://plausible.io/)** supported
* Search engine **verification** supported (Google, Bind, Yandex and Baidu)
* **CDN** for third-party libraries supported
* Automatically converted images with **Lazy Load** by [lazysizes](https://github.com/aFarkas/lazysizes)

### Appearance and Layout

* **Responsive** layout
* **Light/Dark/Black** mode
* Globally consistent **design language**
* **Pagination** supported
* Easy-to-use and self-expanding **table of contents**
* **Multilanguage** supported and i18n ready
* Beautiful **CSS animation**
* Brand new **Page Layout** optimized for wide screens
* Compatibility for **PWA**

### Social and Comment Systems

* **Gravatar** supported by [Gravatar](https://gravatar.com)
* Local **Avatar** supported
* Up to **64** social links supported
* Up to **28** share sites supported
* **Disqus** comment system supported by [Disqus](https://disqus.com)
* **Gitalk** comment system supported by [Gitalk](https://github.com/gitalk/gitalk)
* **Valine** comment system supported by [Valine](https://valine.js.org/)
* **Waline** comment system supported by [Waline](https://waline.js.org/)
* **Facebook comments** system supported by [Facebook](https://developers.facebook.com/docs/plugins/comments/)
* **Telegram comments** system supported by [Telegram Comments](https://comments.app/)
* **Commento** comment system supported by [Commento](https://commento.io/)
* **Utterances** comment system supported by [Utterances](https://utteranc.es/)
* **Twikoo** comment system supported by [Twikoo](https://twikoo.js.org/)
* **Vssue** comment system supported by [Vssue](https://vssue.js.org/)
* **Remark42** comment system supported by[Remark42](https://remark42.com/)
* **giscus** comment system supported by [giscus](https://giscus.app/)

### Extended Features

* **Search** supported by [Lunr.js](https://lunrjs.com/) or [algolia](https://www.algolia.com/) or [Fuse.js](https://fusejs.io/)
* **Twemoji** supported
* Automatically **highlighting** code
* **Copy code** to clipboard with one click
* **Images gallery** supported by [lightgallery.js](https://github.com/sachinchoolur/lightgallery.js)
* Extended Markdown syntax for **[Font Awesome](https://fontawesome.com/) icons**
* Extended Markdown syntax for **ruby annotation**
* Extended Markdown syntax for **fraction**
* **Mathematical formula** supported by [KaTeX](https://katex.org/)
* **Diagrams** shortcode supported by [mermaid](https://github.com/knsv/mermaid)
* **Interactive data visualization** shortcode supported by [ECharts](https://echarts.apache.org/)
* **Mapbox** shortcode supported by [Mapbox GL JS](https://docs.mapbox.com/mapbox-gl-js)
* **Music player** shortcode supported by [APlayer](https://github.com/MoePlayer/APlayer) and [MetingJS](https://github.com/metowolf/MetingJS)
* **Bilibili player** shortcode
* Kinds of **admonitions** shortcode
* **Custom style** shortcode
* **Custom script** shortcode
* **Custom friend** shortcode
* **Animated typing** supported by [TypeIt](https://typeitjs.com/)
* **Dynamic scroll** supported by native CSS
* **Cookie consent banner** supported by [cookieconsen

## Multilingual and i18n

DoIt supports the following languages:

* English
* Simplified Chinese
* French
* Polish
* Brazilian Portuguese
* Italian
* Spanish
* German
* Serbian
* Russian
* Romanian
* Vietnamese