---
title: Hugo Serif
github: https://github.com/zerostaticthemes/hugo-serif-theme
demo: https://hugo-serif.netlify.app
author: Robert Austin
ssg:
  - Hugo
cms:
  - No Cms
date: 2020-10-12T00:00:00.000Z
description: >-
  Serif is a modern business theme for Hugo. It contains content types for the
  archetypical business website. The theme is fully responsive, blazing fast and
  artfully illustrated.
stale: false
---

# Deployment

## Stackbit

Use Stackbit to deploy this theme and connect any headless CMS _(Forestry, NetlifyCMS, Sanity, Contentful, DatoCMS)_ - It's actually really amazing. This theme contains a valid and tested `stackbit.yaml`

[![Create with Stackbit](https://assets.stackbit.com/badge/create-with-stackbit.svg)](https://app.stackbit.com/create?theme=https://github.com/zerostaticthemes/hugo-serif-theme)

## Netlify

Use Netlify to deploy this theme. This theme contains a valid and tested `netlify.toml` - Feel free to use the 1-click deploy below.

[![Deploy to Netlify](https://www.netlify.com/img/deploy/button.svg)](https://app.netlify.com/start/deploy?repository=https://github.com/zerostaticthemes/hugo-serif-theme)

## Theme features

- SCSS (Hugo Pipelines)
- Responsive design
- Bootstrap 4.4 grid and media queries only
- 100/100 Google Lighthouse speed score
- Under 50KB without images or 80KB with images and illustrations ⚡
- No jQuery, only a tiny bit of vanilla Javascript for the mobile menu.
- 100/100 Google Lighthouse SEO score
- Google analytics configured in `config.toml`
- Semantic HTML document structure
- Robust example content included
- Royalty free illustrations included
- No hardcoded content in the layouts
