---
title: Osprey Delight
github: https://github.com/kdevo/osprey-delight
demo: https://hugo-mods.github.io/
author: kdevo
date: 2022-05-01T00:00:00.000Z
ssg:
  - Hugo
cms:
  - No CMS
css:
  - SCSS
archetype:
  - Single-Page
  - Portfolio
  - Blog
description: >-
  Modular and fast theme perfectly suited for showing your work. Built with
  hugo-mods.
stale: false
---

[![Osprey Delight Logo](https://raw.githubusercontent.com/kdevo/osprey-delight/master/images/osprey-delight-logo.png)](https://github.com/kdevo/osprey-delight)

[![GitHub Release](https://img.shields.io/github/v/release/kdevo/osprey-delight?style=flat-square&color=%230097a7&logo=github)](https://github.com/kdevo/osprey-delight/releases/latest)
[![Discussions](https://img.shields.io/badge/GitHub-Discussions-%230097a7?logo=github&style=flat-square)](https://github.com/kdevo/osprey-delight/discussions)
[![Hugo Minimum Version](https://img.shields.io/badge/hugo-%3E=v0.83-%230097a7?logo=hugo&style=flat-square)](https://github.com/gohugoio/hugo/releases)
[![Built with hugo-mods](https://img.shields.io/static/v1?label=%E2%9D%A4&message=hugo-mods&color=0097a7&style=flat-square)](https://github.com/hugo-mods)

Osprey Delight is the free-minded artist's choice for a clutter-free and blazingly fast single-page portfolio. It's perfectly suited to show off your awesome work! 

This theme is built around the modules shown on the demo site [Hugo Mods](https://hugo-mods.github.io/), making it highly customizable. 
If you are only interested in a subset of the functionality, take a look at the existing modules [in the `hugo-mods` GitHub organization](https://github.com/hugo-mods).

> Originating from [the great Osprey theme](https://github.com/tomanistor/osprey), it brings new features to your **delight** while keeping the original design idea.

### Features

- Modular and made out of extensible section building blocks:
  - About: Introduce yourself
  - Gallery: Show your work using a grid-based gallery with interactive modal boxes
  - Blog: Lightweight blog features
  - Contact: Contact form with Basin support and built-in spambot protection
- Use your high-quality images [assets](https://gohugo.io/categories/asset-management):
    - Lazy image loading plus completely automatic resizing using [lazyimg](https://github.com/hugo-mods/lazyimg) module
    - Blur-up technique using automatic low-quality image placeholders (LQIP)
    - Modern WebP support with fallback for older browsers
- SEO:
  - Score 100 at PageSpeed Insights ([example](https://pagespeed.web.dev/report?url=https%3A%2F%2Fkdevo.github.io%2F))
  - Auto-generated structured ensures that everyone finds you
- Delightful UX:
    - Choose between different themes
    - Awesome social icons in footer via [icons module](https://github.com/hugo-mods/icons)
    - Smooth scrolling plus scroll-spy
    - Fetches GitHub repo data if wanted
    - Sane fallbacks for No-Script/No-JS users
- Highly [customizable](https://github.com/kdevo/osprey-delight/blob/master/CUSTOMIZING.md)


### [Get started!](https://github.com/kdevo/osprey-delight#quickstart)
