---
title: Bootstrap Theme
github: https://github.com/razonyang/hugo-theme-bootstrap
demo: https://hbs.razonyang.com/
author: razonyang
date: 2021-07-26T00:00:00.000Z
ssg:
  - Hugo
css:
  - Bootstrap
cms:
  - No CMS
archetype:
  - Blog
description: An extreme fast, responsive and feature-rich blog theme for Hugo.
stale: false
---

[English](https://github.com/razonyang/hugo-theme-bootstrap/blob/master/README.md) · 
[简体中文](https://github.com/razonyang/hugo-theme-bootstrap/blob/master/README.zh-CN.md) · 
[繁體中文](https://github.com/razonyang/hugo-theme-bootstrap/blob/master/README.zh-TW.md)

## Screenshots

![Screenshot](https://raw.githubusercontent.com/razonyang/hugo-theme-bootstrap/master/images/screenshot.png)

**Dark Mode**

![Screenshot in Dark Mode](https://raw.githubusercontent.com/razonyang/hugo-theme-bootstrap/master/images/screenshot-dark.png)

## Live Preview

- https://hugo-theme-bootstrap.netlify.app/ - Deploy on Netlify.
- https://hugo-theme-bootstrap.razonyang.com/ - A self-hosted server located in Asia.

There is also a [list of websites that use this theme](https://github.com/razonyang/hugo-theme-bootstrap/blob/master/USERS.md).

## Features

- Extreme Fast: [Google PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights/?url=https://hugo-theme-bootstrap.netlify.app/en/)'s score `95-100`.
- Built on top of [Bootstrap 5](https://getbootstrap.com/).
- Responsive.
- Various Palettes: `blue`, `blue-gray`, `brown`, `cyan`, `green`, `indigo`, `orange`, `pink`, `purple`, `red`, `teal`, `yellow`.
- [Highly Configurable](#configuration).
- Dark Mode Switcher.
- Font Size Switcher.
- Multilingual(I18N).
- Search.
- Breadcrumb.
- Archive.
- [Syntax Highlighting](#syntax-highlighting)
- Resources Lazy Loading: `image` and `iframe`.
- Reward Widget: supports Alipay and Wechat.
- Table of Contents.
- Share Buttons: supports [AddThis](https://www.addthis.com).
- [Comments](#comments): supports [Disqus](#disqus) and [Utterances](#utterances).
- [Custom Assets](#custom-assets): custom CSS and JS.
- [Hooks](#hooks): provides ability to add custom code in page, such as `head`, `body`, `sidebar` etc.
- [Social Links](#social-links).
- [Various Shortcodes](#shortcodes).
- [Twitter Cards](https://gohugo.io/templates/internal/#configure-twitter-cards) and [Open Graph](https://gohugo.io/templates/internal/#configure-open-graph).
- [Creative Commons License](https://creativecommons.org/licenses/)
