---
title: Gatsby Netlify CMS Modern blog web-app
github: https://github.com/simarmannsingh/gatsby-netlifycms-starter-template
demo: https://gatsby-netlifycms-modern-template.netlify.app/
author: Simar Mann Singh
date: 2021-07-03T00:00:00.000Z
ssg:
  - Gatsby
cms:
  - NetlifyCMS
css:
  - Bulma
archetype:
  - Blog
description: >-
  This public repo is an example blog web-app that is built with Gatsby using
  Netlify CMS. It follows the JAMstack architecture by using Git as a single
  source of truth, and Netlify for continuous deployment, and CDN distribution.
stale: false
---

# Gatsby Netlify-CMS Modern blog

A fully-responsive [Gatsby](https://www.gatsbyjs.org/) based template web-app which can be easily hosted on any platform. This web-app uses the [Netlify CMS](https://www.netlifycms.org) as its content management system.

**Note:** This starter template is a customized version of the original template by Netlify that can be found on [Netlify CMS](https://www.netlifycms.org/) website and uses [Gatsby v2](https://www.gatsbyjs.org/blog/2018-09-17-gatsby-v2/).

## Features

- A simple landing page with a customized blog functionality built with Netlify CMS
- Editable Pages: About, Blog-Collection and Contact page with Netlify Form support
- Create Blog posts from Netlify CMS
- Tags support: Separate page for posts under each tag
- Basic directory organization
- Uses Bulma for styling, but size is reduced by `purge-css-plugin`
- Blazing fast loading times thanks to pre-rendered HTML and automatic chunk loading of JS files
- Uses `gatsby-image` with Netlify-CMS preview support
- Separate components for everything
- Netlify deploy configuration
- Netlify function support, see `lambda` folder
- Perfect score on Lighthouse for SEO, Accessibility and Performance (wip:PWA)
- ..and more

## License

This repository has MIT license which can be found [here](https://github.com/simarmannsingh/gatsby-netlifycms-starter-template/blob/master/LICENSE).
