---
title: Material Starter
github: https://github.com/Vagr9K/gatsby-material-starter
demo: https://gatsby-theme-material.netlify.app/
author: vagr9k
date: 2021-12-31T00:00:00.000Z
ssg:
  - Gatsby
cms:
  - No CMS
description: >-
  A Material Design oriented blog starter for GatsbyJS equipped with advanced
  features such as SEO, image optimization, PWA capabilities and infinite
  scrolling feeds.
stale: false
---

# A starter skeleton with Material Design in mind

This starter aims to provide a minimal base for building advanced GatsbyJS powered websites by using the latest technologies to simplify your process.

Starter supports both [TypeScript](https://www.typescriptlang.org/) and JavaScript, comes with [Jest](https://jestjs.io/) and [Cypress](https://www.cypress.io/) configurations and allows you to write Unit/Integration/E2E tests out of the box.

## Demo

[Material Demo](https://gatsby-theme-material.netlify.app/).

## Features

- Gatsby v3 support
- First class [TypeScript](https://www.typescriptlang.org/) support (for query data and components exposed by the theme)
- [Material UI V5](https://material-ui.com/) components
- [Emotion](https://emotion.sh/docs/introduction) used for styling
- Posts in MDX
  - Code syntax highlighting
  - Embed videos
  - Embed iframes
- Infinite Scrolling
- React Query for client side API calls
- Tags
  - Separate page for posts under each tag
- Categories
  - Separate page for posts under each category
- Social features
  - Twitter tweet button
  - Facebook share/share count
  - Reddit share/share count
  - LinkedIn share button
- Author section
- Related posts computation and display based on category/tag match ranking
- [Disqus](https://disqus.com/) support via [`gatsby-theme-advanced`](https://www.npmjs.com/package/gatsby-theme-advanced)
- [gatsby-plugin-image](https://www.gatsbyjs.com/plugins/gatsby-plugin-image/) for optimized image generation
- Inline SVG imports
- High configurability
- Separate components for everything:
  - Gatsby Link utilities
  - SEO
  - Disqus
- PWA features
  - Offline support
  - Web App Manifest support
  - Loading progress for slow networks
- SEO
  - [Google gtag.js](https://developers.google.com/gtagjs/) support
  - Sitemap generation
  - General description tags
  - [Google Structured Data](https://developers.google.com/search/docs/advanced/structured-data/intro-structured-data)
  - [OpenGraph Tags (Facebook/Google+/Pinterest)](https://ogp.me/)
  - [Twitter Tags (Twitter Cards)](https://developer.twitter.com/en/docs/tweets/optimize-with-cards/overview/markup)
- RSS feeds
- Development tools
  - Yarn 3
  - [Jest](https://jestjs.io/) for unit/integration testing
  - [Cypress](https://www.cypress.io/) for E2E testing
  - CI via GitHub Actions
  - CD via GitHub Actions
  - [ESLint](https://eslint.org/) for linting
  - [Prettier](https://prettier.io/) for code formatting
  - [React Hooks Linting](https://www.npmjs.com/package/eslint-plugin-react-hooks)
  - Remark-Lint for linting Markdown
  - write-good for linting English prose
  - gh-pages for deploying to GitHub pages
  - [Netlify](https://www.netlify.com/) deploy configuration
