---
title: Eleventy Starter Boilerplate
github: https://github.com/ixartz/Eleventy-Starter-Boilerplate
demo: >-
  https://creativedesignsguru.com/demo/Eleventy-Starter-Boilerplate/eleventy-starter-boilerplate-presentation/
author: Ixartz
ssg:
  - Eleventy
cms:
  - No Cms
css:
  - Tailwind
date: 2020-06-21T14:48:50.000Z
description: >-
  🚀 Eleventy Starter Boilerplate is production-ready with SEO-friendly for
  quickly starting a blog.
stale: true
---

# Eleventy Starter Boilerplate

🚀 Eleventy Starter Boilerplate is production-ready with SEO-friendly for quickly starting a blog. ⚡️ Built with [Eleventy](https://www.11ty.dev), [ESLint](https://eslint.org), [Prettier](https://prettier.io), [Webpack](https://webpack.js.org), [PostCSS](https://postcss.org), [Tailwind CSS](https://tailwindcss.com).

## Features

Production-ready in mind:

- 🔥 [11ty](https://www.11ty.dev) for Static Site Generator
- 🎨 Integrate with [Tailwind CSS](https://tailwindcss.com) (with [PurgeCSS](https://purgecss.com), remove unused CSS)
- 💅 [PostCSS](https://postcss.org) for processing [Tailwind CSS](https://tailwindcss.com)
- ⚡️ Lazy load images with [lazysizes](https://github.com/aFarkas/lazysizes)
- ✨ Compress image with [Imagemin](https://github.com/imagemin/imagemin)
- 🎈 Syntax Highlighting with [Prism.js](https://prismjs.com)
- ☕ Minify HTML & CSS with [HTMLMinifier](https://www.npmjs.com/package/html-minifier) and [cssnano](https://cssnano.co)
- ✏️ Linter with [ESLint](https://eslint.org)
- 🛠 Code Formatter with [Prettier](https://prettier.io)
- 💨 Live reload
- 📦 Module Bundler with [Webpack](https://webpack.js.org)
- 🦊 Templating with [EJS](https://ejs.co)
- 🤖 SEO metadata and [Open Graph](https://ogp.me/) tags
- ⚙️ [JSON-LD](https://developers.google.com/search/docs/guides/intro-structured-data) for richer indexing
- 🗺 Sitemap.xml
- ⚠️ 404 page
- 📖 Pagination
- ✅ Cache busting
- 💯 Maximize lighthouse score

## Philosophy

- Minimal code (HTML, CSS & JS). Add what you need
- SEO-friendly
- 🚀 Production-ready
