# Jamstack.club?

[Jamstack.club](https://jamstack.club) is a collection of free Jamstack themes for Hugo, Eleventy, Jekyll, Gatsby and [many other static-sites generators](https://jamstack.club/ssg).  
Filter, sort, preview, and find the best Jamstack theme for your next project!

[![Screenshot of the homepage of jamstack club](https://raw.githubusercontent.com/RoneoOrg/jamstack.club/main/static/images/cards/overview-second-md.jpg)](https://jamstack.club)

## Contribute

Willing to help? Welcome aboard!

**There are many ways you can contribute**, and **we value each contribution**.  
If you wish, we can acknowledge you using the [@allcontributors principles](https://github.com/all-contributors/all-contributors#readme).

### Report a problem

Found an issue? You can [submit a report](https://github.com/RoneoOrg/jamstack.club/issues), or [drop us an email](https://jamstack.club/contact/).

We'll get back to you as soon as possible.

### Submit a new theme

There are only two requirements for submitting a theme:

* The source code must be open-source and public
* The demo URL links must point to a demo of the theme and not a personal/business site.

Ready? Let's go!

1. Open [this template file](https://github.com/RoneoOrg/jamstack.club/edit/main/archetypes/theme-template.md) and confirm the creation of a fork.  
(See [the Github documentation](https://docs.github.com/en/repositories/working-with-files/managing-files/editing-files#editing-files-in-another-users-repository) for details, and reach out if you're stuck somewhere!)
2. Edit the file and click on "Propose changes" at the bottom.
3. Submit the Pull Request.
4. You're done!

Yes, the screenshot and the demo page; the Github stars — everything is generated automatically!

### Suggest an improvement

Missing something? A new feature in mind?  
We are open to your suggestions. [Leave us a message](https://jamstack.club/contact/) or [open a ticket](https://github.com/RoneoOrg/jamstack.club/issues) and we'll check it out.

### Work on the code

See [docs/CONTRIBUTING.md](docs/CONTRIBUTING.md)

## How does it work?

Each theme is described in a Markdown file. (See [this example](https://raw.githubusercontent.com/RoneoOrg/jamstack.club/main/content/theme/hugo-restaurant.md) to get an idea).

The website is then built with [Hugo](https://gohugo.io) along with [a few JS scripts](https://github.com/RoneoOrg/jamstack.club/tree/main/scripts) to automate the creation of the Github stats and generate the screenshots.

A [dedicated page](https://jamstack.club/theme/hugo-restaurant/) is created for each theme, as well as [a theme demo website](https://jamstack.club/demo/theme/hugo-restaurant/), showcasing the demo URL filled out in the Markdown file.

The index is updated, still automatically, and the website is published. Hosted by [Netlify](https://www.netlify.com/) with a landing at [Jamstack.club](https://jamstack.club).

## What's coming up?

Check out [our roadmap](https://gitlab.com/Roneo/jamstack.club/-/boards/3757613) to see where we are heading to:

[![The roadmap of jamstack club](https://raw.githubusercontent.com/RoneoOrg/jamstack.club/main/static/images/roadmap.jpg)](https://gitlab.com/Roneo/jamstack.club/-/boards/3757613)

## Acknowledgements

See the [About page](https://jamstack.club/about/) for updated acknowledgements and shout-outs!
