unit DelphiAST.Consts;

interface

type
  TSyntaxNodeType = (
    ntUnknown,
    ntAbsolute,
    ntAdd,
    ntAddr,
    ntAlignmentParam,
    ntAnd,
    ntAnonymousMethod,
    ntArguments,
    ntAs,
    ntAssign,
    ntAt,
    ntAttribute,
    ntAttributes,
    ntBounds,
    ntCall,
    ntCase,
    ntCaseElse,
    ntCaseLabel,
    ntCaseLabels,
    ntCaseSelector,
    ntClassConstraint,
    ntConstant,
    ntConstants,
    ntConstraints,
    ntConstructorConstraint,
    ntContains,
    ntDefault,
    ntDeref,
    ntDimension,
    ntDiv,
    ntDot,
    ntDownTo,
    ntElement,
    ntElse,
    ntEmptyStatement,
    ntEnum,
    ntEqual,
    ntExcept,
    ntExceptionHandler,
    ntExports,
    ntExpression,
    ntExpressions,
    ntExternal,
    ntFDiv,
    ntField,
    ntFields,
    ntFinalization,
    ntFinally,
    ntFor,
    ntFrom,
    ntGeneric,
    ntGoto,
    ntGreater,
    ntGreaterEqual,
    ntGuid,
    ntHelper,
    ntIdentifier,
    ntIf,
    ntImplementation,
    ntImplements,
    ntIn,
    ntIndex,
    ntIndexed,
    ntInherited,
    ntInitialization,
    ntInterface,
    ntIs,
    ntLabel,
    ntLHS,
    ntLiteral,
    ntLower,
    ntLowerEqual,
    ntMessage,
    ntMethod,
    ntMod,
    ntMul,
    ntName,
    ntNamedArgument,
    ntNotEqual,
    ntNot,
    ntOr,
    ntPackage,
    ntParameter,
    ntParameters,
    ntPath,
    ntPositionalArgument,
    ntProtected,
    ntPrivate,
    ntProperty,
    ntPublic,
    ntPublished,
    ntRaise,
    ntRead,
    ntRecordConstraint,
    ntRepeat,
    ntRequires,
    ntResolutionClause,
    ntResourceString,
    ntReturnType,
    ntRHS,
    ntRoundClose,
    ntRoundOpen,
    ntSet,
    ntShl,
    ntShr,
    ntStatement,
    ntStatements,
    ntStrictPrivate,
    ntStrictProtected,
    ntSub,
    ntSubrange,
    ntThen,
    ntTo,
    ntTry,
    ntType,
    ntTypeArgs,
    ntTypeDecl,
    ntTypeParam,
    ntTypeParams,
    ntTypeSection,
    ntValue,
    ntVariable,
    ntVariables,
    ntXor,
    ntUnaryMinus,
    ntUnit,
    ntUses,
    ntWhile,
    ntWith,
    ntWrite,

    ntAnsiComment,
    ntBorComment,
    ntSlashesComment
  );

  TAttributeName = (
    anType,
    anClass,
    anForwarded,
    anKind,
    anName,
    anVisibility,
    anCallingConvention,
    anPath,
    anMethodBinding,
    anReintroduce,
    anOverload,
    anAbstract,
    anInline,
    anAlign
  );

const
  SyntaxNodeNames: array [TSyntaxNodeType] of string = (
    'unknown',
    'absolute',
    'add',
    'addr',
    'alignmentparam',
    'and',
    'anonymousmethod',
    'arguments',
    'as',
    'assign',
    'at',
    'attribute',
    'attributes',
    'bounds',
    'call',
    'case',
    'caseelse',
    'caselabel',
    'caselabels',
    'caseselector',
    'classconstraint',
    'constant',
    'constants',
    'constraints',
    'constructorconstraint',
    'contains',
    'default',
    'deref',
    'dimension',
    'div',
    'dot',
    'downto',
    'element',
    'else',
    'emptystatement',
    'enum',
    'equal',
    'except',
    'exceptionhandler',
    'exports',
    'expression',
    'expressions',
    'external',
    'fdiv',
    'field',
    'fields',
    'finalization',
    'finally',
    'for',
    'from',
    'generic',
    'goto',
    'greater',
    'greaterequal',
    'guid',
    'helper',
    'identifier',
    'if',
    'implementation',
    'implements',
    'in',
    'index',
    'indexed',
    'inherited',
    'initialization',
    'interface',
    'is',
    'label',
    'lhs',
    'literal',
    'lower',
    'lowerequal',
    'message',
    'method',
    'mod',
    'mul',
    'name',
    'namedargument',
    'notequal',
    'not',
    'or',
    'package',
    'parameter',
    'parameters',
    'path',
    'positionalargument',
    'protected',
    'private',
    'property',
    'public',
    'published',
    'raise',
    'read',
    'recordconstraint',
    'repeat',
    'requires',
    'resolutionclause',
    'resourcestring',
    'returntype',
    'rhs',
    'roundclose',
    'roundopen',
    'set',
    'shl',
    'shr',
    'statement',
    'statements',
    'strictprivate', 
    'strictprotected',
    'sub',
    'subrange',
    'then',
    'to',
    'try',
    'type',
    'typeargs',
    'typedecl',
    'typeparam',
    'typeparams',
    'typesection',
    'value',
    'variable',
    'variables',
    'xor',
    'unaryminus',
    'unit',
    'uses',
    'while',
    'with',
    'write',

    'ansicomment',
    'borlandcomment',
    'slashescomment'
  );

  AttributeNameStrings: array[TAttributeName] of string = (
    'type',
    'class',
    'forwarded',
    'kind',
    'name',
    'visibility',
    'callingconvention',
    'path',
    'methodbinding',
    'reintroduce',
    'overload',
    'abstract',
    'inline',
    'align'
  );

implementation

end.
