/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SoftHashMap
extends AbstractMap {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_LIMIT = 1;
    private final Map map = new HashMap();
    private final int max_limit;
    private final LinkedList hardCache = new LinkedList();
    private final ReferenceQueue queue = new ReferenceQueue();

    public SoftHashMap() {
        this(1000);
    }

    public SoftHashMap(int hardSize) {
        this.max_limit = hardSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object result;
        block8: {
            result = null;
            SoftReference soft_ref = (SoftReference)this.map.get(key);
            if (soft_ref != null) {
                try {
                    result = soft_ref.get();
                    if (result == null) {
                        this.map.remove(key);
                        break block8;
                    }
                    LinkedList linkedList = this.hardCache;
                    synchronized (linkedList) {
                        this.hardCache.addFirst(result);
                        if (this.hardCache.size() > this.max_limit) {
                            this.hardCache.removeLast();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private void clearGCCollected() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
        }
    }

    public synchronized Object put(Object key, Object value) {
        this.clearGCCollected();
        return this.map.put(key, new SoftValue(value, key, this.queue));
    }

    public Object remove(Object key) {
        this.clearGCCollected();
        return this.map.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.hardCache;
        synchronized (linkedList) {
            this.hardCache.clear();
        }
        this.clearGCCollected();
        this.map.clear();
    }

    public int size() {
        this.clearGCCollected();
        return this.map.size();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object k, Object key, ReferenceQueue q) {
            super(k, q);
            this.key = key;
        }
    }
}

