/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.TranslationTable;

abstract class AbstractTranslationTable
implements TranslationTable {
    AbstractTranslationTable() {
    }

    public abstract Alphabet getSourceAlphabet();

    public abstract Alphabet getTargetAlphabet();

    protected abstract Symbol doTranslate(Symbol var1) throws IllegalSymbolException;

    public Symbol translate(Symbol sym) throws IllegalSymbolException {
        Symbol s = this.doTranslate(sym);
        if (s == null) {
            if (sym instanceof AtomicSymbol) {
                this.getSourceAlphabet().validate(sym);
                throw new IllegalSymbolException("Unable to map " + sym.getName());
            }
            if (sym == null) {
                throw new NullPointerException("Can't translate null");
            }
            HashSet<Symbol> syms = new HashSet<Symbol>();
            Iterator<Symbol> i = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (i.hasNext()) {
                Symbol is = i.next();
                syms.add(this.translate(is));
            }
            s = this.getTargetAlphabet().getAmbiguity(syms);
        }
        return s;
    }
}

