/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.Unchangeable;

public abstract class WordTokenization
extends Unchangeable
implements SymbolTokenization,
Serializable {
    private Alphabet alphabet;

    public WordTokenization(Alphabet fab) {
        this.alphabet = fab;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolTokenization.TokenType getTokenType() {
        return SEPARATED;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public String tokenizeSymbolList(SymbolList sl) throws IllegalSymbolException, IllegalAlphabetException {
        if (sl.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Symbol> i = sl.iterator();
        while (i.hasNext()) {
            Symbol sym = i.next();
            sb.append(this.tokenizeSymbol(sym));
            if (!i.hasNext()) continue;
            sb.append(' ');
        }
        return sb.substring(0);
    }

    public StreamParser parseStream(SeqIOListener siol) {
        return new WordStreamParser(siol);
    }

    protected List splitString(String str) throws IllegalSymbolException {
        int ptr = 0;
        ArrayList<String> sl = new ArrayList<String>();
        while (ptr < str.length()) {
            char nc;
            int nextPtr;
            char c = str.charAt(ptr);
            if (Character.isWhitespace(c)) {
                ++ptr;
                continue;
            }
            if (c == '(') {
                nextPtr = this.findMatch(str, ptr, '(', ')');
                sl.add(str.substring(ptr, nextPtr));
                ptr = nextPtr;
                continue;
            }
            if (c == '[') {
                nextPtr = this.findMatch(str, ptr, '[', ']');
                sl.add(str.substring(ptr, nextPtr));
                ptr = nextPtr;
                continue;
            }
            nextPtr = ptr;
            boolean quoted = false;
            do {
                if ((nc = ++nextPtr == str.length() ? (char)' ' : (char)str.charAt(nextPtr)) != 34) continue;
                boolean bl = quoted = !quoted;
            } while (!Character.isWhitespace(nc));
            sl.add(str.substring(ptr, nextPtr));
            ptr = nextPtr;
        }
        return sl;
    }

    protected Symbol[] parseString(String s) throws IllegalSymbolException {
        List split = this.splitString(s);
        Symbol[] syms = new Symbol[split.size()];
        for (int i = 0; i < split.size(); ++i) {
            syms[i] = this.parseToken((String)split.get(i));
        }
        return syms;
    }

    private int findMatch(String str, int ptr, char openChar, char closeChar) {
        int level = 0;
        do {
            char c;
            if ((c = str.charAt(ptr++)) == openChar) {
                ++level;
                continue;
            }
            if (c != closeChar) continue;
            --level;
        } while (level > 0);
        return ptr;
    }

    private class WordStreamParser
    implements StreamParser {
        SeqIOListener listener;
        StringBuffer sb = new StringBuffer();

        WordStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) {
            this.sb.append(data, start, len);
        }

        public void close() throws IllegalSymbolException {
            String str = this.sb.substring(0);
            Symbol[] syms = WordTokenization.this.parseString(str);
            try {
                this.listener.addSymbols(WordTokenization.this.alphabet, syms, 0, syms.length);
            }
            catch (IllegalAlphabetException ex) {
                throw new IllegalSymbolException("Mismatched alphabets");
            }
        }
    }
}

