/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim.trimmomatic;

import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trim.QualityTrimmer;

public class SlidingWindowQualityTrimmer
implements QualityTrimmer {
    private final int windowSize;
    private final double requiredQuality;
    private static Range EMPTY = Range.ofLength(0L);

    public SlidingWindowQualityTrimmer(int windowSize, PhredQuality requiredQuality) {
        Objects.requireNonNull(requiredQuality);
        if (windowSize < 1) {
            throw new IllegalArgumentException("window size must be >= 1");
        }
        this.windowSize = windowSize;
        this.requiredQuality = requiredQuality.getQualityScore();
    }

    @Override
    public Range trim(QualitySequence qualities) {
        byte[] quals = qualities.toArray();
        if (quals.length < this.windowSize) {
            return EMPTY;
        }
        return this.trim(quals);
    }

    @Override
    public Range trim(QualitySequenceBuilder builder) {
        byte[] quals = builder.toArray();
        if (quals.length < this.windowSize) {
            return EMPTY;
        }
        return this.trim(quals);
    }

    @Override
    private Range trim(byte[] quals) {
        double avgQual;
        for (int currentWindowStart = 0; currentWindowStart < quals.length && !((avgQual = this.computeAvgQualFor(quals, currentWindowStart)) < this.requiredQuality); ++currentWindowStart) {
        }
        for (int i = Math.min(quals.length - 1, --currentWindowStart + this.windowSize - 1); i >= 0; --i) {
            if (!((double)quals[i] >= this.requiredQuality)) continue;
            return Range.ofLength(i + 1);
        }
        return EMPTY;
    }

    private double computeAvgQualFor(byte[] quals, int currentWindowStart) {
        long total = 0L;
        int end = Math.min(currentWindowStart + this.windowSize, quals.length);
        for (int i = currentWindowStart; i < end; ++i) {
            total += (long)quals[i];
        }
        return (double)total / (double)(end - currentWindowStart);
    }
}

