/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim.trimmomatic;

import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trim.QualityTrimmer;

public class MaxInfoTrimmer
implements QualityTrimmer {
    private static int MAX_READ_LENGTH = 1000;
    private final long[] qualLookup;
    private final long[] factorLookup;

    public MaxInfoTrimmer(int targetLength, double strictness) {
        if (targetLength < 1) {
            throw new IllegalArgumentException("target length must be >=1");
        }
        if (strictness < 0.0 || strictness > 1.0) {
            throw new IllegalArgumentException("strictness must be between 0 and 1");
        }
        double[] qualLookup = new double[128];
        for (int i = 0; i < qualLookup.length; ++i) {
            qualLookup[i] = Math.log(1.0 - Math.pow(0.1, (0.5 + (double)i) / 10.0)) * strictness;
        }
        double[] factorLookup = new double[MAX_READ_LENGTH];
        double leniency = 1.0 - strictness;
        for (int i = 0; i < MAX_READ_LENGTH; ++i) {
            factorLookup[i] = Math.log(1.0 / (1.0 + Math.exp(targetLength - i - 1))) + Math.log(i + 1) * leniency;
        }
        double ratio = Math.max(MaxInfoTrimmer.calcNormalizationRatio(qualLookup, MAX_READ_LENGTH * 2), MaxInfoTrimmer.calcNormalizationRatio(factorLookup, MAX_READ_LENGTH * 2));
        this.qualLookup = MaxInfoTrimmer.normalize(qualLookup, ratio);
        this.factorLookup = MaxInfoTrimmer.normalize(factorLookup, ratio);
    }

    private static double calcNormalizationRatio(double[] array, int margin) {
        double maxVal = array[0];
        for (int i = 1; i < array.length; ++i) {
            double val = Math.abs(array[i]);
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        return 9.223372036854776E18 / (maxVal * (double)margin);
    }

    private static long[] normalize(double[] array, double ratio) {
        long[] out = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = (long)(array[i] * ratio);
        }
        return out;
    }

    @Override
    public Range trim(QualitySequence qualities) {
        return this.trim(qualities.toArray());
    }

    @Override
    public Range trim(QualitySequenceBuilder builder) {
        return this.trim(builder.toArray());
    }

    @Override
    private Range trim(byte[] quals) {
        int bestOffset = -1;
        double maxScore = -1.7976931348623157E308;
        long acumulativeQual = 0L;
        for (int i = 0; i < quals.length; ++i) {
            long score = (acumulativeQual += this.qualLookup[quals[i]]) + this.factorLookup[i];
            if (!((double)score >= maxScore)) continue;
            maxScore = score;
            bestOffset = i;
        }
        if (bestOffset < 0 || maxScore == 0.0) {
            return Range.ofLength(0L);
        }
        return Range.ofLength(bestOffset + 1);
    }
}

