/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim.trimmomatic;

import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trim.QualityTrimmer;

abstract class AbstractEdgeQualityTrimmer
implements QualityTrimmer {
    private final byte threshold;
    private final boolean trimFromLeading;
    private static final Range EMPTY = Range.ofLength(0L);

    public AbstractEdgeQualityTrimmer(PhredQuality threshold, boolean trimFromLeading) {
        Objects.requireNonNull(threshold);
        this.threshold = threshold.getQualityScore();
        this.trimFromLeading = trimFromLeading;
    }

    @Override
    public Range trim(QualitySequenceBuilder builder) {
        return this.trim(builder.toArray());
    }

    @Override
    public Range trim(QualitySequence qualities) {
        return this.trim(qualities.toArray());
    }

    @Override
    private Range trim(byte[] quals) {
        if (this.trimFromLeading) {
            for (int i = 0; i < quals.length; ++i) {
                if (this.threshold > quals[i]) continue;
                return Range.of(i, (long)(quals.length - 1));
            }
        } else {
            for (int i = quals.length - 1; i >= 0; --i) {
                if (this.threshold > quals[i]) continue;
                return Range.ofLength(i + 1);
            }
        }
        return EMPTY;
    }
}

