/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim.lucy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrices;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.align.pairwise.NucleotidePairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.PairwiseAlignmentBuilder;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.trim.NucleotideTrimmer;

public class LucyVectorSpliceTrimmerBuilder
implements Builder<NucleotideTrimmer> {
    private static final AdaptiveSearchArea DEFAULT_SEARCH_AREA = new AdaptiveSearchAreaBuilder().addAreaRange(40L, 8).addAreaRange(60L, 12).addAreaRange(100L, 16).build();
    private static final int DEFAULT_GAP_OPEN = -17;
    private static final int DEFAULT_GAP_EXTENSION = -5;
    private static final NucleotideSubstitutionMatrix DEFAULT_MATRIX;
    private final NucleotideSequence upstreamSpliceSeq;
    private final NucleotideSequence downstreamSpliceSeq;
    private NucleotideSubstitutionMatrix matrix = DEFAULT_MATRIX;
    private int gapOpen = -17;
    private int gapExtension = -5;
    private boolean checkBothDirections = true;
    private AdaptiveSearchArea adaptiveSearchArea = DEFAULT_SEARCH_AREA;

    public LucyVectorSpliceTrimmerBuilder(NucleotideSequence upstreamSpliceSeq, NucleotideSequence downstreamSpliceSeq) {
        Objects.requireNonNull(upstreamSpliceSeq);
        Objects.requireNonNull(downstreamSpliceSeq);
        this.upstreamSpliceSeq = upstreamSpliceSeq;
        this.downstreamSpliceSeq = downstreamSpliceSeq;
    }

    public LucyVectorSpliceTrimmerBuilder onlyCheckForwardDirection() {
        this.checkBothDirections = false;
        return this;
    }

    @Override
    public NucleotideTrimmer build() {
        return new LucyLikeVectorSpliceTrimmer(this);
    }

    public LucyVectorSpliceTrimmerBuilder alignmentMatrix(NucleotideSubstitutionMatrix matrix, int gapOpen, int gapExtension) {
        Objects.requireNonNull(matrix);
        this.gapOpen = gapOpen;
        this.gapExtension = gapExtension;
        return this;
    }

    public LucyVectorSpliceTrimmerBuilder adaptiveSearchArea(AdaptiveSearchArea adaptiveSearchArea) {
        Objects.requireNonNull(adaptiveSearchArea);
        this.adaptiveSearchArea = adaptiveSearchArea;
        return this;
    }

    static {
        try {
            DEFAULT_MATRIX = NucleotideSubstitutionMatrices.parsePropertyFile(LucyVectorSpliceTrimmerBuilder.class.getResourceAsStream("lucy.matrix"));
        }
        catch (IOException e) {
            throw new IllegalStateException("error parsing lucy subsitution matrix file", e);
        }
    }

    public static final class AdaptiveSearchAreaBuilder
    implements Builder<AdaptiveSearchArea> {
        private final List<SearchArea> areas = new ArrayList<SearchArea>();
        private long currentOffset = 0L;

        public AdaptiveSearchAreaBuilder addAreaRange(long areaLength, int minimumMatchLength) {
            if (areaLength < 1L) {
                throw new IllegalArgumentException("area length can not be < 1");
            }
            if (minimumMatchLength < 1) {
                throw new IllegalArgumentException("min match length can not be < 1");
            }
            Range range = new Range.Builder(areaLength).shift(this.currentOffset).build();
            this.currentOffset += areaLength;
            this.areas.add(new SearchArea(range, minimumMatchLength));
            return this;
        }

        @Override
        public AdaptiveSearchArea build() {
            return new AdaptiveSearchArea(this);
        }
    }

    public static final class AdaptiveSearchArea {
        private static final double MIN_DOWNSTREAM_PERCENT_IDENT = 0.75;
        private final List<SearchArea> areas;
        private final Range areaRange;

        private AdaptiveSearchArea(AdaptiveSearchAreaBuilder builder) {
            this.areas = new ArrayList<SearchArea>(builder.areas);
            Collections.reverse(this.areas);
            this.areaRange = Range.ofLength(builder.currentOffset);
            if (this.areas.isEmpty()) {
                throw new IllegalStateException("must have at least one search area");
            }
        }

        boolean meetsDownstreamMatchingCriteria(Range downstreamSubjectRange, double percentIdentity) {
            if (percentIdentity < 0.75) {
                return false;
            }
            SearchArea area = this.areas.get(0);
            return downstreamSubjectRange.getLength() >= (long)area.minAlignmentLength;
        }

        Range getSearchAreaRange() {
            return this.areaRange;
        }

        boolean meetsUpstreamMatchingCriteria(Range alignmentRange) {
            long alignmentLength = alignmentRange.getLength();
            for (SearchArea area : this.areas) {
                if (!area.range.intersects(alignmentRange) || alignmentLength < (long)area.minAlignmentLength) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SearchArea {
        private final Range range;
        private final int minAlignmentLength;

        public SearchArea(Range range, int minAlignmentLength) {
            Objects.requireNonNull(range);
            if (minAlignmentLength < 1) {
                throw new IllegalStateException("min alignment length can not be null");
            }
            this.range = range;
            this.minAlignmentLength = minAlignmentLength;
        }
    }

    private static final class LucyLikeVectorSpliceTrimmer
    implements NucleotideTrimmer {
        private final NucleotideSequence upstreamSpliceSeq;
        private final NucleotideSequence downstreamSpliceSeq;
        private final AdaptiveSearchArea adaptiveSearchArea;
        private final NucleotideSubstitutionMatrix matrix;
        private final int gapOpen;
        private final int gapExtension;
        private final boolean checkBothDirections;

        private LucyLikeVectorSpliceTrimmer(LucyVectorSpliceTrimmerBuilder builder) {
            this.upstreamSpliceSeq = builder.upstreamSpliceSeq;
            this.downstreamSpliceSeq = builder.downstreamSpliceSeq;
            this.adaptiveSearchArea = builder.adaptiveSearchArea;
            this.matrix = builder.matrix;
            this.gapOpen = builder.gapOpen;
            this.gapExtension = builder.gapExtension;
            this.checkBothDirections = builder.checkBothDirections;
        }

        @Override
        public Range trim(NucleotideSequence seq) {
            Range fwdRange = this.getForwardGoodRange(seq);
            if (!this.checkBothDirections) {
                return fwdRange;
            }
            Range revRange = this.getReverseGoodRange(seq);
            if (revRange.getLength() < fwdRange.getLength()) {
                return revRange;
            }
            return fwdRange;
        }

        private Range getReverseGoodRange(NucleotideSequence seq) {
            NucleotideSequence revComp = seq.toBuilder().reverseComplement().build();
            Range revRange = this.getForwardGoodRange(revComp);
            return AssemblyUtil.reverseComplementValidRange(revRange, revComp.getLength());
        }

        private Range getForwardGoodRange(NucleotideSequence seq) {
            Range upstreamVectorHit = this.findUpstreamVectorHit(seq);
            Range downstreamVectorHit = this.findDownstreamVectorHit(seq, upstreamVectorHit);
            Range.Builder goodRangeBuilder = new Range.Builder(seq.getLength());
            if (downstreamVectorHit != null) {
                goodRangeBuilder.setEnd(downstreamVectorHit.getBegin() - 1L);
            }
            if (upstreamVectorHit != null) {
                goodRangeBuilder.setBegin(upstreamVectorHit.getEnd() + 1L);
            }
            return goodRangeBuilder.build();
        }

        private Range findDownstreamVectorHit(NucleotideSequence seq, Range upstreamVectorHit) {
            long shiftAmount;
            NucleotideSequence subseq;
            if (upstreamVectorHit == null) {
                subseq = seq;
                shiftAmount = 0L;
            } else {
                shiftAmount = upstreamVectorHit.getEnd() + 1L;
                subseq = seq.toBuilder().delete(Range.ofLength(shiftAmount)).build();
            }
            NucleotidePairwiseSequenceAlignment alignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(this.downstreamSpliceSeq, subseq, this.matrix).gapPenalty(this.gapOpen, this.gapExtension).useLocalAlignment().build();
            Range subjectRange = alignment.getSubjectRange().getRange();
            if (this.adaptiveSearchArea.meetsDownstreamMatchingCriteria(subjectRange, alignment.getPercentIdentity())) {
                return new Range.Builder(subjectRange).shift(shiftAmount).build();
            }
            return null;
        }

        private Range findUpstreamVectorHit(NucleotideSequence seq) {
            NucleotideSequence subseq = seq.toBuilder().trim(this.adaptiveSearchArea.getSearchAreaRange()).build();
            NucleotidePairwiseSequenceAlignment alignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(this.upstreamSpliceSeq, subseq, this.matrix).gapPenalty(this.gapOpen, this.gapExtension).useLocalAlignment().build();
            Range subjectRange = alignment.getSubjectRange().getRange();
            if (this.adaptiveSearchArea.meetsUpstreamMatchingCriteria(subjectRange)) {
                return subjectRange;
            }
            NucleotidePairwiseSequenceAlignment downstreamAlignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(this.upstreamSpliceSeq, seq, this.matrix).gapPenalty(this.gapOpen, this.gapExtension).useLocalAlignment().build();
            Range downstreamSubjectRange = downstreamAlignment.getSubjectRange().getRange();
            if (this.adaptiveSearchArea.meetsDownstreamMatchingCriteria(downstreamSubjectRange, downstreamAlignment.getPercentIdentity())) {
                return downstreamSubjectRange;
            }
            return null;
        }
    }
}

