/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim.lucy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.core.util.JillionUtil;
import org.jcvi.jillion.trim.QualityTrimmer;

public final class LucyQualityTrimmerBuilder
implements Builder<QualityTrimmer> {
    public static final Window DEFAULT_BRACKET_WINDOW = new Window(10, 0.02);
    private static final List<Window> DEFAULT_TRIM_WINDOWS = Arrays.asList(new Window(50, 0.08), new Window(10, 0.3));
    public static final double DEFAULT_MAX_AVG_ERROR = 0.025;
    public static final double DEFAULT_ERROR_AT_ENDS = 0.02;
    private final int minGoodLength;
    private final Window bracketWindow;
    private double maxAvgError;
    private double maxErrorAtEnds;
    private final Set<Window> trimWindows = new TreeSet<Window>();

    public LucyQualityTrimmerBuilder(int minGoodLength) {
        this.minGoodLength = minGoodLength;
        this.bracketWindow = DEFAULT_BRACKET_WINDOW;
        this.maxAvgError = 0.025;
        this.maxErrorAtEnds = 0.02;
    }

    public LucyQualityTrimmerBuilder maxAvgError(double maxAvgError) {
        this.isValidErrorRate(maxAvgError);
        this.maxAvgError = maxAvgError;
        return this;
    }

    private void isValidErrorRate(double maxAvgError) {
        if (maxAvgError < 0.0 || maxAvgError > 1.0) {
            throw new IllegalArgumentException("max avg error must be between 0.0 and 1.0");
        }
    }

    public LucyQualityTrimmerBuilder maxErrorAtEdges(double maxErrorAtEdges) {
        this.isValidErrorRate(maxErrorAtEdges);
        this.maxErrorAtEnds = maxErrorAtEdges;
        return this;
    }

    public LucyQualityTrimmerBuilder addTrimWindow(int windowSize, double maxErrorRate) {
        this.isValidErrorRate(maxErrorRate);
        if (windowSize < 1) {
            throw new IllegalArgumentException("window size must be >= 1");
        }
        this.trimWindows.add(new Window(windowSize, maxErrorRate));
        return this;
    }

    @Override
    public QualityTrimmer build() {
        if (this.trimWindows.isEmpty()) {
            this.trimWindows.addAll(DEFAULT_TRIM_WINDOWS);
        }
        return new LucyLikeQualityTrimmerImpl(this.minGoodLength, this.bracketWindow, this.trimWindows, this.maxAvgError, this.maxErrorAtEnds);
    }

    private static final class Window
    implements Comparable<Window> {
        private final int size;
        private final double maxErrorRate;

        public Window(int size, double maxErrorRate) {
            this.size = size;
            this.maxErrorRate = maxErrorRate;
        }

        public int getSize() {
            return this.size;
        }

        public double getMaxErrorRate() {
            return this.maxErrorRate;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.maxErrorRate);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Window)) {
                return false;
            }
            Window other = (Window)obj;
            if (Double.doubleToLongBits(this.maxErrorRate) != Double.doubleToLongBits(other.maxErrorRate)) {
                return false;
            }
            return this.size == other.size;
        }

        public String toString() {
            return "Window [size=" + this.size + ", maxErrorRate=" + this.maxErrorRate + "]";
        }

        @Override
        public int compareTo(Window o) {
            int sizeCmp = JillionUtil.compare(o.getSize(), this.size);
            if (sizeCmp != 0) {
                return sizeCmp;
            }
            return Double.compare(o.getMaxErrorRate(), this.maxErrorRate);
        }
    }

    private static final class LucyLikeQualityTrimmerImpl
    implements QualityTrimmer {
        private static final int SIZE_OF_ENDS = 2;
        private final int minGoodLength;
        private final Window bracketWindow;
        private final double maxTotalAvgError;
        private final double maxErrorAtEnds;
        private final Set<Window> trimWindows;

        private LucyLikeQualityTrimmerImpl(int minGoodLength, Window bracketWindow, Set<Window> trimWindows, double maxAvgError, double maxErrorAtEnds) {
            this.minGoodLength = minGoodLength;
            this.bracketWindow = bracketWindow;
            this.trimWindows = trimWindows;
            this.maxTotalAvgError = maxAvgError;
            this.maxErrorAtEnds = maxErrorAtEnds;
        }

        @Override
        public Range trim(QualitySequence qualities) {
            List<Double> errorRates = this.convertToErrorRates(qualities);
            Range bracketedRegion = this.findBracketedRegion(errorRates);
            Range largestRange = this.findLargestCleanRangeFrom(bracketedRegion, errorRates);
            if (largestRange.getLength() < (long)this.minGoodLength) {
                return new Range.Builder().build();
            }
            return new Range.Builder(largestRange).shift(bracketedRegion.getBegin()).build();
        }

        private Range findLargestCleanRangeFrom(Range bracketedRegion, List<Double> errorRates) {
            List<Double> bracketedErrorRates = this.getSubList(errorRates, bracketedRegion);
            ArrayList<Range> largestRanges = new ArrayList<Range>();
            List<Range> candidateCleanRanges = this.findCandidateCleanRangesFrom(bracketedErrorRates, this.trimWindows);
            for (Range candidateCleanRange : candidateCleanRanges) {
                List<Double> candidateErrorRates = this.getSubList(bracketedErrorRates, candidateCleanRange);
                largestRanges.add(this.findLargestRangeThatPassesTotalAvgErrorRate(candidateErrorRates, candidateCleanRange));
            }
            return this.getLargestRangeFrom(largestRanges);
        }

        private List<Double> getSubList(List<Double> errorRates, Range region) {
            return errorRates.subList((int)region.getBegin(), (int)region.getEnd() + 1);
        }

        private List<Double> convertToErrorRates(QualitySequence qualities) {
            ArrayList<Double> errorRates = new ArrayList<Double>((int)qualities.getLength());
            for (PhredQuality quality : qualities) {
                errorRates.add(quality.getErrorProbability());
            }
            return errorRates;
        }

        private Range findLargestRangeThatPassesTotalAvgErrorRate(List<Double> encodedCandidateErrorRates, Range candidateCleanRange) {
            boolean done = false;
            for (long currentWindowSize = candidateCleanRange.getLength(); !done && currentWindowSize >= 2L; --currentWindowSize) {
                int i = 0;
                while ((long)i < (long)encodedCandidateErrorRates.size() - currentWindowSize && (long)i <= currentWindowSize) {
                    Range currentWindowRange = new Range.Builder(currentWindowSize).shift(i).build();
                    double avgErrorRate = this.computeAvgErrorRateOf(encodedCandidateErrorRates, currentWindowRange);
                    Range leftRange = new Range.Builder(2L).shift(currentWindowRange.getBegin()).build();
                    double leftEndErrorRate = this.computeAvgErrorRateOf(encodedCandidateErrorRates, leftRange);
                    double rightEndErrorRate = this.computeAvgErrorRateOf(encodedCandidateErrorRates, new Range.Builder(2L).shift(currentWindowRange.getEnd() - 2L).build());
                    if (avgErrorRate <= this.maxTotalAvgError && leftEndErrorRate <= this.maxErrorAtEnds && rightEndErrorRate <= this.maxErrorAtEnds) {
                        return new Range.Builder(currentWindowRange).shift(candidateCleanRange.getBegin()).build();
                    }
                    ++i;
                }
            }
            return new Range.Builder().shift(candidateCleanRange.getBegin()).build();
        }

        private List<Range> findCandidateCleanRangesFrom(List<Double> bracketedErrorRates, Set<Window> slidingWindows) {
            Iterator<Window> iterator = slidingWindows.iterator();
            Window firstTrimWindow = iterator.next();
            List<Range> candidateCleanRanges = this.trim(bracketedErrorRates, firstTrimWindow);
            while (iterator.hasNext()) {
                Window subsequentTrimWindow = iterator.next();
                ArrayList<Range> trimmedCandidateCleanRanges = new ArrayList<Range>();
                for (Range range : candidateCleanRanges) {
                    List<Range> trim = this.trim(this.getSubList(bracketedErrorRates, range), subsequentTrimWindow);
                    for (Range newCandidateRange : trim) {
                        trimmedCandidateCleanRanges.add(new Range.Builder(newCandidateRange).shift(range.getBegin()).build());
                    }
                }
                candidateCleanRanges = trimmedCandidateCleanRanges;
            }
            return candidateCleanRanges;
        }

        private List<Range> trim(List<Double> errorRates, Window trimWindow) {
            ArrayList<Range> candidateCleanRanges = new ArrayList<Range>();
            for (long i = 0L; i < (long)(errorRates.size() - trimWindow.getSize()); ++i) {
                Range windowRange = new Range.Builder(trimWindow.getSize()).shift(i).build();
                double avgErrorRate = this.computeAvgErrorRateOf(errorRates, windowRange);
                if (!(avgErrorRate <= trimWindow.getMaxErrorRate())) continue;
                candidateCleanRanges.add(windowRange);
            }
            return Ranges.merge(candidateCleanRanges);
        }

        private Range findBracketedRegion(List<Double> errorRates) {
            long rightCoordinate;
            long leftCoordinate = this.findLeftBracketCoordinate(errorRates);
            if (leftCoordinate > (rightCoordinate = this.findRightBracketCoordinate(errorRates)) - 2L) {
                return new Range.Builder().build();
            }
            return Range.of(leftCoordinate, rightCoordinate);
        }

        private long findRightBracketCoordinate(List<Double> errorRates) {
            long coordinate;
            int bracketSize = this.bracketWindow.getSize();
            for (coordinate = (long)(errorRates.size() - 1); coordinate >= (long)bracketSize; --coordinate) {
                Range windowRange = new Range.Builder(bracketSize).shift(coordinate - (long)bracketSize).build();
                double avgErrorRate = this.computeAvgErrorRateOf(errorRates, windowRange);
                if (!(avgErrorRate <= this.bracketWindow.getMaxErrorRate())) continue;
                return coordinate;
            }
            return coordinate;
        }

        private int findLeftBracketCoordinate(List<Double> errorRates) {
            int coordinate;
            int bracketSize = this.bracketWindow.getSize();
            for (coordinate = 0; coordinate < errorRates.size() - bracketSize; ++coordinate) {
                Range windowRange = new Range.Builder(bracketSize).shift(coordinate).build();
                double avgErrorRate = this.computeAvgErrorRateOf(errorRates, windowRange);
                if (!(avgErrorRate <= this.bracketWindow.getMaxErrorRate())) continue;
                return coordinate;
            }
            return coordinate;
        }

        private double computeAvgErrorRateOf(List<Double> errorRates, Range windowRange) {
            double totalErrorRate = 0.0;
            for (double errorRate : this.getSubList(errorRates, windowRange)) {
                totalErrorRate += errorRate;
            }
            return totalErrorRate / (double)windowRange.getLength();
        }

        private Range getLargestRangeFrom(List<Range> goodQualityRanges) {
            if (goodQualityRanges.isEmpty()) {
                return new Range.Builder().build();
            }
            ArrayList<Range> sorted = new ArrayList<Range>(goodQualityRanges);
            Collections.sort(sorted, Range.Comparators.LONGEST_TO_SHORTEST);
            return (Range)sorted.get(0);
        }
    }
}

