/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trim.NucleotideTrimmer;
import org.jcvi.jillion.trim.QualityTrimmer;
import org.jcvi.jillion.trim.TrimmerPipeline;

public class TrimmerPipelineBuilder {
    final List<NucleotideTrimmer> nucleotideTrimmers = new ArrayList<NucleotideTrimmer>();
    final List<QualityTrimmer> qualityTrimmers = new ArrayList<QualityTrimmer>();
    Predicate<Rangeable> rangePredicate = null;
    Predicate<NucleotideSequence> seqPredicate = null;
    Predicate<QualitySequence> qualityPredicate = null;
    long minLength = -1L;

    public TrimmerPipelineBuilder minLength(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("min length must be >= 0");
        }
        this.minLength = length;
        return this;
    }

    public TrimmerPipelineBuilder filterRange(Predicate<Rangeable> predicate) {
        this.rangePredicate = predicate;
        return this;
    }

    public TrimmerPipelineBuilder filterSequence(Predicate<NucleotideSequence> predicate) {
        this.seqPredicate = predicate;
        return this;
    }

    public TrimmerPipelineBuilder filterQualities(Predicate<QualitySequence> predicate) {
        this.qualityPredicate = predicate;
        return this;
    }

    public TrimmerPipelineBuilder add(NucleotideTrimmer trimmer) {
        Objects.requireNonNull(trimmer);
        this.nucleotideTrimmers.add(trimmer);
        return this;
    }

    public TrimmerPipelineBuilder add(QualityTrimmer trimmer) {
        Objects.requireNonNull(trimmer);
        this.qualityTrimmers.add(trimmer);
        return this;
    }

    public TrimmerPipeline build() {
        return new TrimmerPipeline(this);
    }
}

