/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trim.NucleotideTrimmer;
import org.jcvi.jillion.trim.QualityTrimmer;
import org.jcvi.jillion.trim.TrimmerPipelineBuilder;

public class TrimmerPipeline {
    private static final long NOT_SET = 1L;
    private static Range EMPTY = Range.ofLength(0L);
    private static Range.Builder EMPTY_BUILDER = new Range.Builder(0L);
    private final List<NucleotideTrimmer> nucleotideTrimmers;
    private final List<QualityTrimmer> qualityTrimmers;
    private final Predicate<Rangeable> rangePredicate;
    private final Predicate<NucleotideSequence> seqPredicate;
    private final Predicate<QualitySequence> qualityPredicate;
    private final long minLength;

    TrimmerPipeline(TrimmerPipelineBuilder builder) {
        this.nucleotideTrimmers = new ArrayList<NucleotideTrimmer>(builder.nucleotideTrimmers);
        this.qualityTrimmers = new ArrayList<QualityTrimmer>(builder.qualityTrimmers);
        this.rangePredicate = builder.rangePredicate;
        this.seqPredicate = builder.seqPredicate;
        this.qualityPredicate = builder.qualityPredicate;
        this.minLength = builder.minLength;
    }

    public Range trim(Trace trace) {
        if (this.nucleotideTrimmers.isEmpty()) {
            return this.trim(trace.getQualitySequence());
        }
        Range.Builder range = this.nucTrim(trace.getNucleotideSequence());
        if (!this.qualityTrimmers.isEmpty()) {
            range.intersect(this.qualTrim(trace.getQualitySequence()));
        }
        if (this.minLength != 1L && range.getLength() < this.minLength) {
            return EMPTY;
        }
        if (this.rangePredicate != null && this.rangePredicate.test(range)) {
            return EMPTY;
        }
        Range builtRange = range.build();
        if (this.seqPredicate != null && this.seqPredicate.test(new NucleotideSequenceBuilder(trace.getNucleotideSequence(), builtRange).turnOffDataCompression(true).build())) {
            return EMPTY;
        }
        if (this.qualityPredicate != null && this.qualityPredicate.test(new QualitySequenceBuilder(trace.getQualitySequence(), builtRange).turnOffDataCompression(true).build())) {
            return EMPTY;
        }
        return builtRange;
    }

    public Range trim(NucleotideSequence seq) {
        Range.Builder builder = this.nucTrim(seq);
        if (builder == EMPTY_BUILDER) {
            return EMPTY;
        }
        if (this.minLength != 1L && builder.getLength() < this.minLength) {
            return EMPTY;
        }
        if (this.rangePredicate != null && this.rangePredicate.test(builder)) {
            return EMPTY;
        }
        Range builtRange = builder.build();
        if (this.seqPredicate != null && this.seqPredicate.test(new NucleotideSequenceBuilder(seq, builtRange).turnOffDataCompression(true).build())) {
            return EMPTY;
        }
        return builder.build();
    }

    private Range.Builder nucTrim(NucleotideSequence seq) {
        long length = seq.getLength();
        if (this.minLength != 1L && length < this.minLength) {
            return EMPTY_BUILDER;
        }
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(seq).turnOffDataCompression(true);
        Range.Builder fullTrimRange = new Range.Builder(length);
        for (NucleotideTrimmer trimmer : this.nucleotideTrimmers) {
            Range currentRange = trimmer.trim(builder);
            if (this.minLength != 1L && currentRange.getLength() < this.minLength) {
                return EMPTY_BUILDER;
            }
            fullTrimRange.contractBegin(currentRange.getBegin());
            fullTrimRange.setEnd(fullTrimRange.getBegin() + currentRange.getLength() - 1L);
            builder.trim(currentRange);
        }
        return fullTrimRange;
    }

    public Range trim(QualitySequence seq) {
        Range.Builder builder = this.qualTrim(seq);
        if (builder == EMPTY_BUILDER) {
            return EMPTY;
        }
        if (this.minLength != 1L && builder.getLength() < this.minLength) {
            return EMPTY;
        }
        if (this.rangePredicate != null && this.rangePredicate.test(builder)) {
            return EMPTY;
        }
        Range builtRange = builder.build();
        if (this.qualityPredicate != null && this.qualityPredicate.test(new QualitySequenceBuilder(seq, builtRange).turnOffDataCompression(true).build())) {
            return EMPTY;
        }
        return builder.build();
    }

    private Range.Builder qualTrim(QualitySequence seq) {
        long length = seq.getLength();
        if (this.minLength != 1L && length < this.minLength) {
            return EMPTY_BUILDER;
        }
        if (this.qualityPredicate != null && this.qualityPredicate.test(seq)) {
            return EMPTY_BUILDER;
        }
        QualitySequenceBuilder builder = new QualitySequenceBuilder(seq).turnOffDataCompression(true);
        Range.Builder fullTrimRange = new Range.Builder(length);
        if (this.rangePredicate != null && this.rangePredicate.test(fullTrimRange)) {
            return EMPTY_BUILDER;
        }
        for (QualityTrimmer trimmer : this.qualityTrimmers) {
            Range currentRange = trimmer.trim(builder);
            if (this.minLength != 1L && currentRange.getLength() < this.minLength) {
                return EMPTY_BUILDER;
            }
            fullTrimRange.contractBegin(currentRange.getBegin());
            fullTrimRange.setEnd(fullTrimRange.getBegin() + currentRange.getLength() - 1L);
            if (this.rangePredicate != null && this.rangePredicate.test(fullTrimRange)) {
                return EMPTY_BUILDER;
            }
            builder.trim(currentRange);
            if (this.qualityPredicate == null || !this.qualityPredicate.test(builder.build())) continue;
            return EMPTY_BUILDER;
        }
        return fullTrimRange;
    }
}

