/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trim;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trim.QualityTrimmer;
import org.jcvi.jillion.trim.Trimmer;

public class BwaQualityTrimmer
implements QualityTrimmer {
    private final byte threshold;

    public static <T extends Trace> Trimmer<T> createFor(PhredQuality threshold) {
        BwaQualityTrimmer bwaTrim = new BwaQualityTrimmer(threshold);
        return t -> bwaTrim.trim(t.getQualitySequence());
    }

    public static <T> Trimmer<T> createFor(PhredQuality threshold, Function<T, QualitySequence> mapper) {
        Objects.requireNonNull(mapper);
        BwaQualityTrimmer bwaTrim = new BwaQualityTrimmer(threshold);
        return t -> bwaTrim.trim((QualitySequence)mapper.apply(t));
    }

    public BwaQualityTrimmer(PhredQuality threshold) {
        this.threshold = threshold.getQualityScore();
    }

    @Override
    public Range trim(QualitySequence qualities) {
        int goodQualityWindowLength = (int)qualities.getLength();
        QualitySequenceBuilder reversedQualities = new QualitySequenceBuilder(qualities).reverse();
        Iterator<PhredQuality> iter = reversedQualities.iterator();
        int currentLength = goodQualityWindowLength;
        int badnessFactor = 0;
        int worstScore = 0;
        while (iter.hasNext() && badnessFactor >= 0) {
            byte qualityScore = iter.next().getQualityScore();
            if ((badnessFactor += this.threshold - qualityScore) > worstScore) {
                worstScore = badnessFactor;
                goodQualityWindowLength = currentLength;
            }
            --currentLength;
        }
        if (currentLength == 0) {
            return new Range.Builder().build();
        }
        return new Range.Builder(goodQualityWindowLength).build();
    }
}

