/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffUtil;

final class SffWriterUtil {
    private SffWriterUtil() {
    }

    public static int writeCommonHeader(SffCommonHeader header, OutputStream out) throws IOException {
        int keyLength = (int)header.getKeySequence().getLength();
        int size = 31 + header.getNumberOfFlowsPerRead() + keyLength;
        int padding = SffUtil.caclulatePaddedBytes(size);
        int headerLength = size + padding;
        ByteBuffer temp = ByteBuffer.allocate(headerLength);
        temp.put(SffUtil.SFF_MAGIC_NUMBER);
        temp.put(IOUtil.convertUnsignedLongToByteArray(header.getIndexOffset()));
        temp.put(IOUtil.convertUnsignedIntToByteArray(header.getIndexLength()));
        temp.put(IOUtil.convertUnsignedIntToByteArray(header.getNumberOfReads()));
        temp.put(IOUtil.convertUnsignedShortToByteArray(headerLength));
        temp.put(IOUtil.convertUnsignedShortToByteArray(keyLength));
        temp.put(IOUtil.convertUnsignedShortToByteArray(header.getNumberOfFlowsPerRead()));
        temp.put((byte)1);
        temp.put(header.getFlowSequence().toString().getBytes(IOUtil.UTF_8));
        temp.put(header.getKeySequence().toString().getBytes(IOUtil.UTF_8));
        temp.put(new byte[padding]);
        out.write(temp.array(), 0, headerLength);
        return headerLength;
    }

    public static int getNumberOfBytesFor(SffCommonHeader header) {
        int keyLength = (int)header.getKeySequence().getLength();
        int size = 31 + header.getNumberOfFlowsPerRead() + keyLength;
        int padding = SffUtil.caclulatePaddedBytes(size);
        return size + padding;
    }

    public static int writeReadHeader(SffReadHeader readHeader, OutputStream out) throws IOException {
        String name = readHeader.getId();
        int nameLength = name.length();
        int unpaddedHeaderLength = 16 + nameLength;
        int padding = SffUtil.caclulatePaddedBytes(unpaddedHeaderLength);
        int paddedHeaderLength = unpaddedHeaderLength + padding;
        ByteBuffer temp = ByteBuffer.allocate(paddedHeaderLength);
        temp.put(IOUtil.convertUnsignedShortToByteArray(paddedHeaderLength));
        temp.put(IOUtil.convertUnsignedShortToByteArray(nameLength));
        temp.put(IOUtil.convertUnsignedIntToByteArray(readHeader.getNumberOfBases()));
        SffWriterUtil.writeClip(readHeader.getQualityClip(), temp);
        SffWriterUtil.writeClip(readHeader.getAdapterClip(), temp);
        temp.put(name.getBytes(IOUtil.UTF_8));
        temp.put(new byte[padding]);
        out.write(temp.array(), 0, paddedHeaderLength);
        return paddedHeaderLength;
    }

    public static int getNumberOfBytesFor(SffReadHeader readHeader) {
        String id = readHeader.getId();
        int unpaddedHeaderLength = 16 + id.length();
        int padding = SffUtil.caclulatePaddedBytes(unpaddedHeaderLength);
        return unpaddedHeaderLength + padding;
    }

    public static int writeReadData(SffReadData readData, OutputStream out) throws IOException {
        short[] flowgramValues = readData.getFlowgramValues();
        NucleotideSequence basecalls = readData.getNucleotideSequence();
        int readDataLength = SffUtil.getReadDataLength(flowgramValues.length, (int)basecalls.getLength());
        int padding = SffUtil.caclulatePaddedBytes(readDataLength);
        int totalLength = readDataLength + padding;
        ByteBuffer temp = ByteBuffer.allocate(totalLength);
        for (int i = 0; i < flowgramValues.length; ++i) {
            temp.putShort(flowgramValues[i]);
        }
        temp.put(readData.getFlowIndexPerBase());
        temp.put(basecalls.toString().getBytes(IOUtil.UTF_8));
        temp.put(PhredQuality.toArray(readData.getQualitySequence()));
        temp.put(new byte[padding]);
        out.write(temp.array(), 0, totalLength);
        return totalLength;
    }

    public static int getNumberOfBytesFor(SffReadData readData) {
        int readDataLength = SffUtil.getReadDataLength(readData.getFlowgramValues().length, (int)readData.getNucleotideSequence().getLength());
        int padding = SffUtil.caclulatePaddedBytes(readDataLength);
        return readDataLength + padding;
    }

    private static void writeClip(Range clip, ByteBuffer out) throws IOException {
        if (clip == null) {
            out.put(SffUtil.EMPTY_CLIP_BYTES);
        } else {
            out.put(IOUtil.convertUnsignedShortToByteArray((int)clip.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
            out.put(IOUtil.convertUnsignedShortToByteArray((int)clip.getEnd(Range.CoordinateSystem.RESIDUE_BASED)));
        }
    }
}

