/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.core.util.GrowableByteArray;
import org.jcvi.jillion.trace.sff.DefaultSffCommonHeader;
import org.jcvi.jillion.trace.sff.DefaultSffReadData;
import org.jcvi.jillion.trace.sff.DefaultSffReadHeader;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffUtil;
import org.jcvi.jillion.trace.sff.SffWriter;
import org.jcvi.jillion.trace.sff.SffWriterUtil;

public class SffWriterBuilder {
    private final NucleotideSequence keySequence;
    private final NucleotideSequence flowSequence;
    private final File outputFile;
    private boolean includeIndex;

    public SffWriterBuilder(File outputFile, SffCommonHeader sffHeader) {
        this(outputFile, sffHeader.getKeySequence(), sffHeader.getFlowSequence());
    }

    public SffWriterBuilder(File outputFile, NucleotideSequence keySequence, NucleotideSequence flowSequence) {
        if (keySequence == null) {
            throw new NullPointerException("key sequence can not be null");
        }
        if (flowSequence == null) {
            throw new NullPointerException("flow sequence can not be null");
        }
        if (keySequence.getNumberOfGaps() > 0) {
            throw new IllegalArgumentException("key sequence can not contain any gaps");
        }
        if (flowSequence.getNumberOfGaps() > 0) {
            throw new IllegalArgumentException("flow sequence can not contain any gaps");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile can not be null");
        }
        this.keySequence = keySequence;
        this.flowSequence = flowSequence;
        this.outputFile = outputFile;
    }

    public SffWriterBuilder includeIndex(boolean includeIndex) {
        this.includeIndex = includeIndex;
        return this;
    }

    public SffWriter build() throws IOException {
        return new SffWriterImpl(this.outputFile, this.includeIndex, this.keySequence, this.flowSequence);
    }

    private static final class SffWriterImpl
    implements SffWriter {
        private static final byte NULL_TERMINATOR = 0;
        private static final byte READ_SEPARATOR = -1;
        private final File outputFile;
        private final OutputStream out;
        private final boolean includeIndex;
        private long numberOfReads = 0L;
        private boolean closed = false;
        private long currentOffset;
        private final SortedMap<String, Long> indexMap = new TreeMap<String, Long>();

        public SffWriterImpl(File outputFile, boolean includeIndex, NucleotideSequence keySequence, NucleotideSequence flowSequence) throws IOException {
            this.outputFile = outputFile;
            this.includeIndex = includeIndex;
            IOUtil.mkdirs(outputFile.getParentFile());
            this.out = new BufferedOutputStream(new FileOutputStream(outputFile));
            this.currentOffset = this.writePartialHeader(keySequence, flowSequence);
        }

        private long writePartialHeader(NucleotideSequence keySequence, NucleotideSequence flowSequence) throws IOException {
            int numberOfFlows = (int)flowSequence.getLength();
            DefaultSffCommonHeader paritalHeader = new DefaultSffCommonHeader(BigInteger.valueOf(0L), 0L, 0L, numberOfFlows, flowSequence, keySequence);
            return SffWriterUtil.writeCommonHeader(paritalHeader, this.out);
        }

        private synchronized void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("writer is closed");
            }
        }

        @Override
        public synchronized void close() throws IOException {
            byte[] index;
            if (this.closed) {
                return;
            }
            if (this.includeIndex) {
                index = this.conmputeBinaryIndex();
                this.out.write(index);
            } else {
                index = null;
            }
            this.out.close();
            if (this.numberOfReads > 0L) {
                try (RandomAccessFile f = new RandomAccessFile(this.outputFile, "rw");){
                    if (this.includeIndex) {
                        f.seek(8L);
                        f.writeLong(this.currentOffset);
                        f.writeInt(index.length);
                    }
                    f.seek(20L);
                    f.write(IOUtil.convertUnsignedIntToByteArray(this.numberOfReads));
                }
            }
            this.closed = true;
        }

        @Override
        public synchronized void write(SffFlowgram flowgram) throws IOException {
            this.checkNotClosed();
            NucleotideSequence seq = flowgram.getNucleotideSequence();
            DefaultSffReadHeader header = new DefaultSffReadHeader((int)seq.getLength(), flowgram.getQualityClip(), flowgram.getAdapterClip(), flowgram.getId());
            DefaultSffReadData data = new DefaultSffReadData(seq, flowgram.getRawIndexes(), flowgram.getRawEncodedFlowValues(), flowgram.getQualitySequence());
            this.write(header, data);
        }

        @Override
        public synchronized void write(SffReadHeader header, SffReadData data) throws IOException {
            this.checkNotClosed();
            if (this.includeIndex) {
                this.indexMap.put(header.getId(), this.currentOffset);
            }
            this.currentOffset += (long)SffWriterUtil.writeReadHeader(header, this.out);
            this.currentOffset += (long)SffWriterUtil.writeReadData(data, this.out);
            ++this.numberOfReads;
        }

        private byte[] conmputeBinaryIndex() {
            GrowableByteArray indexBytes = new GrowableByteArray(19 * this.indexMap.size() + 8);
            indexBytes.append(".srt1.00".getBytes(IOUtil.UTF_8));
            for (Map.Entry<String, Long> entry : this.indexMap.entrySet()) {
                byte[] b = entry.getKey().getBytes(IOUtil.UTF_8);
                indexBytes.append(b);
                indexBytes.append((byte)0);
                indexBytes.append(SffUtil.toSffIndexOffsetValue(entry.getValue()));
                indexBytes.append((byte)-1);
            }
            return indexBytes.toArray();
        }
    }
}

