/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableIterator;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffReadHeader;

public final class SffUtil {
    private static final float ONE_HUNDRED = 100.0f;
    static final byte[] SFF_MAGIC_NUMBER = new byte[]{46, 115, 102, 102, 0, 0, 0, 1};
    private static final long POW_3 = 16581375L;
    private static final long POW_2 = 65025L;
    private static final long POW_1 = 255L;
    public static final byte FORMAT_CODE = 1;
    static final byte[] EMPTY_CLIP_BYTES = new byte[]{0, 0, 0, 0};
    private static final Pattern SFFINFO_ENCODED_FLOWGRAM_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");

    private SffUtil() {
    }

    public static long parseSffIndexOffsetValue(byte[] values) {
        return (long)IOUtil.toUnsignedByte(values[3]) + 255L * (long)IOUtil.toUnsignedByte(values[2]) + 65025L * (long)IOUtil.toUnsignedByte(values[1]) + 16581375L * (long)IOUtil.toUnsignedByte(values[0]);
    }

    public static byte[] toSffIndexOffsetValue(long offset) {
        long currentOffset = offset;
        byte[] values = new byte[4];
        short place4 = (short)(currentOffset / 16581375L);
        values[0] = IOUtil.toSignedByte(place4);
        short place3 = (short)((currentOffset -= (long)place4 * 16581375L) / 65025L);
        values[1] = IOUtil.toSignedByte(place3);
        short place2 = (short)((currentOffset -= (long)place3 * 65025L) / 255L);
        values[2] = IOUtil.toSignedByte(place2);
        values[3] = IOUtil.toSignedByte((short)(currentOffset -= (long)place2 * 255L));
        return values;
    }

    public static int caclulatePaddedBytes(int bytesReadInSection) {
        int remainder = bytesReadInSection % 8;
        if (remainder == 0) {
            return 0;
        }
        return 8 - remainder;
    }

    public static float convertFlowgramValue(short encodedValue) {
        return (float)encodedValue / 100.0f;
    }

    public static short parseSffInfoEncodedFlowgram(String sffinfoEncodedFlowgram) {
        Matcher matcher = SFFINFO_ENCODED_FLOWGRAM_PATTERN.matcher(sffinfoEncodedFlowgram);
        if (matcher.find()) {
            return Short.parseShort(matcher.group(1) + matcher.group(2));
        }
        throw new IllegalArgumentException("could not parse sffinfo encoded flowgram value " + sffinfoEncodedFlowgram);
    }

    public static int getReadDataLength(int numberOfFlows, int numberOfBases) {
        return numberOfFlows * 2 + 3 * numberOfBases;
    }

    public static float getFlowValueFor(SffFlowgram flowgram, int ungappedFullRangeOffset) {
        int i = 0;
        PeekableIterator nucIter = IteratorUtil.createPeekableIterator(flowgram.getNucleotideSequence().iterator(Range.ofLength(ungappedFullRangeOffset + 1)));
        int j = 0;
        float currentFlowValue = 0.0f;
        while (j < ungappedFullRangeOffset) {
            Nucleotide base = (Nucleotide)nucIter.next();
            ++j;
            while (nucIter.hasNext() && base.equals(nucIter.peek())) {
                nucIter.next();
                ++j;
            }
            currentFlowValue = flowgram.getCalledFlowValue(i);
            ++i;
        }
        return currentFlowValue;
    }

    public static Range computeTrimRangeFor(SffFlowgram flowgram) {
        return SffUtil.getTrimRangeFor(flowgram.getQualityClip(), flowgram.getAdapterClip(), flowgram.getNucleotideSequence().getLength());
    }

    private static Range getTrimRangeFor(Range qualityClip, Range adapterClip, long fullSequenceLength) {
        long firstBaseOfInsert = Math.max(1L, Math.max(qualityClip.getBegin(Range.CoordinateSystem.RESIDUE_BASED), adapterClip.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
        long lastBaseOfInsert = Math.min(qualityClip.getEnd(Range.CoordinateSystem.RESIDUE_BASED) == 0L ? fullSequenceLength : qualityClip.getEnd(Range.CoordinateSystem.RESIDUE_BASED), adapterClip.getEnd(Range.CoordinateSystem.RESIDUE_BASED) == 0L ? fullSequenceLength : adapterClip.getEnd(Range.CoordinateSystem.RESIDUE_BASED));
        return Range.of(Range.CoordinateSystem.RESIDUE_BASED, firstBaseOfInsert, lastBaseOfInsert);
    }

    public static Range computeTrimRangeFor(SffReadHeader readHeader) {
        return SffUtil.getTrimRangeFor(readHeader.getQualityClip(), readHeader.getAdapterClip(), readHeader.getNumberOfBases());
    }

    public static enum Linkers {
        FLX("GTTGGAACCGAAAGGGTTTGAATTCAAACCCTTTCGGTTCCAAC"),
        TITANIUM("TCGTATAACTTCGTATAATGTATGCTATACGAAGTTATTACG");

        private final NucleotideSequence forwardSequence;
        private final NucleotideSequence reverseSequence;

        private Linkers(String sequence) {
            NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(sequence);
            this.forwardSequence = builder.build();
            this.reverseSequence = builder.reverseComplement().build();
        }

        public NucleotideSequence getForwardSequence() {
            return this.forwardSequence;
        }

        public NucleotideSequence getReverseSequence() {
            return this.reverseSequence;
        }
    }
}

