/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.util.Arrays;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.internal.core.util.GrowableShortArray;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffUtil;

final class SffFlowgramImpl
implements SffFlowgram {
    private final String id;
    private final NucleotideSequence basecalls;
    private final QualitySequence qualities;
    private final Range qualitiesClip;
    private final Range adapterClip;
    private final short[] values;
    private final byte[] rawIndexes;
    private final short[] rawEncodedFlowValues;

    public static SffFlowgram create(SffReadHeader readHeader, SffReadData readData) {
        byte[] indexes = readData.getFlowIndexPerBase();
        short[] encodedValues = readData.getFlowgramValues();
        SffFlowgramImpl.verifyNotEmpty(encodedValues);
        short[] calledFlows = SffFlowgramImpl.computeValues(indexes, encodedValues);
        return new SffFlowgramImpl(readHeader.getId(), readData.getNucleotideSequence(), readData.getQualitySequence(), calledFlows, readHeader.getQualityClip(), readHeader.getAdapterClip(), indexes, encodedValues);
    }

    static short[] computeValues(byte[] indexes, short[] encodedValues) {
        if (indexes.length == 0) {
            return new short[0];
        }
        GrowableShortArray values = new GrowableShortArray(indexes.length);
        int position = -1;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == 0) continue;
            values.append(encodedValues[position += IOUtil.toUnsignedByte(indexes[i])]);
        }
        return Arrays.copyOf(values.toArray(), values.getCurrentLength());
    }

    private static void verifyNotEmpty(short[] encodedValues) {
        if (encodedValues.length == 0) {
            throw new IllegalArgumentException("read data must contain Flowgram values");
        }
    }

    protected SffFlowgramImpl(String id, NucleotideSequence basecalls, QualitySequence qualities, short[] values, Range qualitiesClip, Range adapterClip, byte[] rawIndexes, short[] rawEncodedFlowValues) {
        this.canNotBeNull(id, basecalls, qualities, values, qualitiesClip, adapterClip);
        this.id = id;
        this.basecalls = basecalls;
        this.qualities = qualities;
        this.values = values;
        this.qualitiesClip = qualitiesClip;
        this.adapterClip = adapterClip;
        this.rawIndexes = Arrays.copyOf(rawIndexes, rawIndexes.length);
        this.rawEncodedFlowValues = Arrays.copyOf(rawEncodedFlowValues, rawEncodedFlowValues.length);
    }

    private void canNotBeNull(String id, NucleotideSequence basecalls, Sequence<PhredQuality> qualities, short[] values, Range qualitiesClip, Range adapterClip) {
        ObjectsUtil.checkNotNull(id, "id can not be null");
        ObjectsUtil.checkNotNull(basecalls, "basecalls can not be null");
        ObjectsUtil.checkNotNull(qualities, "qualities can not be null");
        ObjectsUtil.checkNotNull(values, "values can not be null");
        ObjectsUtil.checkNotNull(qualitiesClip, "qualitiesClip can not be null");
        ObjectsUtil.checkNotNull(adapterClip, "adapterClip can not be null");
        if (values.length == 0) {
            throw new IllegalArgumentException("values can not be empty");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.basecalls;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    @Override
    public Range getQualityClip() {
        return this.qualitiesClip;
    }

    @Override
    public Range getAdapterClip() {
        return this.adapterClip;
    }

    @Override
    public int getNumberOfFlows() {
        return this.values.length;
    }

    @Override
    public float getCalledFlowValue(int index) {
        return SffUtil.convertFlowgramValue(this.values[index]);
    }

    @Override
    public final byte[] getRawIndexes() {
        return Arrays.copyOf(this.rawIndexes, this.rawIndexes.length);
    }

    @Override
    public final short[] getRawEncodedFlowValues() {
        return Arrays.copyOf(this.rawEncodedFlowValues, this.rawEncodedFlowValues.length);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.basecalls.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + this.qualities.hashCode();
        result = 31 * result + this.qualitiesClip.hashCode();
        result = 31 * result + this.adapterClip.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean nonValuesEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SffFlowgram)) {
            return false;
        }
        SffFlowgram other = (SffFlowgram)obj;
        boolean bl = nonValuesEqual = ObjectsUtil.nullSafeEquals(this.id, other.getId()) && ObjectsUtil.nullSafeEquals(this.basecalls, other.getNucleotideSequence()) && ObjectsUtil.nullSafeEquals(this.qualities, other.getQualitySequence()) && ObjectsUtil.nullSafeEquals(this.qualitiesClip, other.getQualityClip()) && ObjectsUtil.nullSafeEquals(this.adapterClip, other.getAdapterClip()) && ObjectsUtil.nullSafeEquals(this.getNumberOfFlows(), other.getNumberOfFlows());
        if (!nonValuesEqual) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.getCalledFlowValue(i) == other.getCalledFlowValue(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SffFlowgram [id=" + this.id + "]";
    }
}

