/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.trace.sff.DefaultSFFCommonHeaderDecoder;
import org.jcvi.jillion.trace.sff.DefaultSffReadDataDecoder;
import org.jcvi.jillion.trace.sff.DefaultSffReadHeaderDecoder;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffParser;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffUtil;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

public abstract class SffFileParser
implements SffParser {
    protected SffCommonHeader header;

    public static SffParser create(File sffFile) throws FileNotFoundException {
        return new FileBasesSffParser(sffFile);
    }

    public static SffParser create(InputStream inputStream) throws FileNotFoundException {
        return new InputStreamBasedSffParser(inputStream);
    }

    private SffFileParser() {
    }

    protected void accept(InputStream in, SffVisitor visitor) throws IOException {
        DataInputStream dataIn = new DataInputStream(in);
        this.header = DefaultSFFCommonHeaderDecoder.INSTANCE.decodeHeader(dataIn);
        ParserState parserState = new ParserState();
        visitor.visitHeader(this.createCommonHeaderCallback(parserState), this.header);
        if (!parserState.keepParsing()) {
            return;
        }
        this.parseReads(visitor, dataIn, this.header);
        visitor.end();
    }

    protected abstract SffVisitorCallback createCommonHeaderCallback(ParserState var1);

    private void parseReads(SffVisitor visitor, DataInputStream dataIn, SffCommonHeader commonHeader) throws IOException {
        long numberOfReads = commonHeader.getNumberOfReads();
        int keyLength = (int)commonHeader.getKeySequence().getLength();
        int size = 31 + commonHeader.getNumberOfFlowsPerRead() + keyLength;
        int padding = SffUtil.caclulatePaddedBytes(size);
        int commonHeaderLength = size + padding;
        ParserState parserState = new ParserState(commonHeaderLength);
        int i = 0;
        while (parserState.keepParsing() && (long)i < numberOfReads) {
            parserState = this.handleSingleRead(visitor, dataIn, parserState, i);
            ++i;
        }
    }

    protected ParserState handleSingleRead(SffVisitor visitor, DataInputStream dataIn, ParserState parserState, int readCount) throws IOException {
        SffVisitorCallback readHeaderCallback = this.createReadHeaderCallback(parserState, readCount);
        SffReadHeader readHeader = DefaultSffReadHeaderDecoder.INSTANCE.decodeReadHeader(dataIn);
        SffFileReadVisitor readVisitor = visitor.visitRead(readHeaderCallback, readHeader);
        int unpaddedHeaderLength = 16 + readHeader.getId().length();
        int readHeaderPadding = SffUtil.caclulatePaddedBytes(unpaddedHeaderLength);
        int paddedHeaderLength = unpaddedHeaderLength + readHeaderPadding;
        ParserState updatedParserState = parserState.incrementPosition(paddedHeaderLength);
        int numberOfFlowsPerRead = this.header.getNumberOfFlowsPerRead();
        int readDataLength = SffUtil.getReadDataLength(numberOfFlowsPerRead, readHeader.getNumberOfBases());
        int readDataPadding = SffUtil.caclulatePaddedBytes(readDataLength);
        if (readVisitor == null) {
            IOUtil.blockingSkip(dataIn, readDataLength + readDataPadding);
        } else {
            int numberOfBases = readHeader.getNumberOfBases();
            SffReadData readData = DefaultSffReadDataDecoder.INSTANCE.decode(dataIn, numberOfFlowsPerRead, numberOfBases);
            readVisitor.visitReadData(readData);
            readVisitor.visitEnd();
        }
        updatedParserState = updatedParserState.incrementPosition(readDataLength + readDataPadding);
        return updatedParserState;
    }

    protected abstract SffVisitorCallback createReadHeaderCallback(ParserState var1, int var2);

    private static final class FileBasesSffParser
    extends SffFileParser {
        private final File sffFile;

        private FileBasesSffParser(File sffFile) throws FileNotFoundException {
            if (sffFile == null) {
                throw new NullPointerException("sff file can not be null");
            }
            if (!sffFile.exists()) {
                throw new FileNotFoundException(String.format("sff file %s does not exist", sffFile.getAbsolutePath()));
            }
            this.sffFile = sffFile;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        public void parse(SffVisitor visitor) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(this.sffFile));
                this.accept(in, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(SffVisitor visitor, SffVisitorCallback.SffVisitorMemento memento) throws IOException {
            BufferedInputStream in;
            block6: {
                if (!(memento instanceof AbstractSffFileMemento)) {
                    throw new IllegalArgumentException("don't know how to handle this memento");
                }
                if (this.header == null) {
                    throw new IllegalStateException("parser has not yet been initialized, must call accept(visitor) method first");
                }
                in = null;
                try {
                    if (memento instanceof ReadRecordSffFileMemento) {
                        ReadRecordSffFileMemento readRecordSffFileMemento = (ReadRecordSffFileMemento)memento;
                        ParserState parserState = new ParserState(readRecordSffFileMemento.getPosition());
                        in = new BufferedInputStream(new RandomAccessFileInputStream(this.sffFile, parserState.position));
                        DataInputStream dataIn = new DataInputStream(in);
                        int i = readRecordSffFileMemento.readCount;
                        while (parserState.keepParsing() && (long)i < this.header.getNumberOfReads()) {
                            parserState = this.handleSingleRead(visitor, dataIn, parserState, i);
                            ++i;
                        }
                        break block6;
                    }
                    in = new BufferedInputStream(new FileInputStream(this.sffFile));
                    this.accept(in, visitor);
                }
                catch (Throwable throwable) {
                    IOUtil.closeAndIgnoreErrors(in);
                    throw throwable;
                }
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        @Override
        protected SffVisitorCallback createReadHeaderCallback(final ParserState parserState, final int readCount) {
            return new SffVisitorCallback(){

                @Override
                public boolean mementoSupported() {
                    return true;
                }

                @Override
                public SffVisitorCallback.SffVisitorMemento createMemento() {
                    return new ReadRecordSffFileMemento(parserState.position, readCount);
                }

                @Override
                public void haltParsing() {
                    parserState.stop();
                }
            };
        }

        @Override
        protected SffVisitorCallback createCommonHeaderCallback(final ParserState parserState) {
            return new SffVisitorCallback(){

                @Override
                public boolean mementoSupported() {
                    return true;
                }

                @Override
                public SffVisitorCallback.SffVisitorMemento createMemento() {
                    return new BeginningSffFileMomento();
                }

                @Override
                public void haltParsing() {
                    parserState.stop();
                }
            };
        }
    }

    private static class InputStreamBasedSffParser
    extends SffFileParser {
        private final OpenAwareInputStream in;

        public InputStreamBasedSffParser(InputStream in) {
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        public void parse(SffVisitor visitor) throws IOException {
            if (!this.canParse()) {
                throw new IllegalStateException("inputstream is not open");
            }
            this.accept(this.in, visitor);
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void parse(SffVisitor visitor, SffVisitorCallback.SffVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("can not accept mementos when inputStream is provided");
        }

        @Override
        protected SffVisitorCallback createReadHeaderCallback(ParserState parserState, int readCount) {
            return this.createMementolessCallback(parserState);
        }

        @Override
        protected SffVisitorCallback createCommonHeaderCallback(ParserState parserState) {
            return this.createMementolessCallback(parserState);
        }

        private SffVisitorCallback createMementolessCallback(final ParserState parserState) {
            return new SffVisitorCallback(){

                @Override
                public boolean mementoSupported() {
                    return false;
                }

                @Override
                public SffVisitorCallback.SffVisitorMemento createMemento() {
                    throw new UnsupportedOperationException("can not create mementos from inputstream");
                }

                @Override
                public void haltParsing() {
                    parserState.stop();
                }
            };
        }
    }

    private static class ParserState {
        private final long position;
        private AtomicBoolean keepParsing = new AtomicBoolean(true);

        public ParserState() {
            this(0L);
        }

        public ParserState(long initialPosition) {
            this.position = initialPosition;
        }

        private ParserState(long position, AtomicBoolean keepParsing) {
            this.position = position;
            this.keepParsing = keepParsing;
        }

        public ParserState incrementPosition(long increment) {
            return new ParserState(this.position + increment, this.keepParsing);
        }

        public void stop() {
            this.keepParsing.set(false);
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }
    }

    private static class BeginningSffFileMomento
    extends AbstractSffFileMemento {
        public BeginningSffFileMomento() {
            super(0L);
        }
    }

    private static class ReadRecordSffFileMemento
    extends AbstractSffFileMemento {
        private final int readCount;

        public ReadRecordSffFileMemento(long position, int readCount) {
            super(position);
            this.readCount = readCount;
        }
    }

    private static abstract class AbstractSffFileMemento
    implements SffVisitorCallback.SffVisitorMemento {
        private final long position;

        public AbstractSffFileMemento(long position) {
            this.position = position;
        }

        public long getPosition() {
            return this.position;
        }
    }
}

