/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFileParser;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffFlowgramImpl;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

final class SffFileIterator
extends AbstractBlockingStreamingIterator<SffFlowgram> {
    private final File sffFile;
    private final DataStoreFilter filter;

    public static SffFileIterator createNewIteratorFor(File sffFile) {
        return SffFileIterator.createNewIteratorFor(sffFile, DataStoreFilters.alwaysAccept());
    }

    public static SffFileIterator createNewIteratorFor(File sffFile, DataStoreFilter filter) {
        SffFileIterator iter = new SffFileIterator(sffFile, filter);
        iter.start();
        return iter;
    }

    private SffFileIterator(File sffFile, DataStoreFilter filter) {
        this.sffFile = sffFile;
        this.filter = filter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        try {
            SffVisitor visitor = new SffVisitor(){

                @Override
                public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
                }

                @Override
                public SffFileReadVisitor visitRead(SffVisitorCallback callback, final SffReadHeader readHeader) {
                    if (SffFileIterator.this.filter.accept(readHeader.getId())) {
                        return new SffFileReadVisitor(){

                            @Override
                            public void visitReadData(SffReadData readData) {
                                SffFileIterator.this.blockingPut(SffFlowgramImpl.create(readHeader, readData));
                            }

                            @Override
                            public void visitEnd() {
                            }
                        };
                    }
                    return null;
                }

                @Override
                public void end() {
                }
            };
            SffFileParser.create(this.sffFile).parse(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

